# 機能設計書 104-OpenTelemetryプラグイン

## 概要

本ドキュメントは、OpenSearchのOpenTelemetryプラグイン（OTel Telemetry Plugin）の設計を記述する。OpenTelemetry SDKを利用してトレーシング・メトリクスデータを外部バックエンドにエクスポートするプラグインである。

### 本機能の処理概要

**業務上の目的・背景**：テレメトリフレームワーク（No.103）の具体的な実装として、業界標準のOpenTelemetryプロトコルを使用したテレメトリデータの収集・エクスポートを提供する。Jaeger、Zipkin、Prometheus等の標準的な監視バックエンドとの統合を可能にする。

**機能の利用シーン**：クラスタの分散トレーシングデータをJaegerやZipkinに送信する場合、メトリクスデータをPrometheusに送信する場合に利用される。

**主要な処理内容**：
1. OpenTelemetry SDKの初期化とライフサイクル管理（RefCountedReleasable）
2. OTelTracingTelemetryによるスパンの作成・管理
3. OTelMetricsTelemetryによるメトリクス（Counter/Histogram/UpDownCounter）の管理
4. スパンエクスポータの設定と生成（OTelSpanExporterFactory）
5. メトリクスエクスポータの設定と生成（OTelMetricsExporterFactory）
6. サンプラーの設定（ProbabilisticSampler/RequestSampler/ProbabilisticTransportActionSampler）
7. OTelResourceProviderによるOpenTelemetry SDKリソース情報の構築

**関連システム・外部連携**：OpenTelemetry SDK（io.opentelemetry）、外部テレメトリバックエンド（Jaeger、Zipkin、Prometheus等）。

**権限による制御**：特定の権限制御はない。設定はクラスタ/ノードレベルの設定で管理される。

## 関連画面

| 画面No | 画面名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| - | - | - | 本機能は直接的な画面を持たない内部プラグイン |

## 機能種別

プラグイン / テレメトリエクスポート

## 入力仕様

### 入力パラメータ

| パラメータ名 | 型 | 必須 | 説明 | バリデーション |
|-------------|-----|-----|------|---------------|
| telemetry.otel.tracer.span.exporter.class | String | No | スパンエクスポータクラス名 | 有効なクラス名 |
| telemetry.otel.tracer.span.sampler.classes | String | No | サンプラークラス名 | 有効なクラス名 |
| telemetry.otel.metrics.exporter.class | String | No | メトリクスエクスポータクラス名 | 有効なクラス名 |
| telemetry.otel.tracer.exporter.batch_size | Integer | No | バッチサイズ | 正の整数 |
| telemetry.otel.tracer.exporter.delay | Long | No | エクスポート遅延 | 正の値 |
| telemetry.otel.tracer.exporter.max_queue_size | Integer | No | 最大キューサイズ | 正の整数 |
| telemetry.otel.tracer.sampler.action.probability | Double | No | アクション別サンプリング確率 | 0.0-1.0 |

### 入力データソース

- テレメトリフレームワークからのSpan/Metrics生成要求
- ノード設定（opensearch.yml）

## 出力仕様

### 出力データ

| 項目名 | 型 | 説明 |
|--------|-----|------|
| Spans | OTLP Span | OpenTelemetryプロトコルのスパンデータ |
| Metrics | OTLP Metric | OpenTelemetryプロトコルのメトリクスデータ |

### 出力先

設定されたエクスポータ経由で外部バックエンド

## 処理フロー

### 処理シーケンス

```
1. OTelTelemetryPlugin初期化
   └─ Settings読み込み
2. getTelemetry()呼出（TelemetryModuleから）
   └─ OpenTelemetrySdkの初期化（OTelResourceProvider）
   └─ RefCountedReleasableでライフサイクル管理
3. OTelTelemetry生成
   └─ OTelTracingTelemetry（トレーシング）
   └─ OTelMetricsTelemetry（メトリクス）
4. スパン/メトリクスの生成とエクスポート
   └─ Exporter経由で外部バックエンドに送信
```

### フローチャート

```mermaid
flowchart TD
    A[TelemetryModule] --> B[OTelTelemetryPlugin.getTelemetry]
    B --> C[OTelResourceProvider.get]
    C --> D[OpenTelemetrySdk初期化]
    D --> E[OTelTelemetry生成]
    E --> F[OTelTracingTelemetry]
    E --> G[OTelMetricsTelemetry]
    F --> H[SpanExporter]
    G --> I[MetricsExporter]
```

## ビジネスルール

### 業務ルール

| ルールNo | ルール名 | 内容 | 適用条件 |
|---------|---------|------|---------|
| BR-401 | 参照カウント管理 | OpenTelemetrySdkはRefCountedReleasableで管理 | プラグインライフサイクル全体 |
| BR-402 | サンプラーチェーン | 複数サンプラーをチェーンで適用 | スパン生成時 |

### 計算ロジック

確率的サンプリング：ProbabilisticSamplerによる設定確率でのサンプリング判定。

## データベース操作仕様

データベース操作なし。

## エラー処理

### エラーケース一覧

| エラーコード | エラー種別 | 発生条件 | 対処方法 |
|------------|----------|---------|---------|
| - | ClassNotFoundException | 指定されたExporterクラスが見つからない | クラスパスを確認 |
| - | IOException | Exporter/SDKクローズ時のエラー | ログ出力して継続 |

### リトライ仕様

OpenTelemetry SDKのバッチエクスポータに内蔵のリトライメカニズムを使用。

## トランザクション仕様

トランザクション管理の対象外。

## パフォーマンス要件

- バッチエクスポートによるオーバーヘッド最小化
- サンプリングにより高トラフィック時のデータ量を制御

## セキュリティ考慮事項

- エクスポータクラス設定はノードスコープのFinal設定
- テレメトリデータに機密情報が含まれないよう注意

## 備考

- INSTRUMENTATION_SCOPE_NAME = "org.opensearch.telemetry"
- プラグイン名: "otel"

---

## コードリーディングガイド

本機能を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: データ構造を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | OTelTelemetrySettings.java | `plugins/telemetry-otel/src/main/java/org/opensearch/telemetry/OTelTelemetrySettings.java` | OTel固有の設定定義 |
| 1-2 | OTelSpan.java | `plugins/telemetry-otel/src/main/java/org/opensearch/telemetry/tracing/OTelSpan.java` | OTelスパンのラッパー |

#### Step 2: エントリーポイントを理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | OTelTelemetryPlugin.java | `plugins/telemetry-otel/src/main/java/org/opensearch/telemetry/OTelTelemetryPlugin.java` | プラグインエントリーポイント |

**主要処理フロー**:
1. **45-47行目**: コンストラクタでSettings保持
2. **63-66行目**: `getTelemetry()`でOpenTelemetrySdk初期化とOTelTelemetry生成
3. **68-73行目**: `initializeOpenTelemetrySdk()`でRefCountedReleasableによるライフサイクル管理
4. **86-90行目**: `close()`でRefCountedReleasable解放

#### Step 3: トレーシング実装を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | OTelTracingTelemetry.java | `plugins/telemetry-otel/src/main/java/org/opensearch/telemetry/tracing/OTelTracingTelemetry.java` | トレーシング実装 |
| 3-2 | OTelResourceProvider.java | `plugins/telemetry-otel/src/main/java/org/opensearch/telemetry/tracing/OTelResourceProvider.java` | SDK初期化ロジック |
| 3-3 | OTelSpanExporterFactory.java | `plugins/telemetry-otel/src/main/java/org/opensearch/telemetry/tracing/exporter/OTelSpanExporterFactory.java` | スパンエクスポータ生成 |
| 3-4 | OTelSamplerFactory.java | `plugins/telemetry-otel/src/main/java/org/opensearch/telemetry/tracing/sampler/OTelSamplerFactory.java` | サンプラー生成 |

#### Step 4: メトリクス実装を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 4-1 | OTelMetricsTelemetry.java | `plugins/telemetry-otel/src/main/java/org/opensearch/telemetry/metrics/OTelMetricsTelemetry.java` | メトリクス実装 |
| 4-2 | OTelCounter.java | `plugins/telemetry-otel/src/main/java/org/opensearch/telemetry/metrics/OTelCounter.java` | カウンターメトリクス |
| 4-3 | OTelHistogram.java | `plugins/telemetry-otel/src/main/java/org/opensearch/telemetry/metrics/OTelHistogram.java` | ヒストグラムメトリクス |
| 4-4 | OTelMetricsExporterFactory.java | `plugins/telemetry-otel/src/main/java/org/opensearch/telemetry/metrics/exporter/OTelMetricsExporterFactory.java` | メトリクスエクスポータ生成 |

### プログラム呼び出し階層図

```
OTelTelemetryPlugin.getTelemetry()
    |
    +-- initializeOpenTelemetrySdk()
    |       +-- OTelResourceProvider.get()
    |               +-- OTelSamplerFactory.create()
    |               +-- OTelSpanExporterFactory.create()
    |               +-- OTelMetricsExporterFactory.create()
    |
    +-- OTelTelemetry
            +-- OTelTracingTelemetry
            |       +-- OTelSpan
            |       +-- OTelPropagatedSpan
            |       +-- OTelTracingContextPropagator
            |
            +-- OTelMetricsTelemetry
                    +-- OTelCounter
                    +-- OTelHistogram
                    +-- OTelUpDownCounter
```

### データフロー図

```
[入力]                    [処理]                           [出力]

Telemetry Framework ---> OTelTracingTelemetry
                          |
                          v
                   OTelSpan                    -----> SpanExporter
                                                       |
                                                       v
                                                 外部バックエンド(Jaeger等)

Telemetry Framework ---> OTelMetricsTelemetry
                          |
                          v
                   OTelCounter/Histogram       -----> MetricsExporter
                                                       |
                                                       v
                                                 外部バックエンド(Prometheus等)
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| OTelTelemetryPlugin.java | `plugins/telemetry-otel/src/main/java/org/opensearch/telemetry/OTelTelemetryPlugin.java` | ソース | プラグインメインクラス |
| OTelTelemetrySettings.java | `plugins/telemetry-otel/src/main/java/org/opensearch/telemetry/OTelTelemetrySettings.java` | ソース | OTel固有設定 |
| OTelTelemetry.java | `plugins/telemetry-otel/src/main/java/org/opensearch/telemetry/tracing/OTelTelemetry.java` | ソース | Telemetry実装 |
| OTelTracingTelemetry.java | `plugins/telemetry-otel/src/main/java/org/opensearch/telemetry/tracing/OTelTracingTelemetry.java` | ソース | トレーシング実装 |
| OTelMetricsTelemetry.java | `plugins/telemetry-otel/src/main/java/org/opensearch/telemetry/metrics/OTelMetricsTelemetry.java` | ソース | メトリクス実装 |
| OTelResourceProvider.java | `plugins/telemetry-otel/src/main/java/org/opensearch/telemetry/tracing/OTelResourceProvider.java` | ソース | SDK初期化 |
| OTelSpanExporterFactory.java | `plugins/telemetry-otel/src/main/java/org/opensearch/telemetry/tracing/exporter/OTelSpanExporterFactory.java` | ソース | スパンエクスポータ生成 |
| OTelMetricsExporterFactory.java | `plugins/telemetry-otel/src/main/java/org/opensearch/telemetry/metrics/exporter/OTelMetricsExporterFactory.java` | ソース | メトリクスエクスポータ生成 |
| OTelSamplerFactory.java | `plugins/telemetry-otel/src/main/java/org/opensearch/telemetry/tracing/sampler/OTelSamplerFactory.java` | ソース | サンプラー生成 |
| ProbabilisticSampler.java | `plugins/telemetry-otel/src/main/java/org/opensearch/telemetry/tracing/sampler/ProbabilisticSampler.java` | ソース | 確率的サンプラー |
| RequestSampler.java | `plugins/telemetry-otel/src/main/java/org/opensearch/telemetry/tracing/sampler/RequestSampler.java` | ソース | リクエストサンプラー |
| OTelSpan.java | `plugins/telemetry-otel/src/main/java/org/opensearch/telemetry/tracing/OTelSpan.java` | ソース | スパンラッパー |
| OTelCounter.java | `plugins/telemetry-otel/src/main/java/org/opensearch/telemetry/metrics/OTelCounter.java` | ソース | カウンタラッパー |
| OTelHistogram.java | `plugins/telemetry-otel/src/main/java/org/opensearch/telemetry/metrics/OTelHistogram.java` | ソース | ヒストグラムラッパー |
| OTelAttributesConverter.java | `plugins/telemetry-otel/src/main/java/org/opensearch/telemetry/OTelAttributesConverter.java` | ソース | 属性変換 |
