# 機能設計書 105-インデックス統計

## 概要

本ドキュメントは、OpenSearchのインデックス統計機能（Indices Stats）の設計を記述する。インデックスレベルの詳細統計情報（ドキュメント数、ストアサイズ、検索・インデックス操作の統計等）を取得する機能である。

### 本機能の処理概要

**業務上の目的・背景**：インデックスの健全性監視、パフォーマンスチューニング、キャパシティプランニングのために、インデックスレベルの詳細な統計情報を取得する必要がある。本機能はシャード単位の統計情報を収集し、インデックス単位に集約して返却する。

**機能の利用シーン**：クラスタの監視ダッシュボード、インデックスのパフォーマンス分析、ストレージ使用量の確認、キャッシュヒット率の分析等で利用される。

**主要な処理内容**：
1. IndicesStatsRequestによるリクエストパラメータの指定（取得対象フラグ制御）
2. TransportBroadcastByNodeActionによる全シャードへの並列統計収集
3. シャード単位のCommonStats収集（ドキュメント数、ストアサイズ、検索統計等）
4. CommitStats、SeqNoStats、RetentionLeaseStats、PollingIngestStatsの収集
5. IndicesStatsResponseでシャード統計をインデックス単位に集約して返却

**関連システム・外部連携**：IndicesService（インデックスサービス）、IndicesQueryCache（クエリキャッシュ）との連携。

**権限による制御**：METADATA_READレベルのクラスタブロックチェックが適用される。

## 関連画面

| 画面No | 画面名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| 78 | データストリーム統計 | 補助機能 | データストリーム配下のインデックス統計取得処理 |
| 87 | インデックス統計 | 主機能 | インデックスの操作統計を提供する処理 |
| 152 | Cat インデックス | 主機能 | インデックス情報をテーブル形式で返す処理 |

## 機能種別

データ取得 / 統計情報

## 入力仕様

### 入力パラメータ

| パラメータ名 | 型 | 必須 | 説明 | バリデーション |
|-------------|-----|-----|------|---------------|
| index | String[] | No | 対象インデックス名 | ワイルドカード対応 |
| flags | CommonStatsFlags | No | 取得対象フラグ | Flagの組合せ |
| groups | String[] | No | 統計グループ | - |
| level | String | No | 集約レベル | cluster/indices/shards |

### 入力データソース

- REST APIリクエストパラメータ
- 各シャードのインデックスデータ

## 出力仕様

### 出力データ

| 項目名 | 型 | 説明 |
|--------|-----|------|
| _shards.total | int | 総シャード数 |
| _shards.successful | int | 成功シャード数 |
| _shards.failed | int | 失敗シャード数 |
| _all.primaries | CommonStats | 全プライマリシャードの集約統計 |
| _all.total | CommonStats | 全シャードの集約統計 |
| indices.{name} | IndexStats | インデックスごとの統計 |

### 出力先

REST APIレスポンス（JSON形式）

## 処理フロー

### 処理シーケンス

```
1. REST APIリクエスト受信
   └─ IndicesStatsRequest生成
2. TransportBroadcastByNodeAction実行
   └─ 対象インデックスのシャードを全ノードから収集
3. 各ノードでshardOperation実行
   └─ IndexService → IndexShard → CommonStats収集
   └─ CommitStats/SeqNoStats/RetentionLeaseStats収集
4. ShardStats集約
   └─ IndicesStatsResponse生成（インデックス単位に集約）
```

### フローチャート

```mermaid
flowchart TD
    A[REST Request] --> B[IndicesStatsRequest]
    B --> C[TransportBroadcastByNodeAction]
    C --> D[各ノードで shardOperation]
    D --> E[CommonStats収集]
    D --> F[CommitStats収集]
    D --> G[SeqNoStats収集]
    E --> H[ShardStats生成]
    F --> H
    G --> H
    H --> I[IndicesStatsResponse集約]
```

## ビジネスルール

### 業務ルール

| ルールNo | ルール名 | 内容 | 適用条件 |
|---------|---------|------|---------|
| BR-501 | フラグ制御 | CommonStatsFlagsにより取得対象統計を制御 | リクエスト処理時 |
| BR-502 | ブロックチェック | METADATA_READレベルのブロックチェック | リクエスト受付時 |
| BR-503 | クローズシャード | AlreadyClosedExceptionはnull統計で処理 | シャード統計収集時 |

### 計算ロジック

統計情報はシャード単位で収集し、プライマリ/全シャードの2レベルで集約される。

## データベース操作仕様

### 操作別データベース影響一覧

| 操作 | 対象テーブル | 操作種別 | 概要 |
|-----|-------------|---------|------|
| 統計取得 | Lucene Index / ShardStats | SELECT | 各シャードの統計情報を読み取り |

## エラー処理

### エラーケース一覧

| エラーコード | エラー種別 | 発生条件 | 対処方法 |
|------------|----------|---------|---------|
| 404 | ShardNotFoundException | シャードのルーティングエントリなし | シャード再配置を待つ |
| 403 | ClusterBlockException | METADATA_READブロック | ブロック解除を待つ |

### リトライ仕様

個別シャードの失敗はレスポンスのshardFailuresに含まれ、他のシャードの統計は返却される。

## トランザクション仕様

読み取り専用操作。トランザクション管理不要。

## パフォーマンス要件

- 全シャードに対するブロードキャスト操作のため、大規模クラスタでは応答時間が増加
- MANAGEMENTスレッドプールで実行

## セキュリティ考慮事項

- METADATA_READレベルのクラスタブロックチェック
- インデックスレベルのアクセス制御はセキュリティプラグインで管理

## 備考

- CommonStatsFlagsのFlag enumで取得対象を細かく制御可能（Docs, Store, Indexing, Get, Search, Merge, Refresh, Flush, Warmer, QueryCache, FieldData, Completion, Segments, Translog, RequestCache, Recovery等）

---

## コードリーディングガイド

本機能を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: データ構造を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | CommonStatsFlags.java | `server/src/main/java/org/opensearch/action/admin/indices/stats/CommonStatsFlags.java` | 取得対象フラグの定義（Flag enum） |
| 1-2 | CommonStats.java | `server/src/main/java/org/opensearch/action/admin/indices/stats/CommonStats.java` | 各種統計データの集約クラス |
| 1-3 | ShardStats.java | `server/src/main/java/org/opensearch/action/admin/indices/stats/ShardStats.java` | シャード単位の統計データ |
| 1-4 | IndexStats.java | `server/src/main/java/org/opensearch/action/admin/indices/stats/IndexStats.java` | インデックス単位の統計データ |

#### Step 2: エントリーポイントを理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | IndicesStatsAction.java | `server/src/main/java/org/opensearch/action/admin/indices/stats/IndicesStatsAction.java` | アクション定義 |
| 2-2 | IndicesStatsRequest.java | `server/src/main/java/org/opensearch/action/admin/indices/stats/IndicesStatsRequest.java` | リクエスト定義 |
| 2-3 | TransportIndicesStatsAction.java | `server/src/main/java/org/opensearch/action/admin/indices/stats/TransportIndicesStatsAction.java` | トランスポートアクション（メイン処理） |

**主要処理フロー**:
1. **94-97行目**: `shards()`で対象インデックスの全シャードを取得
2. **100-107行目**: クラスタブロックチェック（METADATA_READ）
3. **133-167行目**: `shardOperation()`で各シャードの統計収集。IndexService→IndexShard→CommonStats→ShardStats
4. **115-125行目**: `newResponse()`でShardStats配列からIndicesStatsResponseを生成

### プログラム呼び出し階層図

```
TransportIndicesStatsAction (extends TransportBroadcastByNodeAction)
    |
    +-- shards() -> ClusterState.routingTable().allShards()
    |
    +-- shardOperation(request, shardRouting)
    |       +-- IndicesService.indexServiceSafe()
    |       +-- IndexService.getShard()
    |       +-- CommonStats(indicesQueryCache, indexShard, flags)
    |       +-- IndexShard.commitStats()
    |       +-- IndexShard.seqNoStats()
    |       +-- IndexShard.getRetentionLeaseStats()
    |       +-- IndexShard.pollingIngestStats()
    |       +-- ShardStats.Builder
    |
    +-- newResponse() -> IndicesStatsResponse
```

### データフロー図

```
[入力]                    [処理]                           [出力]

REST Request       ----> IndicesStatsRequest
                          |
                          v
ClusterState       ----> TransportBroadcastByNodeAction
(ShardRouting)            |
                          v (各ノード並列)
IndexShard         ----> shardOperation()
                          |
                          +-> CommonStats          -----> ShardStats[]
                          +-> CommitStats                  |
                          +-> SeqNoStats                   v
                          +-> RetentionLeaseStats   IndicesStatsResponse
                                                          |
                                                          v
                                                   REST Response (JSON)
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| IndicesStatsAction.java | `server/src/main/java/org/opensearch/action/admin/indices/stats/IndicesStatsAction.java` | ソース | アクション定義 |
| IndicesStatsRequest.java | `server/src/main/java/org/opensearch/action/admin/indices/stats/IndicesStatsRequest.java` | ソース | リクエスト定義 |
| IndicesStatsResponse.java | `server/src/main/java/org/opensearch/action/admin/indices/stats/IndicesStatsResponse.java` | ソース | レスポンス定義 |
| TransportIndicesStatsAction.java | `server/src/main/java/org/opensearch/action/admin/indices/stats/TransportIndicesStatsAction.java` | ソース | トランスポートアクション |
| CommonStats.java | `server/src/main/java/org/opensearch/action/admin/indices/stats/CommonStats.java` | ソース | 共通統計データ |
| CommonStatsFlags.java | `server/src/main/java/org/opensearch/action/admin/indices/stats/CommonStatsFlags.java` | ソース | 統計フラグ制御 |
| ShardStats.java | `server/src/main/java/org/opensearch/action/admin/indices/stats/ShardStats.java` | ソース | シャード統計 |
| IndexStats.java | `server/src/main/java/org/opensearch/action/admin/indices/stats/IndexStats.java` | ソース | インデックス統計 |
| IndexShardStats.java | `server/src/main/java/org/opensearch/action/admin/indices/stats/IndexShardStats.java` | ソース | インデックスシャード統計 |
| IndicesStatsRequestBuilder.java | `server/src/main/java/org/opensearch/action/admin/indices/stats/IndicesStatsRequestBuilder.java` | ソース | リクエストビルダー |
