# 機能設計書 106-クラスタ統計

## 概要

本ドキュメントは、OpenSearchのクラスタ統計機能（Cluster Stats）の設計を記述する。クラスタレベルの統計情報（ノード統計、インデックス統計、マッピング統計、分析統計等）を集約して取得する機能である。

### 本機能の処理概要

**業務上の目的・背景**：クラスタ全体の健全性把握、リソース使用状況の監視、インデックスマッピングの統計分析を目的として、クラスタ内の全ノードから統計情報を収集し集約して提供する。

**機能の利用シーン**：クラスタの全体状況把握、ノード間のリソース比較、マッピング・分析設定の統計確認、クラスタ管理ダッシュボードの表示に利用される。

**主要な処理内容**：
1. TransportNodesActionによる全ノードへの統計収集リクエスト
2. 各ノードでのNodeInfo/NodeStats/ShardStats収集
3. ClusterStatsNodes（ノード統計集約）とClusterStatsIndices（インデックス統計集約）の生成
4. MappingStats/AnalysisStatsによるマッピング・分析設定の統計
5. ClusterHealthStatusの計算
6. メトリクスベースのフィルタリング（Metric/IndexMetric enum）

**関連システム・外部連携**：NodeService、IndicesService、ClusterService。

**権限による制御**：特定の権限制御はコード上では確認できない（セキュリティプラグインで管理）。

## 関連画面

| 画面No | 画面名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| 92 | クラスタ統計 | 主機能 | クラスタ統計の概要を返す処理 |

## 機能種別

データ取得 / 統計情報

## 入力仕様

### 入力パラメータ

| パラメータ名 | 型 | 必須 | 説明 | バリデーション |
|-------------|-----|-----|------|---------------|
| nodeId | String[] | No | 対象ノードID | - |
| metric | Set<Metric> | No | 取得対象メトリクス | Metric enum値 |
| index_metric | Set<IndexMetric> | No | インデックスメトリクス | IndexMetric enum値 |

### 入力データソース

- REST APIリクエストパラメータ
- 各ノードのNodeInfo/NodeStats/ShardStats

## 出力仕様

### 出力データ

| 項目名 | 型 | 説明 |
|--------|-----|------|
| cluster_name | String | クラスタ名 |
| cluster_uuid | String | クラスタUUID |
| timestamp | long | タイムスタンプ |
| status | String | クラスタヘルスステータス |
| nodes | ClusterStatsNodes | ノード統計集約 |
| indices | ClusterStatsIndices | インデックス統計集約 |

### 出力先

REST APIレスポンス（JSON形式）

## 処理フロー

### 処理シーケンス

```
1. REST APIリクエスト受信
   └─ ClusterStatsRequest生成
2. TransportNodesAction実行
   └─ 各ノードにリクエスト配布
3. 各ノードでnodeOperation実行
   └─ NodeInfo/NodeStats収集
   └─ ShardStats収集
4. ClusterStatsResponse生成
   └─ ClusterStatsNodes集約
   └─ ClusterStatsIndices集約
   └─ MappingStats/AnalysisStats生成
```

### フローチャート

```mermaid
flowchart TD
    A[REST Request] --> B[ClusterStatsRequest]
    B --> C[TransportNodesAction]
    C --> D[各ノードで nodeOperation]
    D --> E[NodeInfo収集]
    D --> F[NodeStats収集]
    D --> G[ShardStats収集]
    E --> H[ClusterStatsNodeResponse]
    F --> H
    G --> H
    H --> I[ClusterStatsResponse集約]
```

## ビジネスルール

### 業務ルール

| ルールNo | ルール名 | 内容 | 適用条件 |
|---------|---------|------|---------|
| BR-601 | メトリクスフィルタリング | Metric/IndexMetric enumで取得対象を制御 | リクエスト処理時 |
| BR-602 | ヘルスステータス計算 | ClusterStateHealthからヘルスステータスを導出 | レスポンス生成時 |

### 計算ロジック

ノード統計は全ノードの情報を集約して計算。インデックス統計は全シャードの統計を集約。

## データベース操作仕様

読み取り専用操作。データベース更新なし。

## エラー処理

### エラーケース一覧

| エラーコード | エラー種別 | 発生条件 | 対処方法 |
|------------|----------|---------|---------|
| - | FailedNodeException | ノードからの統計収集失敗 | 失敗ノード情報をレスポンスに含む |

### リトライ仕様

個別ノードの失敗はレスポンスのfailuresに含まれ、他のノードの統計は返却される。

## トランザクション仕様

読み取り専用操作。トランザクション管理不要。

## パフォーマンス要件

- 全ノードへの並列リクエストで統計収集
- Metric/IndexMetricフィルタにより不要な統計収集を回避

## セキュリティ考慮事項

- クラスタ統計には機密性の高いノード情報が含まれる可能性がある
- セキュリティプラグインによるアクセス制御が推奨される

## 備考

- ClusterStatsResponseはToXContentFragmentを実装しJSON出力対応
- MappingStatsはマッピング定義のフィールド型統計を提供
- AnalysisStatsは使用されているアナライザ・トークナイザの統計を提供

---

## コードリーディングガイド

本機能を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: データ構造を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | ClusterStatsRequest.java | `server/src/main/java/org/opensearch/action/admin/cluster/stats/ClusterStatsRequest.java` | Metric/IndexMetric enumの定義 |
| 1-2 | ClusterStatsNodeResponse.java | `server/src/main/java/org/opensearch/action/admin/cluster/stats/ClusterStatsNodeResponse.java` | ノード単位レスポンス |
| 1-3 | ClusterStatsResponse.java | `server/src/main/java/org/opensearch/action/admin/cluster/stats/ClusterStatsResponse.java` | 集約レスポンス |

#### Step 2: エントリーポイントを理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | TransportClusterStatsAction.java | `server/src/main/java/org/opensearch/action/admin/cluster/stats/TransportClusterStatsAction.java` | メインTransportAction |

**主要処理フロー**:
1. **78-80行目**: TransportNodesAction継承による全ノード並列処理

#### Step 3: 統計集約を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | ClusterStatsNodes.java | `server/src/main/java/org/opensearch/action/admin/cluster/stats/ClusterStatsNodes.java` | ノード統計集約 |
| 3-2 | ClusterStatsIndices.java | `server/src/main/java/org/opensearch/action/admin/cluster/stats/ClusterStatsIndices.java` | インデックス統計集約 |
| 3-3 | MappingStats.java | `server/src/main/java/org/opensearch/action/admin/cluster/stats/MappingStats.java` | マッピング統計 |
| 3-4 | AnalysisStats.java | `server/src/main/java/org/opensearch/action/admin/cluster/stats/AnalysisStats.java` | 分析統計 |

### プログラム呼び出し階層図

```
TransportClusterStatsAction (extends TransportNodesAction)
    |
    +-- nodeOperation()
    |       +-- NodeService.info()  -> NodeInfo
    |       +-- NodeService.stats() -> NodeStats
    |       +-- IndicesService -> ShardStats[]
    |
    +-- newResponse()
            +-- ClusterStatsNodes(nodeResponses)
            +-- ClusterStatsIndices(shardStats)
            +-- MappingStats.of(clusterState)
            +-- AnalysisStats.of(clusterState)
```

### データフロー図

```
[入力]                    [処理]                           [出力]

REST Request       ----> ClusterStatsRequest
                          |
                          v (各ノード並列)
NodeService        ----> NodeInfo + NodeStats
IndicesService     ----> ShardStats[]
                          |
                          v
                   ClusterStatsNodeResponse
                          |
                          v (集約)
                   ClusterStatsResponse     -----> REST Response (JSON)
                     +- ClusterStatsNodes
                     +- ClusterStatsIndices
                     +- MappingStats
                     +- AnalysisStats
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| ClusterStatsAction.java | `server/src/main/java/org/opensearch/action/admin/cluster/stats/ClusterStatsAction.java` | ソース | アクション定義 |
| ClusterStatsRequest.java | `server/src/main/java/org/opensearch/action/admin/cluster/stats/ClusterStatsRequest.java` | ソース | リクエスト定義 |
| ClusterStatsResponse.java | `server/src/main/java/org/opensearch/action/admin/cluster/stats/ClusterStatsResponse.java` | ソース | レスポンス定義 |
| TransportClusterStatsAction.java | `server/src/main/java/org/opensearch/action/admin/cluster/stats/TransportClusterStatsAction.java` | ソース | トランスポートアクション |
| ClusterStatsNodes.java | `server/src/main/java/org/opensearch/action/admin/cluster/stats/ClusterStatsNodes.java` | ソース | ノード統計集約 |
| ClusterStatsIndices.java | `server/src/main/java/org/opensearch/action/admin/cluster/stats/ClusterStatsIndices.java` | ソース | インデックス統計集約 |
| ClusterStatsNodeResponse.java | `server/src/main/java/org/opensearch/action/admin/cluster/stats/ClusterStatsNodeResponse.java` | ソース | ノードレスポンス |
| MappingStats.java | `server/src/main/java/org/opensearch/action/admin/cluster/stats/MappingStats.java` | ソース | マッピング統計 |
| AnalysisStats.java | `server/src/main/java/org/opensearch/action/admin/cluster/stats/AnalysisStats.java` | ソース | 分析統計 |
| MappingVisitor.java | `server/src/main/java/org/opensearch/action/admin/cluster/stats/MappingVisitor.java` | ソース | マッピング走査 |
| IndexFeatureStats.java | `server/src/main/java/org/opensearch/action/admin/cluster/stats/IndexFeatureStats.java` | ソース | インデックス機能統計 |
| ClusterStatsRequestBuilder.java | `server/src/main/java/org/opensearch/action/admin/cluster/stats/ClusterStatsRequestBuilder.java` | ソース | リクエストビルダー |
