# 機能設計書 108-Ehcacheプラグイン

## 概要

本ドキュメントは、OpenSearchのEhcacheプラグイン（Ehcache Disk Cache Plugin）の設計を記述する。Ehcacheライブラリを使用したディスクベースのキャッシュ実装を提供するプラグインである。

### 本機能の処理概要

**業務上の目的・背景**：キャッシュ共通基盤（No.107）のディスク層として使用されるEhcacheベースのキャッシュ実装を提供する。ヒープメモリの制約を超えて大量のキャッシュエントリをディスク上に永続化し、メモリ効率を最大化する。

**機能の利用シーン**：TieredSpilloverCacheのディスク層として使用。オンヒープキャッシュから溢れたエントリをディスクに保存し、ヒープメモリの圧迫を防ぎつつキャッシュヒット率を維持する。

**主要な処理内容**：
1. EhcacheDiskCacheによるICache<K,V>インターフェースの実装
2. PersistentCacheManagerによるEhcacheキャッシュマネージャのライフサイクル管理
3. キー/値のシリアライゼーション（ICacheKeySerializer、Serializer）
4. キャッシュイベントリスナーによるRemovalNotificationの発行
5. TTL（Time To Live）ベースのExpiry管理
6. EhcacheDiskCacheManagerによる複数キャッシュインスタンスの一元管理
7. 設定ベースのディスクサイズ・セグメント数・スレッド数制御

**関連システム・外部連携**：Ehcacheライブラリ（org.ehcache）、キャッシュ共通基盤（TieredSpilloverCache）。

**権限による制御**：特定の権限制御はない。ファイルシステムアクセスが必要。

## 関連画面

| 画面No | 画面名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| - | - | - | 本機能は直接的な画面を持たない内部プラグイン |

## 機能種別

プラグイン / ディスクキャッシュ

## 入力仕様

### 入力パラメータ

| パラメータ名 | 型 | 必須 | 説明 | バリデーション |
|-------------|-----|-----|------|---------------|
| disk_cache.storage.path | String | Yes | ディスクキャッシュ保存パス | 有効なファイルパス |
| disk_cache.max_size_in_bytes | long | No | 最大ディスクサイズ | 正の値 |
| disk_cache.alias | String | No | キャッシュエイリアス名 | - |
| disk_cache.expire_after_access | TimeValue | No | アクセス後の有効期限 | 正のTimeValue |
| disk_cache.segment | int | No | ディスクセグメント数 | 正の整数 |
| disk_cache.concurrency.write.min_threads | int | No | 書き込み最小スレッド数 | 正の整数 |
| disk_cache.concurrency.write.max_threads | int | No | 書き込み最大スレッド数 | 正の整数 |
| disk_cache.concurrency.write_concurrency | int | No | 書き込み並行度 | 正の整数 |
| disk_cache.listener_mode.sync | boolean | No | 同期リスナーモード | - |

### 入力データソース

- クラスタ設定/インデックス設定
- TieredSpilloverCacheからのスピルオーバーデータ

## 出力仕様

### 出力データ

| 項目名 | 型 | 説明 |
|--------|-----|------|
| キャッシュ値 | V | ディスクキャッシュから取得した値 |
| stats | ImmutableCacheStatsHolder | キャッシュ統計 |

### 出力先

呼び出し元のキャッシュ利用コンポーネント（TieredSpilloverCache）

## 処理フロー

### 処理シーケンス

```
1. EhcacheDiskCache初期化
   └─ PersistentCacheManager生成
   └─ CacheConfiguration構築（サイズ、TTL、セグメント等）
2. put(key, value)
   └─ ICacheKeySerializerでキーシリアライズ
   └─ Ehcache Cache.put()
3. get(key)
   └─ Ehcache Cache.get()
   └─ デシリアライズして返却
4. Eviction発生時
   └─ CacheEventListenerでイベント検知
   └─ RemovalNotification発行
```

### フローチャート

```mermaid
flowchart TD
    A[TieredSpilloverCache] --> B[EhcacheDiskCache.put]
    B --> C[ICacheKeySerializer.serialize]
    C --> D[Ehcache PersistentCache.put]
    D --> E[ディスク書き込み]

    F[TieredSpilloverCache] --> G[EhcacheDiskCache.get]
    G --> H[Ehcache PersistentCache.get]
    H --> I[デシリアライズ]
    I --> J[値返却]
```

## ビジネスルール

### 業務ルール

| ルールNo | ルール名 | 内容 | 適用条件 |
|---------|---------|------|---------|
| BR-801 | TTL管理 | expire_after_access設定によるエントリ自動失効 | キャッシュアクセス時 |
| BR-802 | ディスクサイズ制限 | max_size_in_bytesを超過した場合のEviction | ディスクキャッシュフル時 |

### 計算ロジック

Ehcacheの内部LRU（Least Recently Used）アルゴリズムによるEviction。

## データベース操作仕様

データベース操作なし。ローカルファイルシステムへのディスクキャッシュ保存。

## エラー処理

### エラーケース一覧

| エラーコード | エラー種別 | 発生条件 | 対処方法 |
|------------|----------|---------|---------|
| - | CacheLoadingException | キャッシュロード失敗 | ログ出力、キャッシュミスとして処理 |
| - | CacheWritingException | キャッシュ書き込み失敗 | ログ出力、書き込みスキップ |
| - | SerializerException | シリアライズ/デシリアライズ失敗 | ログ出力、エントリスキップ |
| - | OpenSearchException | キャッシュマネージャ初期化失敗 | エラー伝搬 |

### リトライ仕様

ディスクI/O失敗時のリトライはEhcache内部で処理。アプリケーションレベルでのリトライは行わない。

## トランザクション仕様

Ehcacheのアトミック操作に依存。キャッシュ操作はスレッドセーフ。

## パフォーマンス要件

- CompletableFutureによる同一キーの重複ロード防止
- PooledExecutionServiceによるスレッドプール管理
- OffHeapDiskStoreConfigurationによるセグメント化

## セキュリティ考慮事項

- ディスクキャッシュデータはローカルファイルシステムに平文で保存
- ストレージパスへのファイルシステム権限が必要
- `@SuppressForbidden`によるセキュリティマネージャ制約の回避あり

## 備考

- 本機能は `@ExperimentalApi` として提供されている
- Ehcache PersistentCacheManagerはFileBasedPersistenceContextを使用

---

## コードリーディングガイド

本機能を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: データ構造を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | EhcacheDiskCacheSettings.java | `plugins/cache-ehcache/src/main/java/org/opensearch/cache/EhcacheDiskCacheSettings.java` | ディスクキャッシュ設定定義 |

#### Step 2: エントリーポイントを理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | EhcacheCachePlugin.java | `plugins/cache-ehcache/src/main/java/org/opensearch/cache/EhcacheCachePlugin.java` | プラグインエントリーポイント |
| 2-2 | EhcacheDiskCache.java | `plugins/cache-ehcache/src/main/java/org/opensearch/cache/store/disk/EhcacheDiskCache.java` | メインディスクキャッシュ実装 |

**主要処理フロー**:
1. **98行目**: ICache<K,V>インターフェースの実装
2. **61-77行目**: Ehcacheライブラリのimport（PersistentCacheManager、CacheConfigurationBuilder等）
3. **79-87行目**: 設定キー定数のimport

#### Step 3: マネージャ層を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | EhcacheDiskCacheManager.java | `plugins/cache-ehcache/src/main/java/org/opensearch/cache/store/disk/EhcacheDiskCacheManager.java` | キャッシュマネージャ |

### プログラム呼び出し階層図

```
EhcacheCachePlugin
    |
    +-- EhcacheDiskCacheManager
            |
            +-- EhcacheDiskCache (ICache<K,V>)
                    |
                    +-- PersistentCacheManager (Ehcache)
                    |       +-- CacheConfigurationBuilder
                    |       +-- ResourcePoolsBuilder
                    |       +-- OffHeapDiskStoreConfiguration
                    |
                    +-- ICacheKeySerializer
                    +-- Serializer<V>
                    +-- CacheEventListener
                    +-- ExpiryPolicy
```

### データフロー図

```
[入力]                    [処理]                           [出力]

ICacheKey<K> + V   ----> EhcacheDiskCache
                          |
                          +-> ICacheKeySerializer   ----> byte[] (キー)
                          +-> Serializer<V>         ----> ByteBuffer (値)
                          |
                          v
                   Ehcache PersistentCache
                          |
                          v
                   ディスクファイルシステム     ----> 永続化データ
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| EhcacheCachePlugin.java | `plugins/cache-ehcache/src/main/java/org/opensearch/cache/EhcacheCachePlugin.java` | ソース | プラグインクラス |
| EhcacheDiskCacheSettings.java | `plugins/cache-ehcache/src/main/java/org/opensearch/cache/EhcacheDiskCacheSettings.java` | ソース | 設定定義 |
| EhcacheDiskCache.java | `plugins/cache-ehcache/src/main/java/org/opensearch/cache/store/disk/EhcacheDiskCache.java` | ソース | ディスクキャッシュ実装 |
| EhcacheDiskCacheManager.java | `plugins/cache-ehcache/src/main/java/org/opensearch/cache/store/disk/EhcacheDiskCacheManager.java` | ソース | キャッシュマネージャ |
