# 機能設計書 109-インデックスキャッシュ

## 概要

本ドキュメントは、OpenSearchのインデックスキャッシュ機能（Index Cache）の設計を記述する。インデックスレベルのクエリキャッシュ、リクエストキャッシュ、ビットセットフィルタキャッシュを管理する機能である。

### 本機能の処理概要

**業務上の目的・背景**：検索パフォーマンスの向上のために、インデックスレベルで頻繁に使用されるクエリ結果やフィルタのビットセットをキャッシュする。クエリキャッシュはLuceneセグメント単位でフィルタ結果をキャッシュし、リクエストキャッシュはシャードレベルで検索リクエスト結果をキャッシュする。

**機能の利用シーン**：同一フィルタクエリの繰り返し実行時のクエリキャッシュ利用、同一検索リクエストの繰り返し時のリクエストキャッシュ利用、親子関係クエリでのビットセットフィルタキャッシュ利用。

**主要な処理内容**：
1. IndexCacheによるクエリキャッシュとビットセットフィルタキャッシュの統合管理
2. QueryCache（IndexQueryCache/DisabledQueryCache）によるLuceneクエリ結果のキャッシュ
3. BitsetFilterCacheによるネストドキュメント・親子関係フィルタのビットセットキャッシュ
4. ShardRequestCacheによるシャードレベルのリクエスト結果キャッシュ
5. キャッシュ統計情報（ヒット数、ミス数、サイズ等）の収集
6. キャッシュクリア操作

**関連システム・外部連携**：Lucene IndexSearcher、IndicesQueryCache、シャードレベルの検索処理。

**権限による制御**：キャッシュ設定はインデックス設定として管理される。

## 関連画面

| 画面No | 画面名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| 150 | Cat Fielddata | 主機能 | フィールドデータのヒープメモリ使用量をテーブル形式で表示 |

## 機能種別

基盤機能 / キャッシュ管理

## 入力仕様

### 入力パラメータ

| パラメータ名 | 型 | 必須 | 説明 | バリデーション |
|-------------|-----|-----|------|---------------|
| index.queries.cache.enabled | boolean | No | クエリキャッシュの有効/無効 | デフォルト: true |
| index.queries.cache.everything | boolean | No | 全クエリをキャッシュ対象に | デフォルト: false |

### 入力データソース

- インデックス設定
- Luceneクエリ/フィルタ実行結果
- 検索リクエスト結果

## 出力仕様

### 出力データ

| 項目名 | 型 | 説明 |
|--------|-----|------|
| query_cache.memory_size_in_bytes | long | クエリキャッシュメモリサイズ |
| query_cache.total_count | long | クエリキャッシュ合計カウント |
| query_cache.hit_count | long | ヒット数 |
| query_cache.miss_count | long | ミス数 |
| query_cache.cache_size | long | キャッシュサイズ |
| query_cache.evictions | long | Eviction数 |
| request_cache.memory_size_in_bytes | long | リクエストキャッシュメモリサイズ |
| request_cache.hit_count | long | リクエストキャッシュヒット数 |
| request_cache.miss_count | long | リクエストキャッシュミス数 |
| request_cache.evictions | long | リクエストキャッシュEviction数 |

### 出力先

統計API（IndicesStats）、REST APIレスポンス

## 処理フロー

### 処理シーケンス

```
1. IndexCache初期化（インデックス作成時）
   └─ QueryCache（IndexQueryCacheまたはDisabledQueryCache）生成
   └─ BitsetFilterCache生成
2. 検索クエリ実行時
   └─ QueryCacheでフィルタ結果のキャッシュ参照/登録
3. リクエストキャッシュ参照時
   └─ ShardRequestCacheで結果キャッシュの参照/登録
4. キャッシュクリア操作
   └─ IndexCache.clear()でQueryCacheとBitsetFilterCacheをクリア
```

### フローチャート

```mermaid
flowchart TD
    A[検索クエリ実行] --> B{QueryCache有効?}
    B -->|Yes| C{キャッシュHit?}
    B -->|No| E[通常実行]
    C -->|Yes| D[キャッシュ結果返却]
    C -->|No| E
    E --> F[クエリ実行]
    F --> G[結果をキャッシュ登録]
    G --> D
```

## ビジネスルール

### 業務ルール

| ルールNo | ルール名 | 内容 | 適用条件 |
|---------|---------|------|---------|
| BR-901 | クエリキャッシュ無効化 | DisabledQueryCacheによるキャッシュ完全無効化 | index.queries.cache.enabled=false |
| BR-902 | セグメント単位キャッシュ | クエリキャッシュはLuceneセグメント単位で管理 | セグメントマージ時にキャッシュ無効化 |

### 計算ロジック

特になし。

## データベース操作仕様

データベース操作なし。インメモリキャッシュ。

## エラー処理

### エラーケース一覧

| エラーコード | エラー種別 | 発生条件 | 対処方法 |
|------------|----------|---------|---------|
| - | IOException | キャッシュクローズ時のエラー | IOUtils.close()で安全にクローズ |

### リトライ仕様

キャッシュミス時は通常のクエリ実行にフォールバック。

## トランザクション仕様

キャッシュ操作はスレッドセーフ。トランザクション管理不要。

## パフォーマンス要件

- クエリキャッシュはインデックスレベルの設定で有効/無効切替
- LRUベースのEvictionポリシー

## セキュリティ考慮事項

- キャッシュデータはノードローカルのヒープメモリに保持
- インデックスの削除時にキャッシュも自動クリア

## 備考

- IndexCacheは `@PublicApi(since = "1.0.0")` として安定APIで提供
- BitsetFilterCacheはネストドキュメントやparent-joinクエリで使用

---

## コードリーディングガイド

本機能を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: データ構造を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | QueryCacheStats.java | `server/src/main/java/org/opensearch/index/cache/query/QueryCacheStats.java` | クエリキャッシュ統計データ構造 |
| 1-2 | RequestCacheStats.java | `server/src/main/java/org/opensearch/index/cache/request/RequestCacheStats.java` | リクエストキャッシュ統計データ構造 |

#### Step 2: エントリーポイントを理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | IndexCache.java | `server/src/main/java/org/opensearch/index/cache/IndexCache.java` | インデックスキャッシュの統合管理クラス |

**主要処理フロー**:
1. **51行目**: AbstractIndexComponentを継承
2. **56-60行目**: QueryCacheとBitsetFilterCacheをコンストラクタで受け取り
3. **62-63行目**: `query()`でQueryCacheアクセス
4. **69-71行目**: `bitsetFilterCache()`でBitsetFilterCacheアクセス
5. **74-76行目**: `close()`でIOUtils.closeによる安全なクローズ
6. **78-81行目**: `clear()`で両キャッシュのクリア

#### Step 3: 各キャッシュ実装を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | QueryCache.java | `server/src/main/java/org/opensearch/index/cache/query/QueryCache.java` | クエリキャッシュインターフェース |
| 3-2 | IndexQueryCache.java | `server/src/main/java/org/opensearch/index/cache/query/IndexQueryCache.java` | クエリキャッシュ実装 |
| 3-3 | DisabledQueryCache.java | `server/src/main/java/org/opensearch/index/cache/query/DisabledQueryCache.java` | 無効化クエリキャッシュ |
| 3-4 | BitsetFilterCache.java | `server/src/main/java/org/opensearch/index/cache/bitset/BitsetFilterCache.java` | ビットセットフィルタキャッシュ |
| 3-5 | ShardRequestCache.java | `server/src/main/java/org/opensearch/index/cache/request/ShardRequestCache.java` | シャードリクエストキャッシュ |

### プログラム呼び出し階層図

```
IndexCache
    |
    +-- QueryCache (interface)
    |       +-- IndexQueryCache (Luceneキャッシュ利用)
    |       +-- DisabledQueryCache (無効化)
    |
    +-- BitsetFilterCache
    |       +-- ShardBitsetFilterCache
    |
    +-- ShardRequestCache (別管理)
            +-- RequestCacheStats
```

### データフロー図

```
[入力]                    [処理]                           [出力]

Lucene Query       ----> IndexQueryCache
                          |
                          +-> [HIT]               -----> キャッシュ結果
                          +-> [MISS] -> 実行      -----> 結果 + キャッシュ登録

Search Request     ----> ShardRequestCache
                          |
                          +-> [HIT]               -----> キャッシュ結果
                          +-> [MISS] -> 実行      -----> 結果 + キャッシュ登録

Nested/Parent Query -> BitsetFilterCache
                          |
                          +-> [HIT]               -----> BitSet
                          +-> [MISS] -> 計算      -----> BitSet + キャッシュ登録
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| IndexCache.java | `server/src/main/java/org/opensearch/index/cache/IndexCache.java` | ソース | 統合キャッシュ管理 |
| QueryCache.java | `server/src/main/java/org/opensearch/index/cache/query/QueryCache.java` | ソース | クエリキャッシュIF |
| IndexQueryCache.java | `server/src/main/java/org/opensearch/index/cache/query/IndexQueryCache.java` | ソース | クエリキャッシュ実装 |
| DisabledQueryCache.java | `server/src/main/java/org/opensearch/index/cache/query/DisabledQueryCache.java` | ソース | 無効化キャッシュ |
| QueryCacheStats.java | `server/src/main/java/org/opensearch/index/cache/query/QueryCacheStats.java` | ソース | クエリキャッシュ統計 |
| BitsetFilterCache.java | `server/src/main/java/org/opensearch/index/cache/bitset/BitsetFilterCache.java` | ソース | ビットセットキャッシュ |
| ShardBitsetFilterCache.java | `server/src/main/java/org/opensearch/index/cache/bitset/ShardBitsetFilterCache.java` | ソース | シャードビットセットキャッシュ |
| ShardRequestCache.java | `server/src/main/java/org/opensearch/index/cache/request/ShardRequestCache.java` | ソース | リクエストキャッシュ |
| RequestCacheStats.java | `server/src/main/java/org/opensearch/index/cache/request/RequestCacheStats.java` | ソース | リクエストキャッシュ統計 |
