# 機能設計書 112-Geoモジュール

## 概要

本ドキュメントは、OpenSearchのGeoモジュールの機能設計書である。地理空間データの処理・検索を支援するマッパーおよび集計機能を提供する。

### 本機能の処理概要

**業務上の目的・背景**：位置情報を含むデータ（店舗位置、ユーザ位置、配送ルートなど）に対して、地理空間的な検索や集計分析を行う必要がある。Geoモジュールは、GeoShapeフィールドマッパーと地理空間集計（GeoBounds、GeoHashGrid、GeoTileGrid）を提供し、地理空間データの格納・検索・集計を実現する。

**機能の利用シーン**：地図上でのデータ可視化、特定エリア内のドキュメント検索、地理的なバケット集計によるヒートマップ生成、地理的境界ボックスの算出などの場面で利用される。

**主要な処理内容**：
1. GeoShapeFieldMapperによるGeoShape型フィールドのマッピング定義
2. GeoBoundsAggregationBuilderによる地理的境界ボックスの算出集計
3. GeoHashGridAggregationBuilderによるGeoHashグリッドバケット集計
4. GeoTileGridAggregationBuilderによるGeoTileグリッドバケット集計
5. GeoTileGridValuesSourceBuilderによるComposite集計内でのGeoTileGrid使用

**関連システム・外部連携**：Luceneの地理空間インデックス機能を利用する。serverモジュールのGeoPointフィールドマッパーと連携する。

**権限による制御**：対象インデックスへの読み取り権限（検索・集計時）および書き込み権限（マッピング定義時）が必要。

## 関連画面

| 画面No | 画面名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| - | - | - | 本機能は画面機能マッピングに直接対応する画面なし。検索API（画面No.21）の集計機能として使用される |

## 機能種別

データ定義 / 集計処理

## 入力仕様

### 入力パラメータ

| パラメータ名 | 型 | 必須 | 説明 | バリデーション |
|-------------|-----|-----|------|---------------|
| type (マッピング) | String | Yes | "geo_shape" フィールドタイプ指定 | geo_shapeであること |
| field (集計) | String | Yes | 集計対象のフィールド名 | geo_pointまたはgeo_shapeフィールドであること |
| precision (GeoHash/TileGrid) | int/String | No | グリッドの精度レベル | 有効な精度値であること |
| bounds (GeoHash/TileGrid) | Object | No | 集計を制限する地理的境界 | 有効な座標であること |
| wrap_longitude (GeoBounds) | boolean | No | 経度の折り返し処理 | - |

### 入力データソース

検索API経由の集計リクエスト、またはインデックスマッピング定義リクエスト。

## 出力仕様

### 出力データ

| 項目名 | 型 | 説明 |
|--------|-----|------|
| bounds (GeoBounds) | Object | top_left, bottom_right座標の境界ボックス |
| buckets (GeoHashGrid) | Array | GeoHashキーごとのバケット（doc_count含む） |
| buckets (GeoTileGrid) | Array | z/x/yタイル座標ごとのバケット（doc_count含む） |

### 出力先

検索APIレスポンスのaggregationsセクション内。

## 処理フロー

### 処理シーケンス

```
1. プラグイン登録（GeoModulePlugin）
   └─ GeoShapeFieldMapper、集計ビルダーをOpenSearchに登録
2. マッピング定義時
   └─ GeoShapeFieldMapper.TypeParserがフィールド定義をパース
3. 検索・集計時
   └─ 各AggregationBuilderが集計ロジックを構築
   └─ Aggregator実装が各シャードでデータを集計
   └─ Internal*クラスが結果をマージ
```

### フローチャート

```mermaid
flowchart TD
    A[検索リクエスト受信] --> B{集計タイプ判定}
    B -->|geo_bounds| C[GeoBoundsAggregator]
    B -->|geohash_grid| D[GeoHashGrid Aggregator]
    B -->|geotile_grid| E[GeoTileGrid Aggregator]
    C --> F[InternalGeoBounds生成]
    D --> G[GeoHashGrid生成]
    E --> H[GeoTileGrid生成]
    F --> I[シャード間結果マージ]
    G --> I
    H --> I
    I --> J[集計結果返却]
```

## ビジネスルール

### 業務ルール

| ルールNo | ルール名 | 内容 | 適用条件 |
|---------|---------|------|---------|
| BR-112-01 | GeoShape対応 | GeoShapeフィールドに対してもGeoBounds、GeoHashGrid、GeoTileGrid集計が可能 | GeoShapeフィールド指定時 |
| BR-112-02 | Composite集計対応 | GeoTileGridはComposite集計のソースとして使用可能 | Composite集計内 |

### 計算ロジック

- GeoBounds: 全ドキュメントの座標値からtop/left/bottom/rightの最大・最小値を算出
- GeoHashGrid: GeoHash文字列の指定精度レベルでバケット化
- GeoTileGrid: z/x/yタイル座標の指定精度レベルでバケット化

## データベース操作仕様

### 操作別データベース影響一覧

| 操作 | 対象テーブル | 操作種別 | 概要 |
|-----|-------------|---------|------|
| マッピング定義 | インデックスメタデータ | UPDATE | GeoShapeフィールドの定義 |
| 集計実行 | 対象インデックス | SELECT | GeoPoint/GeoShapeフィールドの読み取り |

### テーブル別操作詳細

集計は読み取り専用操作。マッピング定義時はインデックスメタデータが更新される。

## エラー処理

### エラーケース一覧

| エラーコード | エラー種別 | 発生条件 | 対処方法 |
|------------|----------|---------|---------|
| 400 | IllegalArgumentException | 無効な精度値の指定 | 有効な精度値を指定する |
| 400 | MapperParsingException | GeoShape定義のパースエラー | マッピング定義を確認する |

### リトライ仕様

集計は検索の一部として実行され、リトライは検索APIの仕様に従う。

## トランザクション仕様

集計は読み取り専用操作のため、トランザクション管理は不要。

## パフォーマンス要件

- グリッド集計の精度レベルが高いほどバケット数が増加しメモリ使用量が増える
- boundsパラメータによる地理的範囲の制限でパフォーマンスを最適化可能

## セキュリティ考慮事項

- 対象インデックスへのアクセス権限に基づく制御

## 備考

- モジュール名: geo
- プラグインクラス: GeoModulePlugin
- MapperPluginおよびSearchPluginインターフェースを実装

---

## コードリーディングガイド

本機能を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: データ構造を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | GeoModulePlugin.java | `modules/geo/src/main/java/org/opensearch/geo/GeoModulePlugin.java` | プラグイン登録内容：マッパー1種、集計3種、Composite集計1種 |

**読解のコツ**: GeoModulePluginはMapperPluginとSearchPluginを同時に実装し、getMappers()でGeoShapeFieldMapper、getAggregations()で3つの集計、getCompositeAggregations()でGeoTileGrid Compositeソースを登録する。

#### Step 2: マッパーを理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | GeoShapeFieldMapper.java | `server/src/main/java/org/opensearch/index/mapper/GeoShapeFieldMapper.java` | GeoShapeフィールドのマッピング定義とインデクシング |

#### Step 3: 集計を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | GeoBoundsAggregationBuilder.java | `modules/geo/src/main/java/org/opensearch/geo/search/aggregations/metrics/GeoBoundsAggregationBuilder.java` | GeoBounds集計のビルダーとパーサー |
| 3-2 | GeoHashGridAggregationBuilder.java | `modules/geo/src/main/java/org/opensearch/geo/search/aggregations/bucket/geogrid/GeoHashGridAggregationBuilder.java` | GeoHashGrid集計のビルダー |
| 3-3 | GeoTileGridAggregationBuilder.java | `modules/geo/src/main/java/org/opensearch/geo/search/aggregations/bucket/geogrid/GeoTileGridAggregationBuilder.java` | GeoTileGrid集計のビルダー |
| 3-4 | GeoTileGridValuesSourceBuilder.java | `modules/geo/src/main/java/org/opensearch/geo/search/aggregations/bucket/composite/GeoTileGridValuesSourceBuilder.java` | Composite集計用のGeoTileGridソース |

### プログラム呼び出し階層図

```
GeoModulePlugin
    |
    +-- getMappers()
    |       +-- GeoShapeFieldMapper.TypeParser
    |
    +-- getAggregations()
    |       +-- GeoBoundsAggregationBuilder --> GeoBoundsAggregator --> InternalGeoBounds
    |       +-- GeoHashGridAggregationBuilder --> GeoHashGrid Aggregator --> GeoHashGrid
    |       +-- GeoTileGridAggregationBuilder --> GeoTileGrid Aggregator --> GeoTileGrid
    |
    +-- getCompositeAggregations()
            +-- GeoTileGridValuesSourceBuilder
```

### データフロー図

```
[入力]                     [処理]                         [出力]

マッピング定義        --> GeoShapeFieldMapper           --> インデックスメタデータ更新

検索リクエスト        --> AggregationBuilder             --> Aggregator生成
(aggregationsセクション)     |
                            +-> 各シャードで集計実行      --> Internal*結果
                            +-> 結果マージ               --> 最終集計結果
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| GeoModulePlugin.java | `modules/geo/src/main/java/org/opensearch/geo/GeoModulePlugin.java` | ソース | プラグイン登録 |
| GeoBoundsAggregationBuilder.java | `modules/geo/src/main/java/org/opensearch/geo/search/aggregations/metrics/GeoBoundsAggregationBuilder.java` | ソース | GeoBounds集計ビルダー |
| InternalGeoBounds.java | `modules/geo/src/main/java/org/opensearch/geo/search/aggregations/metrics/InternalGeoBounds.java` | ソース | GeoBounds内部結果 |
| GeoHashGridAggregationBuilder.java | `modules/geo/src/main/java/org/opensearch/geo/search/aggregations/bucket/geogrid/GeoHashGridAggregationBuilder.java` | ソース | GeoHashGrid集計ビルダー |
| GeoTileGridAggregationBuilder.java | `modules/geo/src/main/java/org/opensearch/geo/search/aggregations/bucket/geogrid/GeoTileGridAggregationBuilder.java` | ソース | GeoTileGrid集計ビルダー |
| GeoTileGridValuesSourceBuilder.java | `modules/geo/src/main/java/org/opensearch/geo/search/aggregations/bucket/composite/GeoTileGridValuesSourceBuilder.java` | ソース | Composite集計用GeoTileGridソース |
| GeoShapeFieldMapper.java | `server/src/main/java/org/opensearch/index/mapper/GeoShapeFieldMapper.java` | ソース | GeoShapeフィールドマッパー |
| PolygonGenerator.java | `modules/geo/src/main/java/org/opensearch/geo/algorithm/PolygonGenerator.java` | ソース | ポリゴン生成アルゴリズム |
