# 機能設計書 114-Dashboards連携

## 概要

本ドキュメントは、OpenSearchのDashboards連携モジュールの機能設計書である。OpenSearch Dashboards向けのシステムインデックス管理およびAPI提供を行う。

### 本機能の処理概要

**業務上の目的・背景**：OpenSearch DashboardsはOpenSearchの可視化フロントエンドであり、設定やSaved Objects（保存済みオブジェクト）をOpenSearchのシステムインデックスに格納する。このモジュールは、Dashboardsがシステムインデックスへ安全にアクセスするための専用APIエンドポイントを提供し、通常のインデックスとは区別されたアクセス制御を実現する。

**機能の利用シーン**：OpenSearch Dashboardsの起動時のマイグレーション処理、Saved Objectsの読み書き、レポーティング機能でのデータアクセスなどで利用される。

**主要な処理内容**：
1. システムインデックスの定義（.opensearch_dashboards, .opensearch_dashboards_*, .reporting-*, .apm-*）
2. `/_opensearch_dashboards` プレフィックス付きのREST APIエンドポイントの提供
3. 既存のREST APIハンドラーをラップし、システムインデックスへのアクセスをデフォルトで許可
4. 設定 `opensearch_dashboards.system_indices` によるシステムインデックスパターンのカスタマイズ

**関連システム・外部連携**：OpenSearch Dashboardsフロントエンドアプリケーションと連携する。

**権限による制御**：`allowSystemIndexAccessByDefault()`がtrueに設定されており、Dashboards経由のリクエストはシステムインデックスへのアクセスがデフォルトで許可される。

## 関連画面

| 画面No | 画面名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| - | - | - | 本機能はOpenSearch Dashboardsのバックエンド支援機能であり、REST API画面に直接対応しない |

## 機能種別

データ連携 / API提供

## 入力仕様

### 入力パラメータ

| パラメータ名 | 型 | 必須 | 説明 | バリデーション |
|-------------|-----|-----|------|---------------|
| opensearch_dashboards.system_indices | List[String] | No | システムインデックスのパターンリスト | 有効なインデックスパターンであること |

### 入力データソース

OpenSearch Dashboardsからの `/_opensearch_dashboards/*` 形式のRESTリクエスト。

## 出力仕様

### 出力データ

各ラップされたAPIの出力は、元のREST APIハンドラーの仕様に従う。

### 出力先

REST APIレスポンス（JSON形式）

## 処理フロー

### 処理シーケンス

```
1. プラグイン初期化
   └─ OpenSearchDashboardsModulePluginがSystemIndexPluginとして登録
2. システムインデックス定義
   └─ OPENSEARCH_DASHBOARDS_INDEX_NAMES_SETTINGに基づきSystemIndexDescriptorを生成
3. RESTハンドラー登録
   └─ 既存のREST APIハンドラーをOpenSearchDashboardsWrappedRestHandlerでラップ
   └─ ルートを /_opensearch_dashboards プレフィックス付きに変換
4. リクエスト処理
   └─ ラップされたハンドラーがシステムインデックスアクセスを許可し、
      元のハンドラーに処理を委譲
```

### フローチャート

```mermaid
flowchart TD
    A[Dashboardsからのリクエスト] --> B["/_opensearch_dashboards/* エンドポイント"]
    B --> C[OpenSearchDashboardsWrappedRestHandler]
    C --> D{allowSystemIndexAccessByDefault}
    D -->|true| E[元のRESTハンドラーに委譲]
    E --> F[システムインデックスへのアクセス実行]
    F --> G[レスポンス返却]
```

## ビジネスルール

### 業務ルール

| ルールNo | ルール名 | 内容 | 適用条件 |
|---------|---------|------|---------|
| BR-114-01 | システムインデックスパターン | デフォルトパターン: .opensearch_dashboards, .opensearch_dashboards_*, .reporting-*, .apm-agent-configuration, .apm-custom-link | 設定未変更時 |
| BR-114-02 | アクセス許可 | /_opensearch_dashboards配下のAPIはシステムインデックスへのアクセスがデフォルト許可 | 全リクエスト |
| BR-114-03 | ルートプレフィックス | 元のAPIルートに /_opensearch_dashboards プレフィックスが付加される | 全ラップハンドラー |

### 計算ロジック

特になし。

## データベース操作仕様

### 操作別データベース影響一覧

| 操作 | 対象テーブル | 操作種別 | 概要 |
|-----|-------------|---------|------|
| インデックス作成 | .opensearch_dashboards* | INSERT | システムインデックスの作成 |
| ドキュメントCRUD | .opensearch_dashboards* | INSERT/UPDATE/DELETE/SELECT | Saved Objectsの読み書き |
| バルク操作 | .opensearch_dashboards* | INSERT/UPDATE/DELETE | 一括操作 |
| 検索 | .opensearch_dashboards* | SELECT | Saved Objectsの検索 |

### テーブル別操作詳細

ラップされたAPIに依存。システムインデックスに対する標準CRUD操作が実行される。

## エラー処理

### エラーケース一覧

| エラーコード | エラー種別 | 発生条件 | 対処方法 |
|------------|----------|---------|---------|
| 403 | SecurityException | 権限不足 | 適切な権限を付与する |
| 404 | IndexNotFoundException | システムインデックスが未作成 | Dashboardsの初期化を実行する |

### リトライ仕様

各ラップされたAPIの仕様に従う。

## トランザクション仕様

各ラップされたAPIの仕様に従う。

## パフォーマンス要件

Dashboardsの応答性能に直結するため、ラップによるオーバーヘッドは最小限に抑えられている（BaseRestHandler.Wrapperによる薄いラッパー実装）。

## セキュリティ考慮事項

- allowSystemIndexAccessByDefault()がtrueであるため、Dashboards経由のリクエストはシステムインデックスへのアクセスが許可される
- システムインデックスへの直接アクセスは通常のAPIでは制限される
- セキュリティプラグイン導入時は追加の認証・認可制御が適用される

## 備考

- モジュール名: opensearch-dashboards
- プラグインクラス: OpenSearchDashboardsModulePlugin
- SystemIndexPluginインターフェースを実装
- ラップされるAPI: RestCreateIndexAction, RestGetAliasesAction, RestIndexPutAliasAction, RestRefreshAction, RestGetAction, RestMultiGetAction, RestSearchAction, RestBulkAction, RestBulkStreamingAction, RestDeleteAction, RestDeleteByQueryAction, RestUpdateSettingsAction, RestGetIndicesAction, RestIndexAction, RestUpdateAction, RestSearchScrollAction, RestClearScrollAction

---

## コードリーディングガイド

本機能を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: データ構造を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | OpenSearchDashboardsModulePlugin.java | `modules/opensearch-dashboards/src/main/java/org/opensearch/dashboards/OpenSearchDashboardsModulePlugin.java` | 唯一のソースファイル。全体構造を理解する |

**読解のコツ**: このモジュールはソースファイルが1つのみ。SystemIndexPluginインターフェースの実装がポイント。内部クラスOpenSearchDashboardsWrappedRestHandlerがBaseRestHandler.Wrapperを拡張し、ルートの変換とシステムインデックスアクセス許可を行う。

#### Step 2: エントリーポイントを理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | OpenSearchDashboardsModulePlugin.java | `modules/opensearch-dashboards/src/main/java/org/opensearch/dashboards/OpenSearchDashboardsModulePlugin.java` | getRestHandlers()メソッド |

**主要処理フロー**:
1. **81-94行目**: OPENSEARCH_DASHBOARDS_INDEX_NAMES_SETTING定義。デフォルトのシステムインデックスパターンリスト
2. **97-104行目**: getSystemIndexDescriptors()でシステムインデックスパターンからSystemIndexDescriptorを生成
3. **107-149行目**: getRestHandlers()で17個のREST APIハンドラーをラップして登録
4. **156-180行目**: OpenSearchDashboardsWrappedRestHandler内部クラス
5. **168-169行目**: allowSystemIndexAccessByDefault()がtrueを返す
6. **173-178行目**: routes()で元ルートに `/_opensearch_dashboards` プレフィックスを付加

### プログラム呼び出し階層図

```
OpenSearchDashboardsModulePlugin
    |
    +-- getSystemIndexDescriptors()
    |       +-- SystemIndexDescriptor生成（パターンごと）
    |
    +-- getRestHandlers()
    |       +-- OpenSearchDashboardsWrappedRestHandler
    |               +-- RestCreateIndexAction
    |               +-- RestGetAliasesAction
    |               +-- RestGetAction
    |               +-- RestSearchAction
    |               +-- RestBulkAction
    |               +-- RestDeleteAction
    |               +-- ... (17ハンドラー)
    |
    +-- getSettings()
            +-- OPENSEARCH_DASHBOARDS_INDEX_NAMES_SETTING
```

### データフロー図

```
[入力]                              [処理]                                [出力]

Dashboardsリクエスト           --> OpenSearchDashboardsWrappedRestHandler --> 元のRESTハンドラー
  /_opensearch_dashboards/*          (ルート変換・システムアクセス許可)
                                                                            --> システムインデックス操作
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| OpenSearchDashboardsModulePlugin.java | `modules/opensearch-dashboards/src/main/java/org/opensearch/dashboards/OpenSearchDashboardsModulePlugin.java` | ソース | プラグイン本体（システムインデックス定義、APIラッパー） |
