# 機能設計書 115-Arrow Flight RPC

## 概要

本ドキュメントは、OpenSearchのArrow Flight RPCプラグインの機能設計書である。Apache Arrow Flight RPCプロトコルを用いた高速データ転送機能を提供する。

### 本機能の処理概要

**業務上の目的・背景**：大規模データの転送において、従来のJSON/HTTP方式ではシリアライゼーション・デシリアライゼーションのオーバーヘッドが大きい。Arrow Flight RPCは、Apache Arrowの列指向メモリフォーマットとgRPCベースのFlightプロトコルを使用することで、ゼロコピーに近いデータ転送を実現し、大規模データセットの効率的な転送を可能にする。

**機能の利用シーン**：大規模検索結果の高速転送、分析ワークロード向けの列指向データ転送、ノード間データストリーミング、外部分析ツール（Python/Spark等）との連携で利用される。

**主要な処理内容**：
1. FlightServiceによるArrow Flight gRPCサーバーの起動・管理
2. FlightStreamManagerによるストリームの登録・管理
3. BaseFlightProducerによるArrow Flightデータの生成
4. FlightClientManagerによるノード間クライアント接続管理
5. TLS/SSL対応の安全な通信
6. Feature Flagによる機能の有効化制御

**関連システム・外部連携**：Apache Arrow Flight gRPCプロトコル、OpenSearchノード間通信、外部分析ツール（Apache Spark、Pandas等）。

**権限による制御**：Feature Flag（ARROW_STREAMS、STREAM_TRANSPORT）による機能有効化制御。SecureTransportSettingsProviderによるTLS設定。

## 関連画面

| 画面No | 画面名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| - | - | - | REST APIではなくgRPCプロトコル。FlightServerInfoActionで接続情報を提供 |

## 機能種別

データ連携 / トランスポート

## 入力仕様

### 入力パラメータ

| パラメータ名 | 型 | 必須 | 説明 | バリデーション |
|-------------|-----|-----|------|---------------|
| arrow.flight.port | String | No | Flightサーバーのポート設定 | 有効なポート番号 |
| arrow.flight.host | String | No | Flightサーバーのバインドホスト | 有効なホスト名/IP |
| arrow.flight.publish_port | int | No | 公開ポート番号 | 有効なポート番号 |
| Feature Flag: ARROW_STREAMS | boolean | No | Arrow Streams機能の有効化 | true/false |
| Feature Flag: STREAM_TRANSPORT | boolean | No | Stream Transport機能の有効化 | true/false |

### 入力データソース

StreamProducerインターフェース実装による任意のデータソース（検索結果、集計結果等）。

## 出力仕様

### 出力データ

| 項目名 | 型 | 説明 |
|--------|-----|------|
| Arrow VectorSchemaRoot | Binary | Apache Arrow列指向フォーマットのデータバッチ |
| StreamTicket | byte[] | ストリームアクセス用のチケット（Base64エンコード） |
| FlightInfo | Object | Flightサーバー接続情報 |

### 出力先

gRPCプロトコル経由のArrow Flightクライアント。REST APIとして `/_flight/info` で接続情報を提供。

## 処理フロー

### 処理シーケンス

```
1. プラグイン初期化（FlightStreamPlugin）
   └─ Feature Flagの確認、ServerConfigの初期化
2. コンポーネント生成（createComponents）
   └─ FlightServiceにClusterService、ThreadPool、Clientを設定
3. サーバー起動（FlightService.doStart）
   └─ RootAllocator生成、ServerComponents初期化
   └─ FlightClientManager生成
   └─ FlightStreamManager初期化
   └─ BaseFlightProducer生成
   └─ gRPCサーバー起動
4. ストリーム登録
   └─ StreamProducerをStreamManagerに登録、StreamTicketを取得
5. ストリーム消費
   └─ StreamTicketを使用してStreamReaderを取得し、データを消費
6. シャットダウン（FlightService.doStop）
   └─ ServerComponents、StreamManager、ClientManager、Allocatorを順次クローズ
```

### フローチャート

```mermaid
flowchart TD
    A[プラグイン初期化] --> B{Feature Flag確認}
    B -->|有効| C[ServerConfig初期化]
    B -->|無効| D[空コンポーネント返却]
    C --> E[FlightService生成]
    E --> F[doStart: サーバー起動]
    F --> G[RootAllocator生成]
    G --> H[FlightClientManager生成]
    H --> I[FlightStreamManager初期化]
    I --> J[BaseFlightProducer生成]
    J --> K[gRPCサーバー起動]
    K --> L[ストリーム登録・消費の待機]
```

## ビジネスルール

### 業務ルール

| ルールNo | ルール名 | 内容 | 適用条件 |
|---------|---------|------|---------|
| BR-115-01 | Feature Flag制御 | ARROW_STREAMSまたはSTREAM_TRANSPORTが有効な場合のみ動作 | プラグイン初期化時 |
| BR-115-02 | TLS対応 | ServerConfig.isSslEnabled()がtrueの場合、SecureTransportSettingsProviderを使用 | SSL有効時 |
| BR-115-03 | Experimental API | @ExperimentalApiアノテーションが付いた実験的機能 | 常時 |

### 計算ロジック

特になし。データ転送プロトコルとしてArrow Flight RPCを使用する。

## データベース操作仕様

### 操作別データベース影響一覧

本機能はデータ転送プロトコルであり、インデックスに対する直接的なデータベース操作は行わない。ストリームの内容はStreamProducer実装に依存する。

### テーブル別操作詳細

該当なし。

## エラー処理

### エラーケース一覧

| エラーコード | エラー種別 | 発生条件 | 対処方法 |
|------------|----------|---------|---------|
| - | RuntimeException | Flight server起動失敗 | ポート設定やSSL設定を確認する |
| - | IllegalArgumentException | 無効なStreamTicket | 有効なチケットを使用する |
| - | IllegalStateException | ストリームがキャンセルまたはクローズ済み | 新しいストリームを登録する |

### リトライ仕様

gRPC層でのリトライはクライアント側で制御する。

## トランザクション仕様

ストリーミングデータ転送のため、トランザクション管理は適用されない。

## パフォーマンス要件

- Apache Arrowの列指向フォーマットによりシリアライゼーション・デシリアライゼーションのオーバーヘッドを最小化
- gRPCベースのHTTP/2通信により多重化・フロー制御を実現
- BufferAllocatorの共有によるメモリ効率の最適化

## セキュリティ考慮事項

- TLS/SSL対応（DefaultSslContextProvider）
- SecureTransportSettingsProviderによるセキュリティ設定
- ServerHeaderMiddleware/ClientHeaderMiddlewareによるヘッダーベースの認証

## 備考

- プラグイン名: arrow-flight-rpc
- プラグインクラス: FlightStreamPlugin
- 実験的機能（@ExperimentalApi）
- StreamManagerPlugin、NetworkPlugin、ActionPlugin、ClusterPlugin、ExtensiblePluginを実装

---

## コードリーディングガイド

本機能を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: データ構造を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | StreamTicket.java | `server/src/main/java/org/opensearch/arrow/spi/StreamTicket.java` | ストリームチケットインターフェース：ticketId, nodeId |
| 1-2 | StreamProducer.java | `server/src/main/java/org/opensearch/arrow/spi/StreamProducer.java` | ストリームプロデューサーインターフェース：createRoot, createJob, BatchedJob |
| 1-3 | StreamManager.java | `server/src/main/java/org/opensearch/arrow/spi/StreamManager.java` | ストリームマネージャーインターフェース：registerStream, getStreamReader |

**読解のコツ**: SPIインターフェースはserver側に定義され、実装はarrow-flight-rpcプラグイン側にある。StreamProducerのBatchedJobインターフェースがバッチ処理の核心。FlushSignalによるproducer-consumer協調が重要。

#### Step 2: プラグインエントリーポイントを理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | FlightStreamPlugin.java | `plugins/arrow-flight-rpc/src/main/java/org/opensearch/arrow/flight/transport/FlightStreamPlugin.java` | プラグイン登録、Feature Flag判定 |

**主要処理フロー**:
- **90-101行目**: コンストラクタ。Feature Flag確認とServerConfig初期化
- **119-148行目**: createComponents。FlightServiceへの各種サービス設定
- **248-263行目**: getAuxTransports。FlightServiceを補助トランスポートとして登録
- **333-336行目**: getStreamManager。FlightStreamManagerをStreamManagerとして提供

#### Step 3: FlightServiceを理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | FlightService.java | `plugins/arrow-flight-rpc/src/main/java/org/opensearch/arrow/flight/bootstrap/FlightService.java` | サーバーライフサイクル管理 |

**主要処理フロー**:
- **62-66行目**: コンストラクタ。ServerComponentsとFlightStreamManagerの生成
- **122-148行目**: doStart。アロケータ生成、クライアントマネージャ生成、プロデューサ生成、サーバー起動
- **184-189行目**: doStop。リソースの順次クローズ

### プログラム呼び出し階層図

```
FlightStreamPlugin
    |
    +-- FlightService (AuxTransport)
    |       |
    |       +-- ServerComponents
    |       |       +-- gRPC Server
    |       |       +-- BaseFlightProducer
    |       |
    |       +-- FlightStreamManager (StreamManager)
    |       |       +-- registerStream()
    |       |       +-- getStreamReader()
    |       |
    |       +-- FlightClientManager
    |               +-- buildClientAsync()
    |
    +-- FlightServerInfoAction (REST: /_flight/info)
    +-- FlightStatsRestHandler (REST: /_flight/stats)
```

### データフロー図

```
[入力]                        [処理]                            [出力]

StreamProducer登録      --> StreamManager.registerStream()  --> StreamTicket
  (データ生成定義)

StreamTicket           --> StreamManager.getStreamReader()  --> StreamReader
  (ストリームアクセス)       +-> BaseFlightProducer               +-> VectorSchemaRoot
                                (Arrow Flight gRPC)                  (列指向データ)
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| FlightStreamPlugin.java | `plugins/arrow-flight-rpc/src/main/java/org/opensearch/arrow/flight/transport/FlightStreamPlugin.java` | ソース | プラグインエントリーポイント |
| FlightService.java | `plugins/arrow-flight-rpc/src/main/java/org/opensearch/arrow/flight/bootstrap/FlightService.java` | ソース | Flightサーバーライフサイクル管理 |
| ServerComponents.java | `plugins/arrow-flight-rpc/src/main/java/org/opensearch/arrow/flight/bootstrap/ServerComponents.java` | ソース | サーバーコンポーネント管理 |
| FlightStreamManager.java | `plugins/arrow-flight-rpc/src/main/java/org/opensearch/arrow/flight/impl/FlightStreamManager.java` | ソース | ストリーム管理実装 |
| BaseFlightProducer.java | `plugins/arrow-flight-rpc/src/main/java/org/opensearch/arrow/flight/impl/BaseFlightProducer.java` | ソース | Flightプロデューサー実装 |
| FlightStreamTicket.java | `plugins/arrow-flight-rpc/src/main/java/org/opensearch/arrow/flight/impl/FlightStreamTicket.java` | ソース | チケット実装 |
| FlightStreamReader.java | `plugins/arrow-flight-rpc/src/main/java/org/opensearch/arrow/flight/impl/FlightStreamReader.java` | ソース | リーダー実装 |
| FlightTransport.java | `plugins/arrow-flight-rpc/src/main/java/org/opensearch/arrow/flight/transport/FlightTransport.java` | ソース | トランスポート実装 |
| StreamManager.java | `server/src/main/java/org/opensearch/arrow/spi/StreamManager.java` | ソース | SPIインターフェース |
| StreamProducer.java | `server/src/main/java/org/opensearch/arrow/spi/StreamProducer.java` | ソース | SPIインターフェース |
| StreamTicket.java | `server/src/main/java/org/opensearch/arrow/spi/StreamTicket.java` | ソース | SPIインターフェース |
| StreamReader.java | `server/src/main/java/org/opensearch/arrow/spi/StreamReader.java` | ソース | SPIインターフェース |
