# 機能設計書 118-フラッシュ

## 概要

本ドキュメントは、OpenSearchのフラッシュ（Flush）機能の設計書である。トランスログをLuceneインデックスにフラッシュする機能を提供する。

### 本機能の処理概要

**業務上の目的・背景**：OpenSearchはドキュメントの変更（追加・更新・削除）をまずトランザクションログ（translog）に記録し、その後Luceneインデックスにコミットする。フラッシュ操作は、トランスログに蓄積された変更をLuceneインデックスに永続化し、トランスログをクリアする。これにより、ノード障害時のリカバリ時間を短縮し、ディスク使用量を管理する。

**機能の利用シーン**：手動でのトランスログクリア、メンテナンス作業前のデータ永続化確認、バックアップ前の整合性確保、メモリ使用量の管理などの場面で利用される。

**主要な処理内容**：
1. RESTリクエストの受付と対象インデックスの解決
2. ブロードキャストレプリケーション方式で各シャードにフラッシュリクエストを配信
3. プライマリシャードでフラッシュを実行し、レプリカシャードに伝播
4. トランスログの永続化とクリア
5. 結果の集約とレスポンス返却

**関連システム・外部連携**：Luceneのコミット機能、トランスログ管理機能と連携する。

**権限による制御**：対象インデックスへの書き込み権限が必要。

## 関連画面

| 画面No | 画面名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| 80 | フラッシュ | 主画面 | 1つ以上のインデックスでフラッシュ操作を実行する処理 |
| 81 | 同期フラッシュ（非推奨） | 主画面 | 同期フラッシュ操作を実行する処理（非推奨API） |

## 機能種別

データ管理 / インデックスメンテナンス

## 入力仕様

### 入力パラメータ

| パラメータ名 | 型 | 必須 | 説明 | バリデーション |
|-------------|-----|-----|------|---------------|
| index | String | No | 対象インデックス名（カンマ区切り、未指定時は全インデックス） | 有効なインデックス名 |
| force | boolean | No | 強制フラッシュの実行（デフォルト: false） | true/false |
| wait_if_ongoing | boolean | No | 進行中のフラッシュ完了を待機（デフォルト: true） | true/false |

### 入力データソース

REST API経由のリクエスト。`POST /{index}/_flush` または `POST /_flush`。

## 出力仕様

### 出力データ

| 項目名 | 型 | 説明 |
|--------|-----|------|
| _shards.total | int | 対象シャード総数 |
| _shards.successful | int | 成功シャード数 |
| _shards.failed | int | 失敗シャード数 |

### 出力先

REST APIレスポンス（JSON形式）

## 処理フロー

### 処理シーケンス

```
1. RESTリクエスト受付
   └─ パラメータ解析、FlushRequest生成
2. バリデーション
   └─ force=trueかつwait_if_ongoing=falseの組み合わせは無効
3. ブロードキャストレプリケーション
   └─ TransportBroadcastReplicationActionで各シャードに配信
4. プライマリシャードでフラッシュ実行
   └─ TransportShardFlushActionがシャードレベルの操作を実行
5. レプリカシャードに伝播
   └─ プライマリの操作完了後、レプリカに伝播
6. レスポンス集約
   └─ 各シャードの結果を集約してFlushResponseを生成
```

### フローチャート

```mermaid
flowchart TD
    A[RESTリクエスト受信] --> B[FlushRequest生成]
    B --> C{バリデーション}
    C -->|force=true & wait_if_ongoing=false| D[エラー返却]
    C -->|OK| E[TransportBroadcastReplicationAction]
    E --> F[各シャードにShardFlushRequest配信]
    F --> G[TransportShardFlushAction実行]
    G --> H[プライマリシャードでフラッシュ]
    H --> I[レプリカシャードに伝播]
    I --> J[結果集約]
    J --> K[FlushResponse返却]
```

## ビジネスルール

### 業務ルール

| ルールNo | ルール名 | 内容 | 適用条件 |
|---------|---------|------|---------|
| BR-118-01 | force制約 | force=trueの場合、wait_if_ongoingはtrueでなければならない | バリデーション時 |
| BR-118-02 | デフォルト待機 | wait_if_ongoingのデフォルトはtrue（進行中のフラッシュ完了を待機） | 未指定時 |
| BR-118-03 | レプリケーション | プライマリでの操作完了後にレプリカに伝播される | 常時 |

### 計算ロジック

特になし。

## データベース操作仕様

### 操作別データベース影響一覧

| 操作 | 対象テーブル | 操作種別 | 概要 |
|-----|-------------|---------|------|
| フラッシュ | 対象インデックス | UPDATE | トランスログのLuceneインデックスへのコミット |
| トランスログクリア | トランスログ | DELETE | フラッシュ完了後のトランスログクリア |

### テーブル別操作詳細

フラッシュはLuceneレベルの操作であり、メモリ上のインデックスセグメントをディスクにコミットし、トランスログをクリアする。

## エラー処理

### エラーケース一覧

| エラーコード | エラー種別 | 発生条件 | 対処方法 |
|------------|----------|---------|---------|
| 400 | ActionRequestValidationException | force=true & wait_if_ongoing=false | wait_if_ongoingをtrueに設定する |
| 500 | ShardOperationFailedException | シャードレベルのフラッシュ失敗 | シャードの状態を確認する |

### リトライ仕様

個別シャードの失敗はshardFailuresに記録され、他のシャードの処理は続行される。

## トランザクション仕様

各シャードのフラッシュ操作は独立して実行される。プライマリ-レプリカ間のレプリケーションが保証される。

## パフォーマンス要件

- フラッシュはI/O操作を伴うが、フォースマージと比較して軽量
- wait_if_ongoing=trueの場合、進行中のフラッシュ完了まで待機

## セキュリティ考慮事項

- 対象インデックスへの書き込み権限が必要

## 備考

- アクション名: indices:admin/flush
- TransportBroadcastReplicationActionを拡張
- シャードレベル操作: TransportShardFlushAction

---

## コードリーディングガイド

本機能を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: データ構造を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | FlushRequest.java | `server/src/main/java/org/opensearch/action/admin/indices/flush/FlushRequest.java` | リクエストパラメータ：force, waitIfOngoing |

**読解のコツ**: FlushRequestはBroadcastRequestを拡張。バリデーションロジック（114-120行目）で force=true かつ wait_if_ongoing=false の組み合わせを禁止している点が重要。

**主要処理フロー**:
- **63-64行目**: デフォルト値。force=false, waitIfOngoing=true
- **114-120行目**: validate()。force && !waitIfOngoing の場合バリデーションエラー

#### Step 2: トランスポートアクションを理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | TransportFlushAction.java | `server/src/main/java/org/opensearch/action/admin/indices/flush/TransportFlushAction.java` | ブロードキャストレプリケーションのメインロジック |
| 2-2 | TransportShardFlushAction.java | `server/src/main/java/org/opensearch/action/admin/indices/flush/TransportShardFlushAction.java` | シャードレベルのフラッシュ実行 |

**主要処理フロー**（TransportFlushAction）:
- **52-56行目**: TransportBroadcastReplicationActionを拡張
- **83-85行目**: newShardRequest。FlushRequestからShardFlushRequestを生成
- **88-95行目**: newResponse。FlushResponseを生成

### プログラム呼び出し階層図

```
REST: POST /{index}/_flush
    |
    +-- RestFlushAction
            |
            +-- TransportFlushAction (TransportBroadcastReplicationAction)
                    |
                    +-- newShardRequest() -> ShardFlushRequest
                    +-- TransportShardFlushAction (プライマリ)
                    |       |
                    |       +-- IndexShard.flush()
                    |
                    +-- TransportShardFlushAction (レプリカ)
                            |
                            +-- IndexShard.flush()
```

### データフロー図

```
[入力]                    [処理]                          [出力]

REST Request         --> FlushRequest生成              --> ブロードキャストレプリケーション
  (force,                  +-> バリデーション
   wait_if_ongoing)        +-> ShardFlushRequest生成

ShardFlushRequest    --> TransportShardFlushAction     --> ReplicationResponse
                          +-> IndexShard.flush()

ReplicationResponse  --> TransportFlushAction          --> FlushResponse
  (各シャード結果)         +-> 結果集約                     (_shards: total/successful/failed)
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| FlushAction.java | `server/src/main/java/org/opensearch/action/admin/indices/flush/FlushAction.java` | ソース | アクション定義 |
| FlushRequest.java | `server/src/main/java/org/opensearch/action/admin/indices/flush/FlushRequest.java` | ソース | リクエストデータ構造 |
| FlushResponse.java | `server/src/main/java/org/opensearch/action/admin/indices/flush/FlushResponse.java` | ソース | レスポンスデータ構造 |
| FlushRequestBuilder.java | `server/src/main/java/org/opensearch/action/admin/indices/flush/FlushRequestBuilder.java` | ソース | リクエストビルダー |
| TransportFlushAction.java | `server/src/main/java/org/opensearch/action/admin/indices/flush/TransportFlushAction.java` | ソース | トランスポートアクション |
| ShardFlushRequest.java | `server/src/main/java/org/opensearch/action/admin/indices/flush/ShardFlushRequest.java` | ソース | シャードレベルリクエスト |
| TransportShardFlushAction.java | `server/src/main/java/org/opensearch/action/admin/indices/flush/TransportShardFlushAction.java` | ソース | シャードレベルトランスポート |
