# 機能設計書 119-リフレッシュ

## 概要

本ドキュメントは、OpenSearchのリフレッシュ（Refresh）機能の設計書である。インデックスのリフレッシュにより最新データを検索可能にする機能を提供する。

### 本機能の処理概要

**業務上の目的・背景**：OpenSearchではドキュメントの追加・更新後、即座に検索結果に反映されるわけではない。リフレッシュ操作は、メモリ上のインデックスバッファからLuceneセグメントを生成し、新しいSearcherをオープンすることで、最新のドキュメントを検索可能な状態にする。デフォルトでは1秒間隔で自動リフレッシュが行われるが、手動でリフレッシュを実行することも可能である。

**機能の利用シーン**：ドキュメント登録直後の即時検索、テスト環境でのデータ反映確認、バルクインサート後の一括反映、Near Real-Time検索の手動トリガーなどの場面で利用される。

**主要な処理内容**：
1. RESTリクエストの受付と対象インデックスの解決
2. ブロードキャストレプリケーション方式で各シャードにリフレッシュリクエストを配信
3. 各シャードでリフレッシュを実行（新しいSearcherのオープン）
4. waitForActiveShards = NONEで待機不要
5. 結果の集約とレスポンス返却

**関連システム・外部連携**：Luceneのインデックスリーダー管理と連携する。

**権限による制御**：対象インデックスへの書き込み権限が必要。

## 関連画面

| 画面No | 画面名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| 79 | リフレッシュ | 主画面 | 1つ以上のインデックスでリフレッシュ操作を実行する処理 |

## 機能種別

データ管理 / インデックスメンテナンス

## 入力仕様

### 入力パラメータ

| パラメータ名 | 型 | 必須 | 説明 | バリデーション |
|-------------|-----|-----|------|---------------|
| index | String | No | 対象インデックス名（カンマ区切り、未指定時は全インデックス） | 有効なインデックス名 |

### 入力データソース

REST API経由のリクエスト。`POST /{index}/_refresh` または `POST /_refresh`、`GET /{index}/_refresh` または `GET /_refresh`。

## 出力仕様

### 出力データ

| 項目名 | 型 | 説明 |
|--------|-----|------|
| _shards.total | int | 対象シャード総数 |
| _shards.successful | int | 成功シャード数 |
| _shards.failed | int | 失敗シャード数 |

### 出力先

REST APIレスポンス（JSON形式）

## 処理フロー

### 処理シーケンス

```
1. RESTリクエスト受付
   └─ パラメータ解析、RefreshRequest生成
2. ブロードキャストレプリケーション
   └─ TransportBroadcastReplicationActionで各シャードに配信
3. 各シャードでリフレッシュ実行
   └─ TransportShardRefreshActionがBasicReplicationRequestでシャード操作を実行
   └─ ActiveShardCount.NONEで待機不要
4. レスポンス集約
   └─ 各シャードの結果を集約してRefreshResponseを生成
```

### フローチャート

```mermaid
flowchart TD
    A[RESTリクエスト受信] --> B[RefreshRequest生成]
    B --> C[TransportBroadcastReplicationAction]
    C --> D[各シャードにBasicReplicationRequest配信]
    D --> E[TransportShardRefreshAction実行]
    E --> F[IndexShard.refresh]
    F --> G[新しいSearcherオープン]
    G --> H[結果集約]
    H --> I[RefreshResponse返却]
```

## ビジネスルール

### 業務ルール

| ルールNo | ルール名 | 内容 | 適用条件 |
|---------|---------|------|---------|
| BR-119-01 | 待機不要 | リフレッシュはActiveShardCount.NONEで、アクティブシャードの待機をしない | 常時 |
| BR-119-02 | 自動リフレッシュ | デフォルトでは1秒間隔で自動リフレッシュが行われる | index.refresh_interval設定 |
| BR-119-03 | Near Real-Time | リフレッシュにより最新データが検索可能になる | リフレッシュ完了後 |

### 計算ロジック

特になし。

## データベース操作仕様

### 操作別データベース影響一覧

| 操作 | 対象テーブル | 操作種別 | 概要 |
|-----|-------------|---------|------|
| リフレッシュ | 対象インデックス | UPDATE | インメモリバッファからLuceneセグメントを生成し、新しいSearcherをオープン |

### テーブル別操作詳細

リフレッシュはLuceneレベルの操作であり、インメモリバッファをディスクに書き出し（ただしfsyncはしない）、新しいインデックスリーダーをオープンする。

## エラー処理

### エラーケース一覧

| エラーコード | エラー種別 | 発生条件 | 対処方法 |
|------------|----------|---------|---------|
| 500 | ShardOperationFailedException | シャードレベルのリフレッシュ失敗 | シャードの状態を確認する |

### リトライ仕様

個別シャードの失敗はshardFailuresに記録され、他のシャードの処理は続行される。

## トランザクション仕様

各シャードのリフレッシュ操作は独立して実行される。

## パフォーマンス要件

- リフレッシュはフラッシュと比較して軽量な操作
- 頻繁なリフレッシュはインデクシングパフォーマンスに影響を与える可能性がある
- 大規模バルクインサート時はリフレッシュ間隔を延長（-1で無効化）することが推奨される

## セキュリティ考慮事項

- 対象インデックスへのアクセス権限が必要

## 備考

- アクション名: indices:admin/refresh
- TransportBroadcastReplicationActionを拡張
- シャードレベル操作: TransportShardRefreshAction
- BasicReplicationRequestを使用（ActiveShardCount.NONE）

---

## コードリーディングガイド

本機能を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: データ構造を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | RefreshRequest.java | `server/src/main/java/org/opensearch/action/admin/indices/refresh/RefreshRequest.java` | リクエストデータ構造（BroadcastRequest拡張） |
| 1-2 | RefreshResponse.java | `server/src/main/java/org/opensearch/action/admin/indices/refresh/RefreshResponse.java` | レスポンスデータ構造 |

**読解のコツ**: RefreshRequestはFlushRequestと異なり、追加パラメータ（force等）を持たないシンプルなBroadcastRequest。

#### Step 2: トランスポートアクションを理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | TransportRefreshAction.java | `server/src/main/java/org/opensearch/action/admin/indices/refresh/TransportRefreshAction.java` | ブロードキャストレプリケーションのメインロジック |

**主要処理フロー**:
- **54-58行目**: TransportBroadcastReplicationActionを拡張
- **85-88行目**: newShardRequest。BasicReplicationRequestを生成し、waitForActiveShards(ActiveShardCount.NONE)を設定
- **92-99行目**: newResponse。RefreshResponseを生成

#### Step 3: シャードレベル操作を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | TransportShardRefreshAction.java | `server/src/main/java/org/opensearch/action/admin/indices/refresh/TransportShardRefreshAction.java` | シャードレベルのリフレッシュ実行 |

### プログラム呼び出し階層図

```
REST: POST /{index}/_refresh
    |
    +-- RestRefreshAction
            |
            +-- TransportRefreshAction (TransportBroadcastReplicationAction)
                    |
                    +-- newShardRequest() -> BasicReplicationRequest
                    |       (waitForActiveShards = NONE)
                    |
                    +-- TransportShardRefreshAction (プライマリ)
                    |       |
                    |       +-- IndexShard.refresh()
                    |
                    +-- TransportShardRefreshAction (レプリカ)
                            |
                            +-- IndexShard.refresh()
```

### データフロー図

```
[入力]                    [処理]                            [出力]

REST Request         --> RefreshRequest生成              --> ブロードキャストレプリケーション
  (index)                  +-> BasicReplicationRequest生成

BasicReplicationReq  --> TransportShardRefreshAction     --> ReplicationResponse
                          +-> IndexShard.refresh()

ReplicationResponse  --> TransportRefreshAction          --> RefreshResponse
  (各シャード結果)         +-> 結果集約                       (_shards: total/successful/failed)
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| RefreshAction.java | `server/src/main/java/org/opensearch/action/admin/indices/refresh/RefreshAction.java` | ソース | アクション定義 |
| RefreshRequest.java | `server/src/main/java/org/opensearch/action/admin/indices/refresh/RefreshRequest.java` | ソース | リクエストデータ構造 |
| RefreshResponse.java | `server/src/main/java/org/opensearch/action/admin/indices/refresh/RefreshResponse.java` | ソース | レスポンスデータ構造 |
| RefreshRequestBuilder.java | `server/src/main/java/org/opensearch/action/admin/indices/refresh/RefreshRequestBuilder.java` | ソース | リクエストビルダー |
| TransportRefreshAction.java | `server/src/main/java/org/opensearch/action/admin/indices/refresh/TransportRefreshAction.java` | ソース | トランスポートアクション |
| TransportShardRefreshAction.java | `server/src/main/java/org/opensearch/action/admin/indices/refresh/TransportShardRefreshAction.java` | ソース | シャードレベルトランスポート |
