# 機能設計書 12-ドキュメント削除

## 概要

本ドキュメントは、OpenSearchの「ドキュメント削除」機能の設計を記述する。IDを指定してインデックスからドキュメントを削除するDelete APIの処理仕様を定義する。

### 本機能の処理概要

本機能は、インデックスに格納された特定のドキュメントをドキュメントIDを指定して削除する機能である。REST APIの `DELETE /{index}/_doc/{id}` エンドポイントを通じて呼び出される。

**業務上の目的・背景**：データライフサイクル管理の一環として、不要になったドキュメントや誤って登録されたドキュメントを個別に削除する需要がある。GDPR等のデータ保護規制への対応としても個別ドキュメントの削除機能は必須である。

**機能の利用シーン**：特定のドキュメントを明示的に削除する場面、楽観的並行制御（バージョンチェック、if_seq_no/if_primary_term）を用いた安全な削除を行う場面、バルク操作の一部として個別削除を実行する場面で利用される。

**主要な処理内容**：
1. リクエストのバリデーション（インデックス名・ドキュメントIDの必須チェック）
2. TransportBulkActionを経由した単一アイテムバルク書き込みとしての処理
3. プライマリシャードでの削除実行とレプリカシャードへの複製
4. 楽観的並行制御（バージョン、シーケンス番号・プライマリターム）のチェック
5. 削除結果のレスポンス構築

**関連システム・外部連携**：内部的にTransportBulkActionに委譲されるため、バルク操作基盤を共有する。インジェストパイプラインは削除操作には適用されない。

**権限による制御**：アクション名 `indices:data/write/delete` に基づくセキュリティプラグインによるアクセス制御が適用される。

## 関連画面

| 画面No | 画面名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| 9 | ドキュメント削除 | 主機能 | IDを指定してドキュメントを削除する主処理 |

## 機能種別

CRUD操作（Delete）

## 入力仕様

### 入力パラメータ

| パラメータ名 | 型 | 必須 | 説明 | バリデーション |
|-------------|-----|-----|------|---------------|
| index | String | Yes | 削除対象のインデックス名 | null不可 |
| id | String | Yes | 削除対象のドキュメントID | 空文字不可 |
| routing | String | No | シャードルーティング値 | - |
| version | long | No | 楽観的並行制御のためのバージョン番号（デフォルト: MATCH_ANY） | - |
| versionType | VersionType | No | バージョンの種別（デフォルト: INTERNAL） | - |
| ifSeqNo | long | No | 条件付き削除のシーケンス番号 | - |
| ifPrimaryTerm | long | No | 条件付き削除のプライマリターム | - |
| timeout | TimeValue | No | 書き込みタイムアウト | - |
| waitForActiveShards | ActiveShardCount | No | アクティブシャード待機数 | - |
| refreshPolicy | RefreshPolicy | No | リフレッシュポリシー（NONE/IMMEDIATE/WAIT_UNTIL） | - |

### 入力データソース

REST APIリクエスト（HTTP DELETE）、Java Transport Client

## 出力仕様

### 出力データ

| 項目名 | 型 | 説明 |
|--------|-----|------|
| _index | String | ドキュメントが削除されたインデックス名 |
| _id | String | 削除されたドキュメントID |
| _version | long | 削除後のドキュメントバージョン |
| _seq_no | long | 削除操作のシーケンス番号 |
| _primary_term | long | 削除時のプライマリターム |
| result | String | 操作結果（deleted / not_found） |
| _shards | ShardInfo | シャード処理結果（total, successful, failed） |

### 出力先

REST APIレスポンス（JSON形式）

## 処理フロー

### 処理シーケンス

```
1. リクエスト受信・バリデーション
   └─ インデックス名とドキュメントIDの必須チェック
2. TransportDeleteAction経由でTransportBulkActionに委譲
   └─ 単一アイテムのバルク書き込みとして処理
3. シャードルーティング
   └─ ドキュメントIDまたはroutingパラメータに基づくシャード特定
4. プライマリシャードでの削除実行
   └─ 楽観的並行制御チェック後、Luceneインデックスからの論理削除
5. レプリカシャードへの複製
   └─ プライマリでの成功後、レプリカに削除操作を複製
6. レスポンス構築・返却
   └─ DeleteResponse生成、result=deleted or not_found
```

### フローチャート

```mermaid
flowchart TD
    A[DELETE リクエスト受信] --> B{バリデーション OK?}
    B -->|No| C[バリデーションエラー返却]
    B -->|Yes| D[TransportBulkAction に委譲]
    D --> E[シャードルーティング]
    E --> F[プライマリシャードへ転送]
    F --> G{楽観的並行制御チェック}
    G -->|不一致| H[VersionConflictEngineException]
    G -->|OK| I{ドキュメント存在?}
    I -->|Yes| J[ドキュメント削除実行]
    I -->|No| K[result=not_found]
    J --> L[レプリカへ複製]
    L --> M[DeleteResponse 返却]
    K --> M
```

## ビジネスルール

### 業務ルール

| ルールNo | ルール名 | 内容 | 適用条件 |
|---------|---------|------|---------|
| BR-12-01 | 楽観的並行制御 | ifSeqNo/ifPrimaryTermが指定された場合、現在の値と一致しない場合はバージョンコンフリクトエラー | ifSeqNo/ifPrimaryTerm指定時 |
| BR-12-02 | 論理削除 | Luceneの特性上、削除はセグメントマージまで論理削除として扱われる | 常時 |
| BR-12-03 | バルク委譲 | TransportDeleteActionは非推奨であり、内部的にTransportBulkActionの単一アイテム処理として実行される | 常時 |

### 計算ロジック

特に複雑な計算ロジックはない。

## データベース操作仕様

### 操作別データベース影響一覧

| 操作 | 対象テーブル | 操作種別 | 概要 |
|-----|-------------|---------|------|
| ドキュメント削除 | Lucene Index（シャード） | DELETE | IDによるドキュメントの論理削除 |
| トランスログ記録 | Translog | INSERT | 削除操作のトランスログへの記録 |

### テーブル別操作詳細

#### Lucene Index

| 操作 | 項目（カラム名） | 更新値・取得条件 | 備考 |
|-----|-----------------|-----------------|------|
| DELETE | _id | _id = リクエストID | 論理削除マーク付与 |

## エラー処理

### エラーケース一覧

| エラーコード | エラー種別 | 発生条件 | 対処方法 |
|------------|----------|---------|---------|
| 400 | ActionRequestValidationException | インデックス名またはIDが未指定 | リクエストパラメータを修正 |
| 404 | ドキュメント未検出 | 指定IDのドキュメントが存在しない | result=not_foundとして正常レスポンス |
| 409 | VersionConflictEngineException | バージョン/シーケンス番号の不一致 | 最新バージョンを再取得して再試行 |
| 503 | UnavailableShardsException | 必要なアクティブシャードが不足 | シャードの回復を待機 |

### リトライ仕様

書き込みタイムアウト内でアクティブシャードの待機が行われる。クライアント側でのリトライは楽観的並行制御の再チェックが必要。

## トランザクション仕様

プライマリシャードで削除が成功した後、レプリカシャードへ非同期で複製される。waitForActiveShardsパラメータにより、指定数のシャードでの完了を待機可能。

## パフォーマンス要件

- 単一ドキュメント削除は低レイテンシで処理される
- refreshPolicy=IMMEDIATEを指定すると即座にリフレッシュが行われ検索結果に反映される
- refreshPolicy=WAIT_UNTILは次回のリフレッシュまで待機する

## セキュリティ考慮事項

- アクション名 `indices:data/write/delete` に対するセキュリティ権限チェックが適用される
- 書き込みブロックが設定されたインデックスへの削除は拒否される

## 備考

- TransportDeleteActionは `@Deprecated` アノテーションが付与されており、内部的にTransportSingleItemBulkWriteActionを通じてTransportBulkActionに委譲される
- DeleteRequestはReplicatedWriteRequest<DeleteRequest>を継承し、DocWriteRequest<DeleteRequest>を実装する
- DeleteRequestのメモリ使用量はSHALLOW_SIZEとして定数管理される

---

## コードリーディングガイド

本機能を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: データ構造を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | DeleteRequest.java | `server/src/main/java/org/opensearch/action/delete/DeleteRequest.java` | 削除リクエストのフィールド定義（id, routing, version, versionType, ifSeqNo, ifPrimaryTerm）。ReplicatedWriteRequestとDocWriteRequestの二重実装 |
| 1-2 | DeleteResponse.java | `server/src/main/java/org/opensearch/action/delete/DeleteResponse.java` | 削除レスポンスの構造 |

**読解のコツ**: DeleteRequestはDocWriteRequestインターフェースを実装しており、IndexRequest, UpdateRequestと共通のインターフェースを持つ。これがバルク操作で統一的に扱える理由。

#### Step 2: エントリーポイントを理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | TransportDeleteAction.java | `server/src/main/java/org/opensearch/action/delete/TransportDeleteAction.java` | @Deprecated。TransportSingleItemBulkWriteActionを継承し、TransportBulkActionに処理を委譲 |
| 2-2 | TransportBulkAction.java | `server/src/main/java/org/opensearch/action/bulk/TransportBulkAction.java` | 実際のバルク処理。シャードごとにリクエストをグループ化 |

**主要処理フロー**:
1. **50-60行目（TransportDeleteAction）**: コンストラクタでTransportBulkActionを受け取り委譲
2. **128-130行目（TransportBulkAction）**: HandledTransportActionを継承した実処理クラス

#### Step 3: シャードレベル処理を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | TransportShardBulkAction.java | `server/src/main/java/org/opensearch/action/bulk/TransportShardBulkAction.java` | シャード単位でのバルク操作実行 |

### プログラム呼び出し階層図

```
REST API (DELETE /{index}/_doc/{id})
    |
    +-- TransportDeleteAction (extends TransportSingleItemBulkWriteAction)
           |
           +-- TransportBulkAction (単一アイテムバルク)
                  |
                  +-- シャードルーティング
                  +-- TransportShardBulkAction
                         |
                         +-- プライマリシャード: Engine.delete()
                         +-- レプリカシャード: 複製処理
```

### データフロー図

```
[入力]                      [処理]                              [出力]

DeleteRequest       -->  TransportDeleteAction               -->  DeleteResponse
 - index                  |                                        - _index
 - id                     +-> TransportBulkAction                  - _id
 - routing                     |                                   - _version
 - version                     +-> TransportShardBulkAction        - result
 - ifSeqNo                          |                              - _shards
 - ifPrimaryTerm                    +-> Engine.delete()
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| DeleteAction.java | `server/src/main/java/org/opensearch/action/delete/DeleteAction.java` | ソース | アクション型定義 |
| DeleteRequest.java | `server/src/main/java/org/opensearch/action/delete/DeleteRequest.java` | ソース | リクエストデータ構造 |
| DeleteResponse.java | `server/src/main/java/org/opensearch/action/delete/DeleteResponse.java` | ソース | レスポンスデータ構造 |
| DeleteRequestBuilder.java | `server/src/main/java/org/opensearch/action/delete/DeleteRequestBuilder.java` | ソース | リクエストビルダー |
| TransportDeleteAction.java | `server/src/main/java/org/opensearch/action/delete/TransportDeleteAction.java` | ソース | 削除のトランスポート処理（非推奨、BulkActionに委譲） |
| TransportBulkAction.java | `server/src/main/java/org/opensearch/action/bulk/TransportBulkAction.java` | ソース | 実際のバルク処理基盤 |
| TransportShardBulkAction.java | `server/src/main/java/org/opensearch/action/bulk/TransportShardBulkAction.java` | ソース | シャード単位のバルク処理 |
