# 機能設計書 122-キャッシュクリア

## 概要

本ドキュメントは、OpenSearchにおけるインデックスキャッシュのクリア機能の設計を記載する。

### 本機能の処理概要

本機能は、指定されたインデックスのクエリキャッシュ、フィールドデータキャッシュ、リクエストキャッシュ、ファイルキャッシュを選択的にクリアする機能である。

**業務上の目的・背景**：OpenSearchは検索パフォーマンス向上のために複数種類のキャッシュを保持する。しかし、マッピング変更やデータ更新後にキャッシュが古くなる場合や、メモリ圧迫時にキャッシュをクリアしてリソースを解放する必要がある。本機能はこれらの運用ニーズに対応する。

**機能の利用シーン**：メモリ使用量の削減、キャッシュの不整合解消、パフォーマンステスト前のキャッシュ初期化、インデックス設定変更後のキャッシュリフレッシュ時に利用される。

**主要な処理内容**：
1. REST APIリクエストを受信し、クリア対象のキャッシュ種別を判定する
2. 対象インデックスの全シャードに対してブロードキャストリクエストを送信する
3. 各シャードでキャッシュクリア操作を実行する
4. ノード全体のキャッシュ強制クリアを実行する

**関連システム・外部連携**：ファイルキャッシュのクリアではNode.fileCache()を使用する。IndicesServiceを通じて各種キャッシュのクリアを行う。

**権限による制御**：METADATA_READレベルのクラスタブロックチェックが行われる。

## 関連画面

| 画面No | 画面名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| 83 | キャッシュクリア | 主機能 | 1つ以上のインデックスのキャッシュをクリアする処理 |

## 機能種別

データ操作（キャッシュクリア）

## 入力仕様

### 入力パラメータ

| パラメータ名 | 型 | 必須 | 説明 | バリデーション |
|-------------|-----|-----|------|---------------|
| index | String[] | No | 対象インデックス名（省略時は全インデックス） | ワイルドカード対応 |
| query | boolean | No | クエリキャッシュをクリアするか（デフォルト: false） | true/false |
| fielddata | boolean | No | フィールドデータキャッシュをクリアするか（デフォルト: false） | true/false |
| request | boolean | No | リクエストキャッシュをクリアするか（デフォルト: false） | true/false |
| file | boolean | No | ファイルキャッシュをクリアするか（デフォルト: false） | true/false（V2.8.0以降） |
| fields | String[] | No | フィールドデータキャッシュの対象フィールド | フィールド名リスト |

### 入力データソース

REST APIリクエスト（`POST /<index>/_cache/clear`）

## 出力仕様

### 出力データ

| 項目名 | 型 | 説明 |
|--------|-----|------|
| _shards.total | int | 対象シャード総数 |
| _shards.successful | int | 成功シャード数 |
| _shards.failed | int | 失敗シャード数 |

### 出力先

REST APIレスポンス（JSON形式）

## 処理フロー

### 処理シーケンス

```
1. REST APIリクエスト受信
   └─ ClearIndicesCacheRequestを生成
2. クラスタブロックチェック
   └─ METADATA_READレベルのブロック確認
3. 対象シャードの決定
   └─ 全シャード（プライマリ＋レプリカ）を取得
4. ブロードキャスト実行
   └─ 各ノードの各シャードに対してshardOperationを実行
5. シャード操作実行
   └─ ファイルキャッシュクリア（該当時）
   └─ IndicesService.clearIndexShardCache()でキャッシュクリア
6. ノード操作実行
   └─ IndicesService.forceClearNodewideCaches()でノード全体のキャッシュ強制クリア
```

### フローチャート

```mermaid
flowchart TD
    A[REST API リクエスト受信] --> B{クラスタブロックチェック}
    B -->|ブロックあり| C[ClusterBlockException]
    B -->|OK| D[対象シャード一覧取得]
    D --> E[各ノードへブロードキャスト]
    E --> F{ファイルキャッシュクリア?}
    F -->|Yes| G[Node.fileCache.prune]
    F -->|No| H[IndicesService.clearIndexShardCache]
    G --> H
    H --> I[ノード全体キャッシュ強制クリア]
    I --> J[ClearIndicesCacheResponse返却]
```

## ビジネスルール

### 業務ルール

| ルールNo | ルール名 | 内容 | 適用条件 |
|---------|---------|------|---------|
| BR-001 | 全キャッシュクリア | パラメータ未指定時は全種類のキャッシュがクリアされる | デフォルト |
| BR-002 | ファイルキャッシュ対応バージョン | ファイルキャッシュのクリアはV2.8.0以降でサポート | バージョンチェック |
| BR-003 | ノード横断クリア | 各ノードでnodeOperation()によりノード全体のキャッシュも強制クリアされる | 常時 |

### 計算ロジック

特になし。

## データベース操作仕様

### 操作別データベース影響一覧

| 操作 | 対象テーブル | 操作種別 | 概要 |
|-----|-------------|---------|------|
| キャッシュクリア | インメモリキャッシュ | DELETE | 各種キャッシュの内容を削除 |

### テーブル別操作詳細

RDBMSの操作は行わない。インメモリのキャッシュデータを削除する。

## エラー処理

### エラーケース一覧

| エラーコード | エラー種別 | 発生条件 | 対処方法 |
|------------|----------|---------|---------|
| ClusterBlockException | ブロック例外 | METADATA_READレベルのブロックが設定されている場合 | ブロック解除後に再試行 |
| BroadcastShardOperationFailedException | シャード操作失敗 | 個別シャードでのキャッシュクリアに失敗 | ログ出力後も処理を継続 |

### リトライ仕様

ノード全体の強制キャッシュクリアが失敗した場合は警告ログを出力し、次回のスケジュール済みキャッシュクリーンアップでクリアされる。

## トランザクション仕様

キャッシュ操作のためトランザクション管理は不要。

## パフォーマンス要件

MANAGEMENTスレッドプールで実行。大量のキャッシュがある場合、クリア操作でGCが発生する可能性がある。

## セキュリティ考慮事項

METADATA_READレベルのクラスタブロックチェックが行われる。

## 備考

ファイルキャッシュクリア機能はV2.8.0で追加された。writeTo/readFromで互換性チェックが行われる。

---

## コードリーディングガイド

本機能を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: データ構造を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | ClearIndicesCacheRequest.java | `server/src/main/java/org/opensearch/action/admin/indices/cache/clear/ClearIndicesCacheRequest.java` | クリア対象のフラグ（queryCache, fieldDataCache, requestCache, fileCache, fields）を保持 |

**読解のコツ**: 各キャッシュ種別はboolean型のフラグで管理される。V2.8.0のバージョンチェックに注目。

**主要処理フロー**:
- **52-56行目**: キャッシュ種別フラグの定義（デフォルトは全てfalse）
- **64-66行目**: fileCacheフラグのバージョンチェック（V2.8.0以降）

#### Step 2: エントリーポイントを理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | ClearIndicesCacheAction.java | `server/src/main/java/org/opensearch/action/admin/indices/cache/clear/ClearIndicesCacheAction.java` | アクション定義 |

#### Step 3: トランスポートアクションを理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | TransportClearIndicesCacheAction.java | `server/src/main/java/org/opensearch/action/admin/indices/cache/clear/TransportClearIndicesCacheAction.java` | ブロードキャスト型アクション。shardOperation()とnodeOperation()の2段階処理 |

**主要処理フロー**:
- **123-140行目**: shardOperation()でファイルキャッシュとインデックスシャードキャッシュのクリア
- **124-130行目**: ファイルキャッシュクリア時はShardPath.loadFileCachePath()でパス取得後prune()実行
- **132-138行目**: IndicesService.clearIndexShardCache()で各種キャッシュクリア
- **143-149行目**: nodeOperation()でノード全体のキャッシュ強制クリア

### プログラム呼び出し階層図

```
REST Handler
    |
    +-- TransportClearIndicesCacheAction
            |
            +-- shardOperation() : 各シャードで実行
            |       |
            |       +-- Node.fileCache().prune() （fileCache指定時）
            |       +-- IndicesService.clearIndexShardCache()
            |
            +-- nodeOperation() : 各ノードで実行
                    |
                    +-- IndicesService.forceClearNodewideCaches()
```

### データフロー図

```
[入力]                    [処理]                           [出力]

REST Request     -->  TransportBroadcastByNodeAction  -->  ClearIndicesCacheResponse
(cache flags)         shardOperation:                       (shards統計)
                      - fileCache prune
                      - clearIndexShardCache
                      nodeOperation:
                      - forceClearNodewideCaches
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| ClearIndicesCacheAction.java | `server/src/main/java/org/opensearch/action/admin/indices/cache/clear/` | ソース | アクション定義 |
| ClearIndicesCacheRequest.java | 同上 | ソース | リクエスト（キャッシュ種別フラグ） |
| ClearIndicesCacheResponse.java | 同上 | ソース | レスポンスクラス |
| TransportClearIndicesCacheAction.java | 同上 | ソース | トランスポートアクション実装 |
| ClearIndicesCacheRequestBuilder.java | 同上 | ソース | リクエストビルダー |
