# 機能設計書 124-インデックスリードオンリー

## 概要

本ドキュメントは、OpenSearchにおけるインデックスを読み取り専用モードに設定する機能の設計を記載する。

### 本機能の処理概要

本機能は、指定されたインデックスに対してブロック（読み取り専用、書き込み禁止等）を追加し、データの変更を防止する機能である。

**業務上の目的・背景**：データの整合性保護、保守作業中のデータ変更防止、コンプライアンス要件でのデータ不変性担保など、インデックスへの書き込みを制御する必要がある。本機能により、運用者はインデックスに対するアクセス制御をブロック単位で柔軟に設定できる。

**機能の利用シーン**：インデックスのメンテナンス時、データの読み取り専用アーカイブ化、書き込み禁止によるデータ保護、インデックスのマイグレーション準備時に利用される。

**主要な処理内容**：
1. リクエストのバリデーション（対象インデックス、ブロック種別の確認）
2. クラスタマネージャノードでのクラスタ状態更新処理
3. ブロックの追加とシャードレベルでの検証
4. インフライト操作の完了を待機後、ブロックを確定する

**関連システム・外部連携**：MetadataIndexStateServiceを通じてクラスタ状態を更新する。DestructiveOperationsによる安全性チェックが行われる。

**権限による制御**：METADATA_WRITEレベルのクラスタブロックチェック。破壊的操作の安全性チェック（DestructiveOperations）が適用される。

## 関連画面

| 画面No | 画面名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| 44 | インデックスブロック追加 | 主機能 | インデックスにブロック（読み取り専用等）を追加する処理 |

## 機能種別

クラスタ状態更新（メタデータ操作）

## 入力仕様

### 入力パラメータ

| パラメータ名 | 型 | 必須 | 説明 | バリデーション |
|-------------|-----|-----|------|---------------|
| index | String[] | Yes | 対象インデックス名 | 空でないこと |
| block | APIBlock | Yes | ブロック種別（read_only, read_only_allow_delete, write, metadata） | read_only_allow_deleteは内部使用のみ |
| timeout | TimeValue | No | ACKタイムアウト | - |
| cluster_manager_timeout | TimeValue | No | クラスタマネージャノードタイムアウト | - |

### 入力データソース

REST APIリクエスト（`PUT /<index>/_block/<block>`）

## 出力仕様

### 出力データ

| 項目名 | 型 | 説明 |
|--------|-----|------|
| acknowledged | boolean | リクエストが受理されたか |
| shards_acknowledged | boolean | 全シャードでブロックが確認されたか |
| indices | Array | 各インデックスのブロック追加結果 |

### 出力先

REST APIレスポンス（JSON形式）

## 処理フロー

### 処理シーケンス

```
1. REST APIリクエスト受信
   └─ AddIndexBlockRequest生成
2. バリデーション
   └─ インデックス名の存在確認、read_only_allow_deleteの排除
3. 破壊的操作チェック
   └─ DestructiveOperations.failDestructive()
4. クラスタブロックチェック
   └─ METADATA_WRITEレベルのブロック確認
5. クラスタマネージャノードでの操作
   └─ MetadataIndexStateService.addIndexBlock()呼び出し
6. 2段階クラスタ状態更新
   └─ Phase1: ブロック追加
   └─ Phase2: シャードレベル検証（TransportVerifyShardIndexBlockAction）
```

### フローチャート

```mermaid
flowchart TD
    A[REST API リクエスト受信] --> B[バリデーション]
    B --> C{read_only_allow_delete?}
    C -->|Yes| D[バリデーションエラー]
    C -->|No| E[DestructiveOperations チェック]
    E --> F{クラスタブロックチェック}
    F -->|ブロックあり| G[ClusterBlockException]
    F -->|OK| H[concreteIndices解決]
    H --> I{対象インデックスあり?}
    I -->|No| J[空レスポンス返却]
    I -->|Yes| K[MetadataIndexStateService.addIndexBlock]
    K --> L[Phase1: ブロック追加]
    L --> M[Phase2: シャード検証]
    M --> N[AddIndexBlockResponse返却]
```

## ビジネスルール

### 業務ルール

| ルールNo | ルール名 | 内容 | 適用条件 |
|---------|---------|------|---------|
| BR-001 | read_only_allow_delete制限 | read_only_allow_deleteブロックは内部使用専用で、APIからは設定不可 | 常時 |
| BR-002 | 2段階更新 | ブロックは2回のクラスタ状態更新で適用される（ブロック追加→シャード検証） | 書き込みブロック時 |
| BR-003 | インフライト待機 | 書き込みブロック追加時、進行中の書き込みの完了を待機する | 書き込みブロック時 |

### 計算ロジック

特になし。

## データベース操作仕様

### 操作別データベース影響一覧

| 操作 | 対象テーブル | 操作種別 | 概要 |
|-----|-------------|---------|------|
| ブロック追加 | クラスタ状態メタデータ | UPDATE | インデックスメタデータにブロックを追加 |

### テーブル別操作詳細

クラスタ状態のインデックスメタデータにブロック情報が追加される。

## エラー処理

### エラーケース一覧

| エラーコード | エラー種別 | 発生条件 | 対処方法 |
|------------|----------|---------|---------|
| ActionRequestValidationException | バリデーション | インデックス未指定、read_only_allow_delete指定時 | リクエスト修正 |
| ClusterBlockException | ブロック例外 | METADATA_WRITEブロックが設定されている場合 | ブロック解除後に再試行 |

### リトライ仕様

特になし。クラスタ状態更新タスクの失敗はActionListenerで通知される。

## トランザクション仕様

クラスタ状態更新タスクとして処理される。2段階のクラスタ状態更新で整合性を確保する。

## パフォーマンス要件

SAMEスレッドプールで実行（非同期処理のため専用スレッド不要）。

## セキュリティ考慮事項

DestructiveOperationsによる安全性チェックが適用される。METADATA_WRITEレベルのクラスタブロックチェックが行われる。

## 備考

本機能はElasticsearchから継承されたAPIであり、OpenSearchで引き続きサポートされている。

---

## コードリーディングガイド

本機能を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: データ構造を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | AddIndexBlockRequest.java | `server/src/main/java/org/opensearch/action/admin/indices/readonly/AddIndexBlockRequest.java` | APIBlock enum、対象インデックス、IndicesOptionsの管理 |
| 1-2 | AddIndexBlockResponse.java | `server/src/main/java/org/opensearch/action/admin/indices/readonly/AddIndexBlockResponse.java` | acknowledged, shards_acknowledged, インデックス別結果 |

**読解のコツ**: APIBlockはIndexMetadata内のenumとして定義されており、read_only、read_only_allow_delete、write、metadataの4種類がある。

**主要処理フロー（AddIndexBlockRequest.java）**:
- **72-75行目**: コンストラクタでblockとindicesをObjects.requireNonNull()で必須チェック
- **78-87行目**: validate()でインデックス空チェックとread_only_allow_deleteの排除

#### Step 2: トランスポートアクションを理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | TransportAddIndexBlockAction.java | `server/src/main/java/org/opensearch/action/admin/indices/readonly/TransportAddIndexBlockAction.java` | クラスタマネージャノードアクション。MetadataIndexStateServiceに委譲 |

**主要処理フロー**:
- **114-117行目**: doExecute()でDestructiveOperationsチェック後、親クラスに委譲
- **136-156行目**: clusterManagerOperation()でconcreteIndicesを解決し、MetadataIndexStateService.addIndexBlock()を呼び出す
- **148-151行目**: AddIndexBlockClusterStateUpdateRequestの構築（ブロック、タスクID、タイムアウト）

### プログラム呼び出し階層図

```
REST Handler
    |
    +-- TransportAddIndexBlockAction
            |
            +-- doExecute()
            |       +-- DestructiveOperations.failDestructive()
            |
            +-- clusterManagerOperation()
                    |
                    +-- indexNameExpressionResolver.concreteResolvedIndices()
                    +-- MetadataIndexStateService.addIndexBlock()
                            |
                            +-- Phase 1: ブロック追加（クラスタ状態更新）
                            +-- Phase 2: TransportVerifyShardIndexBlockAction
```

### データフロー図

```
[入力]                    [処理]                           [出力]

REST Request     -->  TransportAddIndexBlockAction  -->  AddIndexBlockResponse
(index, block)        |                                    (acknowledged,
                      +-> MetadataIndexStateService        shards_acknowledged)
                           |
                           +-> ClusterState更新
                           +-> シャードレベル検証
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| AddIndexBlockAction.java | `server/src/main/java/org/opensearch/action/admin/indices/readonly/` | ソース | アクション定義 |
| AddIndexBlockRequest.java | 同上 | ソース | リクエスト（APIBlock、インデックス） |
| AddIndexBlockResponse.java | 同上 | ソース | レスポンス |
| TransportAddIndexBlockAction.java | 同上 | ソース | トランスポートアクション |
| TransportVerifyShardIndexBlockAction.java | 同上 | ソース | シャードレベル検証アクション |
| AddIndexBlockClusterStateUpdateRequest.java | 同上 | ソース | クラスタ状態更新リクエスト |
| MetadataIndexStateService.java | `server/src/main/java/org/opensearch/cluster/metadata/` | ソース | ブロック追加のコアロジック |
