# 機能設計書 127-レート制限

## 概要

本ドキュメントは、OpenSearchにおけるリクエストのレート制限機能（アドミッションコントロール）の設計を記載する。

### 本機能の処理概要

本機能は、ノードのリソース使用状況（CPU、I/O）に基づいてトランスポートレイヤーでのリクエスト受け入れを制御し、過負荷を防止するアドミッションコントロール機能である。

**業務上の目的・背景**：大量のリクエストが集中した場合、ノードのリソースが枯渇しサービス全体に影響を及ぼす可能性がある。アドミッションコントロールにより、ノードの健全性を維持しながらリクエストを適切に制御し、クラスタの安定性を確保する。

**機能の利用シーン**：高負荷環境でのノード保護、バルクインジェスト時のリソース管理、検索負荷の急増への対応、クラスタの安定運用時に利用される。

**主要な処理内容**：
1. AdmissionControlServiceの初期化とコントローラー登録
2. CPU使用率に基づくリクエスト受け入れ制御（CpuBasedAdmissionController）
3. I/O使用率に基づくリクエスト受け入れ制御（IoBasedAdmissionController）
4. トランスポートアクションごとの制御適用
5. アドミッション制御統計の収集と報告

**関連システム・外部連携**：ResourceUsageCollectorServiceからノードリソース使用状況を取得。TransportServiceのインターセプターとして動作。

**権限による制御**：クラスタ設定によるアドミッションコントロールの有効/無効および閾値の制御。

## 関連画面

| 画面No | 画面名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| - | - | - | 本機能はトランスポートレイヤーの内部処理であり、直接的な画面はない |

## 機能種別

リクエスト制御（アドミッションコントロール）

## 入力仕様

### 入力パラメータ

クラスタ設定として:

| パラメータ名 | 型 | 必須 | 説明 | バリデーション |
|-------------|-----|-----|------|---------------|
| admission_control.transport.enabled | boolean | No | アドミッションコントロール有効/無効 | true/false |
| admission_control.cpu.* | 各種 | No | CPU基準の閾値設定 | - |
| admission_control.io.* | 各種 | No | I/O基準の閾値設定 | - |

### 入力データソース

ノードリソースメトリクス（ResourceUsageCollectorService）、トランスポートアクションリクエスト

## 出力仕様

### 出力データ

| 項目名 | 型 | 説明 |
|--------|-----|------|
| admission_control_stats | Object | コントローラー別の拒否統計 |

### 出力先

ノード統計APIレスポンス

## 処理フロー

### 処理シーケンス

```
1. AdmissionControlService初期化
   └─ CpuBasedAdmissionController登録
   └─ IoBasedAdmissionController登録（Linuxのみ）
2. トランスポートリクエスト受信時
   └─ applyTransportAdmissionControl()呼び出し
3. 各コントローラーでリソースチェック
   └─ CPU使用率 / I/O使用率の閾値チェック
4. 閾値超過時
   └─ リクエスト拒否（OpenSearchRejectedExecutionException）
```

### フローチャート

```mermaid
flowchart TD
    A[トランスポートリクエスト受信] --> B[applyTransportAdmissionControl]
    B --> C[CpuBasedAdmissionController.apply]
    C --> D{CPU閾値超過?}
    D -->|Yes| E[リクエスト拒否]
    D -->|No| F[IoBasedAdmissionController.apply]
    F --> G{I/O閾値超過?}
    G -->|Yes| E
    G -->|No| H[リクエスト許可・処理続行]
```

## ビジネスルール

### 業務ルール

| ルールNo | ルール名 | 内容 | 適用条件 |
|---------|---------|------|---------|
| BR-001 | I/OコントローラーLinux限定 | IoBasedAdmissionControllerはLinux環境でのみ登録 | 初期化時 |
| BR-002 | アクションタイプ別制御 | AdmissionControlActionTypeに基づいて制御対象を分類 | リクエスト受信時 |
| BR-003 | 全コントローラー適用 | 登録された全コントローラーに対してapply()を順次適用 | リクエスト受信時 |

### 計算ロジック

各コントローラーがResourceUsageCollectorServiceから取得したリソース使用率と設定閾値を比較する。

## データベース操作仕様

### 操作別データベース影響一覧

本機能はデータベース操作を行わない。

## エラー処理

### エラーケース一覧

| エラーコード | エラー種別 | 発生条件 | 対処方法 |
|------------|----------|---------|---------|
| OpenSearchRejectedExecutionException | 拒否 | リソース閾値超過時 | クライアント側でリトライまたは負荷軽減 |
| IllegalArgumentException | 不正引数 | 未サポートのコントローラー名指定 | コントローラー名確認 |

### リトライ仕様

拒否されたリクエストのリトライはクライアント側の責務。

## トランザクション仕様

トランザクション管理は不要。

## パフォーマンス要件

リクエスト処理のクリティカルパスに含まれるため、軽量なチェック処理である必要がある。ConcurrentHashMapによるスレッドセーフなコントローラー管理。

## セキュリティ考慮事項

クラスタ設定変更権限が必要。

## 備考

パッケージ名は「ratelimitting」（typo含む）となっている。

---

## コードリーディングガイド

本機能を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: 設定とデータ構造を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | AdmissionControlSettings.java | `server/src/main/java/org/opensearch/ratelimitting/admissioncontrol/AdmissionControlSettings.java` | グローバル設定（有効/無効、モード） |
| 1-2 | AdmissionControlActionType.java | `server/src/main/java/org/opensearch/ratelimitting/admissioncontrol/enums/AdmissionControlActionType.java` | アクション種別enum |

#### Step 2: メインサービスを理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | AdmissionControlService.java | `server/src/main/java/org/opensearch/ratelimitting/admissioncontrol/AdmissionControlService.java` | サービスのブートストラップとコントローラー管理 |

**主要処理フロー**:
- **52-65行目**: コンストラクタでsettings, clusterService, threadPool, resourceUsageCollectorServiceを注入しinitialize()
- **70-76行目**: initialize()でCPUとI/O（Linux限定）コントローラーを登録
- **83-87行目**: applyTransportAdmissionControl()で全コントローラーにapply()
- **101-120行目**: controllerFactory()でコントローラーをインスタンス化

#### Step 3: コントローラーを理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | AdmissionController.java | `server/src/main/java/org/opensearch/ratelimitting/admissioncontrol/controllers/AdmissionController.java` | コントローラー抽象基底クラス |
| 3-2 | CpuBasedAdmissionController.java | 同ディレクトリ | CPU基準のアドミッション制御 |
| 3-3 | IoBasedAdmissionController.java | 同ディレクトリ | I/O基準のアドミッション制御 |

### プログラム呼び出し階層図

```
TransportService (インターセプター)
    |
    +-- AdmissionControlService.applyTransportAdmissionControl()
            |
            +-- CpuBasedAdmissionController.apply()
            |       +-- ResourceUsageCollectorService.getNodeStatistics()
            |       +-- CPU使用率チェック
            |
            +-- IoBasedAdmissionController.apply() [Linuxのみ]
                    +-- ResourceUsageCollectorService.getNodeStatistics()
                    +-- I/O使用率チェック
```

### データフロー図

```
[入力]                    [処理]                           [出力]

TransportAction  -->  AdmissionControlService     -->  許可/拒否判定
リソースメトリクス -->  AdmissionController.apply()  -->  統計更新
                                                        (AdmissionControlStats)
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| AdmissionControlService.java | `server/src/main/java/org/opensearch/ratelimitting/admissioncontrol/` | ソース | メインサービス |
| AdmissionControlSettings.java | 同上 | ソース | グローバル設定 |
| AdmissionController.java | `同上/controllers/` | ソース | コントローラー基底 |
| CpuBasedAdmissionController.java | 同上 | ソース | CPUコントローラー |
| IoBasedAdmissionController.java | 同上 | ソース | I/Oコントローラー |
| AdmissionControlActionType.java | `同上/enums/` | ソース | アクション種別 |
| AdmissionControlStats.java | `同上/stats/` | ソース | 統計情報 |
| AdmissionControllerStats.java | 同上 | ソース | コントローラー別統計 |
