# 機能設計書 128-スレッドプール管理

## 概要

本ドキュメントは、OpenSearchにおける各種処理用のスレッドプール管理機能の設計を記載する。

### 本機能の処理概要

本機能は、OpenSearchの各種処理（検索、書き込み、マージ、管理等）に必要なスレッドプールを統合的に管理し、適切なリソース配分を行う基盤機能である。

**業務上の目的・背景**：OpenSearchは多様な種類の処理を並行して実行する必要がある。検索、インデクシング、フラッシュ、マージなど各処理の特性に応じた最適なスレッドプール構成が、システムの安定性とパフォーマンスに直結する。本機能は30種類以上のスレッドプールを統合管理し、適切なリソース配分を実現する。

**機能の利用シーン**：OpenSearchノード起動時のスレッドプール初期化、各種処理のスレッド割り当て、スレッドプール統計の監視（Cat Thread Pool API）、動的なスレッドプールサイズ変更時に利用される。

**主要な処理内容**：
1. ノード起動時のスレッドプール初期化と設定適用
2. 各種ExecutorBuilderによるスレッドプール生成
3. タスクのスケジューリングと時間管理
4. スレッドプール統計情報の収集と報告
5. ThreadContextによるスレッド間コンテキスト伝搬

**関連システム・外部連携**：OpenSearchの全コンポーネントがThreadPoolを利用する。プラグインがカスタムExecutorBuilderを追加可能。

**権限による制御**：クラスタ設定（cluster.thread_pool.*）によるスレッドプールサイズの動的変更。

## 関連画面

| 画面No | 画面名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| 110 | ホットスレッド | 補助機能 | スレッドプールのホットスレッド情報取得処理 |
| 165 | Cat スレッドプール | 主機能 | クラスタ全体のスレッドプール統計をテーブル形式で返す処理 |

## 機能種別

基盤機能（リソース管理）

## 入力仕様

### 入力パラメータ

ノード設定として:

| パラメータ名 | 型 | 必須 | 説明 | バリデーション |
|-------------|-----|-----|------|---------------|
| thread_pool.estimated_time_interval | TimeValue | No | 推定時刻の更新間隔（デフォルト: 200ms） | 0以上 |
| thread_pool.<name>.size | int | No | 固定サイズプールのスレッド数 | - |
| thread_pool.<name>.max | int | No | スケーリングプールの最大スレッド数 | - |
| thread_pool.<name>.core | int | No | スケーリングプールのコアスレッド数 | - |
| cluster.thread_pool.* | Settings | No | クラスタレベルのスレッドプール動的設定 | - |

### 入力データソース

opensearch.yml設定、クラスタ動的設定

## 出力仕様

### 出力データ

| 項目名 | 型 | 説明 |
|--------|-----|------|
| thread_pool.<name>.type | String | スレッドプール種別（fixed/scaling/resizable/fork_join/direct） |
| thread_pool.<name>.active | int | アクティブスレッド数 |
| thread_pool.<name>.queue | int | キュー内タスク数 |
| thread_pool.<name>.rejected | long | 拒否されたタスク数 |
| thread_pool.<name>.largest | int | 最大到達スレッド数 |
| thread_pool.<name>.completed | long | 完了タスク数 |

### 出力先

ThreadPoolInfo（ReportingService）、ThreadPoolStats

## 処理フロー

### 処理シーケンス

```
1. ThreadPool初期化
   └─ allocatedProcessorsからスレッドプールサイズ計算
   └─ 各ExecutorBuilder生成
   └─ カスタムExecutorBuilder登録
2. Executor構築
   └─ 各ビルダーのbuild()でExecutorService生成
   └─ executorsマップに登録
3. スケジューラ初期化
   └─ ScheduledThreadPoolExecutorの生成
4. CachedTimeThread開始
   └─ 推定時刻の定期更新
5. 運用中
   └─ executor(name)でExecutorService取得
   └─ schedule()でタスクスケジューリング
   └─ stats()で統計情報取得
```

### フローチャート

```mermaid
flowchart TD
    A[ノード起動] --> B[allocatedProcessors計算]
    B --> C[各ExecutorBuilder生成]
    C --> D[カスタムBuilder追加]
    D --> E[各Executorビルド]
    E --> F[スケジューラ初期化]
    F --> G[CachedTimeThread開始]
    G --> H[サービス開始]
    H --> I[executor取得/タスク実行]
    H --> J[stats収集/報告]
```

## ビジネスルール

### 業務ルール

| ルールNo | ルール名 | 内容 | 適用条件 |
|---------|---------|------|---------|
| BR-001 | プロセッサ基準サイズ | スレッドプールサイズはallocatedProcessorsに基づき計算 | 初期化時 |
| BR-002 | プール種別固定 | 各名前付きプールの種別（fixed/scaling等）は変更不可 | 常時 |
| BR-003 | SAME直接実行 | SAMEプールは呼び出しスレッドで直接実行 | 常時 |
| BR-004 | GENERIC汎用 | GENERICプールはスケーリング型で汎用処理用 | 常時 |

### 計算ロジック

主要なスレッドプールサイズ計算:
- GENERIC: min(max(4 * allocatedProcessors, 128), 512)
- WRITE: allocatedProcessors
- SEARCH: searchThreadPoolSize(allocatedProcessors)
- FORCE_MERGE: max(1, allocatedProcessors / 8)
- MANAGEMENT: 1-5（スケーリング）
- FLUSH/REFRESH: 1 - halfProcMaxAt5/10（スケーリング）

## データベース操作仕様

本機能はデータベース操作を行わない。インメモリのスレッドプール管理のみ。

## エラー処理

### エラーケース一覧

| エラーコード | エラー種別 | 発生条件 | 対処方法 |
|------------|----------|---------|---------|
| OpenSearchRejectedExecutionException | 拒否 | キューが満杯でタスクが拒否された場合 | リトライまたは負荷軽減 |
| IllegalArgumentException | 不正引数 | 重複するExecutorBuilder名 | カスタムプラグイン設定確認 |

### リトライ仕様

タスク拒否時はOpenSearchRejectedExecutionExceptionが返される。リトライは呼び出し側の責務。

## トランザクション仕様

トランザクション管理は不要。

## パフォーマンス要件

CachedTimeThreadにより推定時刻を200ms間隔で更新し、System.currentTimeMillis()の呼び出しを最小化。各プールのキューサイズ制限でバックプレッシャーを実現。

## セキュリティ考慮事項

ThreadContextにより認証情報やトレーシング情報がスレッド間で伝搬される。

## 備考

ThreadPoolはSchedulerインターフェースも実装しており、遅延実行や定期実行のスケジューリング機能も提供する。

---

## コードリーディングガイド

本機能を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: データ構造を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | ThreadPoolInfo.java | `server/src/main/java/org/opensearch/threadpool/ThreadPoolInfo.java` | スレッドプール情報のシリアライズ |
| 1-2 | ThreadPoolStats.java | `server/src/main/java/org/opensearch/threadpool/ThreadPoolStats.java` | スレッドプール統計（active, queue, rejected等） |

#### Step 2: メインクラスを理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | ThreadPool.java | `server/src/main/java/org/opensearch/threadpool/ThreadPool.java` | 30以上のスレッドプール定義、初期化、統計収集 |

**主要処理フロー**:
- **99-130行目**: Names内部クラスで全スレッドプール名を定数定義
- **141-146行目**: ThreadPoolType enumでDIRECT/FIXED/RESIZABLE/SCALING/FORK_JOINを定義
- **179-211行目**: THREAD_POOL_TYPESマップで各プール名と種別の対応を定義
- **244-349行目**: コンストラクタで全ExecutorBuilderを生成しサイズ計算
- **262行目**: GENERICプール（4-512スレッド、スケーリング）
- **264行目**: WRITEプール（allocatedProcessorsスレッド、キュー10000）
- **268-270行目**: SEARCHプール（リサイズ可能、キュー1000）
- **300-302行目**: FORCE_MERGEプール（allocatedProcessors/8スレッド）

#### Step 3: ExecutorBuilderを理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | ExecutorBuilder.java | `server/src/main/java/org/opensearch/threadpool/ExecutorBuilder.java` | ビルダー基底クラス |
| 3-2 | FixedExecutorBuilder.java | 同ディレクトリ | 固定サイズプールビルダー |
| 3-3 | ScalingExecutorBuilder.java | 同ディレクトリ | スケーリングプールビルダー |
| 3-4 | ResizableExecutorBuilder.java | 同ディレクトリ | リサイズ可能プールビルダー |

### プログラム呼び出し階層図

```
ThreadPool (コンストラクタ)
    |
    +-- ExecutorBuilder群の生成
    |       +-- FixedExecutorBuilder (WRITE, GET, FORCE_MERGE等)
    |       +-- ScalingExecutorBuilder (GENERIC, MANAGEMENT, FLUSH等)
    |       +-- ResizableExecutorBuilder (SEARCH, STREAM_SEARCH等)
    |
    +-- 各Builder.build() -> ExecutorService
    +-- ScheduledThreadPoolExecutor (scheduler)
    +-- CachedTimeThread (推定時刻)
    |
    +-- executor(name) -> Executor
    +-- schedule(task, delay) -> ScheduledCancellable
    +-- stats() -> ThreadPoolStats
```

### データフロー図

```
[入力]                    [処理]                           [出力]

Settings         -->  ThreadPool初期化            -->  ExecutorServiceマップ
(opensearch.yml)      各ExecutorBuilder.build()        ScheduledThreadPoolExecutor
                      CachedTimeThread

タスク           -->  executor(name).execute()    -->  タスク実行結果
統計要求         -->  stats()                     -->  ThreadPoolStats
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| ThreadPool.java | `server/src/main/java/org/opensearch/threadpool/` | ソース | メインクラス |
| ThreadPoolInfo.java | 同上 | ソース | プール情報 |
| ThreadPoolStats.java | 同上 | ソース | プール統計 |
| ExecutorBuilder.java | 同上 | ソース | ビルダー基底 |
| FixedExecutorBuilder.java | 同上 | ソース | 固定サイズビルダー |
| ScalingExecutorBuilder.java | 同上 | ソース | スケーリングビルダー |
| ResizableExecutorBuilder.java | 同上 | ソース | リサイズ可能ビルダー |
| ForkJoinPoolExecutorBuilder.java | 同上 | ソース | ForkJoinPoolビルダー |
| Scheduler.java | 同上 | ソース | スケジューラIF |
| TaskAwareRunnable.java | 同上 | ソース | タスク認識Runnable |
| RunnableTaskExecutionListener.java | 同上 | ソース | タスク実行リスナー |
