# 機能設計書 17-マッピング管理

## 概要

本ドキュメントは、OpenSearchの「マッピング管理」機能の設計を記述する。インデックスのフィールド型定義（マッピング）を設定・取得するAPI群の処理仕様を定義する。

### 本機能の処理概要

本機能は、インデックスのマッピング（フィールドの型定義、アナライザ設定等）を管理する機能群である。マッピングの取得（Get Mapping API）、マッピングの更新（Put Mapping API）、フィールドマッピングの取得（Get Field Mapping API）の3つのAPIを提供する。

**業務上の目的・背景**：OpenSearchでは、ドキュメントのフィールドがどのようなデータ型として扱われるか（text、keyword、integer、date等）をマッピングで定義する。適切なマッピング設定は検索精度、インデキシング性能、ストレージ効率に直結する重要な設定項目である。

**機能の利用シーン**：インデックスのスキーマ設計時のフィールド型定義、既存マッピングの確認、新規フィールドの追加、マッピング変更時の互換性確認、特定フィールドのマッピング情報の取得で利用される。

**主要な処理内容**：
1. Get Mapping API：インデックスのマッピング定義全体を返却
2. Put Mapping API：インデックスのマッピング定義を更新（フィールド追加。既存フィールドの型変更は不可）
3. Get Field Mapping API：特定フィールドのマッピング定義を返却
4. Auto Put Mapping：ドキュメント登録時の自動マッピング更新

**関連システム・外部連携**：インデックス作成機能（マッピング初期設定）、ドキュメントインデックス機能（動的マッピング検出）、インデックステンプレート（テンプレートマッピング適用）。

**権限による制御**：マッピング取得はアクション名 `indices:admin/mappings/get`、マッピング更新はアクション名 `indices:admin/mapping/put` に基づくセキュリティ権限チェック。

## 関連画面

| 画面No | 画面名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| 50 | マッピング取得 | 主機能 | 1つ以上のインデックスのマッピングを返す処理 |
| 51 | マッピング更新 | 主機能 | インデックスマッピングを更新する処理 |
| 52 | フィールドマッピング取得 | 主機能 | 1つ以上のフィールドのマッピングを返す処理 |

## 機能種別

CRUD操作（Read/Update） - スキーマ管理

## 入力仕様

### 入力パラメータ

#### Get Mapping API

| パラメータ名 | 型 | 必須 | 説明 | バリデーション |
|-------------|-----|-----|------|---------------|
| indices | String[] | No | 対象インデックス名（省略時は全インデックス） | - |
| clusterManagerNodeTimeout | TimeValue | No | クラスタマネージャノードへの接続タイムアウト | - |

#### Put Mapping API

| パラメータ名 | 型 | 必須 | 説明 | バリデーション |
|-------------|-----|-----|------|---------------|
| indices | String[] | Yes | 対象インデックス名 | 1つ以上必須 |
| source | String(JSON) | Yes | マッピング定義（JSON形式） | 有効なマッピングJSON |
| timeout | TimeValue | No | タイムアウト | - |
| writeIndexOnly | boolean | No | 書き込みインデックスのみに適用 | - |

#### Get Field Mapping API

| パラメータ名 | 型 | 必須 | 説明 | バリデーション |
|-------------|-----|-----|------|---------------|
| indices | String[] | No | 対象インデックス名 | - |
| fields | String[] | Yes | 対象フィールド名（ワイルドカード可） | 1つ以上必須 |
| includeDefaults | boolean | No | デフォルト設定を含めるか | - |

### 入力データソース

REST APIリクエスト（HTTP GET/PUT/POST）

## 出力仕様

### 出力データ

#### Get Mapping API

| 項目名 | 型 | 説明 |
|--------|-----|------|
| {index} | Object | インデックス名をキーとしたマッピング定義 |
| {index}.mappings | Object | マッピング定義（properties, dynamic等） |

#### Put Mapping API

| 項目名 | 型 | 説明 |
|--------|-----|------|
| acknowledged | boolean | マッピング更新が承認されたか |

### 出力先

REST APIレスポンス（JSON形式）

## 処理フロー

### 処理シーケンス

```
1. リクエスト受信・バリデーション
   └─ インデックス名解決、マッピングJSON検証
2. クラスタマネージャノードへの転送（Put Mapping時）
   └─ マッピング更新はクラスタ状態の変更を伴うためクラスタマネージャで処理
3. RequestValidatorsによる追加バリデーション
   └─ プラグインによる拡張バリデーション
4. MappingTransformerRegistryによるマッピング変換
   └─ プラグインによるマッピング変換処理
5. MetadataMappingServiceによるマッピング適用
   └─ クラスタ状態を更新してマッピングを永続化
6. レスポンス構築・返却
```

### フローチャート

```mermaid
flowchart TD
    A[Mapping リクエスト受信] --> B{GET or PUT?}
    B -->|GET| C[クラスタ状態からマッピング取得]
    C --> D[GetMappingsResponse 返却]
    B -->|PUT| E[クラスタマネージャへ転送]
    E --> F{RequestValidators OK?}
    F -->|No| G[バリデーションエラー]
    F -->|Yes| H[MappingTransformerRegistry変換]
    H --> I[MetadataMappingService.putMapping]
    I --> J{成功?}
    J -->|Yes| K[AcknowledgedResponse返却]
    J -->|No| L[エラー返却]
```

## ビジネスルール

### 業務ルール

| ルールNo | ルール名 | 内容 | 適用条件 |
|---------|---------|------|---------|
| BR-17-01 | フィールド型の不変性 | 既存フィールドの型は変更不可。新しいフィールドの追加のみ可能 | Put Mapping時 |
| BR-17-02 | 動的マッピング | ドキュメント登録時に未定義フィールドが検出された場合、dynamic設定に従い自動マッピング | dynamic=true（デフォルト） |
| BR-17-03 | クラスタ状態更新 | マッピング更新はクラスタ状態の変更として伝播される | Put Mapping時 |
| BR-17-04 | Auto Put Mapping | ドキュメント登録時のフィールド自動検出では、AutoPutMappingActionが使用される | 動的マッピング時 |

### 計算ロジック

特に複雑な計算ロジックはない。

## データベース操作仕様

### 操作別データベース影響一覧

| 操作 | 対象テーブル | 操作種別 | 概要 |
|-----|-------------|---------|------|
| マッピング取得 | ClusterState（メタデータ） | SELECT | クラスタ状態からマッピング定義を取得 |
| マッピング更新 | ClusterState（メタデータ） | UPDATE | クラスタ状態を更新してマッピングを永続化 |

## エラー処理

### エラーケース一覧

| エラーコード | エラー種別 | 発生条件 | 対処方法 |
|------------|----------|---------|---------|
| 400 | MapperParsingException | マッピングJSONの構文エラーまたは不正な型定義 | マッピング定義を修正 |
| 400 | IllegalArgumentException | 既存フィールドの型変更試行 | 新フィールドとして追加するかリインデックス |
| 404 | IndexNotFoundException | 指定インデックスが存在しない | インデックスを事前作成 |
| 503 | ClusterBlockException | クラスタ書き込みブロック中 | ブロック解除後に再試行 |

### リトライ仕様

クラスタマネージャノードへの転送はトランスポート層のリトライメカニズムに従う。

## トランザクション仕様

マッピング更新はクラスタ状態の更新として処理される。クラスタ状態の更新はアトミックであり、成功または失敗のいずれかとなる。

## パフォーマンス要件

- マッピング取得はクラスタ状態のメモリ上のデータを参照するため高速
- マッピング更新はクラスタ状態の更新を伴うためクラスタマネージャの負荷に注意

## セキュリティ考慮事項

- マッピング取得：`indices:admin/mappings/get` 権限
- マッピング更新：`indices:admin/mapping/put` 権限
- フィールドマッピング取得：`indices:admin/mappings/fields/get` 権限

## 備考

- TransportPutMappingActionはTransportClusterManagerNodeActionを継承し、クラスタマネージャノードで処理される
- MappingTransformerRegistryによりプラグインがマッピング定義を変換可能
- RequestValidators<PutMappingRequest>により追加バリデーションが挿入可能

---

## コードリーディングガイド

本機能を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: データ構造を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | PutMappingRequest.java | `server/src/main/java/org/opensearch/action/admin/indices/mapping/put/PutMappingRequest.java` | マッピング更新リクエスト構造 |
| 1-2 | GetMappingsRequest.java | `server/src/main/java/org/opensearch/action/admin/indices/mapping/get/GetMappingsRequest.java` | マッピング取得リクエスト |
| 1-3 | GetMappingsResponse.java | `server/src/main/java/org/opensearch/action/admin/indices/mapping/get/GetMappingsResponse.java` | マッピング取得レスポンス |
| 1-4 | GetFieldMappingsRequest.java | `server/src/main/java/org/opensearch/action/admin/indices/mapping/get/GetFieldMappingsRequest.java` | フィールドマッピング取得リクエスト |

#### Step 2: エントリーポイントを理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | TransportPutMappingAction.java | `server/src/main/java/org/opensearch/action/admin/indices/mapping/put/TransportPutMappingAction.java` | マッピング更新処理。TransportClusterManagerNodeActionを継承 |
| 2-2 | TransportGetMappingsAction.java | `server/src/main/java/org/opensearch/action/admin/indices/mapping/get/TransportGetMappingsAction.java` | マッピング取得処理 |
| 2-3 | TransportGetFieldMappingsAction.java | `server/src/main/java/org/opensearch/action/admin/indices/mapping/get/TransportGetFieldMappingsAction.java` | フィールドマッピング取得 |

**主要処理フロー（TransportPutMappingAction）**:
1. **73-75行目**: TransportClusterManagerNodeActionを継承、TransportIndicesResolvingActionを実装
2. **79-81行目**: MetadataMappingService, RequestValidators, MappingTransformerRegistryに依存

#### Step 3: メタデータサービスを理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | MetadataMappingService.java | `server/src/main/java/org/opensearch/cluster/metadata/MetadataMappingService.java` | マッピングのクラスタ状態への適用ロジック |

### プログラム呼び出し階層図

```
REST API (PUT /{index}/_mapping)
    |
    +-- TransportPutMappingAction (ClusterManager Node)
           |
           +-- RequestValidators<PutMappingRequest>
           +-- MappingTransformerRegistry
           +-- MetadataMappingService.putMapping()
                  |
                  +-- ClusterState更新

REST API (GET /{index}/_mapping)
    |
    +-- TransportGetMappingsAction
           |
           +-- ClusterState.metadata().findMappings()

REST API (GET /{index}/_mapping/field/{fields})
    |
    +-- TransportGetFieldMappingsAction
           |
           +-- TransportGetFieldMappingsIndexAction (インデックスごと)
```

### データフロー図

```
[入力]                        [処理]                            [出力]

PutMappingRequest     -->  TransportPutMappingAction         -->  AcknowledgedResponse
 - indices                  +-> MetadataMappingService              - acknowledged
 - source(JSON)             +-> ClusterState更新

GetMappingsRequest    -->  TransportGetMappingsAction        -->  GetMappingsResponse
 - indices                  +-> ClusterState参照                    - mappings{}
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| PutMappingAction.java | `server/src/main/java/org/opensearch/action/admin/indices/mapping/put/PutMappingAction.java` | ソース | マッピング更新アクション |
| PutMappingRequest.java | `server/src/main/java/org/opensearch/action/admin/indices/mapping/put/PutMappingRequest.java` | ソース | 更新リクエスト |
| TransportPutMappingAction.java | `server/src/main/java/org/opensearch/action/admin/indices/mapping/put/TransportPutMappingAction.java` | ソース | 更新トランスポート処理 |
| AutoPutMappingAction.java | `server/src/main/java/org/opensearch/action/admin/indices/mapping/put/AutoPutMappingAction.java` | ソース | 自動マッピング更新アクション |
| TransportAutoPutMappingAction.java | `server/src/main/java/org/opensearch/action/admin/indices/mapping/put/TransportAutoPutMappingAction.java` | ソース | 自動マッピング更新処理 |
| PutMappingClusterStateUpdateRequest.java | `server/src/main/java/org/opensearch/action/admin/indices/mapping/put/PutMappingClusterStateUpdateRequest.java` | ソース | クラスタ状態更新リクエスト |
| GetMappingsAction.java | `server/src/main/java/org/opensearch/action/admin/indices/mapping/get/GetMappingsAction.java` | ソース | マッピング取得アクション |
| GetMappingsRequest.java | `server/src/main/java/org/opensearch/action/admin/indices/mapping/get/GetMappingsRequest.java` | ソース | 取得リクエスト |
| GetMappingsResponse.java | `server/src/main/java/org/opensearch/action/admin/indices/mapping/get/GetMappingsResponse.java` | ソース | 取得レスポンス |
| TransportGetMappingsAction.java | `server/src/main/java/org/opensearch/action/admin/indices/mapping/get/TransportGetMappingsAction.java` | ソース | 取得トランスポート処理 |
| GetFieldMappingsAction.java | `server/src/main/java/org/opensearch/action/admin/indices/mapping/get/GetFieldMappingsAction.java` | ソース | フィールドマッピング取得アクション |
| GetFieldMappingsRequest.java | `server/src/main/java/org/opensearch/action/admin/indices/mapping/get/GetFieldMappingsRequest.java` | ソース | フィールドマッピング取得リクエスト |
| GetFieldMappingsResponse.java | `server/src/main/java/org/opensearch/action/admin/indices/mapping/get/GetFieldMappingsResponse.java` | ソース | フィールドマッピング取得レスポンス |
| TransportGetFieldMappingsAction.java | `server/src/main/java/org/opensearch/action/admin/indices/mapping/get/TransportGetFieldMappingsAction.java` | ソース | フィールドマッピング取得処理 |
| TransportGetFieldMappingsIndexAction.java | `server/src/main/java/org/opensearch/action/admin/indices/mapping/get/TransportGetFieldMappingsIndexAction.java` | ソース | インデックス単位のフィールドマッピング取得 |
| MetadataMappingService.java | `server/src/main/java/org/opensearch/cluster/metadata/MetadataMappingService.java` | ソース | マッピングメタデータ管理 |
