# 機能設計書 18-インデックス設定管理

## 概要

本ドキュメントは、OpenSearchの「インデックス設定管理」機能の設計を記述する。インデックスの動的設定を更新・取得するAPI群の処理仕様を定義する。

### 本機能の処理概要

本機能は、インデックスの設定（レプリカ数、リフレッシュ間隔、検索スローログ設定等）を管理する機能群である。設定取得（Get Settings API）と設定更新（Update Settings API）の2つのAPIを提供する。

**業務上の目的・背景**：OpenSearchのインデックスには多数の設定項目があり、運用中に動的に変更可能なものも多い。レプリカ数の調整、リフレッシュ間隔のチューニング、検索スローログの有効化等、運用要件に応じた設定変更が必要となる。

**機能の利用シーン**：インデックスの現在設定の確認、レプリカ数の変更、リフレッシュ間隔の調整、スローログ閾値の設定、検索・インデキシング性能のチューニングで利用される。

**主要な処理内容**：
1. Get Settings API：インデックスの設定値全体またはフィルタリングされた設定値を返却
2. Update Settings API：インデックスの動的設定を更新（静的設定はクローズ状態でのみ変更可能）
3. リモートスナップショットインデックスに対する設定変更の制限

**関連システム・外部連携**：インデックス作成機能（初期設定）、クラスタ設定管理機能。

**権限による制御**：設定取得はアクション名 `indices:monitor/settings/get`、設定更新はアクション名 `indices:admin/settings/update` に基づくセキュリティ権限チェック。

## 関連画面

| 画面No | 画面名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| 53 | 設定取得 | 主機能 | 1つ以上のインデックスの設定を返す処理 |
| 54 | 設定更新 | 主機能 | インデックス設定を動的に更新する処理 |

## 機能種別

CRUD操作（Read/Update） - 設定管理

## 入力仕様

### 入力パラメータ

#### Get Settings API

| パラメータ名 | 型 | 必須 | 説明 | バリデーション |
|-------------|-----|-----|------|---------------|
| indices | String[] | No | 対象インデックス名 | - |
| names | String[] | No | 取得する設定名（フィルタリング） | - |
| includeDefaults | boolean | No | デフォルト値を含めるか | - |
| clusterManagerNodeTimeout | TimeValue | No | クラスタマネージャ接続タイムアウト | - |

#### Update Settings API

| パラメータ名 | 型 | 必須 | 説明 | バリデーション |
|-------------|-----|-----|------|---------------|
| indices | String[] | Yes | 対象インデックス名 | 1つ以上必須 |
| settings | Settings | Yes | 更新する設定値 | 有効な設定キー・値 |
| preserveExisting | boolean | No | 既存設定を保持するか | - |
| timeout | TimeValue | No | タイムアウト | - |

### 入力データソース

REST APIリクエスト（HTTP GET/PUT）

## 出力仕様

### 出力データ

#### Get Settings API

| 項目名 | 型 | 説明 |
|--------|-----|------|
| {index} | Object | インデックス名をキーとした設定値 |
| {index}.settings | Settings | インデックスの設定値 |
| {index}.defaults | Settings | デフォルト設定値（includeDefaults=true時） |

#### Update Settings API

| 項目名 | 型 | 説明 |
|--------|-----|------|
| acknowledged | boolean | 設定更新が承認されたか |

### 出力先

REST APIレスポンス（JSON形式）

## 処理フロー

### 処理シーケンス

```
1. リクエスト受信・バリデーション
   └─ インデックス名解決、設定キーの検証
2. クラスタマネージャノードへの転送（Update Settings時）
   └─ 設定更新はクラスタ状態の変更を伴うためクラスタマネージャで処理
3. リモートスナップショット設定の許可リストチェック（Update Settings時）
   └─ リモートスナップショットインデックスに対しては限定的な設定のみ変更可能
4. MetadataUpdateSettingsServiceによる設定適用
   └─ クラスタ状態を更新して設定を永続化
5. レスポンス構築・返却
```

### フローチャート

```mermaid
flowchart TD
    A[Settings リクエスト受信] --> B{GET or PUT?}
    B -->|GET| C[クラスタ状態から設定取得]
    C --> D[GetSettingsResponse 返却]
    B -->|PUT| E[クラスタマネージャへ転送]
    E --> F{リモートスナップショット?}
    F -->|Yes| G{許可リスト内?}
    G -->|No| H[エラー返却]
    G -->|Yes| I[MetadataUpdateSettingsService]
    F -->|No| I
    I --> J{成功?}
    J -->|Yes| K[AcknowledgedResponse返却]
    J -->|No| L[エラー返却]
```

## ビジネスルール

### 業務ルール

| ルールNo | ルール名 | 内容 | 適用条件 |
|---------|---------|------|---------|
| BR-18-01 | 動的/静的設定 | 動的設定はインデックスオープン中に変更可能。静的設定はインデックスクローズ中にのみ変更可能 | 常時 |
| BR-18-02 | リモートスナップショット制限 | リモートスナップショットインデックスに対してはmax_result_window, number_of_replicas等の限定的な設定のみ変更可能 | リモートスナップショットインデックス |
| BR-18-03 | スローログ設定プレフィックス | index.search.slowlogプレフィックスの設定はリモートスナップショットでも変更可能 | リモートスナップショット |
| BR-18-04 | ルーティングアロケーション設定 | index.routing.allocationプレフィックスの設定はリモートスナップショットでも変更可能 | リモートスナップショット |

### 計算ロジック

特に複雑な計算ロジックはない。

## データベース操作仕様

### 操作別データベース影響一覧

| 操作 | 対象テーブル | 操作種別 | 概要 |
|-----|-------------|---------|------|
| 設定取得 | ClusterState（メタデータ） | SELECT | クラスタ状態から設定値を取得 |
| 設定更新 | ClusterState（メタデータ） | UPDATE | クラスタ状態を更新して設定を永続化 |

## エラー処理

### エラーケース一覧

| エラーコード | エラー種別 | 発生条件 | 対処方法 |
|------------|----------|---------|---------|
| 400 | IllegalArgumentException | 不正な設定キーまたは値 | 設定キー・値を修正 |
| 400 | IllegalArgumentException | 静的設定のオープンインデックスへの適用 | インデックスをクローズして変更 |
| 403 | リモートスナップショット制限 | 許可リスト外の設定変更 | 許可された設定のみ変更 |
| 404 | IndexNotFoundException | 指定インデックスが存在しない | インデックスを事前作成 |
| 503 | ClusterBlockException | クラスタ書き込みブロック中 | ブロック解除後に再試行 |

### リトライ仕様

クラスタマネージャノードへの転送はトランスポート層のリトライメカニズムに従う。

## トランザクション仕様

設定更新はクラスタ状態の更新として処理される。クラスタ状態の更新はアトミック。

## パフォーマンス要件

- 設定取得はクラスタ状態のメモリ上のデータを参照するため高速
- 設定更新はクラスタ状態の更新を伴うためクラスタマネージャの負荷に注意

## セキュリティ考慮事項

- 設定取得：`indices:monitor/settings/get` 権限
- 設定更新：`indices:admin/settings/update` 権限

## 備考

- TransportUpdateSettingsActionはTransportClusterManagerNodeActionを継承
- ALLOWLIST_REMOTE_SNAPSHOT_SETTINGSにリモートスナップショットで許可される設定が定義
- ALLOWLIST_REMOTE_SNAPSHOT_SETTINGS_PREFIXESにプレフィックスベースの許可設定が定義

---

## コードリーディングガイド

本機能を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: データ構造を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | UpdateSettingsRequest.java | `server/src/main/java/org/opensearch/action/admin/indices/settings/put/UpdateSettingsRequest.java` | 設定更新リクエスト構造 |
| 1-2 | GetSettingsRequest.java | `server/src/main/java/org/opensearch/action/admin/indices/settings/get/GetSettingsRequest.java` | 設定取得リクエスト |
| 1-3 | GetSettingsResponse.java | `server/src/main/java/org/opensearch/action/admin/indices/settings/get/GetSettingsResponse.java` | 設定取得レスポンス |

#### Step 2: エントリーポイントを理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | TransportUpdateSettingsAction.java | `server/src/main/java/org/opensearch/action/admin/indices/settings/put/TransportUpdateSettingsAction.java` | 設定更新処理。TransportClusterManagerNodeActionを継承 |
| 2-2 | TransportGetSettingsAction.java | `server/src/main/java/org/opensearch/action/admin/indices/settings/get/TransportGetSettingsAction.java` | 設定取得処理 |

**主要処理フロー（TransportUpdateSettingsAction）**:
1. **68-70行目**: TransportClusterManagerNodeActionを継承、TransportIndicesResolvingActionを実装
2. **74-86行目**: ALLOWLIST_REMOTE_SNAPSHOT_SETTINGS（許可設定セット）の定義。max_result_window, number_of_replicas等
3. **86行目**: ALLOWLIST_REMOTE_SNAPSHOT_SETTINGS_PREFIXES（プレフィックス許可リスト）
4. **88行目**: MetadataUpdateSettingsServiceへの依存

### プログラム呼び出し階層図

```
REST API (PUT /{index}/_settings)
    |
    +-- TransportUpdateSettingsAction (ClusterManager Node)
           |
           +-- リモートスナップショット許可リストチェック
           +-- MetadataUpdateSettingsService.updateSettings()
                  |
                  +-- ClusterState更新

REST API (GET /{index}/_settings)
    |
    +-- TransportGetSettingsAction
           |
           +-- ClusterState.metadata().index().getSettings()
```

### データフロー図

```
[入力]                          [処理]                              [出力]

UpdateSettingsRequest   -->  TransportUpdateSettingsAction       -->  AcknowledgedResponse
 - indices                    +-> 許可リストチェック                    - acknowledged
 - settings                   +-> MetadataUpdateSettingsService

GetSettingsRequest      -->  TransportGetSettingsAction          -->  GetSettingsResponse
 - indices                    +-> ClusterState参照                     - settings{}
 - names
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| UpdateSettingsAction.java | `server/src/main/java/org/opensearch/action/admin/indices/settings/put/UpdateSettingsAction.java` | ソース | 設定更新アクション |
| UpdateSettingsRequest.java | `server/src/main/java/org/opensearch/action/admin/indices/settings/put/UpdateSettingsRequest.java` | ソース | 更新リクエスト |
| TransportUpdateSettingsAction.java | `server/src/main/java/org/opensearch/action/admin/indices/settings/put/TransportUpdateSettingsAction.java` | ソース | 更新トランスポート処理 |
| UpdateSettingsClusterStateUpdateRequest.java | `server/src/main/java/org/opensearch/action/admin/indices/settings/put/UpdateSettingsClusterStateUpdateRequest.java` | ソース | クラスタ状態更新リクエスト |
| GetSettingsAction.java | `server/src/main/java/org/opensearch/action/admin/indices/settings/get/GetSettingsAction.java` | ソース | 設定取得アクション |
| GetSettingsRequest.java | `server/src/main/java/org/opensearch/action/admin/indices/settings/get/GetSettingsRequest.java` | ソース | 取得リクエスト |
| GetSettingsResponse.java | `server/src/main/java/org/opensearch/action/admin/indices/settings/get/GetSettingsResponse.java` | ソース | 取得レスポンス |
| TransportGetSettingsAction.java | `server/src/main/java/org/opensearch/action/admin/indices/settings/get/TransportGetSettingsAction.java` | ソース | 取得トランスポート処理 |
| MetadataUpdateSettingsService.java | `server/src/main/java/org/opensearch/cluster/metadata/MetadataUpdateSettingsService.java` | ソース | 設定メタデータ管理 |
