# 機能設計書 2-インデックス削除

## 概要

本ドキュメントは、OpenSearchにおけるインデックス削除機能の設計を記述する。指定したインデックスをクラスタから完全に削除する機能である。

### 本機能の処理概要

インデックス削除機能は、指定されたインデックス（複数指定可能）をクラスタから完全に削除する。削除対象はオープン・クローズ両方のインデックスが含まれる。

**業務上の目的・背景**：不要になったインデックスを削除することで、ディスク容量を解放し、クラスタのリソース消費を削減する。データの保持期間経過後のインデックス削除やテスト環境のクリーンアップに使用される。

**機能の利用シーン**：保持期間を過ぎた時系列インデックスの削除、テストデータの削除、インデックス再構築前の既存インデックス削除時に利用される。

**主要な処理内容**：
1. REST APIからのリクエスト受信と破壊的操作チェック
2. インデックス名の解決（ワイルドカード展開含む）
3. クラスタブロックチェック
4. MetadataDeleteIndexServiceを介したクラスタ状態の更新
5. インデックスメタデータとルーティング情報の削除

**関連システム・外部連携**：データストリームのバッキングインデックスを直接削除する場合は制限がある。スナップショットが進行中のインデックスは削除できない場合がある。

**権限による制御**：`indices:admin/delete`アクションに対する権限が必要。破壊的操作の安全チェック（DestructiveOperations）が適用される。

## 関連画面

| 画面No | 画面名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| 39 | インデックス削除 | 主画面 | 指定したインデックスを削除する主処理 |
| 130 | Danglingインデックス削除 | 参照画面 | 指定したDanglingインデックスを削除する処理 |

## 機能種別

CRUD操作（Delete）/ クラスタ状態管理

## 入力仕様

### 入力パラメータ

| パラメータ名 | 型 | 必須 | 説明 | バリデーション |
|-------------|-----|-----|------|---------------|
| indices | String[] | Yes | 削除対象のインデックス名（複数指定可、ワイルドカード可） | 空配列でないこと |
| timeout | TimeValue | No | Ack待機タイムアウト | デフォルト30秒 |
| cluster_manager_timeout | TimeValue | No | クラスタマネージャノード待機タイムアウト | デフォルト30秒 |
| indicesOptions | IndicesOptions | No | インデックス解決オプション | デフォルト: オープン・クローズ両方対象、存在しないインデックスは無視 |

### 入力データソース

REST API（DELETE /{index}）からのHTTPリクエスト。

## 出力仕様

### 出力データ

| 項目名 | 型 | 説明 |
|--------|-----|------|
| acknowledged | boolean | クラスタ状態の更新が全ノードで承認されたか |

### 出力先

REST APIレスポンス（JSON形式）

## 処理フロー

### 処理シーケンス

```
1. REST APIリクエスト受信
   └─ DeleteIndexRequestの生成とバリデーション
2. 破壊的操作チェック（DestructiveOperations.failDestructive）
   └─ ワイルドカード「_all」等の危険な操作をチェック
3. クラスタブロックチェック
   └─ indicesAllowReleaseResources()によるチェック
4. インデックス名の具象解決
   └─ ワイルドカード展開、エイリアス解決
5. 具象インデックスが0件の場合は即座にacknowledged=trueを返却
6. DeleteIndexClusterStateUpdateRequestの構築
7. MetadataDeleteIndexService.deleteIndices()呼び出し
   └─ クラスタ状態の更新（インデックスメタデータの削除）
8. AcknowledgedResponseの返却
```

### フローチャート

```mermaid
flowchart TD
    A[REST API リクエスト受信] --> B[破壊的操作チェック]
    B -->|ワイルドカード禁止設定時| ERR1[IllegalArgumentException]
    B -->|OK| C[クラスタブロックチェック]
    C -->|ブロックあり| ERR2[ClusterBlockException]
    C -->|OK| D[インデックス名の具象解決]
    D --> E{具象インデックス 0件?}
    E -->|Yes| F[acknowledged=true 即座返却]
    E -->|No| G[DeleteIndexClusterStateUpdateRequest構築]
    G --> H[MetadataDeleteIndexService.deleteIndices]
    H --> I[AcknowledgedResponse返却]
```

## ビジネスルール

### 業務ルール

| ルールNo | ルール名 | 内容 | 適用条件 |
|---------|---------|------|---------|
| BR-01 | インデックス名必須 | インデックス名は空配列であってはならない | 常時 |
| BR-02 | 破壊的操作チェック | `action.destructive_requires_name`設定がtrueの場合、_allやワイルドカードのみの指定は拒否 | 設定有効時 |
| BR-03 | オープン/クローズ両方対象 | デフォルトでオープン・クローズ両方のインデックスが削除対象 | 常時 |
| BR-04 | 空結果の即座返却 | 解決後の具象インデックスが0件の場合はacknowledged=trueを即座に返却 | indicesOptionsで存在しないインデックスを許可している場合 |

### 計算ロジック

該当なし

## データベース操作仕様

### 操作別データベース影響一覧

| 操作 | 対象テーブル | 操作種別 | 概要 |
|-----|-------------|---------|------|
| インデックス削除 | ClusterState.metadata | DELETE | インデックスメタデータの削除 |
| インデックス削除 | ClusterState.routingTable | DELETE | シャードルーティング情報の削除 |

## エラー処理

### エラーケース一覧

| エラーコード | エラー種別 | 発生条件 | 対処方法 |
|------------|----------|---------|---------|
| 400 | ActionRequestValidationException | インデックス名が未指定 | インデックス名を指定する |
| 400 | IllegalArgumentException | 破壊的操作チェックに失敗 | 具体的なインデックス名を指定する |
| 404 | IndexNotFoundException | 指定インデックスが存在しない | インデックス名を確認する |
| 403 | ClusterBlockException | クラスタブロック中 | ブロック解除後に再実行 |

### リトライ仕様

TransportClusterManagerNodeActionの標準リトライ機構が適用される。

## トランザクション仕様

クラスタ状態の更新はアトミックに行われる。複数インデックスの削除は単一のクラスタ状態更新として実行される。

## パフォーマンス要件

大量のシャードを持つインデックスの削除は、クラスタ状態の更新サイズが大きくなるため時間がかかる場合がある。

## セキュリティ考慮事項

- `indices:admin/delete`アクション権限が必要
- 破壊的操作の安全チェック（DestructiveOperations）が適用される
- `action.destructive_requires_name`設定でワイルドカード削除を禁止可能

## 備考

- DeleteIndexActionのアクション名は`indices:admin/delete`
- IndicesOptionsのデフォルト設定: `fromOptions(false, true, true, true, false, false, true, false)` -- オープン・クローズ両方対象、存在しないインデックスは無視

---

## コードリーディングガイド

本機能を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: データ構造を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | DeleteIndexRequest.java | `server/src/main/java/org/opensearch/action/admin/indices/delete/DeleteIndexRequest.java` | 削除リクエスト。indices（String配列）とindicesOptions。IndicesRequest.Replaceableを実装 |
| 1-2 | DeleteIndexClusterStateUpdateRequest.java | `server/src/main/java/org/opensearch/action/admin/indices/delete/DeleteIndexClusterStateUpdateRequest.java` | クラスタ状態更新用リクエスト。Index配列を保持 |

**読解のコツ**: DeleteIndexRequestはIndicesRequest.Replaceableを実装しており、インデックス名を後から差し替え可能。IndicesOptionsのデフォルト値（59行目）が重要で、オープン・クローズ両方のインデックスを対象とする。

#### Step 2: エントリーポイントを理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | TransportDeleteIndexAction.java | `server/src/main/java/org/opensearch/action/admin/indices/delete/TransportDeleteIndexAction.java` | メインのトランスポートアクション |

**主要処理フロー**:
1. **109-112行目**: doExecute() -- 破壊的操作チェック後にスーパークラスの処理を呼び出し
2. **115-117行目**: checkBlock() -- indicesAllowReleaseResources()によるブロックチェック
3. **120-148行目**: clusterManagerOperation() -- メイン処理。具象インデックス解決、0件チェック、削除リクエスト構築、deleteIndices呼び出し
4. **125行目**: resolveIndices() -- インデックス名の具象解決
5. **131-133行目**: DeleteIndexClusterStateUpdateRequest構築
6. **135行目**: deleteIndexService.deleteIndices() -- 実際の削除処理

### プログラム呼び出し階層図

```
REST API (DELETE /{index})
    |
    +-- TransportDeleteIndexAction
          |
          +-- doExecute()
          |     +-- DestructiveOperations.failDestructive() -- 破壊的操作チェック
          |
          +-- checkBlock() -- クラスタブロックチェック
          |
          +-- clusterManagerOperation()
                |
                +-- resolveIndices() -- インデックス名の具象解決
                |
                +-- MetadataDeleteIndexService.deleteIndices()
                      |
                      +-- クラスタ状態更新（メタデータ・ルーティング削除）
```

### データフロー図

```
[入力]                          [処理]                              [出力]

DeleteIndexRequest -------> TransportDeleteIndexAction -------> AcknowledgedResponse
 (indices[],                 |                                   (acknowledged)
  indicesOptions)            +-> failDestructive()
                             +-> concreteIndexNames()
                             +-> MetadataDeleteIndexService.deleteIndices()
                                  |
                                  +-> ClusterState更新
                                       (IndexMetadata削除,
                                        RoutingTable削除)
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| DeleteIndexAction.java | `server/src/main/java/org/opensearch/action/admin/indices/delete/DeleteIndexAction.java` | ソース | アクション型定義 |
| DeleteIndexRequest.java | `server/src/main/java/org/opensearch/action/admin/indices/delete/DeleteIndexRequest.java` | ソース | リクエストデータ構造 |
| DeleteIndexRequestBuilder.java | `server/src/main/java/org/opensearch/action/admin/indices/delete/DeleteIndexRequestBuilder.java` | ソース | リクエストビルダー |
| DeleteIndexClusterStateUpdateRequest.java | `server/src/main/java/org/opensearch/action/admin/indices/delete/DeleteIndexClusterStateUpdateRequest.java` | ソース | クラスタ状態更新リクエスト |
| TransportDeleteIndexAction.java | `server/src/main/java/org/opensearch/action/admin/indices/delete/TransportDeleteIndexAction.java` | ソース | トランスポートアクション |
| MetadataDeleteIndexService.java | `server/src/main/java/org/opensearch/cluster/metadata/MetadataDeleteIndexService.java` | ソース | 削除処理の実体 |
| DestructiveOperations.java | `server/src/main/java/org/opensearch/action/support/DestructiveOperations.java` | ソース | 破壊的操作チェック |
