# 機能設計書 3-インデックスオープン/クローズ

## 概要

本ドキュメントは、OpenSearchにおけるインデックスのオープン/クローズ機能の設計を記述する。インデックスの開閉を制御し、クローズ中はリソース消費を抑制する。

### 本機能の処理概要

インデックスオープン/クローズ機能は、インデックスの状態をオープン（読み書き可能）またはクローズ（読み書き不可だがメタデータは保持）に切り替える。クローズ状態のインデックスはシャードのリソースを解放し、ディスク容量以外のクラスタリソース消費を抑制する。

**業務上の目的・背景**：古い時系列インデックスを完全に削除せずにリソース消費を削減したい場合に使用する。データを保持しつつ、検索対象から外すことでクラスタの負荷を軽減できる。

**機能の利用シーン**：過去の月次/年次インデックスをクローズして検索負荷を軽減する場合、メンテナンス時に一時的にインデックスをクローズする場合、クローズしたインデックスを再度オープンして検索可能にする場合。

**主要な処理内容**：
1. REST APIからのリクエスト受信と破壊的操作チェック
2. クラスタブロックチェック（METADATA_WRITE）
3. インデックス名の具象解決
4. MetadataIndexStateServiceを介した状態変更
5. クローズ時：各シャードへのVerifyShardBeforeCloseアクション実行
6. オープン時：シャードのアロケーションとアクティブシャード待機

**関連システム・外部連携**：リモートストアマイグレーション中（MIXED互換モードかつREMOTE_STORE方向）はクローズが禁止される。クローズはクラスタ設定`cluster.indices.close.enable`で無効化可能。

**権限による制御**：オープンは`indices:admin/open`、クローズは`indices:admin/close`アクション権限が必要。

## 関連画面

| 画面No | 画面名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| 42 | インデックスオープン | 主画面 | インデックスをオープンして検索・書き込み可能にする処理 |
| 43 | インデックスクローズ | 主画面 | インデックスをクローズしてリソース消費を抑制する処理 |

## 機能種別

CRUD操作（Update）/ クラスタ状態管理

## 入力仕様

### 入力パラメータ

| パラメータ名 | 型 | 必須 | 説明 | バリデーション |
|-------------|-----|-----|------|---------------|
| indices | String[] | Yes | 対象インデックス名（ワイルドカード可） | 空配列でないこと |
| wait_for_active_shards | ActiveShardCount | No | オープン時のアクティブシャード待機数 | デフォルトDEFAULT |
| timeout | TimeValue | No | Ack待機タイムアウト | デフォルト30秒 |
| cluster_manager_timeout | TimeValue | No | クラスタマネージャノード待機タイムアウト | デフォルト30秒 |

### 入力データソース

REST API（POST /{index}/_open, POST /{index}/_close）からのHTTPリクエスト。

## 出力仕様

### 出力データ

| 項目名 | 型 | 説明 |
|--------|-----|------|
| acknowledged | boolean | クラスタ状態の更新が承認されたか |
| shards_acknowledged | boolean | （オープン時のみ）必要なアクティブシャード数が開始されたか |

### 出力先

REST APIレスポンス（JSON形式）

## 処理フロー

### 処理シーケンス

```
1. REST APIリクエスト受信
   └─ OpenIndexRequest/CloseIndexRequestの生成
2. 破壊的操作チェック
   └─ DestructiveOperations.failDestructive()
3. （クローズのみ）closeIndexEnabled設定チェック
   └─ cluster.indices.close.enableがfalseの場合は拒否
4. （クローズのみ）リモートマイグレーション検証
   └─ MIXEDモードかつREMOTE_STORE方向の場合は拒否
5. クラスタブロックチェック
   └─ METADATA_WRITEレベルのブロックチェック
6. インデックス名の具象解決
7. 具象インデックスが0件の場合は即座返却
8. MetadataIndexStateService.openIndex()/closeIndices()呼び出し
9. レスポンス返却
```

### フローチャート

```mermaid
flowchart TD
    A[REST API リクエスト受信] --> B{オープン or クローズ?}
    B -->|クローズ| C1[closeIndexEnabled チェック]
    C1 -->|disabled| ERR1[IllegalStateException]
    C1 -->|enabled| C2[リモートマイグレーション検証]
    C2 -->|MIXED + REMOTE_STORE| ERR2[IllegalStateException]
    C2 -->|OK| D[破壊的操作チェック]
    B -->|オープン| D
    D --> E[クラスタブロックチェック]
    E --> F[インデックス名の具象解決]
    F --> G{具象インデックス 0件?}
    G -->|Yes| H1[即座に成功返却]
    G -->|No| H2[MetadataIndexStateService呼び出し]
    H2 --> I[レスポンス返却]
```

## ビジネスルール

### 業務ルール

| ルールNo | ルール名 | 内容 | 適用条件 |
|---------|---------|------|---------|
| BR-01 | クローズ無効化設定 | `cluster.indices.close.enable`がfalseの場合クローズは拒否 | クローズ操作時 |
| BR-02 | リモートマイグレーション制限 | MIXEDモードかつREMOTE_STORE方向のマイグレーション中はクローズ不可 | クローズ操作時 |
| BR-03 | 破壊的操作チェック | ワイルドカード「_all」等の危険な操作をチェック | 常時 |

### 計算ロジック

該当なし

## データベース操作仕様

### 操作別データベース影響一覧

| 操作 | 対象テーブル | 操作種別 | 概要 |
|-----|-------------|---------|------|
| オープン/クローズ | ClusterState.metadata | UPDATE | インデックス状態（State.OPEN/State.CLOSE）の変更 |
| オープン/クローズ | ClusterState.routingTable | UPDATE | シャードルーティング情報の更新 |

## エラー処理

### エラーケース一覧

| エラーコード | エラー種別 | 発生条件 | 対処方法 |
|------------|----------|---------|---------|
| 400 | IllegalStateException | cluster.indices.close.enableがfalse | 設定をtrueに変更 |
| 400 | IllegalStateException | リモートマイグレーション中のクローズ | マイグレーション完了後に再実行 |
| 403 | ClusterBlockException | クラスタブロック中 | ブロック解除後に再実行 |

### リトライ仕様

TransportClusterManagerNodeActionの標準リトライ機構が適用される。

## トランザクション仕様

クラスタ状態の更新はアトミックに行われる。クローズ時はVerifyShardBeforeCloseアクションにより全シャードの整合性を確認した上で状態変更が行われる。

## パフォーマンス要件

クローズ操作はシャードへのVerifyShardBeforeCloseアクション実行を伴うため、シャード数に比例して処理時間が増加する。

## セキュリティ考慮事項

- オープン：`indices:admin/open`アクション権限が必要
- クローズ：`indices:admin/close`アクション権限が必要
- 破壊的操作の安全チェックが適用される

## 備考

- クローズされたインデックスはディスク容量は消費するが、メモリやCPUリソースは解放される
- CLUSTER_INDICES_CLOSE_ENABLE_SETTINGは動的設定（Dynamic）でありNodeスコープ
- クローズ時にはVerifyShardBeforeCloseアクション（TransportVerifyShardBeforeCloseAction）が各シャードで実行される

---

## コードリーディングガイド

本機能を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: データ構造を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | OpenIndexRequest.java | `server/src/main/java/org/opensearch/action/admin/indices/open/OpenIndexRequest.java` | オープンリクエスト。indices, waitForActiveShards |
| 1-2 | CloseIndexRequest.java | `server/src/main/java/org/opensearch/action/admin/indices/close/CloseIndexRequest.java` | クローズリクエスト。indices, waitForActiveShards |
| 1-3 | CloseIndexResponse.java | `server/src/main/java/org/opensearch/action/admin/indices/close/CloseIndexResponse.java` | クローズレスポンス。個別シャードの結果も含む |

#### Step 2: エントリーポイントを理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | TransportOpenIndexAction.java | `server/src/main/java/org/opensearch/action/admin/indices/open/TransportOpenIndexAction.java` | オープン処理のメインロジック |
| 2-2 | TransportCloseIndexAction.java | `server/src/main/java/org/opensearch/action/admin/indices/close/TransportCloseIndexAction.java` | クローズ処理のメインロジック |

**主要処理フロー（クローズ）**:
- **81-86行目**: CLUSTER_INDICES_CLOSE_ENABLE_SETTING定義
- **131-142行目**: doExecute() -- 破壊的操作チェック、closeIndexEnabledチェック、リモートマイグレーション検証
- **160-182行目**: clusterManagerOperation(Task) -- メイン処理
- **197-204行目**: validateRemoteMigration() -- リモートマイグレーション検証

**主要処理フロー（オープン）**:
- **109-112行目**: doExecute() -- 破壊的操作チェック
- **121-149行目**: clusterManagerOperation() -- メイン処理

### プログラム呼び出し階層図

```
REST API (POST /{index}/_open or _close)
    |
    +-- TransportOpenIndexAction / TransportCloseIndexAction
          |
          +-- doExecute()
          |     +-- DestructiveOperations.failDestructive()
          |     +-- (Close) closeIndexEnabled チェック
          |     +-- (Close) validateRemoteMigration()
          |
          +-- checkBlock() -- METADATA_WRITE ブロックチェック
          |
          +-- clusterManagerOperation()
                |
                +-- resolveIndices() -- 具象インデックス解決
                |
                +-- MetadataIndexStateService
                      +-- openIndex() / closeIndices()
                            |
                            +-- (Close) TransportVerifyShardBeforeCloseAction
```

### データフロー図

```
[入力]                          [処理]                              [出力]

OpenIndexRequest /           TransportOpen/CloseIndexAction     OpenIndexResponse /
CloseIndexRequest --------> |                                   CloseIndexResponse
 (indices[],                 +-> failDestructive()               (acknowledged,
  waitForActiveShards)       +-> closeIndexEnabled check          shards_acknowledged)
                             +-> validateRemoteMigration()
                             +-> MetadataIndexStateService
                                  +-> openIndex() / closeIndices()
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| OpenIndexAction.java | `server/src/main/java/org/opensearch/action/admin/indices/open/OpenIndexAction.java` | ソース | オープンアクション定義 |
| OpenIndexRequest.java | `server/src/main/java/org/opensearch/action/admin/indices/open/OpenIndexRequest.java` | ソース | オープンリクエスト |
| OpenIndexResponse.java | `server/src/main/java/org/opensearch/action/admin/indices/open/OpenIndexResponse.java` | ソース | オープンレスポンス |
| TransportOpenIndexAction.java | `server/src/main/java/org/opensearch/action/admin/indices/open/TransportOpenIndexAction.java` | ソース | オープントランスポートアクション |
| CloseIndexAction.java | `server/src/main/java/org/opensearch/action/admin/indices/close/CloseIndexAction.java` | ソース | クローズアクション定義 |
| CloseIndexRequest.java | `server/src/main/java/org/opensearch/action/admin/indices/close/CloseIndexRequest.java` | ソース | クローズリクエスト |
| CloseIndexResponse.java | `server/src/main/java/org/opensearch/action/admin/indices/close/CloseIndexResponse.java` | ソース | クローズレスポンス |
| TransportCloseIndexAction.java | `server/src/main/java/org/opensearch/action/admin/indices/close/TransportCloseIndexAction.java` | ソース | クローズトランスポートアクション |
| TransportVerifyShardBeforeCloseAction.java | `server/src/main/java/org/opensearch/action/admin/indices/close/TransportVerifyShardBeforeCloseAction.java` | ソース | クローズ前のシャード検証 |
| MetadataIndexStateService.java | `server/src/main/java/org/opensearch/cluster/metadata/MetadataIndexStateService.java` | ソース | インデックス状態変更ロジック |
