# 機能設計書 34-Matrix Stats集計

## 概要

本ドキュメントは、OpenSearchのMatrix Stats集計機能の設計を記述する。Matrix Stats集計は、複数の数値フィールドに対して行列形式の統計量（相関行列、共分散行列等）を一度に算出する集計機能である。

### 本機能の処理概要

Matrix Stats集計は、複数のフィールドを同時に対象とし、各フィールド間の相関係数、共分散、分散、平均値、カウント等の統計量を行列形式で算出する。ArrayValuesSourceを使用して複数フィールドの値を同時に収集する点が他のメトリクス集計と異なる。

**業務上の目的・背景**：複数の数値変数間の関係性を分析する多変量統計のニーズに対応する。フィールド間の相関関係を把握することで、データの傾向やパターンを理解するために利用される。

**機能の利用シーン**：検索APIのaggregationsパラメータ内でmatrix_statsタイプを指定し、fieldsに複数のフィールド名を列挙して利用する。

**主要な処理内容**：
1. 検索リクエストからmatrix_stats集計定義をパース
2. ArrayValuesSourceConfigで複数フィールドのデータソースを構成
3. MatrixStatsAggregatorでセグメント単位に統計量を収集
4. RunningStatsオブジェクトで中間統計量を管理
5. reduce時にRunningStats.mergeで各シャード結果を統合
6. 最終的な相関行列・共分散行列等を算出して返却

**関連システム・外部連携**：LuceneのDocValues。モジュール（aggs-matrix-stats）として提供。

**権限による制御**：インデックスの読み取り権限が必要。

## 関連画面

| 画面No | 画面名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| 21 | 検索 | 補助機能 | 検索結果に対するMatrix Stats集計処理 |

## 機能種別

計算処理（集計・分析）

## 入力仕様

### 入力パラメータ

| パラメータ名 | 型 | 必須 | 説明 | バリデーション |
|-------------|-----|-----|------|---------------|
| fields | String[] | Yes | 集計対象フィールド名の配列 | 数値型フィールドであること |
| missing | Map | No | フィールドごとの欠損値代替 | フィールド型と互換 |
| mode | String | No | 多値フィールドの集計モード（デフォルトAVG） | AVG, MIN, MAX, SUM, MEDIAN |

### 入力データソース

検索APIリクエストのaggregationsセクション。LuceneインデックスのDocValuesから複数フィールドの数値を取得。

## 出力仕様

### 出力データ

| 項目名 | 型 | 説明 |
|--------|-----|------|
| doc_count | Long | 対象ドキュメント数 |
| fields | Array | フィールドごとの統計情報配列 |
| fields[].name | String | フィールド名 |
| fields[].count | Long | 有効値のドキュメント数 |
| fields[].mean | Double | 平均値 |
| fields[].variance | Double | 分散 |
| fields[].skewness | Double | 歪度 |
| fields[].kurtosis | Double | 尖度 |
| fields[].covariance | Map | 他フィールドとの共分散 |
| fields[].correlation | Map | 他フィールドとの相関係数 |

### 出力先

検索APIレスポンスのaggregationsフィールド内にJSON形式で返却。

## 処理フロー

### 処理シーケンス

```
1. 検索リクエスト受信
   └─ matrix_stats集計定義をパース
2. ArrayValuesSourceConfigの構成
   └─ 複数フィールドのValuesSourceを同時に構成
3. MatrixStatsAggregatorの生成
   └─ RunningStatsオブジェクトを初期化
4. セグメント単位のデータ収集
   └─ 各ドキュメントの複数フィールド値をRunningStatsに追加
5. 部分結果の構築
   └─ InternalMatrixStatsとしてRunningStatsをシリアライズ
6. reduce処理
   └─ RunningStats.mergeで各シャードの統計を結合
7. 最終統計量算出
   └─ 相関係数、共分散、分散、歪度、尖度を算出
```

### フローチャート

```mermaid
flowchart TD
    A[検索リクエスト受信] --> B[MatrixStatsAggregationBuilderパース]
    B --> C[ArrayValuesSourceConfig構成]
    C --> D[MatrixStatsAggregator生成]
    D --> E[RunningStats初期化]
    E --> F[セグメント単位でデータ収集]
    F --> G[各フィールド値をRunningStatsに追加]
    G --> H[InternalMatrixStats構築]
    H --> I[reduce: RunningStats.merge]
    I --> J[最終統計量算出・返却]
```

## ビジネスルール

### 業務ルール

| ルールNo | ルール名 | 内容 | 適用条件 |
|---------|---------|------|---------|
| BR-34-01 | 複数フィールド必須 | fieldsに2つ以上のフィールドを指定することが推奨 | matrix_stats集計 |
| BR-34-02 | MultiValueMode | 多値フィールドのモードデフォルトはAVG | 多値フィールド |
| BR-34-03 | LeafOnly制約 | サブ集計を持てない | matrix_stats集計 |
| BR-34-04 | ストリーミング統計 | RunningStatsでオンライン統計量計算を実行 | 全ドキュメント |

### 計算ロジック

- **相関係数**: correlation(X,Y) = covariance(X,Y) / (std_dev(X) * std_dev(Y))
- **共分散**: Welfordのオンラインアルゴリズムで逐次計算
- **歪度・尖度**: 高次モーメントのストリーミング計算

## データベース操作仕様

### 操作別データベース影響一覧

| 操作 | 対象テーブル | 操作種別 | 概要 |
|-----|-------------|---------|------|
| Matrix Stats集計 | Luceneインデックス | SELECT（読取） | 複数フィールドのDocValuesから値を読取 |

### テーブル別操作詳細

#### Luceneインデックス

| 操作 | 項目（カラム名） | 更新値・取得条件 | 備考 |
|-----|-----------------|-----------------|------|
| SELECT | fieldsで指定された各数値フィールド | 検索クエリでフィルタされたドキュメント | ArrayValuesSource経由 |

## エラー処理

### エラーケース一覧

| エラーコード | エラー種別 | 発生条件 | 対処方法 |
|------------|----------|---------|---------|
| 400 | illegal_argument_exception | fieldsが未指定 | fieldsにフィールド名を指定 |
| 400 | illegal_argument_exception | 非数値フィールドの指定 | 数値型フィールドを指定 |

### リトライ仕様

読み取り専用操作のため、クライアント側でのリトライが可能。

## トランザクション仕様

読み取り専用操作のためトランザクション制御は不要。

## パフォーマンス要件

- フィールド数の二乗に比例した計算量（共分散・相関行列の算出）
- RunningStatsのmerge操作はO(fields^2)

## セキュリティ考慮事項

- インデックスの読み取り権限が必要
- フィールドレベルセキュリティの対象

## 備考

- aggs-matrix-statsモジュールとして提供される独立モジュール
- MatrixAggregationModulePluginで集計タイプが登録される
- MatrixStatsNamedXContentProviderがXContentパーサを提供

---

## コードリーディングガイド

本機能を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: データ構造を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | RunningStats.java | `modules/aggs-matrix-stats/src/main/java/org/opensearch/search/aggregations/matrix/stats/RunningStats.java` | 中間統計量管理。fieldCount, fieldSum, fieldSumOfSqrs等のMapを保持 |
| 1-2 | MatrixStats.java | `modules/aggs-matrix-stats/src/main/java/org/opensearch/search/aggregations/matrix/stats/MatrixStats.java` | 結果インターフェース。getCorrelation, getCovarianceメソッド |

**読解のコツ**: RunningStatsはWelfordのオンラインアルゴリズムを使用してストリーミング方式で統計量を計算する。merge()メソッドがシャード間統合の核心。

#### Step 2: エントリーポイントを理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | MatrixStatsAggregationBuilder.java | `modules/aggs-matrix-stats/src/main/java/org/opensearch/search/aggregations/matrix/stats/MatrixStatsAggregationBuilder.java` | ビルダークラス。NAME = "matrix_stats"、MultiValueMode設定 |
| 2-2 | MatrixAggregationModulePlugin.java | `modules/aggs-matrix-stats/src/main/java/org/opensearch/search/aggregations/matrix/MatrixAggregationModulePlugin.java` | モジュールプラグイン登録 |

**主要処理フロー**:
- **51行目**: MatrixStatsAggregationBuilderクラス定義。ArrayValuesSourceAggregationBuilder.LeafOnlyを継承
- **52行目**: NAME = "matrix_stats"
- **54行目**: multiValueMode = MultiValueMode.AVG（デフォルト）

#### Step 3: 集計実行ロジックを理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | MatrixStatsAggregator.java | `modules/aggs-matrix-stats/src/main/java/org/opensearch/search/aggregations/matrix/stats/MatrixStatsAggregator.java` | 集計実行ロジック。RunningStatsへのデータ追加 |
| 3-2 | ArrayValuesSource.java | `modules/aggs-matrix-stats/src/main/java/org/opensearch/search/aggregations/support/ArrayValuesSource.java` | 複数フィールドの値ソース |

### プログラム呼び出し階層図

```
MatrixAggregationModulePlugin (モジュール登録)
    |
    +-- MatrixStatsAggregationBuilder.build()
          |
          +-- MatrixStatsAggregatorFactory.create()
                |
                +-- MatrixStatsAggregator()
                      |
                      +-- getLeafCollector()
                      |     +-- ArrayValuesSource.Numeric.getField()
                      |     +-- RunningStats.add()
                      |
                      +-- buildAggregation()
                            +-- InternalMatrixStats(RunningStats)
                                  |
                                  +-- reduce() -> RunningStats.merge()
```

### データフロー図

```
[入力]                    [処理]                           [出力]

検索リクエスト       +--> MatrixStatsAggregationBuilder
(fields: [f1, f2])   |
                     +--> ArrayValuesSourceConfig構成
                     |
Luceneセグメント     +--> MatrixStatsAggregator
(f1, f2のDocValues)  |     +-- RunningStats.add(fieldValues)
                     |     +-- 逐次統計量更新
                     |
                     +--> InternalMatrixStats構築    +--> 検索レスポンス
                     |                                    (correlation, covariance等)
                     +--> reduce: RunningStats.merge()
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| MatrixStatsAggregationBuilder.java | `modules/aggs-matrix-stats/src/main/java/org/opensearch/search/aggregations/matrix/stats/MatrixStatsAggregationBuilder.java` | ソース | ビルダー |
| MatrixStatsAggregator.java | `modules/aggs-matrix-stats/src/main/java/org/opensearch/search/aggregations/matrix/stats/MatrixStatsAggregator.java` | ソース | 集計実行 |
| RunningStats.java | `modules/aggs-matrix-stats/src/main/java/org/opensearch/search/aggregations/matrix/stats/RunningStats.java` | ソース | 中間統計量管理 |
| MatrixStats.java | `modules/aggs-matrix-stats/src/main/java/org/opensearch/search/aggregations/matrix/stats/MatrixStats.java` | ソース | 結果インターフェース |
| MatrixStatsParser.java | `modules/aggs-matrix-stats/src/main/java/org/opensearch/search/aggregations/matrix/stats/MatrixStatsParser.java` | ソース | パーサ |
| ParsedMatrixStats.java | `modules/aggs-matrix-stats/src/main/java/org/opensearch/search/aggregations/matrix/stats/ParsedMatrixStats.java` | ソース | パース済み結果 |
| MatrixAggregationModulePlugin.java | `modules/aggs-matrix-stats/src/main/java/org/opensearch/search/aggregations/matrix/MatrixAggregationModulePlugin.java` | ソース | モジュールプラグイン |
| ArrayValuesSource.java | `modules/aggs-matrix-stats/src/main/java/org/opensearch/search/aggregations/support/ArrayValuesSource.java` | ソース | 複数フィールド値ソース |
| ArrayValuesSourceAggregationBuilder.java | `modules/aggs-matrix-stats/src/main/java/org/opensearch/search/aggregations/support/ArrayValuesSourceAggregationBuilder.java` | ソース | 配列値ソースビルダー基底 |
| MatrixStatsAggregationBuilders.java | `modules/aggs-matrix-stats/src/main/java/org/opensearch/search/aggregations/MatrixStatsAggregationBuilders.java` | ソース | ビルダーヘルパー |
