# 機能設計書 4-インデックスエイリアス

## 概要

本ドキュメントは、OpenSearchにおけるインデックスエイリアス機能の設計を記述する。インデックスに対して別名（エイリアス）を付与・管理する機能である。

### 本機能の処理概要

インデックスエイリアス機能は、1つまたは複数のインデックスに対してエイリアス（別名）を付与し、エイリアスを通じてインデックスにアクセスする仕組みを提供する。エイリアスの追加（ADD）、削除（REMOVE）、インデックス自体の削除（REMOVE_INDEX）を一括で実行できる。

**業務上の目的・背景**：エイリアスを使用することで、アプリケーションはインデックス名の変更（ロールオーバー等）を意識せずに一貫した名前でデータにアクセスできる。フィルタ付きエイリアスにより、データのサブセットに対するビューを作成可能。

**機能の利用シーン**：時系列インデックスのロールオーバー時のエイリアス切り替え、複数インデックスを統合した検索用エイリアスの作成、書き込み先インデックスの指定（write index）、フィルタ付きエイリアスによるデータアクセス制御。

**主要な処理内容**：
1. REST APIからのリクエスト受信とバリデーション
2. AliasActionsの解決（インデックス名の具象化、ワイルドカード展開）
3. データストリームのバッキングインデックスへのエイリアス付与の禁止チェック
4. MetadataIndexAliasesServiceを介したクラスタ状態更新
5. エイリアスメタデータの追加/削除

**関連システム・外部連携**：ロールオーバー機能はエイリアスの切り替えに依存する。インデックス解決時にエイリアスが透過的に使用される。

**権限による制御**：`indices:admin/aliases`アクションに対する権限が必要。REMOVE_INDEXアクションの場合は`indices:admin/delete`権限も必要。

## 関連画面

| 画面No | 画面名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| 49 | インデックス解決 | 主画面 | 一致するインデックス・エイリアス・データストリーム情報を返す処理 |
| 56 | エイリアス取得 | 主画面 | エイリアスの情報を返す処理 |
| 57 | エイリアス作成・更新 | 主画面 | エイリアスを作成または更新する処理 |
| 58 | エイリアス削除 | 主画面 | エイリアスを削除する処理 |
| 59 | エイリアス存在確認 | 主画面 | エイリアスが存在するかを確認する処理 |
| 60 | エイリアス一括更新 | 主画面 | インデックスエイリアスを一括で更新する処理 |
| 146 | Cat エイリアス | 参照画面 | 設定済みエイリアス情報をテーブル形式で表示する処理 |

## 機能種別

CRUD操作（Create/Delete）/ クラスタ状態管理

## 入力仕様

### 入力パラメータ

| パラメータ名 | 型 | 必須 | 説明 | バリデーション |
|-------------|-----|-----|------|---------------|
| actions | List\<AliasActions\> | Yes | エイリアス操作のリスト | 空でないこと |
| AliasActions.type | ActionType | Yes | ADD / REMOVE / REMOVE_INDEX | 有効なアクションタイプ |
| AliasActions.indices | String[] | Yes | 対象インデックス名 | ワイルドカード使用可 |
| AliasActions.aliases | String[] | Conditional | エイリアス名（ADD/REMOVEで必須） | - |
| AliasActions.filter | String | No | フィルタクエリ（ADDのみ） | JSON形式のクエリ |
| AliasActions.routing | String | No | ルーティング値 | - |
| AliasActions.searchRouting | String | No | 検索時ルーティング | - |
| AliasActions.indexRouting | String | No | インデックス時ルーティング | - |
| AliasActions.writeIndex | Boolean | No | 書き込みインデックスフラグ | - |
| AliasActions.isHidden | Boolean | No | 隠しエイリアスフラグ | - |
| AliasActions.mustExist | Boolean | No | エイリアスが存在する必要があるか（REMOVEのみ） | - |
| timeout | TimeValue | No | Ack待機タイムアウト | デフォルト30秒 |

### 入力データソース

REST API（POST /_aliases）からのHTTPリクエスト。

## 出力仕様

### 出力データ

| 項目名 | 型 | 説明 |
|--------|-----|------|
| acknowledged | boolean | クラスタ状態の更新が承認されたか |

### 出力先

REST APIレスポンス（JSON形式）

## 処理フロー

### 処理シーケンス

```
1. REST APIリクエスト受信
   └─ IndicesAliasesRequestの生成
2. クラスタブロックチェック
   └─ リモートスナップショットブロックのチェック
3. AliasActionsの解決
   └─ インデックス名の具象化、ワイルドカード展開
4. データストリームバッキングインデックスチェック
   └─ バッキングインデックスへのエイリアス付与は拒否
5. RequestValidatorsによるバリデーション
6. 具象AliasAction（Add/Remove/RemoveIndex）の構築
7. IndicesAliasesClusterStateUpdateRequestの作成
8. MetadataIndexAliasesService.indicesAliases()呼び出し
9. AcknowledgedResponseの返却
```

### フローチャート

```mermaid
flowchart TD
    A[REST API リクエスト受信] --> B[クラスタブロックチェック]
    B --> C[AliasActions解決]
    C --> D{データストリームバッキングインデックス?}
    D -->|Yes| ERR[IllegalArgumentException]
    D -->|No| E[RequestValidators バリデーション]
    E --> F[具象AliasAction構築]
    F --> G{最終アクション空 かつ 元アクション非空?}
    G -->|Yes| ERR2[AliasesNotFoundException]
    G -->|No| H[MetadataIndexAliasesService.indicesAliases]
    H --> I[AcknowledgedResponse返却]
```

## ビジネスルール

### 業務ルール

| ルールNo | ルール名 | 内容 | 適用条件 |
|---------|---------|------|---------|
| BR-01 | データストリーム制限 | データストリームのバッキングインデックスにはエイリアスを付与できない | ADD操作時 |
| BR-02 | REMOVE時のワイルドカード展開 | REMOVE操作ではエイリアス名のワイルドカードが展開される | REMOVE操作時 |
| BR-03 | mustExist制御 | mustExist=trueの場合、存在しないエイリアスの削除はAliasesNotFoundExceptionをスロー | REMOVE操作時 |
| BR-04 | 空結果のエラー | 解決後のアクションが空で元のアクションが空でない場合はAliasesNotFoundException | 常時 |

### 計算ロジック

該当なし

## データベース操作仕様

### 操作別データベース影響一覧

| 操作 | 対象テーブル | 操作種別 | 概要 |
|-----|-------------|---------|------|
| ADD | ClusterState.metadata.IndexMetadata.aliases | INSERT/UPDATE | エイリアスメタデータの追加 |
| REMOVE | ClusterState.metadata.IndexMetadata.aliases | DELETE | エイリアスメタデータの削除 |
| REMOVE_INDEX | ClusterState.metadata | DELETE | インデックス全体の削除 |

## エラー処理

### エラーケース一覧

| エラーコード | エラー種別 | 発生条件 | 対処方法 |
|------------|----------|---------|---------|
| 400 | IllegalArgumentException | データストリームバッキングインデックスへのエイリアス付与 | 直接インデックスを指定しない |
| 404 | AliasesNotFoundException | 指定エイリアスが存在しない | エイリアス名を確認 |
| 403 | ClusterBlockException | クラスタブロック中 | ブロック解除後に再実行 |

### リトライ仕様

TransportClusterManagerNodeActionの標準リトライ機構が適用される。

## トランザクション仕様

全てのエイリアス操作は単一のクラスタ状態更新としてアトミックに実行される。

## パフォーマンス要件

エイリアス操作はクラスタ状態の更新を伴うため、大量のエイリアスを同時に操作する場合はクラスタマネージャの負荷を考慮する必要がある。

## セキュリティ考慮事項

- `indices:admin/aliases`アクション権限が必要
- REMOVE_INDEXの場合は`indices:admin/delete`権限も必要
- フィルタ付きエイリアスによるデータアクセス制御が可能

## 備考

- IndicesAliasesActionのアクション名は`indices:admin/aliases`
- AliasActionsにはADD、REMOVE、REMOVE_INDEXの3種類がある
- REMOVE_INDEXはエイリアスではなくインデックス自体を削除するアクション

---

## コードリーディングガイド

本機能を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: データ構造を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | IndicesAliasesRequest.java | `server/src/main/java/org/opensearch/action/admin/indices/alias/IndicesAliasesRequest.java` | リクエスト構造。AliasActionsのリスト。AliasActions内部クラスの構造が重要 |
| 1-2 | Alias.java | `server/src/main/java/org/opensearch/action/admin/indices/alias/Alias.java` | エイリアスの定義。name, filter, routing, writeIndex, isHidden |

#### Step 2: エントリーポイントを理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | TransportIndicesAliasesAction.java | `server/src/main/java/org/opensearch/action/admin/indices/alias/TransportIndicesAliasesAction.java` | メインの処理ロジック |

**主要処理フロー**:
- **127-133行目**: checkBlock() -- リモートスナップショットブロックチェック
- **136-167行目**: clusterManagerOperation() -- メイン処理
- **144行目**: resolvedAliasActions() -- AliasActionsの解決
- **151行目**: IndicesAliasesClusterStateUpdateRequest構築
- **155行目**: indexAliasesService.indicesAliases() -- 実際の更新
- **206-272行目**: resolvedAliasActions() -- 具象AliasActionの構築ロジック

### プログラム呼び出し階層図

```
REST API (POST /_aliases)
    |
    +-- TransportIndicesAliasesAction
          |
          +-- checkBlock() -- リモートスナップショットブロックチェック
          |
          +-- clusterManagerOperation()
                |
                +-- resolvedAliasActions() -- AliasActions解決
                |     +-- concreteResolvedIndices() -- インデックス具象化
                |     +-- データストリームチェック
                |     +-- requestValidators.validateRequest()
                |     +-- AliasAction.Add/Remove/RemoveIndex構築
                |
                +-- MetadataIndexAliasesService.indicesAliases()
                      +-- クラスタ状態更新
```

### データフロー図

```
[入力]                          [処理]                              [出力]

IndicesAliasesRequest -----> TransportIndicesAliasesAction ----> AcknowledgedResponse
 (AliasActions[]:             |                                  (acknowledged)
   ADD/REMOVE/REMOVE_INDEX,   +-> resolvedAliasActions()
   indices, aliases,           +-> IndicesAliasesClusterStateUpdateRequest
   filter, routing)            +-> MetadataIndexAliasesService.indicesAliases()
                                    |
                                    +-> ClusterState更新
                                         (AliasMetadata追加/削除)
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| IndicesAliasesAction.java | `server/src/main/java/org/opensearch/action/admin/indices/alias/IndicesAliasesAction.java` | ソース | アクション型定義 |
| IndicesAliasesRequest.java | `server/src/main/java/org/opensearch/action/admin/indices/alias/IndicesAliasesRequest.java` | ソース | リクエスト構造 |
| Alias.java | `server/src/main/java/org/opensearch/action/admin/indices/alias/Alias.java` | ソース | エイリアス定義 |
| TransportIndicesAliasesAction.java | `server/src/main/java/org/opensearch/action/admin/indices/alias/TransportIndicesAliasesAction.java` | ソース | トランスポートアクション |
| MetadataIndexAliasesService.java | `server/src/main/java/org/opensearch/cluster/metadata/MetadataIndexAliasesService.java` | ソース | エイリアス更新ロジック |
| AliasAction.java | `server/src/main/java/org/opensearch/cluster/metadata/AliasAction.java` | ソース | エイリアスアクション定義（Add, Remove, RemoveIndex） |
