# 機能設計書 46-検索パイプライン共通プロセッサ

## 概要

本ドキュメントは、検索パイプラインで使用される共通プロセッサ群（search-pipeline-commonモジュール）の機能設計書である。

### 本機能の処理概要

**業務上の目的・背景**：検索パイプラインにおいて、フィルタクエリの追加、レスポンスフィールドの変更、結果のソート・トリミングなど、汎用的な検索前処理・後処理を標準プロセッサとして提供する必要がある。本モジュールはこれらの共通プロセッサをプラグインとして一括提供する。

**機能の利用シーン**：検索パイプラインの構築において、カスタムプロセッサを開発することなく標準的な検索処理の加工を行う場面で利用される。

**主要な処理内容**：
1. リクエストプロセッサ群：FilterQueryRequestProcessor、ScriptRequestProcessor、OversampleRequestProcessor、HierarchicalRoutingSearchProcessor、TemporalRoutingSearchProcessor、AclRoutingSearchProcessor
2. レスポンスプロセッサ群：RenameFieldResponseProcessor、TruncateHitsResponseProcessor、CollapseResponseProcessor、SplitResponseProcessor、SortResponseProcessor

**関連システム・外部連携**：SearchPipelinePluginインターフェースを実装し、SearchPipelineServiceに登録される。

**権限による制御**：各プロセッサの許可リストをノード設定で制御可能（search.pipeline.common.request.processors.allowed等）。

## 関連画面

| 画面No | 画面名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| 21 | 検索 | 補助機能 | 検索パイプラインプロセッサによるリクエスト・レスポンスの加工 |

## 機能種別

データ連携 / 計算処理

## 入力仕様

### 入力パラメータ

各プロセッサごとに固有のパラメータを持つ。代表的なプロセッサのパラメータを以下に示す。

#### FilterQueryRequestProcessor

| パラメータ名 | 型 | 必須 | 説明 | バリデーション |
|-------------|-----|-----|------|---------------|
| query | Object | Yes | 追加するフィルタクエリ定義 | - |

#### RenameFieldResponseProcessor

| パラメータ名 | 型 | 必須 | 説明 | バリデーション |
|-------------|-----|-----|------|---------------|
| field | String | Yes | 元のフィールド名 | - |
| target_field | String | Yes | 変更後のフィールド名 | - |

#### TruncateHitsResponseProcessor

| パラメータ名 | 型 | 必須 | 説明 | バリデーション |
|-------------|-----|-----|------|---------------|
| target_size | int | No | 結果を切り詰めるサイズ | - |

### 入力データソース

検索パイプラインを通過する検索リクエスト・レスポンス。

## 出力仕様

### 出力データ

| 項目名 | 型 | 説明 |
|--------|-----|------|
| SearchRequest | SearchRequest | 変更後の検索リクエスト（リクエストプロセッサ） |
| SearchResponse | SearchResponse | 変更後の検索レスポンス（レスポンスプロセッサ） |

### 出力先

検索パイプラインの次のプロセッサまたは最終レスポンスとして返却。

## 処理フロー

### 処理シーケンス

```
1. SearchPipelineCommonModulePlugin登録
   └─ SearchPipelinePluginとしてプロセッサファクトリを登録
2. 許可リストフィルタリング
   └─ ノード設定の許可リストに基づきプロセッサを制限
3. パイプライン構築時
   └─ 各プロセッサファクトリからプロセッサインスタンスを生成
4. パイプライン実行時
   └─ リクエストプロセッサ → 検索 → レスポンスプロセッサの順で実行
```

### フローチャート

```mermaid
flowchart TD
    A[Search Pipeline Execution] --> B{Request Processors}
    B --> B1[FilterQueryRequestProcessor]
    B --> B2[ScriptRequestProcessor]
    B --> B3[OversampleRequestProcessor]
    B --> B4[HierarchicalRoutingSearchProcessor]
    B --> B5[TemporalRoutingSearchProcessor]
    B --> B6[AclRoutingSearchProcessor]
    B1 --> C[Execute Search]
    B2 --> C
    B3 --> C
    B4 --> C
    B5 --> C
    B6 --> C
    C --> D{Response Processors}
    D --> D1[RenameFieldResponseProcessor]
    D --> D2[TruncateHitsResponseProcessor]
    D --> D3[CollapseResponseProcessor]
    D --> D4[SplitResponseProcessor]
    D --> D5[SortResponseProcessor]
    D1 --> E[Final Response]
    D2 --> E
    D3 --> E
    D4 --> E
    D5 --> E
```

## ビジネスルール

### 業務ルール

| ルールNo | ルール名 | 内容 | 適用条件 |
|---------|---------|------|---------|
| BR-46-01 | 許可リスト制御 | ノード設定でプロセッサの使用を許可リストで制限可能 | プラグイン初期化時 |
| BR-46-02 | 未知プロセッサ検出 | 許可リストに未知のプロセッサ名が含まれる場合はIllegalArgumentException | プラグイン初期化時 |
| BR-46-03 | 空許可リスト | 許可リスト設定が未指定の場合は全プロセッサが利用可能 | プラグイン初期化時 |

### 計算ロジック

各プロセッサ固有の計算ロジックはプロセッサ実装に依存する。

## データベース操作仕様

本モジュールはデータベース操作を直接行わない。

## エラー処理

### エラーケース一覧

| エラーコード | エラー種別 | 発生条件 | 対処方法 |
|------------|----------|---------|---------|
| - | IllegalArgumentException | 許可リストに未知のプロセッサ名 | 設定値を確認 |
| - | SearchRequestMapProcessingException | リクエストマップ処理エラー | プロセッサ設定を確認 |

### リトライ仕様

検索パイプライン基盤のリトライ制御に依存する。

## トランザクション仕様

プロセッサの実行はステートレスであり、トランザクション管理は不要。

## パフォーマンス要件

各プロセッサは軽量な処理であることが期待される。ScriptRequestProcessorはスクリプト実行のオーバーヘッドがある。

## セキュリティ考慮事項

- ScriptRequestProcessorはPainlessスクリプトを実行するため、スクリプト実行のセキュリティポリシーが適用される
- 許可リスト設定により、使用可能なプロセッサを制限可能
- AclRoutingSearchProcessorはアクセス制御リストベースのルーティングを行う

## 備考

リクエストプロセッサ6種、レスポンスプロセッサ5種が提供される。SearchPhaseResultsProcessorの共通実装は現時点では提供されていない。

---

## コードリーディングガイド

本機能を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: プラグイン構成を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | SearchPipelineCommonModulePlugin.java | `modules/search-pipeline-common/src/main/java/org/opensearch/search/pipeline/common/SearchPipelineCommonModulePlugin.java` | プロセッサファクトリの登録と許可リストフィルタリングロジック |

**主要処理フロー**:
- **31-50行目**: 許可リスト設定の定義（REQUEST_PROCESSORS_ALLOWLIST_SETTING等）
- **73-92行目**: getRequestProcessorsで6種のリクエストプロセッサファクトリを登録
- **95-112行目**: getResponseProcessorsで5種のレスポンスプロセッサファクトリを登録
- **119-141行目**: filterForAllowlistSettingで許可リストに基づくフィルタリング

#### Step 2: リクエストプロセッサを理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | FilterQueryRequestProcessor.java | `modules/search-pipeline-common/src/main/java/org/opensearch/search/pipeline/common/FilterQueryRequestProcessor.java` | フィルタクエリ追加プロセッサ |
| 2-2 | ScriptRequestProcessor.java | 同上 | スクリプトベースのリクエスト加工 |
| 2-3 | OversampleRequestProcessor.java | 同上 | オーバーサンプリングプロセッサ |

#### Step 3: レスポンスプロセッサを理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | RenameFieldResponseProcessor.java | `modules/search-pipeline-common/src/main/java/org/opensearch/search/pipeline/common/RenameFieldResponseProcessor.java` | フィールド名変更プロセッサ |
| 3-2 | TruncateHitsResponseProcessor.java | 同上 | 検索結果トリミングプロセッサ |
| 3-3 | CollapseResponseProcessor.java | 同上 | 結果折りたたみプロセッサ |
| 3-4 | SortResponseProcessor.java | 同上 | 結果ソートプロセッサ |
| 3-5 | SplitResponseProcessor.java | 同上 | フィールド分割プロセッサ |

### プログラム呼び出し階層図

```
SearchPipelineCommonModulePlugin (SearchPipelinePlugin)
    |
    +-- getRequestProcessors()
    |       +-- FilterQueryRequestProcessor.Factory
    |       +-- ScriptRequestProcessor.Factory
    |       +-- OversampleRequestProcessor.Factory
    |       +-- HierarchicalRoutingSearchProcessor.Factory
    |       +-- TemporalRoutingSearchProcessor.Factory
    |       +-- AclRoutingSearchProcessor.Factory
    |
    +-- getResponseProcessors()
    |       +-- RenameFieldResponseProcessor.Factory
    |       +-- TruncateHitsResponseProcessor.Factory
    |       +-- CollapseResponseProcessor.Factory
    |       +-- SplitResponseProcessor.Factory
    |       +-- SortResponseProcessor.Factory
    |
    +-- filterForAllowlistSetting()
```

### データフロー図

```
[入力]                    [処理]                              [出力]

SearchRequest ──────▶ FilterQueryRequestProcessor     ──▶ Modified SearchRequest
                     ScriptRequestProcessor                (追加フィルタ、変更クエリ)
                     OversampleRequestProcessor
                     *RoutingSearchProcessor

SearchResponse ◀──── RenameFieldResponseProcessor     ◀── Raw SearchResponse
                     TruncateHitsResponseProcessor
                     CollapseResponseProcessor
                     SplitResponseProcessor
                     SortResponseProcessor
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| SearchPipelineCommonModulePlugin.java | `modules/search-pipeline-common/src/main/java/org/opensearch/search/pipeline/common/` | ソース | プラグインエントリーポイント |
| FilterQueryRequestProcessor.java | 同上 | ソース | フィルタクエリ追加プロセッサ |
| ScriptRequestProcessor.java | 同上 | ソース | スクリプトリクエストプロセッサ |
| OversampleRequestProcessor.java | 同上 | ソース | オーバーサンプリングプロセッサ |
| HierarchicalRoutingSearchProcessor.java | 同上 | ソース | 階層ルーティングプロセッサ |
| TemporalRoutingSearchProcessor.java | 同上 | ソース | 時間ルーティングプロセッサ |
| AclRoutingSearchProcessor.java | 同上 | ソース | ACLルーティングプロセッサ |
| RenameFieldResponseProcessor.java | 同上 | ソース | フィールド名変更プロセッサ |
| TruncateHitsResponseProcessor.java | 同上 | ソース | 結果トリミングプロセッサ |
| CollapseResponseProcessor.java | 同上 | ソース | 結果折りたたみプロセッサ |
| SplitResponseProcessor.java | 同上 | ソース | フィールド分割プロセッサ |
| SortResponseProcessor.java | 同上 | ソース | 結果ソートプロセッサ |
| BasicMap.java | 同上 | ソース | マップ操作ユーティリティ |
| SearchRequestMap.java（テスト参照） | 同上 | ソース | リクエストマップ操作 |
