# 機能設計書 48-クラスタ状態管理

## 概要

本ドキュメントは、OpenSearchクラスタのメタデータ・ルーティングテーブル・ノード情報等の包括的な状態を管理するクラスタ状態管理機能の設計書である。

### 本機能の処理概要

**業務上の目的・背景**：OpenSearchクラスタは、インデックスメタデータ、シャードルーティング情報、ノード構成、クラスタブロック、カスタムメタデータなどの多岐にわたる状態情報を一元管理する必要がある。ClusterStateはクラスタのスナップショットとして機能し、全ノード間で一貫した状態を維持するための中核データ構造である。

**機能の利用シーン**：クラスタの状態確認API、内部的なクラスタ状態変更タスクの実行、クラスタ情報の参照、Ping応答など、クラスタ運用全般の基盤として利用される。

**主要な処理内容**：
1. クラスタ状態の保持：Metadata、RoutingTable、DiscoveryNodes、ClusterBlocks等の管理
2. クラスタ状態の取得API：REST APIを通じたクラスタ状態の参照
3. クラスタ状態の更新：ClusterStateUpdateTaskを通じた原子的な状態更新
4. クラスタ状態のバージョン管理：term/versionによる世代管理

**関連システム・外部連携**：全てのクラスタ操作がClusterStateに依存する。リモートクラスタ状態管理（リモートストア永続化）との連携もある。

**権限による制御**：クラスタマネージャノードへの読み取り操作（TransportClusterManagerNodeReadAction）。

## 関連画面

| 画面No | 画面名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| 1 | クラスタ情報 | 主機能 | クラスタの基本情報を返す主処理 |
| 2 | Ping | 主機能 | クラスタが稼働中かどうかを確認するヘルスチェック処理 |
| 91 | クラスタ状態 | 主機能 | クラスタの包括的な状態情報を返す処理 |

## 機能種別

データ参照 / CRUD操作

## 入力仕様

### 入力パラメータ

| パラメータ名 | 型 | 必須 | 説明 | バリデーション |
|-------------|-----|-----|------|---------------|
| indices | String[] | No | 対象インデックス | - |
| routingTable | boolean | No | ルーティングテーブルを含めるか | デフォルトtrue |
| nodes | boolean | No | ノード情報を含めるか | デフォルトtrue |
| metadata | boolean | No | メタデータを含めるか | デフォルトtrue |
| blocks | boolean | No | クラスタブロックを含めるか | デフォルトtrue |
| customs | boolean | No | カスタムメタデータを含めるか | デフォルトtrue |
| local | boolean | No | ローカルノードの状態を返すか | デフォルトfalse |
| waitForMetadataVersion | Long | No | 待機するメタデータバージョン | - |
| waitForTimeout | TimeValue | No | 待機タイムアウト | - |

### 入力データソース

REST API経由でのリクエスト（`GET /_cluster/state`、`GET /_cluster/state/{metrics}`、`GET /_cluster/state/{metrics}/{indices}`）。

## 出力仕様

### 出力データ

| 項目名 | 型 | 説明 |
|--------|-----|------|
| cluster_name | String | クラスタ名 |
| cluster_uuid | String | クラスタUUID |
| version | long | クラスタ状態バージョン |
| state_uuid | String | 状態UUID |
| metadata | Metadata | インデックスメタデータ、テンプレート、設定等 |
| routing_table | RoutingTable | シャードルーティング情報 |
| nodes | DiscoveryNodes | クラスタノード情報 |
| blocks | ClusterBlocks | クラスタブロック情報 |
| customs | Map<String, Custom> | カスタムメタデータ |

### 出力先

REST APIレスポンス（JSON形式）

## 処理フロー

### 処理シーケンス

```
1. REST APIリクエスト受信
   └─ ClusterStateRequest生成（含めるメトリクスを指定）
2. クラスタマネージャノードへ転送（local=false時）
   └─ TransportClusterManagerNodeReadAction経由
3. クラスタ状態フィルタリング
   └─ リクエストで指定されたメトリクスに基づきClusterStateを構築
4. レスポンス生成
   └─ ClusterStateResponse構築
```

### フローチャート

```mermaid
flowchart TD
    A[Cluster State Request] --> B{local?}
    B -->|Yes| C[Get Local ClusterState]
    B -->|No| D[Route to Cluster Manager]
    C --> E[Filter by requested metrics]
    D --> E
    E --> F{waitForMetadataVersion?}
    F -->|Yes| G[Wait for version]
    F -->|No| H[Build Response]
    G --> H
    H --> I[Return ClusterStateResponse]
```

## ビジネスルール

### 業務ルール

| ルールNo | ルール名 | 内容 | 適用条件 |
|---------|---------|------|---------|
| BR-48-01 | クラスタ状態の不変性 | ClusterStateインスタンスは不変（immutable）。更新はBuilderを通じて新しいインスタンスを生成 | 常時 |
| BR-48-02 | バージョン単調増加 | クラスタ状態バージョンは単調に増加する | 状態更新時 |
| BR-48-03 | メトリクスフィルタ | リクエストで指定されたメトリクスのみをレスポンスに含める | API呼び出し時 |

### 計算ロジック

特になし。

## データベース操作仕様

### 操作別データベース影響一覧

| 操作 | 対象テーブル | 操作種別 | 概要 |
|-----|-------------|---------|------|
| 状態取得 | ClusterState（メモリ） | SELECT | 現在のクラスタ状態を取得 |

## エラー処理

### エラーケース一覧

| エラーコード | エラー種別 | 発生条件 | 対処方法 |
|------------|----------|---------|---------|
| - | ClusterManagerNotDiscoveredException | クラスタマネージャが未発見 | クラスタマネージャの起動を待つ |

### リトライ仕様

waitForMetadataVersion指定時は条件到達まで自動的に待機する。

## トランザクション仕様

読み取り操作はトランザクション不要。クラスタ状態の更新はClusterStateUpdateTaskを通じて原子的に実行される。

## パフォーマンス要件

クラスタ状態の全体取得は大規模クラスタではデータ量が大きくなるため、メトリクスフィルタの活用が推奨される。

## セキュリティ考慮事項

- クラスタ読み取り権限が必要
- クラスタ状態にはセンシティブな情報（設定値等）が含まれる可能性がある

## 備考

ClusterStateはOpenSearchの中核データ構造であり、929行の大規模クラスである。Metadata、RoutingTable、DiscoveryNodes、ClusterBlocks、CoordinationMetadataなどの複数のサブコンポーネントで構成される。

---

## コードリーディングガイド

本機能を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: データ構造を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | ClusterState.java | `server/src/main/java/org/opensearch/cluster/ClusterState.java` | クラスタ状態の中核データ構造。Metadata, RoutingTable, DiscoveryNodes, ClusterBlocks等のフィールドを理解する |

**読解のコツ**: ClusterStateは不変（immutable）オブジェクトであり、Builder パターンで構築される。**80行目付近**のクラスJavadocと主要フィールドの定義を最初に確認するとよい。

#### Step 2: エントリーポイントを理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | TransportClusterStateAction.java | `server/src/main/java/org/opensearch/action/admin/cluster/state/TransportClusterStateAction.java` | クラスタ状態取得のトランスポートアクション |
| 2-2 | ClusterStateRequest.java | `server/src/main/java/org/opensearch/action/admin/cluster/state/ClusterStateRequest.java` | リクエストの各フラグ（routingTable, nodes, metadata等）を確認 |
| 2-3 | ClusterStateResponse.java | `server/src/main/java/org/opensearch/action/admin/cluster/state/ClusterStateResponse.java` | レスポンスデータ構造 |

#### Step 3: クラスタ状態の構成要素を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | Metadata.java | `server/src/main/java/org/opensearch/cluster/metadata/Metadata.java` | インデックスメタデータ、テンプレート、設定の管理 |
| 3-2 | RoutingTable.java | `server/src/main/java/org/opensearch/cluster/routing/RoutingTable.java` | シャードルーティング情報 |
| 3-3 | DiscoveryNodes.java | `server/src/main/java/org/opensearch/cluster/node/DiscoveryNodes.java` | クラスタノード情報 |
| 3-4 | ClusterBlocks.java | `server/src/main/java/org/opensearch/cluster/block/ClusterBlocks.java` | クラスタブロック情報 |

### プログラム呼び出し階層図

```
TransportClusterStateAction
    |
    +-- clusterManagerOperation()
            |
            +-- ClusterState
                    |
                    +-- Metadata
                    |       +-- IndexMetadata
                    |       +-- Templates
                    |       +-- Settings
                    |
                    +-- RoutingTable
                    |       +-- IndexRoutingTable
                    |       +-- IndexShardRoutingTable
                    |
                    +-- DiscoveryNodes
                    |       +-- DiscoveryNode
                    |
                    +-- ClusterBlocks
                    +-- CoordinationMetadata
                    +-- Customs
```

### データフロー図

```
[入力]                    [処理]                              [出力]

ClusterStateRequest --> TransportClusterStateAction     --> ClusterStateResponse
  (metrics filter,       |                                   (metadata, routing_table,
   indices)              +-> ClusterState (in-memory)         nodes, blocks, ...)
                         +-> Filter by requested metrics
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| ClusterState.java | `server/src/main/java/org/opensearch/cluster/` | ソース | クラスタ状態の中核データ構造（929行） |
| TransportClusterStateAction.java | `server/src/main/java/org/opensearch/action/admin/cluster/state/` | ソース | トランスポートアクション |
| ClusterStateRequest.java | 同上 | ソース | リクエスト定義 |
| ClusterStateResponse.java | 同上 | ソース | レスポンス定義 |
| ClusterStateAction.java | 同上 | ソース | アクション定義 |
| Metadata.java | `server/src/main/java/org/opensearch/cluster/metadata/` | ソース | クラスタメタデータ |
| RoutingTable.java | `server/src/main/java/org/opensearch/cluster/routing/` | ソース | シャードルーティング |
| DiscoveryNodes.java | `server/src/main/java/org/opensearch/cluster/node/` | ソース | ノード情報 |
| ClusterBlocks.java | `server/src/main/java/org/opensearch/cluster/block/` | ソース | クラスタブロック |
