# 機能設計書 49-ノード情報・統計

## 概要

本ドキュメントは、OpenSearchクラスタ内のノード情報および統計情報を取得する機能の設計書である。

### 本機能の処理概要

**業務上の目的・背景**：クラスタの運用監視において、各ノードの設定情報、OS情報、JVM情報、スレッドプール情報、各種統計情報を取得する必要がある。本機能はノード単位の詳細情報と実行時統計を提供し、運用監視・トラブルシューティング・キャパシティプランニングを支援する。

**機能の利用シーン**：ノードの設定確認、パフォーマンスモニタリング、リソース使用状況の把握、ホットスレッド分析、REST API使用状況の確認など、運用監視全般で利用される。

**主要な処理内容**：
1. ノード情報取得（Nodes Info）：設定、OS、プロセス、JVM、スレッドプール、トランスポート、HTTP、プラグイン、インジェスト、集計、インデックス、検索パイプラインの情報
2. ノード統計取得（Nodes Stats）：OS、プロセス、JVM、スレッドプール、FS、トランスポート、HTTP、ブレーカー、スクリプト等の実行時統計
3. ノード使用状況（Nodes Usage）：REST API使用状況
4. ホットスレッド：各ノードのホットスレッド情報

**関連システム・外部連携**：NodeServiceを通じて各ノードのローカル情報を収集する。TransportNodesActionによりクラスタ全ノードに分散リクエストを実行する。

**権限による制御**：クラスタ管理権限が必要。

## 関連画面

| 画面No | 画面名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| 1 | クラスタ情報 | 補助機能 | クラスタ情報取得時のノード関連情報の補助取得 |
| 107 | ノード情報 | 主機能 | クラスタ内のノード情報を返す処理 |
| 108 | ノード統計 | 主機能 | クラスタ内のノード統計情報を返す処理 |
| 109 | ノード使用状況 | 主機能 | ノードのRESTアクション使用状況を返す処理 |
| 110 | ホットスレッド | 主機能 | 各ノードのホットスレッド情報を返す処理 |
| 111 | セキュア設定リロード | 主機能 | セキュア設定をリロードする処理 |
| 145 | Cat ヘルプ | 主機能 | Cat APIの利用可能なエンドポイント一覧を返すヘルプ処理 |
| 153 | Cat ノード属性 | 主機能 | カスタムノード属性の情報をテーブル形式で返す処理 |
| 154 | Cat ノード | 主機能 | クラスタノードの基本パフォーマンス統計をテーブル形式で返す処理 |

## 機能種別

データ参照

## 入力仕様

### 入力パラメータ（Nodes Info）

| パラメータ名 | 型 | 必須 | 説明 | バリデーション |
|-------------|-----|-----|------|---------------|
| nodeIds | String[] | No | 対象ノードID | 未指定時は全ノード |
| metrics | Set<String> | No | 取得するメトリクス | settings, os, process, jvm, thread_pool, transport, http, plugins, ingest, aggregations, indices, search_pipelines |

### 入力パラメータ（Nodes Stats）

| パラメータ名 | 型 | 必須 | 説明 | バリデーション |
|-------------|-----|-----|------|---------------|
| nodeIds | String[] | No | 対象ノードID | 未指定時は全ノード |
| metrics | Set<String> | No | 取得するメトリクス | os, process, jvm, thread_pool, fs, transport, http, breaker, script, discovery, ingest, adaptive_selection, script_cache, indexing_pressure, shard_indexing_pressure, search_backpressure, cluster_manager_throttling, weighted_routing_stats, file_cache_stats, task_cancellation, search_pipeline, resource_usage_stats, segment_replication_backpressure, repositories, admission_control, cache_stats, remote_store |
| indices | CommonStatsFlags | No | インデックス統計のフラグ | - |

### 入力データソース

REST API経由でのリクエスト（`GET /_nodes`、`GET /_nodes/stats`、`GET /_nodes/usage`、`GET /_nodes/hot_threads`）。

## 出力仕様

### 出力データ（Nodes Info）

| 項目名 | 型 | 説明 |
|--------|-----|------|
| cluster_name | String | クラスタ名 |
| nodes | Map<String, NodeInfo> | ノードIDをキーとしたノード情報マップ |
| _nodes | NodesResponseHeader | 成功・失敗ノード数 |

### 出力データ（Nodes Stats）

| 項目名 | 型 | 説明 |
|--------|-----|------|
| cluster_name | String | クラスタ名 |
| nodes | Map<String, NodeStats> | ノードIDをキーとした統計情報マップ |
| _nodes | NodesResponseHeader | 成功・失敗ノード数 |

### 出力先

REST APIレスポンス（JSON形式）

## 処理フロー

### 処理シーケンス

```
1. REST APIリクエスト受信
   └─ NodesInfoRequest / NodesStatsRequest 生成
2. 対象ノードの解決
   └─ ノードIDの解決（全ノードまたは指定ノード）
3. 各ノードへリクエスト分散
   └─ TransportNodesAction により各ノードへ転送
4. 各ノードでローカル情報収集
   └─ NodeService.info() / NodeService.stats() でローカル情報を取得
5. レスポンス集約
   └─ 全ノードの結果をマージしてレスポンスを生成
```

### フローチャート

```mermaid
flowchart TD
    A[Nodes Info/Stats Request] --> B[Resolve Target Nodes]
    B --> C[Distribute to Each Node]
    C --> D[Node 1: NodeService.info/stats]
    C --> E[Node 2: NodeService.info/stats]
    C --> F[Node N: NodeService.info/stats]
    D --> G[Aggregate Responses]
    E --> G
    F --> G
    G --> H[Return NodesInfoResponse/NodesStatsResponse]
```

## ビジネスルール

### 業務ルール

| ルールNo | ルール名 | 内容 | 適用条件 |
|---------|---------|------|---------|
| BR-49-01 | メトリクス選択 | リクエストで指定されたメトリクスのみを収集・返却 | API呼び出し時 |
| BR-49-02 | 部分的成功 | 一部ノードが失敗してもレスポンスは返却される | ノード障害時 |
| BR-49-03 | MANAGEMENTスレッドプール | ノード操作はMANAGEMENTスレッドプールで実行 | 常時 |

### 計算ロジック

特になし。NodeService経由で各メトリクスの現在値を取得する。

## データベース操作仕様

本機能はメモリ上の情報を収集するのみであり、永続ストレージへの操作は行わない。

## エラー処理

### エラーケース一覧

| エラーコード | エラー種別 | 発生条件 | 対処方法 |
|------------|----------|---------|---------|
| - | FailedNodeException | 特定ノードからの情報取得失敗 | ノードの状態を確認。部分的レスポンスは返却される |

### リトライ仕様

TransportNodesActionの基盤リトライ機構に依存する。

## トランザクション仕様

読み取り専用操作であり、トランザクション管理は不要。

## パフォーマンス要件

大規模クラスタではノード数に比例してレスポンスサイズが増大するため、メトリクスフィルタの活用が推奨される。

## セキュリティ考慮事項

- クラスタ管理権限が必要
- ノード情報にはJVM設定やプラグイン情報などのシステム情報が含まれる

## 備考

Nodes Statsでは27種類のメトリクスカテゴリをサポートしており、メトリクスの選択的な取得が可能である。

---

## コードリーディングガイド

本機能を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: データ構造を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | NodeInfo.java | `server/src/main/java/org/opensearch/action/admin/cluster/node/info/NodeInfo.java` | ノード情報のデータ構造。各種メトリクスフィールドを確認 |
| 1-2 | NodeStats.java | `server/src/main/java/org/opensearch/action/admin/cluster/node/stats/NodeStats.java` | ノード統計のデータ構造。27種類のメトリクスフィールドを確認 |
| 1-3 | NodesInfoRequest.java | `server/src/main/java/org/opensearch/action/admin/cluster/node/info/NodesInfoRequest.java` | ノード情報リクエスト。Metric列挙型で12種類のメトリクスカテゴリを定義 |
| 1-4 | NodesStatsRequest.java | `server/src/main/java/org/opensearch/action/admin/cluster/node/stats/NodesStatsRequest.java` | ノード統計リクエスト。Metric列挙型で27種類のメトリクスカテゴリを定義 |

#### Step 2: エントリーポイントを理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | TransportNodesInfoAction.java | `server/src/main/java/org/opensearch/action/admin/cluster/node/info/TransportNodesInfoAction.java` | ノード情報のトランスポートアクション |
| 2-2 | TransportNodesStatsAction.java | `server/src/main/java/org/opensearch/action/admin/cluster/node/stats/TransportNodesStatsAction.java` | ノード統計のトランスポートアクション |

**主要処理フロー（TransportNodesInfoAction.java）**:
- **106-123行目**: nodeOperationメソッドで各メトリクスの有無をチェックし、NodeService.info()を呼び出し

**主要処理フロー（TransportNodesStatsAction.java）**:
- **102-134行目**: nodeOperationメソッドで27種類のメトリクスの有無をチェックし、NodeService.stats()を呼び出し

#### Step 3: NodeServiceを理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | NodeService.java | `server/src/main/java/org/opensearch/node/NodeService.java` | info()とstats()メソッドの実装。各メトリクスの収集ロジック |

### プログラム呼び出し階層図

```
TransportNodesInfoAction / TransportNodesStatsAction
    |
    +-- TransportNodesAction (base class)
    |       +-- Distribute request to all target nodes
    |       +-- Aggregate responses
    |
    +-- nodeOperation() (on each node)
            |
            +-- NodeService.info() / NodeService.stats()
                    |
                    +-- OS info/stats
                    +-- Process info/stats
                    +-- JVM info/stats
                    +-- ThreadPool info/stats
                    +-- Transport info/stats
                    +-- HTTP info/stats
                    +-- FileSystem stats
                    +-- Breaker stats
                    +-- Script stats
                    +-- ...
```

### データフロー図

```
[入力]                    [処理]                              [出力]

NodesInfoRequest ──────▶ TransportNodesInfoAction       ──▶ NodesInfoResponse
  (nodeIds, metrics)       |                                  (Map<nodeId, NodeInfo>)
                           +-> Distribute to each node
                           +-> NodeService.info() on each
                           +-> Aggregate

NodesStatsRequest ─────▶ TransportNodesStatsAction      ──▶ NodesStatsResponse
  (nodeIds, metrics)       |                                  (Map<nodeId, NodeStats>)
                           +-> Distribute to each node
                           +-> NodeService.stats() on each
                           +-> Aggregate
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| TransportNodesInfoAction.java | `server/src/main/java/org/opensearch/action/admin/cluster/node/info/` | ソース | ノード情報トランスポートアクション |
| NodesInfoRequest.java | 同上 | ソース | ノード情報リクエスト |
| NodesInfoResponse.java | 同上 | ソース | ノード情報レスポンス |
| NodeInfo.java | 同上 | ソース | ノード情報データ構造 |
| TransportNodesStatsAction.java | `server/src/main/java/org/opensearch/action/admin/cluster/node/stats/` | ソース | ノード統計トランスポートアクション |
| NodesStatsRequest.java | 同上 | ソース | ノード統計リクエスト |
| NodesStatsResponse.java | 同上 | ソース | ノード統計レスポンス |
| NodeStats.java | 同上 | ソース | ノード統計データ構造 |
| NodeService.java | `server/src/main/java/org/opensearch/node/` | ソース | ノード情報・統計収集サービス |
| TransportNodesUsageAction.java | `server/src/main/java/org/opensearch/action/admin/cluster/node/usage/` | ソース | ノード使用状況トランスポートアクション |
