# 機能設計書 51-タスク管理

## 概要

本ドキュメントは、OpenSearchにおけるタスク管理機能の設計を記述する。タスク管理は、クラスタ内で実行中・保留中のタスクを監視・制御するための機能群である。

### 本機能の処理概要

タスク管理機能は、OpenSearchクラスタ内のタスク（操作）のライフサイクルを監視・管理する。保留中のクラスタタスクの一覧取得、実行中タスクの一覧取得、個別タスクの詳細取得、およびタスクのキャンセルを提供する。

**業務上の目的・背景**：分散システムであるOpenSearchでは、様々な操作がタスクとして非同期に実行される。運用者がシステムの状態を把握し、必要に応じて長時間実行中のタスクをキャンセルするなどの制御を行うために、タスク管理機能が必要となる。

**機能の利用シーン**：
- クラスタの状態監視時に保留中・実行中のタスクを確認する場合
- 長時間実行中のタスク（リインデックス等）の進捗を確認する場合
- 問題のあるタスクをキャンセルする場合
- クラスタのパフォーマンス分析時にタスクキューの状態を確認する場合

**主要な処理内容**：
1. 保留中クラスタタスク一覧取得（Pending Cluster Tasks）
2. 実行中タスク一覧取得（List Tasks）
3. 個別タスク取得（Get Task）
4. タスクキャンセル（Cancel Tasks）

**関連システム・外部連携**：ClusterServiceと連携してクラスタマネージャノードで管理されるタスクキューの情報を取得する。TaskManagerと連携して各ノードで実行中のタスク情報を取得する。

**権限による制御**：
- 保留中タスク一覧: `cluster:monitor/task`
- タスク一覧: `cluster:monitor/tasks/lists`
- 個別タスク取得: `cluster:monitor/task/get`
- タスクキャンセル: `cluster:admin/tasks/cancel`

## 関連画面

| 画面No | 画面名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| - | タスク一覧 | 参照画面 | 実行中タスクの一覧表示 |
| - | 保留中タスク一覧 | 参照画面 | 保留中クラスタタスクの一覧表示 |

## 機能種別

監視・運用管理

## 入力仕様

### サブ機能1: 保留中クラスタタスク一覧取得

#### REST API
- エンドポイント: `GET /_cluster/pending_tasks`
- アクション名: `cluster:monitor/task`

#### 入力パラメータ

| パラメータ名 | 型 | 必須 | 説明 | バリデーション |
|-------------|-----|-----|------|---------------|
| local | boolean | No | ローカルノードから取得するか | デフォルトfalse |
| cluster_manager_timeout | TimeValue | No | クラスタマネージャノード待機タイムアウト | デフォルト30秒 |

### サブ機能2: 実行中タスク一覧取得

#### REST API
- エンドポイント: `GET /_tasks`
- アクション名: `cluster:monitor/tasks/lists`

#### 入力パラメータ

| パラメータ名 | 型 | 必須 | 説明 | バリデーション |
|-------------|-----|-----|------|---------------|
| nodes | String[] | No | 対象ノードの指定 | カンマ区切り |
| actions | String[] | No | フィルタするアクション名 | ワイルドカード使用可 |
| parent_task_id | String | No | 親タスクIDでフィルタ | node_id:task_id形式 |
| detailed | boolean | No | 詳細情報を含めるか | デフォルトfalse |
| wait_for_completion | boolean | No | タスク完了まで待機するか | デフォルトfalse |
| group_by | String | No | グループ化方法 | nodes/parents/none |
| timeout | TimeValue | No | 待機タイムアウト | - |

### サブ機能3: 個別タスク取得

#### REST API
- エンドポイント: `GET /_tasks/{task_id}`
- アクション名: `cluster:monitor/task/get`

#### 入力パラメータ

| パラメータ名 | 型 | 必須 | 説明 | バリデーション |
|-------------|-----|-----|------|---------------|
| task_id | String | Yes | タスクID | node_id:task_id形式 |
| wait_for_completion | boolean | No | タスク完了まで待機するか | デフォルトfalse |
| timeout | TimeValue | No | 待機タイムアウト | - |

### サブ機能4: タスクキャンセル

#### REST API
- エンドポイント: `POST /_tasks/_cancel`, `POST /_tasks/{task_id}/_cancel`
- アクション名: `cluster:admin/tasks/cancel`

#### 入力パラメータ

| パラメータ名 | 型 | 必須 | 説明 | バリデーション |
|-------------|-----|-----|------|---------------|
| task_id | String | No | キャンセルするタスクID | node_id:task_id形式 |
| nodes | String[] | No | 対象ノードの指定 | カンマ区切り |
| actions | String[] | No | キャンセルするアクション名 | ワイルドカード使用可 |
| parent_task_id | String | No | 親タスクIDでフィルタ | node_id:task_id形式 |
| wait_for_completion | boolean | No | キャンセル完了まで待機するか | デフォルトfalse |

## 出力仕様

### サブ機能1: 保留中クラスタタスク一覧取得

| 項目名 | 型 | 説明 |
|--------|-----|------|
| tasks | Array | 保留中タスクのリスト |
| tasks[].insert_order | long | 挿入順序 |
| tasks[].priority | String | 優先度（IMMEDIATE/URGENT/HIGH/NORMAL/LOW/LANGUID） |
| tasks[].source | String | タスクのソース（説明） |
| tasks[].executing | boolean | 現在実行中かどうか |
| tasks[].time_in_queue_millis | long | キュー内待機時間（ミリ秒） |
| tasks[].time_in_queue | String | キュー内待機時間（人間可読形式） |
| tasks[].time_in_execution_millis | long | 実行時間（ミリ秒） |
| tasks[].time_in_execution | String | 実行時間（人間可読形式） |

### サブ機能2: 実行中タスク一覧取得

| 項目名 | 型 | 説明 |
|--------|-----|------|
| nodes | Object | ノードごとのタスク情報 |
| nodes.{node_id}.tasks | Object | タスク情報のマップ |
| tasks[].node | String | ノードID |
| tasks[].id | long | タスクID |
| tasks[].type | String | タスクタイプ |
| tasks[].action | String | アクション名 |
| tasks[].status | Object | タスクステータス |
| tasks[].description | String | タスクの説明 |
| tasks[].start_time_in_millis | long | 開始時刻（ミリ秒） |
| tasks[].running_time_in_nanos | long | 実行時間（ナノ秒） |
| tasks[].cancellable | boolean | キャンセル可能か |
| tasks[].cancelled | boolean | キャンセル済みか |
| tasks[].parent_task_id | String | 親タスクID |

### 出力先

REST APIレスポンス（JSON形式）

## 処理フロー

### 処理シーケンス（保留中タスク一覧取得）

```
1. REST APIリクエスト受信
   └─ PendingClusterTasksRequestの生成
2. TransportPendingClusterTasksAction.clusterManagerOperation()実行
   └─ クラスタマネージャノードへの転送
3. ClusterService.getClusterManagerService().pendingTasks()呼び出し
   └─ 保留中タスクリストの取得
4. PendingClusterTasksResponseの返却
   └─ タスク情報のJSON形式変換
```

### フローチャート

```mermaid
flowchart TD
    A[REST API リクエスト受信] --> B{サブ機能判定}
    B -->|Pending Tasks| C[TransportPendingClusterTasksAction]
    B -->|List Tasks| D[TransportListTasksAction]
    B -->|Get Task| E[TransportGetTaskAction]
    B -->|Cancel Tasks| F[TransportCancelTasksAction]

    C --> G[ClusterService.pendingTasks]
    G --> H[PendingClusterTasksResponse]

    D --> I[TaskManager.getTasks]
    I --> J[ListTasksResponse]

    E --> K[TaskManager.getTask]
    K --> L[GetTaskResponse]

    F --> M[TaskManager.cancel]
    M --> N[CancelTasksResponse]

    H --> O[JSON Response]
    J --> O
    L --> O
    N --> O
```

## ビジネスルール

### 業務ルール

| ルールNo | ルール名 | 内容 | 適用条件 |
|---------|---------|------|---------|
| BR-01 | 軽量操作 | 保留中タスク取得はメモリ内操作のため、スレッドフォークしない | 常時 |
| BR-02 | クラスタブロックなし | 保留中タスク取得はクラスタブロック中でも実行可能 | 常時 |
| BR-03 | キャンセル可能フラグ | タスクがcancellable=trueの場合のみキャンセル可能 | キャンセル時 |
| BR-04 | 優先度順序 | タスクは優先度順（IMMEDIATE > URGENT > HIGH > NORMAL > LOW > LANGUID）で処理される | 常時 |

### 計算ロジック

該当なし

## データベース操作仕様

### 操作別データベース影響一覧

| 操作 | 対象 | 操作種別 | 概要 |
|-----|------|---------|------|
| 保留中タスク取得 | ClusterService.taskQueue | READ | タスクキューの参照 |
| タスク一覧取得 | TaskManager.tasks | READ | 実行中タスクの参照 |
| タスクキャンセル | TaskManager.tasks | UPDATE | タスクのキャンセルフラグ設定 |

## エラー処理

### エラーケース一覧

| エラーコード | エラー種別 | 発生条件 | 対処方法 |
|------------|----------|---------|---------|
| 404 | ResourceNotFoundException | 指定したタスクIDが存在しない | 正しいタスクIDを指定する |
| 400 | IllegalArgumentException | 不正なパラメータ形式 | パラメータ形式を確認する |
| 408 | - | タイムアウト | タイムアウト値を延長して再実行 |

### リトライ仕様

タスク取得操作は読み取り専用のため、リトライは自動的に行われない。クライアント側でリトライを実装する必要がある。

## トランザクション仕様

タスク管理の読み取り操作はトランザクションを使用しない。タスクキャンセルは各ノードで個別に実行され、アトミック性は保証されない。

## パフォーマンス要件

- 保留中タスク取得はメモリ内操作のため、非常に軽量
- タスク一覧取得は全ノードへの問い合わせが必要なため、クラスタサイズに比例して時間がかかる可能性がある
- 大量のタスクがある場合、actionsやnodesパラメータでフィルタリングすることを推奨

## セキュリティ考慮事項

- タスク監視には`cluster:monitor/task`または`cluster:monitor/tasks/lists`アクション権限が必要
- タスクキャンセルには`cluster:admin/tasks/cancel`アクション権限が必要
- タスク情報には内部的な操作詳細が含まれるため、適切なアクセス制御が必要

## 備考

- PendingClusterTasksActionのアクション名は`cluster:monitor/task`
- ListTasksActionのアクション名は`cluster:monitor/tasks/lists`
- GetTaskActionのアクション名は`cluster:monitor/task/get`
- CancelTasksActionのアクション名は`cluster:admin/tasks/cancel`
- V3.1.0以降でPendingClusterTaskにtimeInExecutionフィールドが追加された

---

## コードリーディングガイド

本機能を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: データ構造を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | PendingClusterTask.java | `server/src/main/java/org/opensearch/cluster/service/PendingClusterTask.java` | 保留中タスクのデータ構造。insertOrder, priority, source, timeInQueue, executing, timeInExecutionの各フィールドを確認 |
| 1-2 | PendingClusterTasksRequest.java | `server/src/main/java/org/opensearch/action/admin/cluster/tasks/PendingClusterTasksRequest.java` | リクエストのデータ構造。ClusterManagerNodeReadRequestを継承 |
| 1-3 | PendingClusterTasksResponse.java | `server/src/main/java/org/opensearch/action/admin/cluster/tasks/PendingClusterTasksResponse.java` | レスポンスのデータ構造。pendingTasksリストとXContent変換 |

#### Step 2: エントリーポイントを理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | PendingClusterTasksAction.java | `server/src/main/java/org/opensearch/action/admin/cluster/tasks/PendingClusterTasksAction.java` | アクション定義。NAME="cluster:monitor/task" |
| 2-2 | TransportPendingClusterTasksAction.java | `server/src/main/java/org/opensearch/action/admin/cluster/tasks/TransportPendingClusterTasksAction.java` | メインのトランスポートアクション |

**主要処理フロー**:
1. **87-90行目**: executor()メソッド -- ThreadPool.Names.SAME（軽量操作のためスレッドフォークしない）
2. **98-100行目**: checkBlock()メソッド -- nullを返す（ブロックチェックなし）
3. **103-112行目**: clusterManagerOperation()メソッド -- ClusterServiceからpendingTasksを取得

#### Step 3: タスク一覧・キャンセル機能を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | ListTasksAction.java | `server/src/main/java/org/opensearch/action/admin/cluster/node/tasks/list/ListTasksAction.java` | タスク一覧アクション定義 |
| 3-2 | TransportListTasksAction.java | `server/src/main/java/org/opensearch/action/admin/cluster/node/tasks/list/TransportListTasksAction.java` | タスク一覧取得の処理 |
| 3-3 | CancelTasksAction.java | `server/src/main/java/org/opensearch/action/admin/cluster/node/tasks/cancel/CancelTasksAction.java` | タスクキャンセルアクション定義 |
| 3-4 | TransportCancelTasksAction.java | `server/src/main/java/org/opensearch/action/admin/cluster/node/tasks/cancel/TransportCancelTasksAction.java` | タスクキャンセルの処理 |

### プログラム呼び出し階層図

```
REST API (GET /_cluster/pending_tasks)
    |
    +-- TransportPendingClusterTasksAction
          |
          +-- checkBlock() -- null返却（ブロックチェックなし）
          |
          +-- clusterManagerOperation()
                |
                +-- clusterService.getClusterManagerService().pendingTasks()
                |
                +-- PendingClusterTasksResponse生成

REST API (GET /_tasks)
    |
    +-- TransportListTasksAction
          |
          +-- nodeOperation()
                |
                +-- taskManager.getTasks()
                |
                +-- ListTasksResponse生成

REST API (POST /_tasks/_cancel)
    |
    +-- TransportCancelTasksAction
          |
          +-- nodeOperation()
                |
                +-- taskManager.cancel()
                |
                +-- CancelTasksResponse生成
```

### データフロー図

```
[入力]                          [処理]                              [出力]

PendingClusterTasksRequest --> TransportPendingClusterTasksAction --> PendingClusterTasksResponse
                                |                                      (tasks[])
                                +-> ClusterService.pendingTasks()

ListTasksRequest -----------> TransportListTasksAction ------------> ListTasksResponse
 (nodes, actions,              |                                      (nodes{}.tasks{})
  parent_task_id)              +-> TaskManager.getTasks()

GetTaskRequest -------------> TransportGetTaskAction ---------------> GetTaskResponse
 (task_id)                     |                                      (task, completed)
                               +-> TaskManager.getTask()

CancelTasksRequest ---------> TransportCancelTasksAction -----------> CancelTasksResponse
 (task_id, nodes,              |                                      (nodes{}.tasks{})
  actions)                     +-> TaskManager.cancel()
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| PendingClusterTasksAction.java | `server/src/main/java/org/opensearch/action/admin/cluster/tasks/PendingClusterTasksAction.java` | ソース | 保留中タスクアクション型定義 |
| PendingClusterTasksRequest.java | `server/src/main/java/org/opensearch/action/admin/cluster/tasks/PendingClusterTasksRequest.java` | ソース | リクエストデータ構造 |
| PendingClusterTasksResponse.java | `server/src/main/java/org/opensearch/action/admin/cluster/tasks/PendingClusterTasksResponse.java` | ソース | レスポンスデータ構造 |
| TransportPendingClusterTasksAction.java | `server/src/main/java/org/opensearch/action/admin/cluster/tasks/TransportPendingClusterTasksAction.java` | ソース | 保留中タスク取得の主処理 |
| PendingClusterTask.java | `server/src/main/java/org/opensearch/cluster/service/PendingClusterTask.java` | ソース | 保留中タスクのデータ構造 |
| ListTasksAction.java | `server/src/main/java/org/opensearch/action/admin/cluster/node/tasks/list/ListTasksAction.java` | ソース | タスク一覧アクション型定義 |
| ListTasksRequest.java | `server/src/main/java/org/opensearch/action/admin/cluster/node/tasks/list/ListTasksRequest.java` | ソース | タスク一覧リクエスト |
| ListTasksResponse.java | `server/src/main/java/org/opensearch/action/admin/cluster/node/tasks/list/ListTasksResponse.java` | ソース | タスク一覧レスポンス |
| TransportListTasksAction.java | `server/src/main/java/org/opensearch/action/admin/cluster/node/tasks/list/TransportListTasksAction.java` | ソース | タスク一覧取得の主処理 |
| GetTaskAction.java | `server/src/main/java/org/opensearch/action/admin/cluster/node/tasks/get/GetTaskAction.java` | ソース | 個別タスク取得アクション型定義 |
| GetTaskRequest.java | `server/src/main/java/org/opensearch/action/admin/cluster/node/tasks/get/GetTaskRequest.java` | ソース | 個別タスク取得リクエスト |
| GetTaskResponse.java | `server/src/main/java/org/opensearch/action/admin/cluster/node/tasks/get/GetTaskResponse.java` | ソース | 個別タスク取得レスポンス |
| TransportGetTaskAction.java | `server/src/main/java/org/opensearch/action/admin/cluster/node/tasks/get/TransportGetTaskAction.java` | ソース | 個別タスク取得の主処理 |
| CancelTasksAction.java | `server/src/main/java/org/opensearch/action/admin/cluster/node/tasks/cancel/CancelTasksAction.java` | ソース | タスクキャンセルアクション型定義 |
| CancelTasksRequest.java | `server/src/main/java/org/opensearch/action/admin/cluster/node/tasks/cancel/CancelTasksRequest.java` | ソース | タスクキャンセルリクエスト |
| CancelTasksResponse.java | `server/src/main/java/org/opensearch/action/admin/cluster/node/tasks/cancel/CancelTasksResponse.java` | ソース | タスクキャンセルレスポンス |
| TransportCancelTasksAction.java | `server/src/main/java/org/opensearch/action/admin/cluster/node/tasks/cancel/TransportCancelTasksAction.java` | ソース | タスクキャンセルの主処理 |
