# 機能設計書 60-インデックス階層化

## 概要

本ドキュメントは、OpenSearchにおけるインデックス階層化（Tiering）機能の設計を記述する。インデックス階層化は、インデックスをHot層からWarm層へ移行する機能である。

### 本機能の処理概要

インデックス階層化機能は、アクセス頻度の低下したインデックスをコスト効率の良いWarm層ストレージに移行する。Hot層は高性能なストレージでアクティブな書き込み・検索に最適化され、Warm層は低コストのストレージで主に読み取り専用ワークロードに使用される。

**業務上の目的・背景**：時系列データを扱うユースケースにおいて、古いデータは参照頻度が低下するため、高コストなHotストレージに保持する必要がない。Warm層への移行により、ストレージコストを削減しながらデータを保持し続けることができる。

**機能の利用シーン**：
- ログデータのライフサイクル管理
- 時系列データのコスト最適化
- コールドデータの長期保存前の中間層として
- Index State Management（ISM）ポリシーとの連携

**主要な処理内容**：
1. 移行対象インデックスのバリデーション
2. ディスク容量チェック
3. インデックスのWarm層への移行
4. 移行結果の報告

**関連システム・外部連携**：ClusterInfoServiceと連携してディスク使用状況を確認する。DiskThresholdSettingsと連携して閾値を検証する。

**権限による制御**：`indices:admin/tiering/hot_to_warm`アクション権限が必要。

## 関連画面

| 画面No | 画面名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| 1 | インデックス作成 | 設定画面 | インデックスの初期層設定 |
| - | Index State Management | 連携機能 | 自動階層化ポリシー |

## 機能種別

インデックス管理 / ストレージ最適化（実験的機能）

## 入力仕様

### REST API

- エンドポイント: `POST /{index}/_tier/warm`
- アクション名: `indices:admin/tiering/hot_to_warm`

### 入力パラメータ

| パラメータ名 | 型 | 必須 | 説明 | バリデーション |
|-------------|-----|-----|------|---------------|
| index | String | Yes | 移行対象のインデックス名（ワイルドカード可） | 存在するインデックス |
| wait_for_completion | boolean | No | 移行完了を待機するか | デフォルトfalse |

### TieringIndexRequest

| フィールド | 型 | 説明 |
|-----------|-----|------|
| indices | String[] | 対象インデックス名の配列 |
| targetTier | Tier | 移行先の層（WARM） |
| indicesOptions | IndicesOptions | インデックス解決オプション |
| waitForCompletion | boolean | 完了待機フラグ |

### Tier列挙型

| 値 | 説明 |
|----|------|
| HOT | ホット層（高性能、アクティブ書き込み） |
| WARM | ウォーム層（低コスト、読み取り専用） |

### 入力データソース

- ClusterState
- ClusterInfo（ディスク使用状況）
- DiskThresholdSettings

## 出力仕様

### HotToWarmTieringResponse

| 項目名 | 型 | 説明 |
|--------|-----|------|
| acknowledged | boolean | リクエストが受理されたか |
| failedIndices | List | 移行に失敗したインデックスのリスト |

### failedIndices要素

| 項目名 | 型 | 説明 |
|--------|-----|------|
| index | String | インデックス名 |
| reason | String | 失敗理由 |

### 出力先

REST APIレスポンス（JSON形式）

## 処理フロー

### 処理シーケンス

```
1. Tieringリクエスト受信
   └─ TransportHotToWarmTieringAction
2. インデックス解決
   └─ ワイルドカードの展開
3. バリデーション
   └─ TieringRequestValidator.validateHotToWarm()
4. インデックスごとの検証
   └─ 現在の層、状態、設定の確認
5. ディスク容量チェック
   └─ DiskThresholdSettingsによる閾値確認
6. 移行実行
   └─ 受け入れられたインデックスの移行
7. 結果返却
   └─ 成功/失敗インデックスの報告
```

### フローチャート

```mermaid
flowchart TD
    A[Tieringリクエスト] --> B[インデックス名解決]
    B --> C{インデックス存在?}

    C -->|No| D[空レスポンス返却]
    C -->|Yes| E[TieringRequestValidator.validateHotToWarm]

    E --> F[各インデックスを検証]
    F --> G{現在Hot層?}

    G -->|No| H[拒否リストに追加]
    G -->|Yes| I{読み取り専用?}

    I -->|Yes| H
    I -->|No| J{リモートストア有効?}

    J -->|No| H
    J -->|Yes| K{ディスク容量OK?}

    K -->|No| H
    K -->|Yes| L[受け入れリストに追加]

    H --> M{全インデックス処理完了?}
    L --> M

    M -->|No| F
    M -->|Yes| N{受け入れリスト空?}

    N -->|Yes| O[バリデーション結果のみ返却]
    N -->|No| P[移行実行]

    P --> Q[結果返却]
```

## ビジネスルール

### 業務ルール

| ルールNo | ルール名 | 内容 | 適用条件 |
|---------|---------|------|---------|
| BR-01 | Hot層のみ移行可能 | Warm層への移行はHot層からのみ | 常時 |
| BR-02 | 読み取り専用不可 | 読み取り専用インデックスは移行不可 | 常時 |
| BR-03 | リモートストア必須 | リモートストアが有効なインデックスのみ対象 | 常時 |
| BR-04 | ディスク容量チェック | 移行先のディスク容量が閾値以下であること | 常時 |
| BR-05 | WARMのみサポート | 現在のターゲット層はWARMのみ | 常時 |

### TieringValidationResult

```
TieringValidationResult {
  acceptedIndices: Set<Index>    // 移行受け入れインデックス
  rejectedIndices: Map<Index, String>  // 拒否インデックスと理由
}
```

## データベース操作仕様

### 操作別データベース影響一覧

| 操作 | 対象 | 操作種別 | 概要 |
|-----|------|---------|------|
| 層移行 | IndexMetadata | UPDATE | インデックスの層情報更新 |
| シャード移動 | RoutingTable | UPDATE | シャードのノード移動 |

## エラー処理

### エラーケース一覧

| エラーコード | エラー種別 | 発生条件 | 対処方法 |
|------------|----------|---------|---------|
| 400 | ActionRequestValidationException | インデックス未指定 | インデックスを指定 |
| 400 | ActionRequestValidationException | 無効なターゲット層 | WARMを指定 |
| 400 | IllegalArgumentException | 対象インデックスがHot層でない | Hot層のインデックスを選択 |
| 400 | - | リモートストア未有効 | リモートストアを有効化 |
| 400 | - | 読み取り専用インデックス | 読み取り専用を解除 |

### リトライ仕様

個別インデックスの移行失敗は、レスポンスのfailedIndicesに報告される。失敗したインデックスは再度リクエストすることで再試行可能。

## トランザクション仕様

インデックス単位で移行処理が実行される。一部のインデックスが失敗しても、他のインデックスの移行は継続される。

## パフォーマンス要件

- 移行はクラスタマネージャノードで調整
- 実際のデータ移動はバックグラウンドで実行
- wait_for_completion=trueの場合、完了まで同期待機

## セキュリティ考慮事項

- `indices:admin/tiering/hot_to_warm`権限が必要
- 誤操作防止のため、バリデーションで複数の条件をチェック

## 備考

- 実験的機能（@ExperimentalApi）
- 現在はHot→Warmの一方向のみサポート
- Index State Management（ISM）と組み合わせて自動化可能

---

## コードリーディングガイド

本機能を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: リクエスト/レスポンスを理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | TieringIndexRequest.java | `server/src/main/java/org/opensearch/action/admin/indices/tiering/TieringIndexRequest.java` | リクエストデータ構造、Tier列挙型 |
| 1-2 | HotToWarmTieringResponse.java | `server/src/main/java/org/opensearch/action/admin/indices/tiering/HotToWarmTieringResponse.java` | レスポンスデータ構造 |
| 1-3 | TieringValidationResult.java | `server/src/main/java/org/opensearch/action/admin/indices/tiering/TieringValidationResult.java` | バリデーション結果 |

#### Step 2: Transport Actionを理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | TransportHotToWarmTieringAction.java | `server/src/main/java/org/opensearch/action/admin/indices/tiering/TransportHotToWarmTieringAction.java` | メインアクションクラス |
| 2-2 | HotToWarmTieringAction.java | `server/src/main/java/org/opensearch/action/admin/indices/tiering/HotToWarmTieringAction.java` | アクション定義 |

**TransportHotToWarmTieringAction主要処理**:
- **92-113行目**: clusterManagerOperation() -- メイン処理フロー
- **102-107行目**: validateHotToWarm() -- バリデーション呼び出し

#### Step 3: バリデーションを理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | TieringRequestValidator.java | `server/src/main/java/org/opensearch/indices/tiering/TieringRequestValidator.java` | バリデーションロジック |

#### Step 4: REST APIを理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 4-1 | RestWarmTieringAction.java | `server/src/main/java/org/opensearch/action/admin/indices/tiering/RestWarmTieringAction.java` | REST APIハンドラ |

### プログラム呼び出し階層図

```
REST API (POST /{index}/_tier/warm)
    |
    +-- RestWarmTieringAction
          |
          +-- TieringIndexRequest作成
          |
          +-- TransportHotToWarmTieringAction.execute()
                |
                +-- clusterManagerOperation()
                      |
                      +-- indexNameExpressionResolver.concreteResolvedIndices()
                      |
                      +-- TieringRequestValidator.validateHotToWarm()
                      |     +-- インデックスごとの検証
                      |     +-- ディスク容量チェック
                      |     +-- TieringValidationResult作成
                      |
                      +-- (移行実行 - 実装継続中)
                      |
                      +-- HotToWarmTieringResponse返却
```

### データフロー図

```
[入力]                          [処理]                              [出力]

TieringIndexRequest -------> TransportHotToWarmTieringAction -----> HotToWarmTieringResponse
 (indices[],                   |                                     (acknowledged,
  targetTier=WARM,             +-> インデックス解決                    failedIndices[])
  waitForCompletion)           |
                               +-> TieringRequestValidator
                               |     +-> 各インデックス検証
                               |     |     - Hot層確認
                               |     |     - 読み取り専用確認
                               |     |     - リモートストア確認
                               |     +-> ディスク容量確認
                               |     +-> TieringValidationResult
                               |
                               +-> 移行実行（acceptedIndices）
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| TieringIndexRequest.java | `server/src/main/java/org/opensearch/action/admin/indices/tiering/TieringIndexRequest.java` | ソース | リクエスト |
| HotToWarmTieringResponse.java | `server/src/main/java/org/opensearch/action/admin/indices/tiering/HotToWarmTieringResponse.java` | ソース | レスポンス |
| TieringValidationResult.java | `server/src/main/java/org/opensearch/action/admin/indices/tiering/TieringValidationResult.java` | ソース | バリデーション結果 |
| TransportHotToWarmTieringAction.java | `server/src/main/java/org/opensearch/action/admin/indices/tiering/TransportHotToWarmTieringAction.java` | ソース | メインアクション |
| HotToWarmTieringAction.java | `server/src/main/java/org/opensearch/action/admin/indices/tiering/HotToWarmTieringAction.java` | ソース | アクション定義 |
| RestWarmTieringAction.java | `server/src/main/java/org/opensearch/action/admin/indices/tiering/RestWarmTieringAction.java` | ソース | REST API |
| TieringRequestValidator.java | `server/src/main/java/org/opensearch/indices/tiering/TieringRequestValidator.java` | ソース | バリデータ |
