# 機能設計書 65-リポジトリ管理

## 概要

本ドキュメントは、OpenSearchのスナップショットリポジトリ管理機能に関する機能設計書である。本機能はスナップショットの保存先となるリポジトリの登録・更新・削除・検証・クリーンアップを行うRepositoriesServiceを中心に実装されている。

### 本機能の処理概要

**業務上の目的・背景**：スナップショット機能を利用するためには、スナップショットデータの保存先となるリポジトリをクラスタに登録する必要がある。リポジトリ管理はスナップショットのライフサイクル全体の基盤となる機能である。

**機能の利用シーン**：スナップショット機能の初期設定時にリポジトリを登録する。また、リポジトリの設定変更、不要になったリポジトリの削除、リポジトリの整合性検証、古いデータのクリーンアップ等に利用される。

**主要な処理内容**：
1. リポジトリの登録・更新（PutRepositoryRequest処理）
2. リポジトリ情報の取得
3. リポジトリの削除（DeleteRepositoryRequest処理）
4. リポジトリの検証（全ノードでの書き込み/読み取り確認）
5. リポジトリのクリーンアップ（古いデータの削除）
6. リポジトリ設定のリロード（reloadableSettings対応）

**関連システム・外部連携**：S3、Azure Blob Storage、GCS、HDFS、共有ファイルシステム等のバックエンドストレージと連携。各ストレージ種別はプラグインとして提供される。

**権限による制御**：リポジトリの登録・削除にはcluster:admin/repository権限が必要。リポジトリ情報の取得にはcluster:monitor/repository権限が必要。

## 関連画面

| 画面No | 画面名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| 115 | リポジトリ作成 | 主機能 | スナップショットリポジトリを作成する処理 |
| 116 | リポジトリ取得 | 主機能 | スナップショットリポジトリの情報を返す処理 |
| 117 | リポジトリ削除 | 主機能 | スナップショットリポジトリを削除する処理 |
| 118 | リポジトリ検証 | 主機能 | スナップショットリポジトリを検証する処理 |
| 119 | リポジトリクリーンアップ | 主機能 | リポジトリから古いデータを削除するクリーンアップ処理 |
| 158 | Cat リポジトリ | 主機能 | 登録されたスナップショットリポジトリ情報をテーブル形式で返す処理 |

## 機能種別

CRUD操作 / 設定管理

## 入力仕様

### 入力パラメータ

| パラメータ名 | 型 | 必須 | 説明 | バリデーション |
|-------------|-----|-----|------|---------------|
| name | String | Yes | リポジトリ名 | 有効な名前（英数字、ハイフン、アンダースコア） |
| type | String | Yes (作成時) | リポジトリタイプ（s3, azure, gcs, hdfs, fs等） | 登録済みタイプ名 |
| settings | Settings | No | リポジトリ設定（bucket, base_path, chunk_size等） | タイプ固有のバリデーション |
| verify | boolean | No | 登録後に検証を行うか | デフォルトtrue |

### 入力データソース

REST API（PUT /_snapshot/{repository}、DELETE /_snapshot/{repository}等）

## 出力仕様

### 出力データ

| 項目名 | 型 | 説明 |
|--------|-----|------|
| acknowledged | boolean | 操作が承認されたか |
| type | String | リポジトリタイプ |
| settings | Object | リポジトリ設定 |

### 出力先

REST APIレスポンス、クラスタ状態（RepositoriesMetadata）

## 処理フロー

### 処理シーケンス

```
1. PutRepositoryRequestを受信
   └─ リポジトリ名のバリデーション
2. RepositoryMetadataの生成
   └─ 名前、タイプ、設定、暗号化メタデータの構築
3. リポジトリ設定の検証
   └─ validateRepositoryMetadataSettings()
4. リロード可能設定の判定
   └─ isReloadableSettingsで既存リポジトリとの比較
5. クラスタ状態更新（AckedClusterStateUpdateTask）
   └─ RepositoriesMetadataの更新
6. リポジトリインスタンスの生成
   └─ typesRegistryからFactoryを取得し、Repositoryを生成
7. 検証（verify=trueの場合）
   └─ VerifyNodeRepositoryActionで全ノードでの検証を実行
```

### フローチャート

```mermaid
flowchart TD
    A[PutRepositoryRequest] --> B[リポジトリ名バリデーション]
    B --> C[RepositoryMetadata生成]
    C --> D[設定検証]
    D --> E{リロード可能?}
    E -->|Yes| F[設定マージ]
    E -->|No| G[新規リポジトリ作成]
    F --> H[ClusterState更新]
    G --> H
    H --> I{verify=true?}
    I -->|Yes| J[全ノード検証]
    I -->|No| K[レスポンス返却]
    J --> K
```

## ビジネスルール

### 業務ルール

| ルールNo | ルール名 | 内容 | 適用条件 |
|---------|---------|------|---------|
| BR-65-01 | リポジトリ名バリデーション | リポジトリ名は有効な文字列でなければならない | リポジトリ登録時 |
| BR-65-02 | 使用中リポジトリ削除制限 | スナップショット作成中・リストア中・削除中のリポジトリは削除不可 | リポジトリ削除時 |
| BR-65-03 | タイプ登録確認 | 指定されたリポジトリタイプが登録されている必要がある | リポジトリ登録時 |
| BR-65-04 | ノード適格性 | リポジトリはデータノードとクラスタマネージャノードでのみ維持される | クラスタ状態適用時 |
| BR-65-05 | 統計アーカイブ | リポジトリ統計は2時間保持、最大100件アーカイブ | 統計管理 |

### 計算ロジック

特になし

## データベース操作仕様

### 操作別データベース影響一覧

| 操作 | 対象テーブル | 操作種別 | 概要 |
|-----|-------------|---------|------|
| リポジトリ登録 | クラスタ状態 | INSERT/UPDATE | RepositoriesMetadataの追加/更新 |
| リポジトリ削除 | クラスタ状態 | DELETE | RepositoriesMetadataからの削除 |
| 検証 | リポジトリBlobStore | READ/WRITE | テストデータの書込/読取 |

### テーブル別操作詳細

#### クラスタ状態 (RepositoriesMetadata)

| 操作 | 項目（カラム名） | 更新値・取得条件 | 備考 |
|-----|-----------------|-----------------|------|
| INSERT/UPDATE | repositories | RepositoryMetadata（name, type, settings, cryptoMetadata） | AckedClusterStateUpdateTaskで更新 |
| DELETE | repositories | 指定リポジトリ名に該当するエントリ | 使用中でないことを確認後 |

## エラー処理

### エラーケース一覧

| エラーコード | エラー種別 | 発生条件 | 対処方法 |
|------------|----------|---------|---------|
| RepositoryException | リポジトリエラー | リポジトリの生成・操作の失敗 | 設定の確認 |
| RepositoryMissingException | 存在エラー | 指定リポジトリが存在しない | リポジトリ名の確認 |
| RepositoryVerificationException | 検証エラー | ノードでの検証失敗 | ネットワーク・ストレージ接続の確認 |
| IllegalStateException | 状態エラー | 使用中リポジトリの削除 | 操作完了後に再試行 |

### リトライ仕様

ClusterManagerTaskThrottlerによりputRepositoryTaskKey、deleteRepositoryTaskKeyでタスクスロットリングが適用される。スロットル時はTransportClusterManagerNodeActionからリトライされる。

## トランザクション仕様

リポジトリの登録・削除はAckedClusterStateUpdateTaskを通じて実行され、クラスタ全体での承認（Ack）を取得してからコミットされる。

## パフォーマンス要件

- リポジトリ統計のアーカイブは保持期間2時間、最大100件（REPOSITORIES_STATS_ARCHIVE_RETENTION_PERIOD, REPOSITORIES_STATS_ARCHIVE_MAX_ARCHIVED_STATS設定）
- Voting-only専用ノードではリポジトリ管理をスキップし、リソース消費を回避

## セキュリティ考慮事項

- リポジトリ設定にはストレージ認証情報が含まれる可能性があるため、SecureSettingの使用を推奨
- CryptoMetadataによるリポジトリデータの暗号化をサポート
- SYSTEM_REPOSITORY_SETTINGによるシステムリポジトリの識別

## 備考

- RepositoriesServiceはAbstractLifecycleComponentを継承し、ライフサイクル管理される
- ClusterStateApplierインターフェースを実装し、クラスタ状態変更時にリポジトリインスタンスを更新
- internalTypesRegistryにより内部リポジトリタイプ（URL等）もサポート

---

## コードリーディングガイド

本機能を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: データ構造を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | Repository.java | `server/src/main/java/org/opensearch/repositories/Repository.java` | Repositoryインターフェース定義、Factory内部インターフェース |
| 1-2 | RepositoryData.java | `server/src/main/java/org/opensearch/repositories/RepositoryData.java` | リポジトリ内のスナップショット・インデックスメタデータ |
| 1-3 | RepositoryInfo.java | `server/src/main/java/org/opensearch/repositories/RepositoryInfo.java` | リポジトリ情報モデル |

#### Step 2: エントリーポイントを理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | RepositoriesService.java | `server/src/main/java/org/opensearch/repositories/RepositoriesService.java` | メインサービスクラス |

**主要処理フロー**:
1. **101行目**: クラス宣言、AbstractLifecycleComponent継承、ClusterStateApplier実装
2. **105-116行目**: 統計アーカイブ設定（保持期間2時間、最大100件）
3. **118-119行目**: typesRegistry, internalTypesRegistry - リポジトリタイプの登録マップ
4. **134-163行目**: コンストラクタ - 依存関係の初期化、タスクスロットリング登録
5. **174-207行目**: registerOrUpdateRepository() - リポジトリ登録/更新の主要メソッド

#### Step 3: 検証とクリーンアップを理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | VerifyNodeRepositoryAction.java | `server/src/main/java/org/opensearch/repositories/VerifyNodeRepositoryAction.java` | 全ノードでのリポジトリ検証 |
| 3-2 | RepositoryCleanupResult.java | `server/src/main/java/org/opensearch/repositories/RepositoryCleanupResult.java` | クリーンアップ結果 |

### プログラム呼び出し階層図

```
REST API (PUT /_snapshot/{repository})
    |
    +-- TransportPutRepositoryAction
            |
            +-- RepositoriesService.registerOrUpdateRepository()
                    |
                    +-- validate() - 名前バリデーション
                    +-- validateRepositoryMetadataSettings() - 設定バリデーション
                    +-- AckedClusterStateUpdateTask - ClusterState更新
                    +-- VerifyNodeRepositoryAction.verify() - 全ノード検証
```

### データフロー図

```
[入力]                       [処理]                         [出力]

PutRepositoryRequest ──> RepositoriesService ──> ClusterState更新
                              |                     (RepositoriesMetadata)
                              +-- 設定バリデーション
                              +-- Repository生成
                              +-- 全ノード検証 ──> 検証結果
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| RepositoriesService.java | `server/src/main/java/org/opensearch/repositories/RepositoriesService.java` | ソース | リポジトリ管理のメインサービス |
| Repository.java | `server/src/main/java/org/opensearch/repositories/Repository.java` | ソース | リポジトリインターフェース |
| RepositoryData.java | `server/src/main/java/org/opensearch/repositories/RepositoryData.java` | ソース | リポジトリデータ管理 |
| RepositoriesModule.java | `server/src/main/java/org/opensearch/repositories/RepositoriesModule.java` | ソース | リポジトリモジュール（DI設定） |
| FilterRepository.java | `server/src/main/java/org/opensearch/repositories/FilterRepository.java` | ソース | フィルタリポジトリ基底クラス |
| RepositoriesStatsArchive.java | `server/src/main/java/org/opensearch/repositories/RepositoriesStatsArchive.java` | ソース | 統計アーカイブ |
| VerifyNodeRepositoryAction.java | `server/src/main/java/org/opensearch/repositories/VerifyNodeRepositoryAction.java` | ソース | ノード検証アクション |
| RepositoryCleanupResult.java | `server/src/main/java/org/opensearch/repositories/RepositoryCleanupResult.java` | ソース | クリーンアップ結果 |
| IndexId.java | `server/src/main/java/org/opensearch/repositories/IndexId.java` | ソース | インデックスID |
| ShardGenerations.java | `server/src/main/java/org/opensearch/repositories/ShardGenerations.java` | ソース | シャードジェネレーション管理 |
