# 機能設計書 67-Azureリポジトリ

## 概要

本ドキュメントは、OpenSearchのAzureリポジトリプラグインに関する機能設計書である。本プラグインはAzure Blob Storageをスナップショットリポジトリとして使用するための機能を提供し、AzureRepositoryPlugin/AzureRepository/AzureBlobStore/AzureBlobContainerの各クラスで実装されている。

### 本機能の処理概要

**業務上の目的・背景**：Microsoft Azure環境でOpenSearchを運用する場合、Azure Blob Storageはスナップショットデータの保存先として最適なストレージサービスである。本プラグインにより、Azure Blob Storageをスナップショットリポジトリとして使用できる。

**機能の利用シーン**：Azure環境でのOpenSearchクラスタのバックアップ・リストア、Azure内でのデータ移行、Azure Blob Storageの高耐久性を活用した長期データ保管等に利用される。

**主要な処理内容**：
1. Azure Blob Storageコンテナへのスナップショットデータの書き込み
2. Azure Blob Storageコンテナからのスナップショットデータの読み取り
3. Azureストレージサービス設定の管理（アカウント名、キー、SASトークン等）
4. ロケーションモード（PRIMARY_ONLY、SECONDARY_ONLY等）の設定
5. プロキシ設定のサポート
6. トークン認証（Managed Identity、Workload Identity等）のサポート

**関連システム・外部連携**：Azure Blob Storage SDK（com.azure.storage.blob）を使用してAzure Blob Storageと通信する。

**権限による制御**：Azure Blob Storageへのアクセスはアカウントキー、SASトークン、またはManaged Identityで制御される。

## 関連画面

| 画面No | 画面名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| 115 | リポジトリ作成 | 補助機能 | type=azureでAzureリポジトリを作成する処理 |

## 機能種別

データ連携 / プラグイン

## 入力仕様

### 入力パラメータ

| パラメータ名 | 型 | 必須 | 説明 | バリデーション |
|-------------|-----|-----|------|---------------|
| container | String | No | Azure Blobコンテナ名（デフォルト: "opensearch-snapshots"） | 有効なコンテナ名 |
| base_path | String | No | コンテナ内のベースパス | 有効なパス文字列 |
| client | String | No | クライアント名（デフォルト: "default"） | 設定済みクライアント名 |
| chunk_size | ByteSizeValue | No | チャンクサイズ | MIN_CHUNK_SIZE〜MAX_CHUNK_SIZE |
| compress | boolean | No | メタデータ圧縮の有効化 | true/false |
| location_mode | LocationMode | No | ロケーションモード（デフォルト: PRIMARY_ONLY） | 有効なLocationMode値 |

### 入力データソース

リポジトリ設定（PUT /_snapshot/{repository}）、opensearch.yml（クライアント設定）、opensearch-keystore（認証情報）

## 出力仕様

### 出力データ

| 項目名 | 型 | 説明 |
|--------|-----|------|
| Azure Blobs | Binary | スナップショットデータファイル |

### 出力先

Azure Blob Storageコンテナ

## 処理フロー

### 処理シーケンス

```
1. AzureRepositoryインスタンスの生成
   └─ MeteredBlobStoreRepositoryを継承
2. AzureBlobStoreの生成
   └─ AzureStorageServiceを通じてAzureクライアントを取得
3. データ書き込み
   └─ AzureBlobContainer.writeBlob()
4. データ読み取り
   └─ AzureBlobContainer.readBlob()
```

### フローチャート

```mermaid
flowchart TD
    A[リポジトリ操作要求] --> B{操作種別}
    B -->|書込| C[AzureBlobContainer.writeBlob]
    B -->|読取| D[AzureBlobContainer.readBlob]
    B -->|削除| E[AzureBlobContainer.deleteBlob]
    C --> F[AzureStorageService]
    D --> F
    E --> F
    F --> G[Azure Blob Storage]
```

## ビジネスルール

### 業務ルール

| ルールNo | ルール名 | 内容 | 適用条件 |
|---------|---------|------|---------|
| BR-67-01 | デフォルトコンテナ名 | コンテナ名未指定時は"opensearch-snapshots" | リポジトリ登録時 |
| BR-67-02 | チャンクサイズ範囲 | MIN_CHUNK_SIZE〜MAX_CHUNK_SIZE内 | リポジトリ設定時 |
| BR-67-03 | ロケーションモード | PRIMARY_ONLY, SECONDARY_ONLY等から選択 | リポジトリ設定時 |

### 計算ロジック

特になし

## データベース操作仕様

### 操作別データベース影響一覧

| 操作 | 対象テーブル | 操作種別 | 概要 |
|-----|-------------|---------|------|
| スナップショット保存 | Azure Blobコンテナ | WRITE | Block Blob API |
| スナップショット読取 | Azure Blobコンテナ | READ | Get Blob API |
| スナップショット削除 | Azure Blobコンテナ | DELETE | Delete Blob API |

### テーブル別操作詳細

#### Azure Blobコンテナ

| 操作 | 項目（カラム名） | 更新値・取得条件 | 備考 |
|-----|-----------------|-----------------|------|
| WRITE | {base_path}/indices/{indexId}/{shardId}/* | Luceneセグメントデータ | Block Blobとして保存 |
| WRITE | {base_path}/index-N | RepositoryData | アトミック更新 |

## エラー処理

### エラーケース一覧

| エラーコード | エラー種別 | 発生条件 | 対処方法 |
|------------|----------|---------|---------|
| BlobStoreException | ストアエラー | Azure API呼び出しの失敗 | Azure設定・権限の確認 |
| RepositoryException | リポジトリエラー | リポジトリ設定の不正 | 設定の修正 |

### リトライ仕様

Azure SDK内蔵のリトライポリシーによりリトライが行われる。

## トランザクション仕様

Azure Blob操作はオブジェクト単位でのアトミック操作。Block Blobの書き込みは単一操作で完了する。

## パフォーマンス要件

- チャンクサイズ設定による大容量ファイルの分割転送
- ロケーションモードによる読み取りパフォーマンスの最適化

## セキュリティ考慮事項

- 認証情報はkeystoreに保存（SecureSetting使用）
- SASトークン、アカウントキー、Managed Identity等の認証方法をサポート
- TokenCredentialTypeによるトークン認証のサポート

## 備考

- AzureRepositoryのTYPE定数は"azure"
- account設定はclient設定に置き換えられた（Deprecatedアノテーション付き）
- LocationMode列挙型でPRIMARY_ONLYがデフォルト

---

## コードリーディングガイド

本機能を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: データ構造を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | AzureStorageSettings.java | `plugins/repository-azure/src/main/java/org/opensearch/repositories/azure/AzureStorageSettings.java` | Azureストレージ設定のデータ構造 |
| 1-2 | LocationMode.java | `plugins/repository-azure/src/main/java/org/opensearch/repositories/azure/LocationMode.java` | ロケーションモード列挙型 |
| 1-3 | TokenCredentialType.java | `plugins/repository-azure/src/main/java/org/opensearch/repositories/azure/TokenCredentialType.java` | トークン認証タイプ |

#### Step 2: エントリーポイントを理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | AzureRepositoryPlugin.java | `plugins/repository-azure/src/main/java/org/opensearch/repositories/azure/AzureRepositoryPlugin.java` | プラグインエントリーポイント |
| 2-2 | AzureRepository.java | `plugins/repository-azure/src/main/java/org/opensearch/repositories/azure/AzureRepository.java` | Azureリポジトリ実装クラス |

**主要処理フロー**:
1. **70行目**: AzureRepositoryクラス宣言、MeteredBlobStoreRepositoryを継承
2. **73行目**: TYPE = "azure"
3. **76-83行目**: ACCOUNT_SETTING（deprecated）、CLIENT_NAME設定
4. **85-97行目**: CONTAINER_SETTING（デフォルト"opensearch-snapshots"）、BASE_PATH_SETTING、LOCATION_MODE_SETTING

#### Step 3: BlobStore層を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | AzureBlobStore.java | `plugins/repository-azure/src/main/java/org/opensearch/repositories/azure/AzureBlobStore.java` | Azure BlobStore実装 |
| 3-2 | AzureBlobContainer.java | `plugins/repository-azure/src/main/java/org/opensearch/repositories/azure/AzureBlobContainer.java` | Azure BlobContainer実装 |
| 3-3 | AzureStorageService.java | `plugins/repository-azure/src/main/java/org/opensearch/repositories/azure/AzureStorageService.java` | Azureストレージサービス管理 |

### プログラム呼び出し階層図

```
AzureRepositoryPlugin (プラグイン登録)
    |
    +-- AzureRepository (MeteredBlobStoreRepository)
            |
            +-- AzureBlobStore
                    |
                    +-- AzureStorageService
                    |       +-- Azure SDK BlobServiceClient
                    |
                    +-- AzureBlobContainer
                            +-- writeBlob() / readBlob()
```

### データフロー図

```
[入力]                        [処理]                            [出力]

スナップショットデータ ──> AzureRepository ──> AzureBlobStore ──> Azure Blob Storage
                                                |
                                                +-- AzureStorageService ──> Azure SDK
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| AzureRepositoryPlugin.java | `plugins/repository-azure/src/main/java/org/opensearch/repositories/azure/AzureRepositoryPlugin.java` | ソース | プラグインエントリーポイント |
| AzureRepository.java | `plugins/repository-azure/src/main/java/org/opensearch/repositories/azure/AzureRepository.java` | ソース | Azureリポジトリ実装 |
| AzureBlobStore.java | `plugins/repository-azure/src/main/java/org/opensearch/repositories/azure/AzureBlobStore.java` | ソース | Azure BlobStore実装 |
| AzureBlobContainer.java | `plugins/repository-azure/src/main/java/org/opensearch/repositories/azure/AzureBlobContainer.java` | ソース | Azure BlobContainer実装 |
| AzureStorageService.java | `plugins/repository-azure/src/main/java/org/opensearch/repositories/azure/AzureStorageService.java` | ソース | ストレージサービス管理 |
| AzureStorageSettings.java | `plugins/repository-azure/src/main/java/org/opensearch/repositories/azure/AzureStorageSettings.java` | ソース | ストレージ設定 |
| LocationMode.java | `plugins/repository-azure/src/main/java/org/opensearch/repositories/azure/LocationMode.java` | ソース | ロケーションモード列挙型 |
| ProxySettings.java | `plugins/repository-azure/src/main/java/org/opensearch/repositories/azure/ProxySettings.java` | ソース | プロキシ設定 |
| TokenCredentialType.java | `plugins/repository-azure/src/main/java/org/opensearch/repositories/azure/TokenCredentialType.java` | ソース | トークン認証タイプ |
