# 機能設計書 68-GCSリポジトリ

## 概要

本ドキュメントは、OpenSearchのGCSリポジトリプラグインに関する機能設計書である。本プラグインはGoogle Cloud Storage（GCS）をスナップショットリポジトリとして使用するための機能を提供し、GoogleCloudStoragePlugin/GoogleCloudStorageRepository/GoogleCloudStorageBlobStore/GoogleCloudStorageBlobContainerの各クラスで実装されている。

### 本機能の処理概要

**業務上の目的・背景**：Google Cloud Platform環境でOpenSearchを運用する場合、GCSはスナップショットデータの保存先として最適なストレージサービスである。本プラグインにより、GCSをスナップショットリポジトリとして使用できる。

**機能の利用シーン**：GCP環境でのOpenSearchクラスタのバックアップ・リストア、GCP内でのデータ移行等に利用される。

**主要な処理内容**：
1. GCSバケットへのスナップショットデータの書き込み
2. GCSバケットからのスナップショットデータの読み取り
3. GCSクライアント設定の管理（サービスアカウント認証、バケット名等）
4. HTTP統計の収集
5. リトライ戦略の管理（GoogleShouldRetryStorageStrategy）
6. プロキシ設定とTLSトラストストアのサポート

**関連システム・外部連携**：Google Cloud Storage JSON API（com.google.cloud.storage）を使用してGCSと通信する。サービスアカウントキーまたはApplication Default Credentialsで認証する。

**権限による制御**：GCSバケットへのアクセスはGCPのIAMポリシーで制御される。サービスアカウントキーの管理はkeystoreで行う。

## 関連画面

| 画面No | 画面名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| 115 | リポジトリ作成 | 補助機能 | type=gcsでGCSリポジトリを作成する処理 |

## 機能種別

データ連携 / プラグイン

## 入力仕様

### 入力パラメータ

| パラメータ名 | 型 | 必須 | 説明 | バリデーション |
|-------------|-----|-----|------|---------------|
| bucket | String | Yes | GCSバケット名 | 存在するGCSバケット |
| base_path | String | No | バケット内のベースパス | 有効なパス文字列 |
| client | String | No | クライアント名（デフォルト: "default"） | 設定済みクライアント名 |
| chunk_size | ByteSizeValue | No | チャンクサイズ（最小1B、最大5TB） | MIN_CHUNK_SIZE〜MAX_CHUNK_SIZE |
| compress | boolean | No | メタデータ圧縮の有効化 | true/false |

### 入力データソース

リポジトリ設定（PUT /_snapshot/{repository}）、opensearch.yml（クライアント設定）、opensearch-keystore（サービスアカウントキー）

## 出力仕様

### 出力データ

| 項目名 | 型 | 説明 |
|--------|-----|------|
| GCS Objects | Binary | スナップショットデータファイル |
| GoogleCloudStorageOperationsStats | Object | GCS操作の統計情報 |

### 出力先

Google Cloud Storageバケット

## 処理フロー

### 処理シーケンス

```
1. GoogleCloudStorageRepositoryインスタンスの生成
   └─ MeteredBlobStoreRepositoryを継承
2. GoogleCloudStorageBlobStoreの生成
   └─ GoogleCloudStorageServiceを通じてGCSクライアントを取得
3. データ書き込み
   └─ GoogleCloudStorageBlobContainer.writeBlob()
4. データ読み取り
   └─ GoogleCloudStorageBlobContainer.readBlob()
   └─ GoogleCloudStorageRetryingInputStream（リトライ対応）
5. 統計収集
   └─ GoogleCloudStorageHttpStatsCollector / GoogleCloudStorageOperationsStats
```

### フローチャート

```mermaid
flowchart TD
    A[リポジトリ操作要求] --> B{操作種別}
    B -->|書込| C[GoogleCloudStorageBlobContainer.writeBlob]
    B -->|読取| D[GoogleCloudStorageBlobContainer.readBlob]
    B -->|削除| E[GoogleCloudStorageBlobContainer.deleteBlob]
    C --> F[GoogleCloudStorageService]
    D --> F
    E --> F
    F --> G[Google Cloud Storage]
```

## ビジネスルール

### 業務ルール

| ルールNo | ルール名 | 内容 | 適用条件 |
|---------|---------|------|---------|
| BR-68-01 | バケット名必須 | bucketパラメータは必須 | リポジトリ登録時 |
| BR-68-02 | チャンクサイズ範囲 | 最小1バイト、最大5TB | リポジトリ設定時 |
| BR-68-03 | リトライ戦略 | GoogleShouldRetryStorageStrategyに基づくリトライ | GCS API呼出時 |

### 計算ロジック

特になし

## データベース操作仕様

### 操作別データベース影響一覧

| 操作 | 対象テーブル | 操作種別 | 概要 |
|-----|-------------|---------|------|
| スナップショット保存 | GCSバケット | WRITE | Cloud Storage JSON API |
| スナップショット読取 | GCSバケット | READ | Cloud Storage JSON API |
| スナップショット削除 | GCSバケット | DELETE | Cloud Storage JSON API |

### テーブル別操作詳細

#### GCSバケット

| 操作 | 項目（カラム名） | 更新値・取得条件 | 備考 |
|-----|-----------------|-----------------|------|
| WRITE | {base_path}/indices/{indexId}/{shardId}/* | Luceneセグメントデータ | |
| WRITE | {base_path}/index-N | RepositoryData | アトミック更新 |

## エラー処理

### エラーケース一覧

| エラーコード | エラー種別 | 発生条件 | 対処方法 |
|------------|----------|---------|---------|
| RepositoryException | リポジトリエラー | GCS API呼出の失敗 | GCS設定・権限の確認 |
| BlobStoreException | ストアエラー | BlobStore操作の失敗 | バケット設定の確認 |

### リトライ仕様

GoogleShouldRetryStorageStrategyにより、GCS API呼び出しのリトライが自動的に行われる。GoogleCloudStorageRetryingInputStreamにより読み取り操作のリトライも対応。

## トランザクション仕様

GCS操作はオブジェクト単位でのアトミック操作。

## パフォーマンス要件

- チャンクサイズ設定による大容量ファイルの分割転送
- HTTP統計収集（GoogleCloudStorageHttpStatsCollector）によるパフォーマンス監視

## セキュリティ考慮事項

- サービスアカウントキーはkeystoreに保存
- Application Default Credentials（GoogleApplicationDefaultCredentials）のサポート
- TLSトラストストア（TruststoreSettings）のカスタマイズが可能
- プロキシ設定（ProxySettings）によるネットワーク制御

## 備考

- GoogleCloudStorageRepositoryのTYPE定数は"gcs"
- 最大オブジェクトサイズは5TB（GCSの制限に準拠）
- GoogleShouldRetryStorageStrategyでGCS固有のリトライ判定を実装

---

## コードリーディングガイド

本機能を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: データ構造を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | GoogleCloudStorageClientSettings.java | `plugins/repository-gcs/src/main/java/org/opensearch/repositories/gcs/GoogleCloudStorageClientSettings.java` | GCSクライアント設定のデータ構造 |

#### Step 2: エントリーポイントを理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | GoogleCloudStoragePlugin.java | `plugins/repository-gcs/src/main/java/org/opensearch/repositories/gcs/GoogleCloudStoragePlugin.java` | プラグインエントリーポイント |
| 2-2 | GoogleCloudStorageRepository.java | `plugins/repository-gcs/src/main/java/org/opensearch/repositories/gcs/GoogleCloudStorageRepository.java` | GCSリポジトリ実装クラス |

**主要処理フロー**:
1. **58行目**: GoogleCloudStorageRepositoryクラス宣言、MeteredBlobStoreRepositoryを継承
2. **62-68行目**: MIN_CHUNK_SIZE（1バイト）、MAX_CHUNK_SIZE（5TB）の定義
3. **70行目**: TYPE = "gcs"
4. **72-82行目**: BUCKET、BASE_PATH、CHUNK_SIZE、CLIENT_NAME設定

#### Step 3: BlobStore層を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | GoogleCloudStorageBlobStore.java | `plugins/repository-gcs/src/main/java/org/opensearch/repositories/gcs/GoogleCloudStorageBlobStore.java` | GCS BlobStore実装 |
| 3-2 | GoogleCloudStorageBlobContainer.java | `plugins/repository-gcs/src/main/java/org/opensearch/repositories/gcs/GoogleCloudStorageBlobContainer.java` | GCS BlobContainer実装 |

### プログラム呼び出し階層図

```
GoogleCloudStoragePlugin (プラグイン登録)
    |
    +-- GoogleCloudStorageRepository (MeteredBlobStoreRepository)
            |
            +-- GoogleCloudStorageBlobStore
                    |
                    +-- GoogleCloudStorageService
                    |       +-- Google Cloud Storage Client
                    |
                    +-- GoogleCloudStorageBlobContainer
                    |       +-- writeBlob() / readBlob()
                    |
                    +-- GoogleCloudStorageRetryingInputStream
                    +-- GoogleShouldRetryStorageStrategy
                    +-- GoogleCloudStorageHttpStatsCollector
```

### データフロー図

```
[入力]                        [処理]                                [出力]

スナップショットデータ ──> GCSRepository ──> GCSBlobStore ──> Google Cloud Storage
                                              |
                                              +-- GoogleCloudStorageService ──> GCS API
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| GoogleCloudStoragePlugin.java | `plugins/repository-gcs/src/main/java/org/opensearch/repositories/gcs/GoogleCloudStoragePlugin.java` | ソース | プラグインエントリーポイント |
| GoogleCloudStorageRepository.java | `plugins/repository-gcs/src/main/java/org/opensearch/repositories/gcs/GoogleCloudStorageRepository.java` | ソース | GCSリポジトリ実装 |
| GoogleCloudStorageBlobStore.java | `plugins/repository-gcs/src/main/java/org/opensearch/repositories/gcs/GoogleCloudStorageBlobStore.java` | ソース | GCS BlobStore実装 |
| GoogleCloudStorageBlobContainer.java | `plugins/repository-gcs/src/main/java/org/opensearch/repositories/gcs/GoogleCloudStorageBlobContainer.java` | ソース | GCS BlobContainer実装 |
| GoogleCloudStorageService.java | `plugins/repository-gcs/src/main/java/org/opensearch/repositories/gcs/GoogleCloudStorageService.java` | ソース | GCSサービス管理 |
| GoogleCloudStorageClientSettings.java | `plugins/repository-gcs/src/main/java/org/opensearch/repositories/gcs/GoogleCloudStorageClientSettings.java` | ソース | クライアント設定 |
| GoogleCloudStorageRetryingInputStream.java | `plugins/repository-gcs/src/main/java/org/opensearch/repositories/gcs/GoogleCloudStorageRetryingInputStream.java` | ソース | リトライ対応InputStream |
| GoogleShouldRetryStorageStrategy.java | `plugins/repository-gcs/src/main/java/org/opensearch/repositories/gcs/GoogleShouldRetryStorageStrategy.java` | ソース | リトライ戦略 |
| GoogleCloudStorageHttpStatsCollector.java | `plugins/repository-gcs/src/main/java/org/opensearch/repositories/gcs/GoogleCloudStorageHttpStatsCollector.java` | ソース | HTTP統計収集 |
| GoogleCloudStorageOperationsStats.java | `plugins/repository-gcs/src/main/java/org/opensearch/repositories/gcs/GoogleCloudStorageOperationsStats.java` | ソース | 操作統計 |
| GoogleApplicationDefaultCredentials.java | `plugins/repository-gcs/src/main/java/org/opensearch/repositories/gcs/GoogleApplicationDefaultCredentials.java` | ソース | デフォルト認証情報 |
| ProxySettings.java | `plugins/repository-gcs/src/main/java/org/opensearch/repositories/gcs/ProxySettings.java` | ソース | プロキシ設定 |
| TruststoreSettings.java | `plugins/repository-gcs/src/main/java/org/opensearch/repositories/gcs/TruststoreSettings.java` | ソース | トラストストア設定 |
