# 機能設計書 69-HDFSリポジトリ

## 概要

本ドキュメントは、OpenSearchのHDFSリポジトリプラグインに関する機能設計書である。本プラグインはHadoop Distributed File System（HDFS）をスナップショットリポジトリとして使用するための機能を提供し、HdfsPlugin/HdfsRepository/HdfsBlobStore/HdfsBlobContainerの各クラスで実装されている。

### 本機能の処理概要

**業務上の目的・背景**：Hadoopエコシステムを使用する環境において、HDFSは大容量データの分散保存に適したファイルシステムである。本プラグインにより、既存のHDFSインフラストラクチャをOpenSearchのスナップショットリポジトリとして活用できる。

**機能の利用シーン**：Hadoop環境でのOpenSearchクラスタのバックアップ・リストア、HDFSの高冗長性を活用したデータ保管、Hadoopクラスタとの連携等に利用される。

**主要な処理内容**：
1. HDFSへのスナップショットデータの書き込み
2. HDFSからのスナップショットデータの読み取り
3. HDFS接続設定の管理（URI、パス、Hadoop設定等）
4. Kerberos認証のサポート
5. HANameNode対応（フェイルオーバー）

**関連システム・外部連携**：Apache Hadoop HDFS（org.apache.hadoop.fs）を使用してHDFSと通信する。Kerberos認証、HANameNodeフェイルオーバーをサポート。

**権限による制御**：HDFSへのアクセスはHadoopのACLおよびKerberos認証で制御される。security.principal設定によりKerberosプリンシパルを指定する。

## 関連画面

| 画面No | 画面名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| 115 | リポジトリ作成 | 補助機能 | type=hdfsでHDFSリポジトリを作成する処理 |

## 機能種別

データ連携 / プラグイン

## 入力仕様

### 入力パラメータ

| パラメータ名 | 型 | 必須 | 説明 | バリデーション |
|-------------|-----|-----|------|---------------|
| uri | String | Yes | HDFS URI（例: hdfs://namenode:8020） | hdfsスキームのURI |
| path | String | Yes | HDFS上のリポジトリパス | 有効なHDFSパス |
| chunk_size | ByteSizeValue | No | チャンクサイズ | 正のバイトサイズ値 |
| compress | boolean | No | メタデータ圧縮の有効化 | true/false |
| security.principal | String | No | Kerberosプリンシパル名 | 有効なプリンシパル名 |
| conf.* | String | No | Hadoop設定のオーバーライド | 有効なHadoop設定キー |

### 入力データソース

リポジトリ設定（PUT /_snapshot/{repository}）

## 出力仕様

### 出力データ

| 項目名 | 型 | 説明 |
|--------|-----|------|
| HDFS Files | Binary | スナップショットデータファイル |

### 出力先

HDFS（Hadoop Distributed File System）

## 処理フロー

### 処理シーケンス

```
1. HdfsRepositoryインスタンスの生成
   └─ BlobStoreRepositoryを継承（MeteredBlobStoreRepositoryではない）
2. HDFS URIの解析とバリデーション
   └─ hdfsスキームのみ許可
3. Hadoop Configurationの構築
   └─ デフォルト設定 + conf.*によるオーバーライド
4. Kerberos認証（必要な場合）
   └─ security.principalの設定に基づく
5. FileContextの生成
   └─ HdfsSecurityContextを使用したセキュアなアクセス
6. HdfsBlobStoreの生成
   └─ FileContext経由でHDFS操作
```

### フローチャート

```mermaid
flowchart TD
    A[リポジトリ操作要求] --> B[Hadoop Configuration構築]
    B --> C{Kerberos認証必要?}
    C -->|Yes| D[SecurityUtil.login]
    C -->|No| E[FileContext生成]
    D --> E
    E --> F{操作種別}
    F -->|書込| G[HdfsBlobContainer.writeBlob]
    F -->|読取| H[HdfsBlobContainer.readBlob]
    F -->|削除| I[HdfsBlobContainer.deleteBlob]
    G --> J[HDFS]
    H --> J
    I --> J
```

## ビジネスルール

### 業務ルール

| ルールNo | ルール名 | 内容 | 適用条件 |
|---------|---------|------|---------|
| BR-69-01 | URI必須 | uri設定は必須。未指定時はIllegalArgumentException | リポジトリ登録時 |
| BR-69-02 | hdfsスキーム限定 | URIのスキームはhdfsのみ許可 | リポジトリ登録時 |
| BR-69-03 | セキュリティコンテキスト | SpecialPermissionチェック後にAccessControllerで特権操作を実行 | 全HDFS操作時 |

### 計算ロジック

特になし

## データベース操作仕様

### 操作別データベース影響一覧

| 操作 | 対象テーブル | 操作種別 | 概要 |
|-----|-------------|---------|------|
| スナップショット保存 | HDFS | WRITE | FileContext.create() |
| スナップショット読取 | HDFS | READ | FileContext.open() |
| スナップショット削除 | HDFS | DELETE | FileContext.delete() |

### テーブル別操作詳細

#### HDFS

| 操作 | 項目（カラム名） | 更新値・取得条件 | 備考 |
|-----|-----------------|-----------------|------|
| WRITE | {path}/indices/{indexId}/{shardId}/* | Luceneセグメントデータ | |
| WRITE | {path}/index-N | RepositoryData | |

## エラー処理

### エラーケース一覧

| エラーコード | エラー種別 | 発生条件 | 対処方法 |
|------------|----------|---------|---------|
| IllegalArgumentException | パラメータエラー | URI未指定またはhdfs以外のスキーム | URIの修正 |
| UnsupportedFileSystemException | ファイルシステムエラー | 非対応のファイルシステム | Hadoop設定の確認 |
| IOException | I/Oエラー | HDFS操作の失敗 | HDFSクラスタの状態確認 |

### リトライ仕様

Hadoop内蔵のリトライ機構（FailoverProxyProvider）によりNameNodeフェイルオーバー時のリトライが行われる。

## トランザクション仕様

HDFS操作はファイル単位。HDFSのアトミック性はファイル作成・リネーム操作で保証される。

## パフォーマンス要件

- HDFSのブロックレプリケーションによるデータ冗長性
- チャンクサイズ設定による転送サイズの最適化
- HANameNode対応によるNameNode障害時の自動フェイルオーバー

## セキュリティ考慮事項

- Kerberos認証（security.principal設定）によるセキュアなHDFSアクセス
- SpecialPermission/AccessControllerによるJavaセキュリティマネージャとの連携
- HdfsSecurityContextによるセキュリティコンテキスト管理

## 備考

- HdfsRepositoryはBlobStoreRepositoryを直接継承（MeteredBlobStoreRepositoryではない）
- Java Security Managerとの互換性のためAccessControllerを使用した特権操作が必要
- Hadoop Configurationのconf.*プレフィックスによるHadoop設定のオーバーライドをサポート

---

## コードリーディングガイド

本機能を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: エントリーポイントを理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | HdfsPlugin.java | `plugins/repository-hdfs/src/main/java/org/opensearch/repositories/hdfs/HdfsPlugin.java` | プラグインエントリーポイント |
| 1-2 | HdfsRepository.java | `plugins/repository-hdfs/src/main/java/org/opensearch/repositories/hdfs/HdfsRepository.java` | HDFSリポジトリ実装クラス |

**主要処理フロー**:
1. **67行目**: HdfsRepositoryクラス宣言、BlobStoreRepositoryを直接継承（finalクラス）
2. **71行目**: CONF_SECURITY_PRINCIPAL = "security.principal"
3. **79-85行目**: コンストラクタ - RepositoryMetadata, Environment, NamedXContentRegistry, ClusterService, RecoverySettings
4. **89行目**: chunk_size設定の取得
5. **91-100行目**: URI解析とhdfsスキームバリデーション

#### Step 2: BlobStore層を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | HdfsBlobStore.java | `plugins/repository-hdfs/src/main/java/org/opensearch/repositories/hdfs/HdfsBlobStore.java` | HDFS BlobStore実装 |
| 2-2 | HdfsBlobContainer.java | `plugins/repository-hdfs/src/main/java/org/opensearch/repositories/hdfs/HdfsBlobContainer.java` | HDFS BlobContainer実装 |

#### Step 3: セキュリティを理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | HdfsSecurityContext.java | `plugins/repository-hdfs/src/main/java/org/opensearch/repositories/hdfs/HdfsSecurityContext.java` | HDFSセキュリティコンテキスト管理 |

### プログラム呼び出し階層図

```
HdfsPlugin (プラグイン登録)
    |
    +-- HdfsRepository (BlobStoreRepository)
            |
            +-- HdfsBlobStore
            |       |
            |       +-- FileContext (Hadoop)
            |       |       +-- AbstractFileSystem
            |       |
            |       +-- HdfsBlobContainer
            |               +-- writeBlob() / readBlob()
            |
            +-- HdfsSecurityContext
                    +-- UserGroupInformation
                    +-- AccessController (PrivilegedAction)
```

### データフロー図

```
[入力]                        [処理]                        [出力]

スナップショットデータ ──> HdfsRepository ──> HdfsBlobStore ──> HDFS
                                              |
                                              +-- FileContext ──> Hadoop FileSystem
                                              +-- HdfsSecurityContext ──> Kerberos認証
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| HdfsPlugin.java | `plugins/repository-hdfs/src/main/java/org/opensearch/repositories/hdfs/HdfsPlugin.java` | ソース | プラグインエントリーポイント |
| HdfsRepository.java | `plugins/repository-hdfs/src/main/java/org/opensearch/repositories/hdfs/HdfsRepository.java` | ソース | HDFSリポジトリ実装 |
| HdfsBlobStore.java | `plugins/repository-hdfs/src/main/java/org/opensearch/repositories/hdfs/HdfsBlobStore.java` | ソース | HDFS BlobStore実装 |
| HdfsBlobContainer.java | `plugins/repository-hdfs/src/main/java/org/opensearch/repositories/hdfs/HdfsBlobContainer.java` | ソース | HDFS BlobContainer実装 |
| HdfsSecurityContext.java | `plugins/repository-hdfs/src/main/java/org/opensearch/repositories/hdfs/HdfsSecurityContext.java` | ソース | セキュリティコンテキスト |
