# 機能設計書 7-インデックステンプレート

## 概要

本ドキュメントは、OpenSearchにおけるインデックステンプレート機能の設計を記述する。インデックス作成時に自動適用されるテンプレート（マッピング・設定・エイリアス）を管理する機能である。

### 本機能の処理概要

インデックステンプレート機能は、インデックス名のパターンに基づいて、インデックス作成時に自動的に適用される設定、マッピング、エイリアスのテンプレートを管理する。レガシーテンプレート（V1）、Composableテンプレート（V2）、コンポーネントテンプレートの3種類をサポートする。

**業務上の目的・背景**：複数のインデックスに共通する設定やマッピングを一元管理し、インデックス作成時の設定漏れや不整合を防ぐ。特に時系列データのインデックスでは、ロールオーバーにより頻繁に新しいインデックスが作成されるため、テンプレートによる自動適用が不可欠。

**機能の利用シーン**：ログ用インデックスの共通マッピング定義、時系列データのシャード数・レプリカ数の一括設定、データストリームのバッキングインデックス設定。

**主要な処理内容**：
1. テンプレートの登録（PUT）：名前、パターン、設定、マッピング、エイリアスの登録
2. テンプレートの取得（GET）：名前指定でテンプレート情報を取得
3. テンプレートの削除（DELETE）：指定テンプレートの削除
4. テンプレートのシミュレーション（POST）：テンプレート適用結果のプレビュー

**関連システム・外部連携**：インデックス作成機能と連携し、パターン一致時に自動適用される。データストリーム機能はComposableテンプレートに依存する。

**権限による制御**：`indices:admin/template/put`、`indices:admin/template/get`、`indices:admin/template/delete`等のアクション権限が必要。

## 関連画面

| 画面No | 画面名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| 61 | インデックステンプレート取得（レガシー） | 主画面 | レガシーインデックステンプレートを返す処理 |
| 62 | インデックステンプレート作成（レガシー） | 主画面 | レガシーインデックステンプレートを作成または更新する処理 |
| 63 | インデックステンプレート削除（レガシー） | 主画面 | レガシーインデックステンプレートを削除する処理 |
| 64 | インデックステンプレート存在確認（レガシー） | 主画面 | レガシーインデックステンプレートの存在を確認する処理 |
| 65 | Composableインデックステンプレート取得 | 主画面 | Composableインデックステンプレートを返す処理 |
| 66 | Composableインデックステンプレート作成 | 主画面 | Composableインデックステンプレートを作成または更新する処理 |
| 67 | Composableインデックステンプレート削除 | 主画面 | Composableインデックステンプレートを削除する処理 |
| 68 | Composableインデックステンプレート存在確認 | 主画面 | Composableインデックステンプレートの存在を確認する処理 |
| 69 | コンポーネントテンプレート取得 | 主画面 | コンポーネントテンプレートを返す処理 |
| 70 | コンポーネントテンプレート作成 | 主画面 | コンポーネントテンプレートを作成または更新する処理 |
| 71 | コンポーネントテンプレート削除 | 主画面 | コンポーネントテンプレートを削除する処理 |
| 72 | コンポーネントテンプレート存在確認 | 主画面 | コンポーネントテンプレートの存在を確認する処理 |
| 73 | インデックステンプレートシミュレーション | 主画面 | テンプレート適用シミュレーション処理 |
| 74 | テンプレートシミュレーション | 主画面 | テンプレート解決シミュレーション処理 |
| 164 | Cat テンプレート | 参照画面 | テンプレート情報をテーブル形式で表示 |

## 機能種別

CRUD操作（Create/Read/Delete）/ クラスタ状態管理

## 入力仕様

### 入力パラメータ（レガシーテンプレート PUT）

| パラメータ名 | 型 | 必須 | 説明 | バリデーション |
|-------------|-----|-----|------|---------------|
| name | String | Yes | テンプレート名 | 空でないこと |
| patterns | List\<String\> | Yes | インデックス名パターン | 空でないこと |
| order | int | No | テンプレート優先順序 | - |
| version | Integer | No | テンプレートバージョン | - |
| settings | Settings | No | インデックス設定 | - |
| mappings | String | No | マッピング定義 | JSON形式 |
| aliases | Set\<Alias\> | No | エイリアス定義 | - |
| create | boolean | No | 既存テンプレートの上書き禁止 | デフォルトfalse |

### 入力データソース

REST API（PUT /_template/{name}, GET /_template/{name}, DELETE /_template/{name}等）。

## 出力仕様

### 出力データ

| 項目名 | 型 | 説明 |
|--------|-----|------|
| acknowledged | boolean | （PUT/DELETE）操作が承認されたか |
| index_templates | List | （GET）テンプレートのリスト |

### 出力先

REST APIレスポンス（JSON形式）

## 処理フロー

### 処理シーケンス（テンプレート作成）

```
1. REST APIリクエスト受信
   └─ PutIndexTemplateRequestの生成
2. クラスタブロックチェック
   └─ METADATA_WRITEレベルのブロックチェック
3. 設定のバリデーション
   └─ IndexScopedSettings.validate()
4. マッピングトランスフォーマーの適用
5. MetadataIndexTemplateService.putTemplate()呼び出し
   └─ クラスタ状態の更新（テンプレートメタデータの追加）
6. AcknowledgedResponseの返却
```

### フローチャート

```mermaid
flowchart TD
    A[REST API リクエスト受信] --> B[クラスタブロックチェック]
    B --> C[設定バリデーション]
    C --> D[マッピングトランスフォーマー適用]
    D --> E[MetadataIndexTemplateService.putTemplate]
    E --> F[クラスタ状態更新]
    F --> G[AcknowledgedResponse返却]
```

## ビジネスルール

### 業務ルール

| ルールNo | ルール名 | 内容 | 適用条件 |
|---------|---------|------|---------|
| BR-01 | テンプレート名必須 | テンプレート名は空であってはならない | PUT時 |
| BR-02 | パターン必須 | インデックスパターンは空であってはならない | V1 PUT時 |
| BR-03 | 既存上書き制御 | create=trueの場合、同名テンプレートが存在する場合はエラー | PUT時 |
| BR-04 | V2テンプレートの優先 | V1とV2の両方にマッチする場合、V2テンプレートが優先される | インデックス作成時 |
| BR-05 | コンポーネントテンプレートの合成 | Composableテンプレートはコンポーネントテンプレートを合成して適用 | V2テンプレート使用時 |

### 計算ロジック

該当なし

## データベース操作仕様

### 操作別データベース影響一覧

| 操作 | 対象テーブル | 操作種別 | 概要 |
|-----|-------------|---------|------|
| テンプレート登録 | ClusterState.metadata.templates | INSERT/UPDATE | テンプレートメタデータの追加/更新 |
| テンプレート削除 | ClusterState.metadata.templates | DELETE | テンプレートメタデータの削除 |

## エラー処理

### エラーケース一覧

| エラーコード | エラー種別 | 発生条件 | 対処方法 |
|------------|----------|---------|---------|
| 400 | ActionRequestValidationException | テンプレート名未指定 | テンプレート名を指定 |
| 400 | IllegalArgumentException | パターン未指定 | パターンを指定 |
| 404 | IndexTemplateMissingException | テンプレートが存在しない（GET/DELETE） | テンプレート名を確認 |
| 403 | ClusterBlockException | クラスタブロック中 | ブロック解除後に再実行 |

### リトライ仕様

TransportClusterManagerNodeActionの標準リトライ機構が適用される。

## トランザクション仕様

テンプレートの登録/削除はクラスタ状態更新としてアトミックに実行される。

## パフォーマンス要件

テンプレート操作自体は軽量であるが、テンプレート数が多い場合のパターンマッチングは負荷が増加する可能性がある。

## セキュリティ考慮事項

- V1テンプレート: `indices:admin/template/put`, `indices:admin/template/get`, `indices:admin/template/delete`
- V2テンプレート: `indices:admin/index_template/put`, `indices:admin/index_template/get`, `indices:admin/index_template/delete`
- コンポーネントテンプレート: `cluster:admin/component_template/put`, `cluster:admin/component_template/get`, `cluster:admin/component_template/delete`

## 備考

- 3種類のテンプレート: V1(レガシー), V2(Composable), コンポーネントテンプレート
- V2テンプレートはV1テンプレートより優先される
- コンポーネントテンプレートはV2テンプレートの構成要素として使用される
- シミュレーション機能により、テンプレート適用結果を事前にプレビュー可能

---

## コードリーディングガイド

本機能を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: データ構造を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | PutIndexTemplateRequest.java | `server/src/main/java/org/opensearch/action/admin/indices/template/put/PutIndexTemplateRequest.java` | V1テンプレートのリクエスト構造。name, patterns, order, settings, mappings, aliases |

#### Step 2: エントリーポイントを理解する（V1テンプレート）

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | TransportPutIndexTemplateAction.java | `server/src/main/java/org/opensearch/action/admin/indices/template/put/TransportPutIndexTemplateAction.java` | V1テンプレート登録のメインロジック |

**主要処理フロー**:
- **108-109行目**: checkBlock() -- METADATA_WRITEグローバルブロックチェック
- **113-153行目**: clusterManagerOperation() -- メイン処理
- **123-124行目**: 設定のノーマライズとバリデーション
- **127-128行目**: MetadataIndexTemplateService.putTemplate()呼び出し
- **152行目**: mappingTransformerRegistry.applyTransformers()

#### Step 3: テンプレートサービスを理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | MetadataIndexTemplateService.java | `server/src/main/java/org/opensearch/cluster/metadata/MetadataIndexTemplateService.java` | テンプレート管理の中核ロジック |

### プログラム呼び出し階層図

```
REST API (PUT /_template/{name})
    |
    +-- TransportPutIndexTemplateAction
          |
          +-- checkBlock() -- グローバルMETADATA_WRITEブロック
          |
          +-- clusterManagerOperation()
                |
                +-- Settings正規化+バリデーション
                +-- mappingTransformerRegistry.applyTransformers()
                +-- MetadataIndexTemplateService.putTemplate()
                      +-- クラスタ状態更新
```

### データフロー図

```
[入力]                          [処理]                              [出力]

PutIndexTemplateRequest ---> TransportPutIndexTemplateAction --> AcknowledgedResponse
 (name, patterns,             |                                  (acknowledged)
  order, settings,            +-> Settings正規化+バリデーション
  mappings, aliases)          +-> マッピングトランスフォーマー
                              +-> MetadataIndexTemplateService.putTemplate()
                                   +-> ClusterState更新
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| PutIndexTemplateAction.java | `server/src/main/java/org/opensearch/action/admin/indices/template/put/PutIndexTemplateAction.java` | ソース | V1 PUTアクション定義 |
| PutIndexTemplateRequest.java | `server/src/main/java/org/opensearch/action/admin/indices/template/put/PutIndexTemplateRequest.java` | ソース | V1 PUTリクエスト |
| TransportPutIndexTemplateAction.java | `server/src/main/java/org/opensearch/action/admin/indices/template/put/TransportPutIndexTemplateAction.java` | ソース | V1 PUTトランスポートアクション |
| PutComposableIndexTemplateAction.java | `server/src/main/java/org/opensearch/action/admin/indices/template/put/PutComposableIndexTemplateAction.java` | ソース | V2 PUTアクション |
| PutComponentTemplateAction.java | `server/src/main/java/org/opensearch/action/admin/indices/template/put/PutComponentTemplateAction.java` | ソース | コンポーネントテンプレートPUTアクション |
| GetIndexTemplatesAction.java | `server/src/main/java/org/opensearch/action/admin/indices/template/get/GetIndexTemplatesAction.java` | ソース | V1 GETアクション |
| DeleteIndexTemplateAction.java | `server/src/main/java/org/opensearch/action/admin/indices/template/delete/DeleteIndexTemplateAction.java` | ソース | V1 DELETEアクション |
| SimulateIndexTemplateAction.java | `server/src/main/java/org/opensearch/action/admin/indices/template/post/SimulateIndexTemplateAction.java` | ソース | シミュレーションアクション |
| MetadataIndexTemplateService.java | `server/src/main/java/org/opensearch/cluster/metadata/MetadataIndexTemplateService.java` | ソース | テンプレート管理サービス |
