# 機能設計書 71-ICUアナライザ

## 概要

本ドキュメントは、OpenSearchのICUアナライザプラグイン（analysis-icu）の機能設計について記述する。ICU（International Components for Unicode）ライブラリを活用した国際化対応のテキスト解析機能を提供するプラグインである。

### 本機能の処理概要

ICUアナライザプラグインは、IBM ICU4Jライブラリを基盤として、多言語テキストの高度な正規化、トークン化、照合、変換を行うテキスト解析プラグインである。

**業務上の目的・背景**：多言語対応の全文検索システムにおいて、Unicode正規化やスクリプト別のテキスト分割は不可欠である。標準アナライザではカバーしきれない多言語テキストの適切なトークン化、異体字の正規化、照合順序の制御を実現するためにICUライブラリを活用する。

**機能の利用シーン**：国際化対応が求められるインデックスにおいて、インデックス作成時およびAnalyze APIによるテキスト解析時に使用される。CJK（中日韓）テキスト、アラビア語、タイ語など、空白区切りが困難な言語のトークン化に特に有効である。

**主要な処理内容**：
1. ICU Normalizer CharFilter/TokenFilter: NFKCやNFKC_CFなどのUnicode正規化処理
2. ICU Tokenizer: ICU BreakIteratorを使用したスクリプトベースのテキストトークン化
3. ICU Folding TokenFilter: UTR#30に基づく文字フォールディング（アクセント除去等）
4. ICU Collation TokenFilter: ICU照合規則に基づくソートキー生成
5. ICU Transform TokenFilter: ICU Transliteratorによるスクリプト変換（例：カタカナ→ローマ字）
6. ICU Collation Keyword Field Mapper: 照合ベースのフィールドマッピング

**関連システム・外部連携**：IBM ICU4Jライブラリ、Apache Lucene ICU分析モジュールとの連携。

**権限による制御**：インデックス作成権限を持つユーザーがインデックス設定としてアナライザを指定する。特別な権限制御はない。

## 関連画面

| 画面No | 画面名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| 55 | アナライズ | 主機能 | テキストに対して解析プロセスを実行しトークン分解を返す処理 |

## 機能種別

テキスト解析処理

## 入力仕様

### 入力パラメータ

| パラメータ名 | 型 | 必須 | 説明 | バリデーション |
|-------------|-----|-----|------|---------------|
| method | String | No | Unicode正規化方式（デフォルト: nfkc_cf） | nfkc, nfkc_cf等のICU Normalizer2名 |
| mode | String | No | 正規化モード（デフォルト: compose） | compose または decompose |
| unicode_set_filter | String | No | UnicodeSetフィルタ式 | ICU UnicodeSet形式 |
| rule_files | List<String> | No | スクリプト別カスタムルールファイル | "code:rulefile"形式のCSV |
| id | String | No | ICU Transliterator ID（デフォルト: Null） | ICU Transliterator登録名 |
| dir | String | No | 変換方向（デフォルト: forward） | forward または reverse |
| language | String | No | 照合ロケール言語コード | ISO-639小文字2文字 |
| country | String | No | 照合ロケール国コード | ISO国コード |
| strength | String | No | 照合強度 | primary/secondary/tertiary/quaternary/identical |
| rules | String | No | カスタム照合ルール | ICU RuleBasedCollatorルール文字列またはファイルパス |

### 入力データソース

インデックス設定（index settings）のanalyzerセクションで指定される。Analyze APIのリクエストボディからも入力される。

## 出力仕様

### 出力データ

| 項目名 | 型 | 説明 |
|--------|-----|------|
| tokens | List<Token> | トークン化されたテキスト片のリスト |
| token.term | String | 正規化・変換後のトークン文字列 |
| token.position | int | トークン位置 |
| token.startOffset | int | 元テキスト内の開始オフセット |
| token.endOffset | int | 元テキスト内の終了オフセット |

### 出力先

Luceneインデックスの転置インデックス（インデックス時）、またはAnalyze APIのレスポンス（解析時）。

## 処理フロー

### 処理シーケンス

```
1. プラグインロード
   └─ AnalysisICUPlugin.getCharFilters/getTokenFilters/getTokenizers/getAnalyzersでコンポーネント登録
2. インデックス設定のアナライザ定義解析
   └─ 各FactoryクラスのコンストラクタでICU設定パラメータをパース
3. テキスト解析パイプライン実行
   └─ CharFilter(正規化) → Tokenizer(トークン分割) → TokenFilter(フォールディング/変換/照合)
```

### フローチャート

```mermaid
flowchart TD
    A[テキスト入力] --> B[ICU Normalizer CharFilter]
    B --> C[ICU Tokenizer]
    C --> D{TokenFilter選択}
    D -->|icu_normalizer| E[ICU Normalizer TokenFilter]
    D -->|icu_folding| F[ICU Folding TokenFilter]
    D -->|icu_transform| G[ICU Transform TokenFilter]
    D -->|icu_collation| H[ICU Collation TokenFilter]
    E --> I[トークン出力]
    F --> I
    G --> I
    H --> I
```

## ビジネスルール

### 業務ルール

| ルールNo | ルール名 | 内容 | 適用条件 |
|---------|---------|------|---------|
| BR-71-01 | デフォルト正規化 | method未指定時はnfkc_cfを使用 | IcuAnalyzerProvider, IcuNormalizerTokenFilterFactory |
| BR-71-02 | モードバリデーション | modeはcomposeまたはdecomposeのみ許可 | IcuAnalyzerProvider（55-58行目） |
| BR-71-03 | UnicodeSetフィルタ | unicode_set_filter指定時はFilteredNormalizer2でラップ | IcuNormalizerTokenFilterFactory（63-72行目） |
| BR-71-04 | ルールファイル形式 | rule_filesは"code:rulefile"形式のCSVリスト | IcuTokenizerFactory（84-86行目） |

### 計算ロジック

照合キー生成はICU Collatorの比較アルゴリズムに基づく。正規化はUnicode Normalization Forms（NFC/NFD/NFKC/NFKD）に準拠。

## データベース操作仕様

### 操作別データベース影響一覧

| 操作 | 対象テーブル | 操作種別 | 概要 |
|-----|-------------|---------|------|
| テキスト解析 | Luceneインデックス | 処理のみ | トークン化結果はインデックス書き込み時に転置インデックスに格納 |

### テーブル別操作詳細

本機能は直接的なデータベース操作を行わない。Luceneの転置インデックスにトークンが格納される。

## エラー処理

### エラーケース一覧

| エラーコード | エラー種別 | 発生条件 | 対処方法 |
|------------|----------|---------|---------|
| IllegalArgumentException | 設定エラー | 不正なmodeパラメータ（compose/decompose以外） | 正しいモード値を指定 |
| OpenSearchException | 初期化エラー | ICUルールファイルの読み込み失敗 | ルールファイルのパスと内容を確認 |
| IllegalArgumentException | 照合設定エラー | 不正なstrength/decomposition/alternate/caseFirst値 | 許可された値を指定 |
| IllegalArgumentException | ルール形式エラー | rule_filesのフォーマットが不正 | "code:rulefile"形式で指定 |

### リトライ仕様

リトライは不要。設定エラーはインデックス作成時に即座にエラーを返す。

## トランザクション仕様

テキスト解析はステートレス処理であり、トランザクション管理は不要。

## パフォーマンス要件

ICU正規化・トークン化はドキュメント単位のインライン処理として実行される。大量ドキュメントのバルクインデックス時には各ドキュメントの解析処理が並列実行される。

## セキュリティ考慮事項

カスタムルールファイルはconfigディレクトリから読み込まれる。ファイルシステムアクセスは設定ディレクトリに制限される。

## 備考

ICUプラグインはAnalysisPluginインターフェースに加え、MapperPluginインターフェースも実装しており、ICU Collation Keyword Fieldマッパーを提供する。

---

## コードリーディングガイド

本機能を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: データ構造を理解する

ICUプラグインはOpenSearchのAnalysisPluginインターフェースを実装し、ICU4JとLuceneのICU分析クラスを統合する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | AnalysisICUPlugin.java | `plugins/analysis-icu/src/main/java/org/opensearch/plugin/analysis/icu/AnalysisICUPlugin.java` | プラグインのエントリーポイント。登録されるアナライザ、トークナイザ、トークンフィルタ、チャーフィルタの一覧を把握 |

**読解のコツ**: AnalysisPluginインターフェースの`getCharFilters()`、`getTokenFilters()`、`getTokenizers()`、`getAnalyzers()`の各メソッドが返すMap<String, AnalysisProvider>を確認すること。キーがアナライザ名、値がファクトリのコンストラクタ参照。

#### Step 2: エントリーポイントを理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | AnalysisICUPlugin.java | `plugins/analysis-icu/src/main/java/org/opensearch/plugin/analysis/icu/AnalysisICUPlugin.java` | 63行目: AnalysisPlugin, MapperPluginの両方を実装 |

**主要処理フロー**:
1. **65-67行目**: CharFilter登録 - `icu_normalizer`
2. **70-77行目**: TokenFilter登録 - `icu_normalizer`, `icu_folding`, `icu_collation`, `icu_transform`
3. **80-82行目**: Analyzer登録 - `icu_analyzer`
4. **85-87行目**: Tokenizer登録 - `icu_tokenizer`
5. **90-92行目**: Mapper登録 - ICUCollationKeywordFieldMapper

#### Step 3: アナライザプロバイダを理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | IcuAnalyzerProvider.java | `plugins/analysis-icu/src/main/java/org/opensearch/index/analysis/IcuAnalyzerProvider.java` | ICU Analyzerの構成: CharFilter(ICUNormalizer2CharFilter) + Tokenizer(ICUTokenizer) + TokenFilter(ICUFoldingFilter) |

**主要処理フロー**:
- **53行目**: method設定読み込み（デフォルト: nfkc_cf）
- **54行目**: mode設定読み込み（デフォルト: compose）
- **55-58行目**: mode値のバリデーション
- **60-64行目**: Normalizer2インスタンス生成
- **65行目**: UnicodeSetフィルタによるラップ
- **69-83行目**: Analyzerの組み立て（CharFilter → Tokenizer → TokenFilter）

#### Step 4: トークナイザファクトリを理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 4-1 | IcuTokenizerFactory.java | `plugins/analysis-icu/src/main/java/org/opensearch/index/analysis/IcuTokenizerFactory.java` | カスタムルールファイルによるICUTokenizerの設定 |

**主要処理フロー**:
- **62-65行目**: コンストラクタでICU設定読み込み
- **68-74行目**: create()でICUTokenizer生成、config nullならデフォルト設定
- **76-118行目**: getIcuConfig()でルールファイルをパースしBreakIterator生成

#### Step 5: 各トークンフィルタを理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 5-1 | IcuNormalizerTokenFilterFactory.java | `plugins/analysis-icu/src/main/java/org/opensearch/index/analysis/IcuNormalizerTokenFilterFactory.java` | Unicode正規化フィルタ。wrapWithUnicodeSetFilterが他クラスからも使われる共通メソッド |
| 5-2 | IcuFoldingTokenFilterFactory.java | `plugins/analysis-icu/src/main/java/org/opensearch/index/analysis/IcuFoldingTokenFilterFactory.java` | UTR#30文字フォールディング |
| 5-3 | IcuTransformTokenFilterFactory.java | `plugins/analysis-icu/src/main/java/org/opensearch/index/analysis/IcuTransformTokenFilterFactory.java` | ICU Transliterator変換 |
| 5-4 | IcuCollationTokenFilterFactory.java | `plugins/analysis-icu/src/main/java/org/opensearch/index/analysis/IcuCollationTokenFilterFactory.java` | ICU照合キー生成 |

### プログラム呼び出し階層図

```
AnalysisICUPlugin (プラグイン登録)
    |
    +-- getAnalyzers() -> IcuAnalyzerProvider
    |       +-- ICUNormalizer2CharFilter (CharFilter)
    |       +-- ICUTokenizer (Tokenizer)
    |       +-- ICUFoldingFilter (TokenFilter)
    |
    +-- getCharFilters() -> IcuNormalizerCharFilterFactory
    |
    +-- getTokenizers() -> IcuTokenizerFactory
    |       +-- ICUTokenizer
    |       +-- DefaultICUTokenizerConfig (カスタムルール時)
    |
    +-- getTokenFilters()
    |       +-- IcuNormalizerTokenFilterFactory -> ICUNormalizer2Filter
    |       +-- IcuFoldingTokenFilterFactory -> ICUNormalizer2Filter (UTR#30)
    |       +-- IcuCollationTokenFilterFactory -> ICUCollationKeyFilter
    |       +-- IcuTransformTokenFilterFactory -> ICUTransformFilter
    |
    +-- getMappers() -> ICUCollationKeywordFieldMapper
```

### データフロー図

```
[入力]                    [処理]                              [出力]

テキスト文字列 ───> ICUNormalizer2CharFilter ───> ICUTokenizer ───> ICU TokenFilter ───> トークンリスト
                     (Unicode正規化)            (スクリプト別分割)  (フォールディング/    (転置インデックス
                                                                    変換/照合)           or APIレスポンス)
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| AnalysisICUPlugin.java | `plugins/analysis-icu/src/main/java/org/opensearch/plugin/analysis/icu/AnalysisICUPlugin.java` | ソース | プラグインエントリーポイント |
| IcuAnalyzerProvider.java | `plugins/analysis-icu/src/main/java/org/opensearch/index/analysis/IcuAnalyzerProvider.java` | ソース | ICUアナライザプロバイダ |
| IcuTokenizerFactory.java | `plugins/analysis-icu/src/main/java/org/opensearch/index/analysis/IcuTokenizerFactory.java` | ソース | ICUトークナイザファクトリ |
| IcuNormalizerTokenFilterFactory.java | `plugins/analysis-icu/src/main/java/org/opensearch/index/analysis/IcuNormalizerTokenFilterFactory.java` | ソース | ICU正規化トークンフィルタ |
| IcuNormalizerCharFilterFactory.java | `plugins/analysis-icu/src/main/java/org/opensearch/index/analysis/IcuNormalizerCharFilterFactory.java` | ソース | ICU正規化チャーフィルタ |
| IcuFoldingTokenFilterFactory.java | `plugins/analysis-icu/src/main/java/org/opensearch/index/analysis/IcuFoldingTokenFilterFactory.java` | ソース | ICUフォールディングフィルタ |
| IcuTransformTokenFilterFactory.java | `plugins/analysis-icu/src/main/java/org/opensearch/index/analysis/IcuTransformTokenFilterFactory.java` | ソース | ICU変換フィルタ |
| IcuCollationTokenFilterFactory.java | `plugins/analysis-icu/src/main/java/org/opensearch/index/analysis/IcuCollationTokenFilterFactory.java` | ソース | ICU照合フィルタ |
| ICUCollationKeyFilter.java | `plugins/analysis-icu/src/main/java/org/opensearch/index/analysis/ICUCollationKeyFilter.java` | ソース | 照合キーフィルタ実装 |
| IndexableBinaryStringTools.java | `plugins/analysis-icu/src/main/java/org/opensearch/index/analysis/IndexableBinaryStringTools.java` | ソース | バイナリ文字列変換ユーティリティ |
