# 機能設計書 74-中国語アナライザ（SmartCN）

## 概要

本ドキュメントは、OpenSearchの中国語アナライザプラグイン（analysis-smartcn）の機能設計について記述する。Apache Lucene SmartChineseAnalyzerを基盤とした中国語テキスト解析機能を提供するプラグインである。

### 本機能の処理概要

SmartCNプラグインは、中国語テキストの単語分割（セグメンテーション）を行い、適切なトークン化とストップワードフィルタリングを提供する。

**業務上の目的・背景**：中国語は単語間にスペースが存在しないため、標準トークナイザでは正しく単語分割ができない。SmartChineseAnalyzerは統計的手法（Hidden Markov Model）に基づく中国語の単語分割を行い、全文検索の精度を向上させる。

**機能の利用シーン**：中国語（簡体字）コンテンツを含むインデックスの作成時、中国語検索クエリの解析時に使用される。

**主要な処理内容**：
1. SmartChineseTokenizer: HMM（隠れマルコフモデル）ベースの中国語単語セグメンテーション
2. SmartChineseStopFilter: 中国語ストップワードフィルタリング
3. SmartChineseNoOpFilter: 後方互換性のためのNo-Opフィルタ（非推奨）

**関連システム・外部連携**：Apache Lucene SmartChineseAnalyzer。

**権限による制御**：特別な権限制御はない。

## 関連画面

| 画面No | 画面名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| 55 | アナライズ | 参照画面 | テキストに対してSmartCN解析プロセスを実行しトークン分解を返す処理 |

## 機能種別

テキスト解析処理

## 入力仕様

### 入力パラメータ

| パラメータ名 | 型 | 必須 | 説明 | バリデーション |
|-------------|-----|-----|------|---------------|
| stopwords | List<String>/String | No | ストップワードリスト | 単語リスト。デフォルトはSmartChineseAnalyzer.getDefaultStopSet() |

### 入力データソース

インデックス設定（index settings）のanalyzerセクション、またはAnalyze APIのリクエストボディ。

## 出力仕様

### 出力データ

| 項目名 | 型 | 説明 |
|--------|-----|------|
| tokens | List<Token> | セグメンテーションされたトークンリスト |
| token.term | String | トークン文字列 |
| token.position | int | トークン位置 |

### 出力先

Luceneインデックスの転置インデックス（インデックス時）、またはAnalyze APIのレスポンス（解析時）。

## 処理フロー

### 処理シーケンス

```
1. プラグインロード
   └─ AnalysisSmartChinesePlugin.getTokenFilters/getTokenizers/getAnalyzersでコンポーネント登録
2. テキスト解析パイプライン実行
   └─ Tokenizer(中国語セグメンテーション) → TokenFilter(ストップワード除去)
```

### フローチャート

```mermaid
flowchart TD
    A[テキスト入力] --> B[SmartChineseTokenizer]
    B --> C[SmartChineseStopFilter]
    C --> D[トークン出力]
```

## ビジネスルール

### 業務ルール

| ルールNo | ルール名 | 内容 | 適用条件 |
|---------|---------|------|---------|
| BR-74-01 | デフォルトストップワード | stopwords未指定時はSmartChineseAnalyzer.getDefaultStopSet()を使用 | SmartChineseAnalyzerProvider（47行目） |
| BR-74-02 | トークナイザエイリアス | smartcn_sentenceはsmartcn_tokenizerのエイリアス（後方互換用） | AnalysisSmartChinesePlugin（67行目） |
| BR-74-03 | NoOpフィルタ | smartcn_wordは後方互換用のNo-Opフィルタ | AnalysisSmartChinesePlugin（58行目） |

### 計算ロジック

特になし。単語分割はLuceneのSmartChineseAnalyzerのHMMアルゴリズムに依存する。

## データベース操作仕様

本機能は直接的なデータベース操作を行わない。

### 操作別データベース影響一覧

該当なし。

### テーブル別操作詳細

該当なし。

## エラー処理

### エラーケース一覧

| エラーコード | エラー種別 | 発生条件 | 対処方法 |
|------------|----------|---------|---------|
| - | 設定エラー | 不正なストップワード形式 | 正しい形式で指定 |

### リトライ仕様

リトライは不要。

## トランザクション仕様

テキスト解析はステートレス処理であり、トランザクション管理は不要。

## パフォーマンス要件

HMMベースの単語分割処理であり、テキスト長に比例した処理時間を要する。

## セキュリティ考慮事項

特別なセキュリティ考慮事項はない。

## 備考

SmartCNプラグインはsmartcn_sentenceトークナイザとsmartcn_wordフィルタを後方互換のために保持しているが、いずれも非推奨（TODO: deprecate and remove）である。

---

## コードリーディングガイド

本機能を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: データ構造を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | AnalysisSmartChinesePlugin.java | `plugins/analysis-smartcn/src/main/java/org/opensearch/plugin/analysis/smartcn/AnalysisSmartChinesePlugin.java` | 登録コンポーネント: TokenFilter x2, Tokenizer x2（エイリアス含む）, Analyzer x1 |

**読解のコツ**: smartcn_sentenceはsmartcn_tokenizerのエイリアス（67行目のTODOコメント参照）。smartcn_wordはNo-Opフィルタ（58行目のTODOコメント参照）。

#### Step 2: アナライザプロバイダを理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | SmartChineseAnalyzerProvider.java | `plugins/analysis-smartcn/src/main/java/org/opensearch/index/analysis/SmartChineseAnalyzerProvider.java` | SmartChineseAnalyzerの生成。デフォルトストップワードのみ設定 |

**主要処理フロー**:
- **44-48行目**: コンストラクタ - SmartChineseAnalyzerをデフォルトストップワードで生成
- **51-53行目**: get() - アナライザインスタンスを返却

### プログラム呼び出し階層図

```
AnalysisSmartChinesePlugin (プラグイン登録)
    |
    +-- getAnalyzers()
    |       +-- SmartChineseAnalyzerProvider -> SmartChineseAnalyzer
    |
    +-- getTokenizers()
    |       +-- SmartChineseTokenizerTokenizerFactory (smartcn_tokenizer)
    |       +-- SmartChineseTokenizerTokenizerFactory (smartcn_sentence, エイリアス)
    |
    +-- getTokenFilters()
            +-- SmartChineseStopTokenFilterFactory (smartcn_stop)
            +-- SmartChineseNoOpTokenFilterFactory (smartcn_word, No-Op)
```

### データフロー図

```
[入力]                [処理]                              [出力]

中国語テキスト ───> SmartChineseTokenizer ───> SmartChineseStopFilter ───> トークンリスト
                    (HMM単語セグメンテーション)   (ストップワード除去)
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| AnalysisSmartChinesePlugin.java | `plugins/analysis-smartcn/src/main/java/org/opensearch/plugin/analysis/smartcn/AnalysisSmartChinesePlugin.java` | ソース | プラグインエントリーポイント |
| SmartChineseAnalyzerProvider.java | `plugins/analysis-smartcn/src/main/java/org/opensearch/index/analysis/SmartChineseAnalyzerProvider.java` | ソース | アナライザプロバイダ |
| SmartChineseTokenizerTokenizerFactory.java | `plugins/analysis-smartcn/src/main/java/org/opensearch/index/analysis/SmartChineseTokenizerTokenizerFactory.java` | ソース | トークナイザファクトリ |
| SmartChineseStopTokenFilterFactory.java | `plugins/analysis-smartcn/src/main/java/org/opensearch/index/analysis/SmartChineseStopTokenFilterFactory.java` | ソース | ストップワードフィルタ |
| SmartChineseNoOpTokenFilterFactory.java | `plugins/analysis-smartcn/src/main/java/org/opensearch/index/analysis/SmartChineseNoOpTokenFilterFactory.java` | ソース | No-Opフィルタ（後方互換） |
