# 機能設計書 75-音声アナライザ（Phonetic）

## 概要

本ドキュメントは、OpenSearchの音声アナライザプラグイン（analysis-phonetic）の機能設計について記述する。発音（音声）ベースのトークンフィルタを提供し、類似発音のテキストマッチングを実現するプラグインである。

### 本機能の処理概要

Phoneticプラグインは、テキストトークンを発音コード（音声コード）に変換するトークンフィルタを提供する。これにより、発音が類似する単語を同一のコードにマッピングし、あいまい検索や発音ベースの検索を可能にする。

**業務上の目的・背景**：名前や地名など、スペルが異なるが発音が類似する単語を同一の検索結果として返すことが必要な場面がある。音声エンコーディングにより、発音の類似性に基づく検索を実現する。

**機能の利用シーン**：人名検索、地名検索、スペルミスの許容検索等、発音ベースのあいまい検索が必要なインデックスで使用される。

**主要な処理内容**：
1. Metaphone: 英語の発音ルールに基づくコード生成
2. Double Metaphone: 複数の発音バリエーションに対応したMetaphone拡張
3. Soundex: サウンデックスアルゴリズムによるコード生成
4. Refined Soundex: 改良版Soundex
5. Beider-Morse: 多言語対応の音声エンコーディング
6. Daitch-Mokotoff Soundex: 東欧系名前向けSoundex
7. Caverphone (1/2): ニュージーランド英語向け音声エンコーディング
8. Cologne Phonetic: ドイツ語向け音声エンコーディング
9. Koelner Phonetik: ケルン式ドイツ語音声コード
10. Haase Phonetik: ハーゼ式音声コード
11. Nysiis: New York State Identification and Intelligence Systemコード

**関連システム・外部連携**：Apache Commons Codec、Apache Lucene Phonetic Analysis。

**権限による制御**：特別な権限制御はない。

## 関連画面

| 画面No | 画面名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| 55 | アナライズ | 参照画面 | テキストに対して音声解析プロセスを実行しトークン分解を返す処理 |

## 機能種別

テキスト解析処理

## 入力仕様

### 入力パラメータ

| パラメータ名 | 型 | 必須 | 説明 | バリデーション |
|-------------|-----|-----|------|---------------|
| encoder | String | No | 音声エンコーダ名（デフォルト: metaphone） | metaphone/soundex/caverphone1/caverphone2/refined_soundex/cologne/double_metaphone/bm/koelnerphonetik/haasephonetik/nysiis/daitch_mokotoff |
| replace | Boolean | No | 元トークンを音声コードで置換するか（デフォルト: true） | true / false |
| max_code_len | int | No | Double Metaphoneの最大コード長（デフォルト: 4） | 正整数 |
| rule_type | String | No | Beider-Morseルールタイプ（デフォルト: approx） | approx / exact |
| name_type | String | No | Beider-Morse名前タイプ（デフォルト: generic） | GENERIC / ASHKENAZI / SEPHARDIC |
| languageset | List<String> | No | Beider-Morseの対象言語セット | 言語コードリスト |

### 入力データソース

インデックス設定（index settings）のanalyzerセクションでtoken filterとして指定。

## 出力仕様

### 出力データ

| 項目名 | 型 | 説明 |
|--------|-----|------|
| token.term | String | 音声エンコードされたトークン（replace=trueの場合）、または元トークン+音声トークン（replace=falseの場合） |

### 出力先

Luceneインデックスの転置インデックス、またはAnalyze APIレスポンス。

## 処理フロー

### 処理シーケンス

```
1. プラグインロード
   └─ AnalysisPhoneticPlugin.getTokenFiltersでphoneticフィルタ登録
2. ファクトリ初期化
   └─ PhoneticTokenFilterFactoryでencoderタイプに基づくエンコーダ選択
3. テキスト解析
   └─ 入力トークンを音声コードに変換（または元トークンに音声コードを付加）
```

### フローチャート

```mermaid
flowchart TD
    A[入力トークン] --> B{encoder種別}
    B -->|metaphone| C[Metaphone]
    B -->|soundex| D[Soundex]
    B -->|double_metaphone| E[DoubleMetaphoneFilter]
    B -->|bm| F[BeiderMorseFilter]
    B -->|daitch_mokotoff| G[DaitchMokotoffSoundexFilter]
    B -->|その他| H[PhoneticFilter + 各Encoder]
    C --> I{replace?}
    D --> I
    E --> J[トークン出力]
    F --> J
    G --> J
    H --> I
    I -->|true| J
    I -->|false| K[元トークン + 音声トークン]
    K --> J
```

## ビジネスルール

### 業務ルール

| ルールNo | ルール名 | 内容 | 適用条件 |
|---------|---------|------|---------|
| BR-75-01 | デフォルトエンコーダ | encoder未指定時はmetaphoneを使用 | PhoneticTokenFilterFactory（79行目） |
| BR-75-02 | デフォルトreplace | replace未指定時はtrueで元トークンを置換 | PhoneticTokenFilterFactory（77行目） |
| BR-75-03 | 同義語フィルタ禁止 | phoneticフィルタは同義語パースに使用不可 | PhoneticTokenFilterFactory getSynonymFilter()（155-157行目） |
| BR-75-04 | encoderバリデーション | 不明なencoder名はIllegalArgumentExceptionをスロー | PhoneticTokenFilterFactory（128行目） |

### 計算ロジック

各エンコーダは固有のアルゴリズムで音声コードを生成する。PhoneticFilterはreplace=falseの場合、元トークンと音声コードの両方をトークンストリームに追加する。

## データベース操作仕様

本機能は直接的なデータベース操作を行わない。

### 操作別データベース影響一覧

該当なし。

### テーブル別操作詳細

該当なし。

## エラー処理

### エラーケース一覧

| エラーコード | エラー種別 | 発生条件 | 対処方法 |
|------------|----------|---------|---------|
| IllegalArgumentException | エンコーダエラー | 不明なencoder名を指定 | サポートされるエンコーダ名を指定 |
| IllegalArgumentException | ルールエラー | Beider-Morseで不正なrule_typeを指定 | approxまたはexactを指定 |
| IllegalArgumentException | 同義語エラー | synonymフィルタとして使用を試みた場合 | 別のフィルタを使用 |

### リトライ仕様

リトライは不要。

## トランザクション仕様

テキスト解析はステートレス処理であり、トランザクション管理は不要。

## パフォーマンス要件

音声エンコーディングは各トークンに対して行われる軽量な変換処理である。

## セキュリティ考慮事項

特別なセキュリティ考慮事項はない。

## 備考

Phoneticプラグインはトークンフィルタのみを提供し、アナライザやトークナイザは提供しない。他のアナライザと組み合わせて使用する。

---

## コードリーディングガイド

本機能を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: データ構造を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | AnalysisPhoneticPlugin.java | `plugins/analysis-phonetic/src/main/java/org/opensearch/plugin/analysis/AnalysisPhoneticPlugin.java` | phoneticトークンフィルタの1コンポーネントのみ登録 |

**読解のコツ**: このプラグインはTokenFilterのみ提供する最小構成のプラグイン。

#### Step 2: トークンフィルタファクトリを理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | PhoneticTokenFilterFactory.java | `plugins/analysis-phonetic/src/main/java/org/opensearch/index/analysis/PhoneticTokenFilterFactory.java` | エンコーダ選択ロジック（80-129行目）とcreate()メソッド（133-152行目）がコアロジック |

**主要処理フロー**:
- **70-130行目**: コンストラクタ - encoder設定に基づくエンコーダインスタンス生成。if-else分岐で11種類のエンコーダを選択
- **77行目**: replace設定（デフォルト: true）
- **79行目**: encoderのデフォルト値（metaphone）
- **94-96行目**: double_metaphoneはencoderをnullに設定し、maxcodelengthを保持
- **97-117行目**: beider_morseはencoderをnullに設定し、languageset/ruletype/nametypeを保持
- **133-152行目**: create()メソッド - encoderの種類に応じて適切なLuceneフィルタを返却

### プログラム呼び出し階層図

```
AnalysisPhoneticPlugin (プラグイン登録)
    |
    +-- getTokenFilters()
            +-- PhoneticTokenFilterFactory
                    +-- create()
                        +-- DaitchMokotoffSoundexFilter (isDaitchMokotoff)
                        +-- BeiderMorseFilter (ruletype != null && nametype != null)
                        +-- DoubleMetaphoneFilter (maxcodelength > 0)
                        +-- PhoneticFilter + Encoder (その他)
                            +-- Metaphone / Soundex / Caverphone1 / Caverphone2
                            +-- RefinedSoundex / ColognePhonetic
                            +-- KoelnerPhonetik / HaasePhonetik / Nysiis
```

### データフロー図

```
[入力]              [処理]                         [出力]

トークン ───> PhoneticTokenFilterFactory.create() ───> 音声エンコード済みトークン
              (エンコーダ選択 + フィルタ適用)           (replace=true: 置換)
                                                       (replace=false: 追加)
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| AnalysisPhoneticPlugin.java | `plugins/analysis-phonetic/src/main/java/org/opensearch/plugin/analysis/AnalysisPhoneticPlugin.java` | ソース | プラグインエントリーポイント |
| PhoneticTokenFilterFactory.java | `plugins/analysis-phonetic/src/main/java/org/opensearch/index/analysis/PhoneticTokenFilterFactory.java` | ソース | 音声トークンフィルタファクトリ |
| KoelnerPhonetik.java | `plugins/analysis-phonetic/src/main/java/org/opensearch/index/analysis/phonetic/KoelnerPhonetik.java` | ソース | ケルン式音声コードエンコーダ |
| HaasePhonetik.java | `plugins/analysis-phonetic/src/main/java/org/opensearch/index/analysis/phonetic/HaasePhonetik.java` | ソース | ハーゼ式音声コードエンコーダ |
| Nysiis.java | `plugins/analysis-phonetic/src/main/java/org/opensearch/index/analysis/phonetic/Nysiis.java` | ソース | NYSIISエンコーダ |
