# 機能設計書 76-ポーランド語アナライザ（Stempel）

## 概要

本ドキュメントは、OpenSearchのポーランド語アナライザプラグイン（analysis-stempel）の機能設計について記述する。Stempelアルゴリズムを使用したポーランド語のステミング（語幹抽出）機能を提供するプラグインである。

### 本機能の処理概要

Stempelプラグインは、ポーランド語テキストのステミング（語幹抽出）とストップワードフィルタリングを提供し、ポーランド語の全文検索精度を向上させる。

**業務上の目的・背景**：ポーランド語は高度な屈折語であり、同一の語根から多数の活用形が生成される。標準的なステマーではポーランド語の複雑な語形変化に対応できないため、Stempelアルゴリズムによる専用のステミング処理が必要である。

**機能の利用シーン**：ポーランド語コンテンツを含むインデックスの作成時、ポーランド語検索クエリの解析時に使用される。

**主要な処理内容**：
1. PolishAnalyzer: ポーランド語用の標準アナライザ（Lucene PolishAnalyzer）
2. PolishStemTokenFilter: Stempelアルゴリズムによるポーランド語ステミング
3. PolishStopTokenFilter: ポーランド語ストップワードフィルタリング

**関連システム・外部連携**：Apache Lucene Stempel分析モジュール、Apache Lucene PolishAnalyzer。

**権限による制御**：特別な権限制御はない。

## 関連画面

| 画面No | 画面名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| 55 | アナライズ | 参照画面 | テキストに対してポーランド語解析プロセスを実行しトークン分解を返す処理 |

## 機能種別

テキスト解析処理

## 入力仕様

### 入力パラメータ

| パラメータ名 | 型 | 必須 | 説明 | バリデーション |
|-------------|-----|-----|------|---------------|
| stopwords | List<String>/String | No | ストップワードリスト（デフォルト: PolishAnalyzer.getDefaultStopSet()） | 単語リスト |

### 入力データソース

インデックス設定（index settings）のanalyzerセクション、またはAnalyze APIのリクエストボディ。

## 出力仕様

### 出力データ

| 項目名 | 型 | 説明 |
|--------|-----|------|
| tokens | List<Token> | ステミング済みトークンリスト |
| token.term | String | 語幹抽出後のトークン文字列 |

### 出力先

Luceneインデックスの転置インデックス、またはAnalyze APIのレスポンス。

## 処理フロー

### 処理シーケンス

```
1. プラグインロード
   └─ AnalysisStempelPlugin.getTokenFilters/getAnalyzersでコンポーネント登録
2. テキスト解析パイプライン実行
   └─ Tokenizer → PolishStemTokenFilter(ステミング) → PolishStopTokenFilter(ストップワード除去)
```

### フローチャート

```mermaid
flowchart TD
    A[テキスト入力] --> B[StandardTokenizer]
    B --> C[PolishStemTokenFilter]
    C --> D[PolishStopTokenFilter]
    D --> E[トークン出力]
```

## ビジネスルール

### 業務ルール

| ルールNo | ルール名 | 内容 | 適用条件 |
|---------|---------|------|---------|
| BR-76-01 | デフォルトストップワード | PolishAnalyzer.getDefaultStopSet()を使用 | PolishAnalyzerProvider（48行目） |
| BR-76-02 | Stempelステミング | PolishAnalyzer.getDefaultTable()からStempelStemmerを生成 | PolishStemTokenFilterFactory（52行目） |

### 計算ロジック

Stempelアルゴリズムはテーブル駆動型のステミングアルゴリズムであり、事前コンパイルされたステミングテーブルを使用して語幹を抽出する。

## データベース操作仕様

本機能は直接的なデータベース操作を行わない。

### 操作別データベース影響一覧

該当なし。

### テーブル別操作詳細

該当なし。

## エラー処理

### エラーケース一覧

| エラーコード | エラー種別 | 発生条件 | 対処方法 |
|------------|----------|---------|---------|
| - | 設定エラー | 不正なストップワード形式 | 正しい形式で指定 |

### リトライ仕様

リトライは不要。

## トランザクション仕様

テキスト解析はステートレス処理であり、トランザクション管理は不要。

## パフォーマンス要件

テーブル駆動型ステミングは高速であり、特別なパフォーマンス上の懸念はない。

## セキュリティ考慮事項

特別なセキュリティ考慮事項はない。

## 備考

AnalysisStempelPluginはTokenFilter x2（polish_stem, polish_stop）とAnalyzer x1（polish）を提供する。

---

## コードリーディングガイド

本機能を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: データ構造を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | AnalysisStempelPlugin.java | `plugins/analysis-stempel/src/main/java/org/opensearch/plugin/analysis/stempel/AnalysisStempelPlugin.java` | 登録コンポーネント: TokenFilter x2, Analyzer x1 |

#### Step 2: ステミングフィルタを理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | PolishStemTokenFilterFactory.java | `plugins/analysis-stempel/src/main/java/org/opensearch/index/analysis/pl/PolishStemTokenFilterFactory.java` | StempelFilter + StempelStemmerの生成 |

**主要処理フロー**:
- **51-53行目**: create() - StempelFilter(StempelStemmer(PolishAnalyzer.getDefaultTable()))でトークンストリームを生成

#### Step 3: アナライザプロバイダを理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | PolishAnalyzerProvider.java | `plugins/analysis-stempel/src/main/java/org/opensearch/index/analysis/pl/PolishAnalyzerProvider.java` | PolishAnalyzerをデフォルトストップワードで生成 |

**主要処理フロー**:
- **45-49行目**: コンストラクタ - PolishAnalyzer(PolishAnalyzer.getDefaultStopSet())
- **51-54行目**: get() - アナライザインスタンス返却

### プログラム呼び出し階層図

```
AnalysisStempelPlugin (プラグイン登録)
    |
    +-- getAnalyzers()
    |       +-- PolishAnalyzerProvider -> PolishAnalyzer
    |
    +-- getTokenFilters()
            +-- PolishStemTokenFilterFactory -> StempelFilter + StempelStemmer
            +-- PolishStopTokenFilterFactory
```

### データフロー図

```
[入力]                  [処理]                                     [出力]

ポーランド語テキスト ───> StandardTokenizer ───> StempelFilter ───> PolishStopFilter ───> トークンリスト
                                                (Stempelステミング)   (ストップワード除去)
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| AnalysisStempelPlugin.java | `plugins/analysis-stempel/src/main/java/org/opensearch/plugin/analysis/stempel/AnalysisStempelPlugin.java` | ソース | プラグインエントリーポイント |
| PolishAnalyzerProvider.java | `plugins/analysis-stempel/src/main/java/org/opensearch/index/analysis/pl/PolishAnalyzerProvider.java` | ソース | アナライザプロバイダ |
| PolishStemTokenFilterFactory.java | `plugins/analysis-stempel/src/main/java/org/opensearch/index/analysis/pl/PolishStemTokenFilterFactory.java` | ソース | ステミングフィルタ |
| PolishStopTokenFilterFactory.java | `plugins/analysis-stempel/src/main/java/org/opensearch/index/analysis/pl/PolishStopTokenFilterFactory.java` | ソース | ストップワードフィルタ |
