# 機能設計書 77-ウクライナ語アナライザ

## 概要

本ドキュメントは、OpenSearchのウクライナ語アナライザプラグイン（analysis-ukrainian）の機能設計について記述する。Morfologik辞書を基盤としたウクライナ語テキスト解析機能を提供するプラグインである。

### 本機能の処理概要

ウクライナ語アナライザプラグインは、UkrainianMorfologikAnalyzer（Lucene）を使用してウクライナ語テキストのレンマ化（語幹抽出）、ストップワードフィルタリング、ステム除外処理を提供する。

**業務上の目的・背景**：ウクライナ語はスラブ語族に属する高度な屈折語であり、豊富な語形変化パターンを持つ。Morfologikベースの辞書駆動型レンマ化により、正確な語根の抽出と検索精度の向上を実現する。

**機能の利用シーン**：ウクライナ語コンテンツを含むインデックスの作成時、ウクライナ語検索クエリの解析時に使用される。

**主要な処理内容**：
1. UkrainianMorfologikAnalyzer: Morfologik辞書ベースのウクライナ語アナライザ
2. ストップワードフィルタリング（カスタマイズ可能）
3. ステム除外ワード指定

**関連システム・外部連携**：Apache Lucene Morfologik分析モジュール、Morfologikウクライナ語辞書。

**権限による制御**：特別な権限制御はない。

## 関連画面

| 画面No | 画面名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| 55 | アナライズ | 参照画面 | テキストに対してウクライナ語解析プロセスを実行しトークン分解を返す処理 |

## 機能種別

テキスト解析処理

## 入力仕様

### 入力パラメータ

| パラメータ名 | 型 | 必須 | 説明 | バリデーション |
|-------------|-----|-----|------|---------------|
| stopwords | List<String>/String | No | ストップワードリスト（デフォルト: UkrainianMorfologikAnalyzer.getDefaultStopwords()） | 単語リスト |
| stem_exclusion | List<String> | No | ステミングから除外する単語リスト | 単語リスト（デフォルト: 空） |

### 入力データソース

インデックス設定（index settings）のanalyzerセクション、またはAnalyze APIのリクエストボディ。

## 出力仕様

### 出力データ

| 項目名 | 型 | 説明 |
|--------|-----|------|
| tokens | List<Token> | レンマ化済みトークンリスト |
| token.term | String | レンマ（基本形）トークン文字列 |

### 出力先

Luceneインデックスの転置インデックス、またはAnalyze APIのレスポンス。

## 処理フロー

### 処理シーケンス

```
1. プラグインロード
   └─ AnalysisUkrainianPlugin.getAnalyzersでukrainianアナライザ登録
2. テキスト解析パイプライン実行
   └─ UkrainianMorfologikAnalyzer(Morfologik辞書レンマ化 + ストップワード除去)
```

### フローチャート

```mermaid
flowchart TD
    A[テキスト入力] --> B[UkrainianMorfologikAnalyzer]
    B --> C[トークン化 + Morfologikレンマ化]
    C --> D[ストップワード除去]
    D --> E[トークン出力]
```

## ビジネスルール

### 業務ルール

| ルールNo | ルール名 | 内容 | 適用条件 |
|---------|---------|------|---------|
| BR-77-01 | デフォルトストップワード | UkrainianMorfologikAnalyzer.getDefaultStopwords()を使用 | UkrainianAnalyzerProvider（48行目） |
| BR-77-02 | ステム除外 | stem_exclusion指定時はCharArraySet.EMPTY_SETをデフォルトとして使用 | UkrainianAnalyzerProvider（49行目） |

### 計算ロジック

Morfologik辞書は有限状態オートマトン（FSA）に基づく辞書引きレンマ化を行う。

## データベース操作仕様

本機能は直接的なデータベース操作を行わない。

### 操作別データベース影響一覧

該当なし。

### テーブル別操作詳細

該当なし。

## エラー処理

### エラーケース一覧

| エラーコード | エラー種別 | 発生条件 | 対処方法 |
|------------|----------|---------|---------|
| - | 設定エラー | 不正なストップワード/ステム除外形式 | 正しい形式で指定 |

### リトライ仕様

リトライは不要。

## トランザクション仕様

テキスト解析はステートレス処理であり、トランザクション管理は不要。

## パフォーマンス要件

FSAベースの辞書参照は高速であり、特別なパフォーマンス上の懸念はない。

## セキュリティ考慮事項

特別なセキュリティ考慮事項はない。

## 備考

AnalysisUkrainianPluginはAnalyzer x1（ukrainian）のみを提供する最小構成のプラグインである。TokenFilterやTokenizerは提供しない。

---

## コードリーディングガイド

本機能を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: データ構造を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | AnalysisUkrainianPlugin.java | `plugins/analysis-ukrainian/src/main/java/org/opensearch/plugin/analysis/ukrainian/AnalysisUkrainianPlugin.java` | ukrainianアナライザの1コンポーネントのみ登録 |

**読解のコツ**: 最小構成のAnalysisPlugin。getAnalyzers()のみオーバーライド。

#### Step 2: アナライザプロバイダを理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | UkrainianAnalyzerProvider.java | `plugins/analysis-ukrainian/src/main/java/org/opensearch/index/analysis/UkrainianAnalyzerProvider.java` | UkrainianMorfologikAnalyzerの生成。stopwordsとstem_exclusionのパース |

**主要処理フロー**:
- **45-50行目**: コンストラクタ
  - **48行目**: Analysis.parseStopWords()でストップワードをパース
  - **49行目**: Analysis.parseStemExclusion()でステム除外リストをパース
  - **47-50行目**: UkrainianMorfologikAnalyzerインスタンス生成
- **53-56行目**: get() - アナライザインスタンスを返却

### プログラム呼び出し階層図

```
AnalysisUkrainianPlugin (プラグイン登録)
    |
    +-- getAnalyzers()
            +-- UkrainianAnalyzerProvider -> UkrainianMorfologikAnalyzer
                    +-- Analysis.parseStopWords()
                    +-- Analysis.parseStemExclusion()
```

### データフロー図

```
[入力]                    [処理]                                   [出力]

ウクライナ語テキスト ───> UkrainianMorfologikAnalyzer ───> トークンリスト
                          (Morfologikレンマ化 +             (レンマ化済み)
                           ストップワード除去)
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| AnalysisUkrainianPlugin.java | `plugins/analysis-ukrainian/src/main/java/org/opensearch/plugin/analysis/ukrainian/AnalysisUkrainianPlugin.java` | ソース | プラグインエントリーポイント |
| UkrainianAnalyzerProvider.java | `plugins/analysis-ukrainian/src/main/java/org/opensearch/index/analysis/UkrainianAnalyzerProvider.java` | ソース | アナライザプロバイダ |
