# 機能設計書 8-データストリーム

## 概要

本ドキュメントは、OpenSearchにおけるデータストリーム機能の設計を記述する。時系列データ向けにインデックスを自動管理するデータストリーム機能である。

### 本機能の処理概要

データストリーム機能は、時系列データ（ログ、メトリクス、イベント等）を複数のバッキングインデックスで自動管理する抽象化レイヤーを提供する。データストリームは書き込み用の最新バッキングインデックスと、検索用の全バッキングインデックスを透過的に管理する。

**業務上の目的・背景**：時系列データは追記型（append-only）であり、過去のデータへの更新は通常発生しない。データストリームは、このようなデータパターンに最適化されたインデックス管理を提供し、ロールオーバーやデータ保持期間の管理を簡素化する。

**機能の利用シーン**：ログデータの集約と管理、メトリクスデータの時系列管理、イベントデータの自動インデックス管理、ISMポリシーと連携したライフサイクル管理。

**主要な処理内容**：
1. データストリームの作成（Composableテンプレートに基づく）
2. データストリーム情報の取得
3. データストリームの削除（バッキングインデックスも削除）
4. データストリームの統計取得
5. ロールオーバーによるバッキングインデックスの自動切り替え

**関連システム・外部連携**：Composableインデックステンプレートに依存する。ロールオーバー機能によるバッキングインデックスの自動切り替え。ISMポリシーとの連携。

**権限による制御**：`indices:admin/data_stream/create`、`indices:admin/data_stream/get`、`indices:admin/data_stream/delete`等のアクション権限が必要。

## 関連画面

| 画面No | 画面名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| 75 | データストリーム作成 | 主画面 | データストリームを作成する処理 |
| 76 | データストリーム取得 | 主画面 | データストリームの情報を返す処理 |
| 77 | データストリーム削除 | 主画面 | データストリームを削除する処理 |
| 78 | データストリーム統計 | 主画面 | データストリームの操作統計を提供する処理 |

## 機能種別

CRUD操作（Create/Read/Delete）/ クラスタ状態管理

## 入力仕様

### 入力パラメータ（データストリーム作成）

| パラメータ名 | 型 | 必須 | 説明 | バリデーション |
|-------------|-----|-----|------|---------------|
| name | String | Yes | データストリーム名 | 空でないこと |
| timeout | TimeValue | No | Ack待機タイムアウト | デフォルト30秒 |
| cluster_manager_timeout | TimeValue | No | クラスタマネージャノード待機タイムアウト | デフォルト30秒 |

### 入力データソース

REST API（PUT /_data_stream/{name}, GET /_data_stream/{name}, DELETE /_data_stream/{name}）。

## 出力仕様

### 出力データ（作成）

| 項目名 | 型 | 説明 |
|--------|-----|------|
| acknowledged | boolean | 操作が承認されたか |

### 出力データ（取得）

| 項目名 | 型 | 説明 |
|--------|-----|------|
| data_streams | List | データストリーム情報のリスト |
| name | String | データストリーム名 |
| timestamp_field | String | タイムスタンプフィールド名 |
| indices | List | バッキングインデックスのリスト |
| generation | long | 世代番号 |

### 出力先

REST APIレスポンス（JSON形式）

## 処理フロー

### 処理シーケンス（データストリーム作成）

```
1. REST APIリクエスト受信
   └─ CreateDataStreamAction.Requestの生成
2. クラスタブロックチェック
   └─ METADATA_WRITEグローバルブロックチェック
3. CreateDataStreamClusterStateUpdateRequestの構築
4. MetadataCreateDataStreamService.createDataStream()呼び出し
   └─ Composableテンプレートの検索
   └─ バッキングインデックスの作成
   └─ データストリームメタデータの登録
5. AcknowledgedResponseの返却
```

### フローチャート

```mermaid
flowchart TD
    A[REST API リクエスト受信] --> B[クラスタブロックチェック]
    B --> C[CreateDataStreamClusterStateUpdateRequest構築]
    C --> D[MetadataCreateDataStreamService.createDataStream]
    D --> E[Composableテンプレート検索]
    E -->|テンプレートなし| ERR[IllegalArgumentException]
    E -->|テンプレートあり| F[バッキングインデックス作成]
    F --> G[データストリームメタデータ登録]
    G --> H[AcknowledgedResponse返却]
```

## ビジネスルール

### 業務ルール

| ルールNo | ルール名 | 内容 | 適用条件 |
|---------|---------|------|---------|
| BR-01 | テンプレート必須 | データストリーム作成にはComposableテンプレートが必要 | 作成時 |
| BR-02 | バッキングインデックス自動管理 | バッキングインデックスは`.ds-{name}-{generation}`形式で自動作成 | 作成/ロールオーバー時 |
| BR-03 | 隠しインデックス | バッキングインデックスはhidden=trueで作成される | 常時 |
| BR-04 | エイリアス制限 | データストリームのバッキングインデックスにはエイリアスを直接付与できない | 常時 |
| BR-05 | ロールオーバー制限 | データストリームのロールオーバー時にnewIndexName, settings, mappings, aliasesは指定不可 | ロールオーバー時 |

### 計算ロジック

該当なし

## データベース操作仕様

### 操作別データベース影響一覧

| 操作 | 対象テーブル | 操作種別 | 概要 |
|-----|-------------|---------|------|
| 作成 | ClusterState.metadata.dataStreams | INSERT | データストリームメタデータの追加 |
| 作成 | ClusterState.metadata.indices | INSERT | バッキングインデックスの作成 |
| 削除 | ClusterState.metadata.dataStreams | DELETE | データストリームメタデータの削除 |
| 削除 | ClusterState.metadata.indices | DELETE | バッキングインデックスの削除 |

## エラー処理

### エラーケース一覧

| エラーコード | エラー種別 | 発生条件 | 対処方法 |
|------------|----------|---------|---------|
| 400 | ActionRequestValidationException | データストリーム名が未指定 | 名前を指定 |
| 400 | IllegalArgumentException | 対応するComposableテンプレートが存在しない | テンプレートを先に作成 |
| 400 | ResourceAlreadyExistsException | 同名のデータストリームが既存 | 別名を使用 |

### リトライ仕様

TransportClusterManagerNodeActionの標準リトライ機構が適用される。

## トランザクション仕様

データストリームの作成/削除はクラスタ状態更新としてアトミックに実行される。

## パフォーマンス要件

データストリーム操作自体は軽量であるが、バッキングインデックスの数が多い場合の統計取得は負荷が増加する。

## セキュリティ考慮事項

- 作成: `indices:admin/data_stream/create`
- 取得: `indices:admin/data_stream/get`
- 削除: `indices:admin/data_stream/delete`
- 統計: `indices:admin/data_stream/stats`

## 備考

- CreateDataStreamActionのアクション名は`indices:admin/data_stream/create`
- データストリームはComposableインデックステンプレート（V2）に依存する
- バッキングインデックス名のフォーマット: `.ds-{name}-{generation:06d}`

---

## コードリーディングガイド

本機能を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: データ構造を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | CreateDataStreamAction.java | `server/src/main/java/org/opensearch/action/admin/indices/datastream/CreateDataStreamAction.java` | 作成アクション定義とRequestの内部クラス。nameフィールドのみ |

#### Step 2: エントリーポイントを理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | CreateDataStreamAction.TransportAction | `server/src/main/java/org/opensearch/action/admin/indices/datastream/CreateDataStreamAction.java` (142行目以降) | 作成処理のメインロジック |

**主要処理フロー**:
- **162-163行目**: executor() -- SAME スレッドプール
- **172-179行目**: clusterManagerOperation() -- CreateDataStreamClusterStateUpdateRequest構築とcreateDataStream()呼び出し
- **183-185行目**: checkBlock() -- METADATA_WRITEグローバルブロック

#### Step 3: データストリームサービスを理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | MetadataCreateDataStreamService.java | `server/src/main/java/org/opensearch/cluster/metadata/MetadataCreateDataStreamService.java` | データストリーム作成の中核ロジック |

### プログラム呼び出し階層図

```
REST API (PUT /_data_stream/{name})
    |
    +-- CreateDataStreamAction.TransportAction
          |
          +-- checkBlock() -- METADATA_WRITE グローバルブロック
          |
          +-- clusterManagerOperation()
                |
                +-- CreateDataStreamClusterStateUpdateRequest構築
                |
                +-- MetadataCreateDataStreamService.createDataStream()
                      +-- lookupTemplateForDataStream()
                      +-- バッキングインデックス作成
                      +-- DataStream メタデータ登録
```

### データフロー図

```
[入力]                       [処理]                              [出力]

CreateDataStreamAction    CreateDataStreamAction             AcknowledgedResponse
  .Request -----------> .TransportAction -----------------> (acknowledged)
 (name)                  |
                         +-> MetadataCreateDataStreamService
                              +-> lookupTemplate()
                              +-> createBackingIndex()
                              +-> DataStream メタデータ登録
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| CreateDataStreamAction.java | `server/src/main/java/org/opensearch/action/admin/indices/datastream/CreateDataStreamAction.java` | ソース | 作成アクション |
| GetDataStreamAction.java | `server/src/main/java/org/opensearch/action/admin/indices/datastream/GetDataStreamAction.java` | ソース | 取得アクション |
| DeleteDataStreamAction.java | `server/src/main/java/org/opensearch/action/admin/indices/datastream/DeleteDataStreamAction.java` | ソース | 削除アクション |
| DataStreamsStatsAction.java | `server/src/main/java/org/opensearch/action/admin/indices/datastream/DataStreamsStatsAction.java` | ソース | 統計アクション |
| MetadataCreateDataStreamService.java | `server/src/main/java/org/opensearch/cluster/metadata/MetadataCreateDataStreamService.java` | ソース | データストリーム作成サービス |
| DataStream.java | `server/src/main/java/org/opensearch/cluster/metadata/DataStream.java` | ソース | データストリームメタデータ |
