# 機能設計書 92-Netty4トランスポート

## 概要

本ドキュメントは、OpenSearchにおけるNetty4ベースのノード間通信トランスポート機能の設計を記述する。Netty4トランスポートは、クラスタ内のノード間でデータを送受信するための基盤的な通信レイヤーである。

### 本機能の処理概要

Netty4トランスポートは、Apache Netty 4フレームワークを使用してOpenSearchノード間のTCPベースの通信を実現する機能を提供する。

**業務上の目的・背景**：分散検索エンジンであるOpenSearchでは、ノード間の高速で信頼性の高い通信が不可欠である。Netty4トランスポートは、非同期I/Oを活用した高スループット・低レイテンシの通信基盤を提供し、検索リクエストの分散処理、シャードレプリケーション、クラスタ状態の伝播など、あらゆるノード間通信を支える。

**機能の利用シーン**：OpenSearchクラスタが起動すると自動的にNetty4トランスポートが初期化され、全てのノード間通信に使用される。検索クエリの分散、インデックスリクエストの転送、クラスタ状態の同期、シャードリカバリなど、ノード間のあらゆるデータ転送に使用される。

**主要な処理内容**：
1. クライアントBootstrapの作成 - 他のノードへの接続用ブートストラップ設定
2. サーバBootstrapの作成 - 他のノードからの接続受付用ブートストラップ設定
3. プロファイル別接続管理 - low/med/high/pingの4種類の接続プロファイル管理
4. TCP接続パラメータ制御 - TCP_NODELAY、SO_KEEPALIVE、バッファサイズ等の設定
5. チャネルハンドラパイプライン構築 - メッセージのエンコード/デコード処理

**関連システム・外部連携**：TcpTransport基底クラスを継承し、TransportServiceを通じてOpenSearchの全モジュールが利用する。SharedGroupFactoryを通じてHTTPトランスポートとイベントループグループを共有する。

**権限による制御**：トランスポート層は全ノードで自動的に起動されるため、個別の権限制御はない。ただし、ノードのロール設定によりトランスポートポートの公開範囲が変わる。

## 関連画面

| 画面No | 画面名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| - | - | - | Netty4トランスポートに直接対応する画面はない（インフラストラクチャ機能） |

## 機能種別

データ連携（ノード間通信基盤）

## 入力仕様

### 入力パラメータ

| パラメータ名 | 型 | 必須 | 説明 | バリデーション |
|-------------|-----|-----|------|---------------|
| transport.netty.worker_count | Integer | No | ワーカースレッド数 | 1以上、デフォルトはプロセッサ数 |
| transport.netty.receive_predictor_size | ByteSizeValue | No | 受信バッファ予測サイズ | デフォルト64KB |
| transport.netty.receive_predictor_min | ByteSizeValue | No | 受信バッファ最小サイズ | デフォルトはreceive_predictor_size |
| transport.netty.receive_predictor_max | ByteSizeValue | No | 受信バッファ最大サイズ | デフォルトはreceive_predictor_size |
| transport.netty.boss_count | Integer | No | ボススレッド数 | 1以上、デフォルト1 |

### 入力データソース

opensearch.ymlまたはクラスタ設定からの設定値。他のノードからのTCPソケット接続。

## 出力仕様

### 出力データ

| 項目名 | 型 | 説明 |
|--------|-----|------|
| Netty4TcpChannel | Channel | 確立されたTCPチャネル |
| BoundTransportAddress | TransportAddress | バインドされたトランスポートアドレス |

### 出力先

TCPソケットを通じたネットワーク出力。

## 処理フロー

### 処理シーケンス

```
1. doStart()が呼ばれる
   └─ SharedGroupFactory.getTransportGroup()でイベントループグループ取得
2. createClientBootstrap()でクライアント用ブートストラップ生成
   └─ チャネル型、バッファアロケータ、TCPオプションを設定
3. 各プロファイル（default等）についてcreateServerBootstrap()実行
   └─ サーバ側のチャネルパイプライン設定
4. bindServer()でサーバをポートにバインド
   └─ バインドアドレスの解決、ポートバインド
5. 接続要求時: initChannel()でチャネルハンドラを設定
   └─ NettyByteBufSizer → Netty4MessageChannelHandler
```

### フローチャート

```mermaid
flowchart TD
    A[doStart] --> B[SharedGroup取得]
    B --> C[createClientBootstrap]
    C --> D{NetworkServer?}
    D -->|Yes| E[プロファイル毎にcreateServerBootstrap]
    D -->|No| G[super.doStart]
    E --> F[bindServer]
    F --> G
    G --> H[起動完了]
```

## ビジネスルール

### 業務ルール

| ルールNo | ルール名 | 内容 | 適用条件 |
|---------|---------|------|---------|
| BR-92-01 | 接続プロファイル | low/med/high/pingの4種類の接続タイプがある | ノード間通信時 |
| BR-92-02 | バッファアロケータ共有 | NettyAllocatorを通じてHTTPトランスポートとアロケータを共有 | 常時 |
| BR-92-03 | TCPキープアライブ | TCP_KEEP_ALIVEが有効時、KEEP_IDLE/INTERVAL/COUNTを設定可能 | TCP_KEEP_ALIVE=true時 |
| BR-92-04 | 受信バッファ予測 | min=maxの場合FixedRecvByteBufAllocator、それ以外はAdaptiveRecvByteBufAllocatorを使用 | 常時 |

### 計算ロジック

ワーカースレッド数のデフォルト値: OpenSearchExecutors.allocatedProcessors(settings) で算出される（ノードに割り当てられたプロセッサ数）。

## データベース操作仕様

### 操作別データベース影響一覧

| 操作 | 対象テーブル | 操作種別 | 概要 |
|-----|-------------|---------|------|
| - | - | - | データベース操作なし（通信レイヤーのみ） |

### テーブル別操作詳細

該当なし。Netty4トランスポートはデータの転送のみを担い、データの永続化は行わない。

## エラー処理

### エラーケース一覧

| エラーコード | エラー種別 | 発生条件 | 対処方法 |
|------------|----------|---------|---------|
| BindTransportException | バインドエラー | ポートが既に使用中 | 別のポートを指定 |
| ConnectTransportException | 接続エラー | リモートノードへの接続失敗 | ネットワーク設定を確認 |
| IOException | I/Oエラー | チャネルの読み書きエラー | ネットワーク接続を確認 |

### リトライ仕様

トランスポートレベルでの接続リトライはTransportServiceが管理する。

## トランザクション仕様

トランスポート層にトランザクション概念はない。メッセージは個別に送受信される。

## パフォーマンス要件

- 非同期I/O（NIO）を使用し、少数のスレッドで大量の接続を処理
- ワーカースレッド数はプロセッサ数に合わせて自動調整
- 受信バッファサイズの予測により効率的なメモリ使用を実現

## セキュリティ考慮事項

- TLS/SSLによる暗号化通信をサポート（SecureTransportSettingsProviderと連携）
- ノード間通信の認証はセキュリティプラグインに委譲

## 備考

- Netty4トランスポートはOpenSearchのデフォルトトランスポート実装である
- modulesディレクトリに配置されるため、常にロードされる
- 接続タイプの説明: Low=バッチ操作（リカバリ等）、Med=通常検索/インデックス、High=クラスタ状態、Ping=ノード検出

---

## コードリーディングガイド

本機能を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: データ構造を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | TcpTransport.java | `server/src/main/java/org/opensearch/transport/TcpTransport.java` | Netty4Transportの基底クラス。プロファイル設定、バインド処理の抽象化 |
| 1-2 | SharedGroupFactory.java | `server/src/main/java/org/opensearch/transport/SharedGroupFactory.java` | Nettyイベントループグループの共有管理 |

**読解のコツ**: TcpTransportのProfileSettingsがlow/med/high/pingの接続プロファイルを定義していることを理解する。

#### Step 2: エントリーポイントを理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | Netty4Transport.java | `modules/transport-netty4/src/main/java/org/opensearch/transport/netty4/Netty4Transport.java` | メインクラス。doStart()がエントリーポイント |

**主要処理フロー**:
1. **127-155行目**: コンストラクタ - 設定の初期化、バッファアロケータの設定
2. **158-176行目**: doStart() - SharedGroup取得、ブートストラップ作成、バインド
3. **178-227行目**: createClientBootstrap() - クライアント側TCPオプション設定
4. **229-249行目**: createServerBootstrap() - サーバ側ブートストラップ作成

#### Step 3: チャネルハンドラを理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | Netty4MessageChannelHandler.java | `modules/transport-netty4/src/main/java/org/opensearch/transport/netty4/Netty4MessageChannelHandler.java` | メッセージの読み込みと書き込みのハンドリング |
| 3-2 | Netty4TcpChannel.java | `modules/transport-netty4/src/main/java/org/opensearch/transport/netty4/Netty4TcpChannel.java` | TCPチャネルのラッパー |
| 3-3 | Netty4TcpServerChannel.java | `modules/transport-netty4/src/main/java/org/opensearch/transport/netty4/Netty4TcpServerChannel.java` | サーバチャネルのラッパー |

### プログラム呼び出し階層図

```
Netty4Transport.doStart()
    |
    +-- SharedGroupFactory.getTransportGroup()
    |
    +-- createClientBootstrap(sharedGroup)
    |    +-- Bootstrap設定（チャネル型、TCPオプション）
    |
    +-- createServerBootstrap(profileSettings, sharedGroup)
    |    +-- ServerBootstrap設定
    |    +-- ChannelInitializer設定
    |         +-- NettyByteBufSizer
    |         +-- Netty4MessageChannelHandler
    |
    +-- bindServer(profileSettings)
    |    +-- TcpTransport.bindServer()
    |
    +-- super.doStart()
```

### データフロー図

```
[入力]                        [処理]                           [出力]

ノード間メッセージ ──────> Netty4Transport ──────> TCPソケット出力
  (TransportRequest)     ChannelPipeline:             |
                         NettyByteBufSizer        リモートノード
                         Netty4MessageChannelHandler
                              |
                         TcpTransport.inboundMessage()
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| Netty4Transport.java | `modules/transport-netty4/src/main/java/org/opensearch/transport/netty4/Netty4Transport.java` | ソース | Netty4トランスポート本体 |
| Netty4MessageChannelHandler.java | `modules/transport-netty4/src/main/java/org/opensearch/transport/netty4/Netty4MessageChannelHandler.java` | ソース | メッセージハンドラ |
| Netty4TcpChannel.java | `modules/transport-netty4/src/main/java/org/opensearch/transport/netty4/Netty4TcpChannel.java` | ソース | TCPチャネルラッパー |
| Netty4TcpServerChannel.java | `modules/transport-netty4/src/main/java/org/opensearch/transport/netty4/Netty4TcpServerChannel.java` | ソース | サーバチャネルラッパー |
| OpenSearchLoggingHandler.java | `modules/transport-netty4/src/main/java/org/opensearch/transport/netty4/OpenSearchLoggingHandler.java` | ソース | ロギングハンドラ |
| TcpTransport.java | `server/src/main/java/org/opensearch/transport/TcpTransport.java` | ソース | TCP通信の基底クラス |
| SharedGroupFactory.java | `server/src/main/java/org/opensearch/transport/SharedGroupFactory.java` | ソース | イベントループグループ共有管理 |
| TransportSettings.java | `server/src/main/java/org/opensearch/transport/TransportSettings.java` | ソース | トランスポート設定定数 |
