# 機能設計書 93-gRPCトランスポート

## 概要

本ドキュメントは、OpenSearchにおけるgRPCプロトコルによるノード間通信トランスポート機能の設計を記述する。gRPCトランスポートは、Protocol Buffersベースの高効率な通信を実現する補助トランスポートモジュールである。

### 本機能の処理概要

gRPCトランスポートは、gRPCプロトコルを使用してOpenSearchへのアクセスを提供するモジュールである。Netty4ベースのgRPCサーバを起動し、Protocol Buffersで定義されたサービスインターフェースを通じてドキュメント操作や検索操作を公開する。

**業務上の目的・背景**：従来のREST APIに加え、gRPCプロトコルによる高効率な通信チャネルを提供することで、マイクロサービスアーキテクチャや高スループット要件のクライアントに対応する。Protocol BuffersによるバイナリシリアライゼーションはJSONと比較して高速であり、HTTP/2ベースのストリーミングも活用できる。

**機能の利用シーン**：高スループットが要求されるデータ取り込みパイプライン、マイクロサービス間の通信、プログラマティックなアクセスが中心の環境で使用される。

**主要な処理内容**：
1. gRPCサーバの起動・バインド - Netty4ベースのgRPCサーバをポートにバインド
2. サービス登録 - DocumentService、SearchService等のgRPCサービスを登録
3. インターセプタチェーン - リクエスト前後のインターセプタ処理
4. ヘルスチェック - gRPCヘルスチェックサービスの提供
5. リフレクション - ProtoReflectionServiceによるサービスディスカバリ

**関連システム・外部連携**：OpenSearch本体のClient APIを通じてドキュメント操作・検索操作を実行する。ExtensiblePluginとして他プラグインからの拡張を受け付ける。

**権限による制御**：gRPCインターセプタチェーンを通じて認証・認可を実装可能。SecureAuxTransportSettingsProviderによるTLS設定をサポート。

## 関連画面

| 画面No | 画面名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| - | - | - | gRPCトランスポートに直接対応するREST API画面はない |

## 機能種別

データ連携（gRPC通信基盤）

## 入力仕様

### 入力パラメータ

| パラメータ名 | 型 | 必須 | 説明 | バリデーション |
|-------------|-----|-----|------|---------------|
| aux.transport.types | List | No | 有効化する補助トランスポートタイプ（"transport-grpc"を含める） | - |
| aux.transport.transport-grpc.port | String | No | gRPCサーバのバインドポート範囲 | 有効なポート範囲 |
| grpc.publish_port | Integer | No | 公開ポート | -1以上 |
| grpc.host | List | No | バインド・公開ホスト | - |
| grpc.bind_host | List | No | バインドホスト | - |
| grpc.publish_host | List | No | 公開ホスト | - |
| grpc.worker_count | Integer | No | ワーカースレッド数 | 1以上 |
| grpc.netty.max_message_size | ByteSizeValue | No | 最大メッセージサイズ | - |

### 入力データソース

opensearch.ymlからの設定値。gRPCクライアントからのProtocol Buffersメッセージ。

## 出力仕様

### 出力データ

| 項目名 | 型 | 説明 |
|--------|-----|------|
| BoundTransportAddress | TransportAddress | バインドされたgRPCサーバアドレス |
| gRPCレスポンス | ProtoBuf Message | 各サービスのレスポンスメッセージ |

### 出力先

gRPCクライアントへのProtocol Buffersレスポンス。

## 処理フロー

### 処理シーケンス

```
1. GrpcPlugin.createComponents()でサービスとインターセプタを初期化
   └─ DocumentServiceImpl、SearchServiceImpl等を生成
2. GrpcPlugin.getAuxTransports()でNetty4GrpcServerTransportを生成
   └─ サービスリストとインターセプタチェーンを渡す
3. Netty4GrpcServerTransport.doStart()
   └─ バインドアドレスの解決
   └─ NioEventLoopGroupの作成
   └─ NettyServerBuilder設定
   └─ サービス登録（BindableService）
   └─ HealthStatusManager登録
   └─ ProtoReflectionService登録
   └─ Server.start()
4. リクエスト受信時
   └─ GrpcInterceptorChain実行
   └─ 対応するServiceImpl処理
   └─ Client APIを通じてOpenSearch操作実行
```

### フローチャート

```mermaid
flowchart TD
    A[GrpcPlugin.createComponents] --> B[サービス初期化]
    B --> C[getAuxTransports]
    C --> D[Netty4GrpcServerTransport生成]
    D --> E[doStart]
    E --> F[アドレス解決]
    F --> G[NioEventLoopGroup作成]
    G --> H[NettyServerBuilder設定]
    H --> I[サービス/インターセプタ登録]
    I --> J[Server.start]
    J --> K[リクエスト待受]
```

## ビジネスルール

### 業務ルール

| ルールNo | ルール名 | 内容 | 適用条件 |
|---------|---------|------|---------|
| BR-93-01 | 補助トランスポート型 | GRPC_TRANSPORT_SETTING_KEY="transport-grpc"で識別 | 常時 |
| BR-93-02 | ヘルスチェック提供 | gRPCヘルスチェックプロトコルのサービスを常に提供 | 常時 |
| BR-93-03 | リフレクション提供 | ProtoReflectionServiceを常に提供 | 常時 |
| BR-93-04 | 拡張可能設計 | ExtensiblePluginとして他プラグインからサービス/インターセプタを追加可能 | 常時 |

### 計算ロジック

特になし。

## データベース操作仕様

### 操作別データベース影響一覧

| 操作 | 対象テーブル | 操作種別 | 概要 |
|-----|-------------|---------|------|
| - | - | - | gRPCトランスポート自体はデータベース操作を行わない（サービス実装が個別に操作する） |

### テーブル別操作詳細

該当なし。

## エラー処理

### エラーケース一覧

| エラーコード | エラー種別 | 発生条件 | 対処方法 |
|------------|----------|---------|---------|
| BindTransportException | バインドエラー | ポートが既に使用中 | 別のポートを指定 |
| IOException | サーバ起動エラー | サーバの起動に失敗 | 設定とネットワーク環境を確認 |
| StatusRuntimeException | gRPCエラー | サービス実行時のエラー | gRPCステータスコードに基づいて対処 |

### リトライ仕様

gRPCクライアント側でリトライポリシーを設定する。サーバ側ではリトライ処理は行わない。

## トランザクション仕様

gRPCリクエストは個別に処理され、トランザクション管理はサービス実装が担当する。

## パフォーマンス要件

- HTTP/2ベースの多重化通信により高スループットを実現
- Protocol Buffersによるバイナリシリアライゼーションでレイテンシを低減
- 専用スレッドプール（GRPC_THREAD_POOL_NAME="grpc"）で処理

## セキュリティ考慮事項

- SecureAuxTransportSettingsProviderによるTLS設定をサポート
- SecureNetty4GrpcServerTransportでTLS付きのgRPCサーバを提供
- GrpcInterceptorChainで認証・認可インターセプタを追加可能

## 備考

- gRPCトランスポートはmodulesディレクトリに配置される
- 有効化にはaux.transport.typesに"transport-grpc"を追加する必要がある
- 専用スレッドプール"grpc"をFixedExecutorBuilderで作成

---

## コードリーディングガイド

本機能を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: データ構造を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | AuxTransport.java | `server/src/main/java/org/opensearch/transport/AuxTransport.java` | 補助トランスポートの基底クラス |
| 1-2 | GrpcInterceptorChain.java | `modules/transport-grpc/src/main/java/org/opensearch/transport/grpc/interceptor/GrpcInterceptorChain.java` | インターセプタチェーンの定義 |

**読解のコツ**: AuxTransportがLifecycleComponentを継承しているため、doStart()/doStop()がライフサイクル管理のキーメソッドである。

#### Step 2: エントリーポイントを理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | GrpcPlugin.java | `modules/transport-grpc/src/main/java/org/opensearch/transport/grpc/GrpcPlugin.java` | プラグインのエントリーポイント。createComponents()とgetAuxTransports()が主要メソッド |

**主要処理フロー**:
1. **78行目**: GrpcPluginクラス定義 - NetworkPlugin, ExtensiblePluginを実装
2. **82行目**: GRPC_THREAD_POOL_NAME = "grpc" - 専用スレッドプール名
3. **97-100行目**: loadExtensions() - 他プラグインからの拡張ロード

#### Step 3: gRPCサーバ実装を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | Netty4GrpcServerTransport.java | `modules/transport-grpc/src/main/java/org/opensearch/transport/grpc/Netty4GrpcServerTransport.java` | gRPCサーバの実装本体 |

**主要処理フロー**:
- **64行目**: AuxTransportを継承
- **70行目**: GRPC_TRANSPORT_SETTING_KEY = "transport-grpc"
- **76-78行目**: SETTING_GRPC_PORT - ポート設定
- **83行目**: SETTING_GRPC_PUBLISH_PORT - 公開ポート設定

#### Step 4: サービス実装を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 4-1 | DocumentServiceImpl.java | `modules/transport-grpc/src/main/java/org/opensearch/transport/grpc/services/DocumentServiceImpl.java` | ドキュメント操作のgRPCサービス |
| 4-2 | SearchServiceImpl.java | `modules/transport-grpc/src/main/java/org/opensearch/transport/grpc/services/SearchServiceImpl.java` | 検索操作のgRPCサービス |

### プログラム呼び出し階層図

```
GrpcPlugin
    |
    +-- createComponents()
    |    +-- DocumentServiceImpl(client)
    |    +-- SearchServiceImpl(client)
    |    +-- GrpcInterceptorChain(interceptorProviders)
    |
    +-- getAuxTransports()
         +-- Netty4GrpcServerTransport
              |
              +-- doStart()
              |    +-- NettyServerBuilder.forAddress()
              |    +-- addService(BindableService)
              |    +-- addService(HealthStatusManager)
              |    +-- addService(ProtoReflectionService)
              |    +-- intercept(GrpcInterceptorChain)
              |    +-- Server.start()
              |
              +-- doStop()
                   +-- Server.shutdown()
```

### データフロー図

```
[入力]                        [処理]                           [出力]

gRPCクライアント ──────> Netty4GrpcServerTransport ──────> gRPCレスポンス
  (ProtoBuf Request)     GrpcInterceptorChain              (ProtoBuf Response)
                         ServiceImpl
                              |
                         OpenSearch Client API
                              |
                         OpenSearch内部処理
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| GrpcPlugin.java | `modules/transport-grpc/src/main/java/org/opensearch/transport/grpc/GrpcPlugin.java` | ソース | プラグインメインクラス |
| Netty4GrpcServerTransport.java | `modules/transport-grpc/src/main/java/org/opensearch/transport/grpc/Netty4GrpcServerTransport.java` | ソース | gRPCサーバ実装 |
| GrpcInterceptorChain.java | `modules/transport-grpc/src/main/java/org/opensearch/transport/grpc/interceptor/GrpcInterceptorChain.java` | ソース | インターセプタチェーン |
| DocumentServiceImpl.java | `modules/transport-grpc/src/main/java/org/opensearch/transport/grpc/services/DocumentServiceImpl.java` | ソース | ドキュメントサービス実装 |
| SearchServiceImpl.java | `modules/transport-grpc/src/main/java/org/opensearch/transport/grpc/services/SearchServiceImpl.java` | ソース | 検索サービス実装 |
| SecureNetty4GrpcServerTransport.java | `modules/transport-grpc/src/main/java/org/opensearch/transport/grpc/ssl/SecureNetty4GrpcServerTransport.java` | ソース | TLS対応gRPCサーバ |
| AuxTransport.java | `server/src/main/java/org/opensearch/transport/AuxTransport.java` | ソース | 補助トランスポート基底クラス |
