# 機能設計書 94-Reactor Netty4トランスポート

## 概要

本ドキュメントは、OpenSearchにおけるReactor Netty4ベースのトランスポートプラグインの設計を記述する。Reactor Netty4プラグインは、Project ReactorベースのリアクティブなHTTPサーバトランスポートを提供する実験的プラグインである。

### 本機能の処理概要

Reactor Netty4プラグインは、Reactor Nettyフレームワークを使用してHTTPサーバトランスポートを実装し、ストリーミングレスポンスやHTTP/2（H2C）、HTTP/3のサポートを提供する。

**業務上の目的・背景**：従来のNetty4ベースのHTTPトランスポートに加え、リアクティブプログラミングモデルに基づくHTTPトランスポートを提供することで、ストリーミングレスポンスや非同期処理のより効率的な実装を実現する。HTTP/2のH2C（cleartext）やHTTP/3の実験的サポートも含む。

**機能の利用シーン**：ストリーミング検索結果の効率的な配信、大量の並行リクエスト処理、HTTP/2やHTTP/3による通信効率の改善が求められる環境で使用される。

**主要な処理内容**：
1. HTTPサーバトランスポートの提供 - ReactorNetty4HttpServerTransportの実装
2. ストリーミングレスポンス - ReactorNetty4StreamingResponseProducerによるストリーミング出力
3. ストリーミングリクエスト消費 - ReactorNetty4StreamingRequestConsumerによるストリーミング入力
4. セキュアHTTPトランスポート - TLS対応のHTTPサーバ提供
5. SharedGroupFactory - イベントループグループの共有管理

**関連システム・外部連携**：NetworkPluginインターフェースを通じてOpenSearchのHTTPサーバとして登録される。SecureHttpTransportSettingsProviderと連携してTLSサポートを提供。

**権限による制御**：HTTPレベルの認証・認可はOpenSearchのセキュリティフレームワークに委譲される。

## 関連画面

| 画面No | 画面名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| - | - | - | Reactor Netty4トランスポートに直接対応する画面はない（インフラストラクチャ機能） |

## 機能種別

データ連携（HTTP通信基盤）

## 入力仕様

### 入力パラメータ

| パラメータ名 | 型 | 必須 | 説明 | バリデーション |
|-------------|-----|-----|------|---------------|
| http.type | String | No | HTTPトランスポートタイプ（"reactor-netty4"を指定） | - |
| http.h2c.max_content_length | ByteSizeValue | No | H2Cの最大コンテンツ長 | - |
| http.h3.max_stream_local_length | Integer | No | HTTP/3ローカルストリーム最大長 | - |
| http.h3.max_stream_remote_length | Integer | No | HTTP/3リモートストリーム最大長 | - |
| http.h3.max_streams | Integer | No | HTTP/3最大ストリーム数 | - |

### 入力データソース

opensearch.ymlからの設定値。HTTPクライアントからのリクエスト。

## 出力仕様

### 出力データ

| 項目名 | 型 | 説明 |
|--------|-----|------|
| HTTPレスポンス | HttpResponse | 通常またはストリーミング形式のHTTPレスポンス |

### 出力先

HTTPクライアントへのレスポンス出力。

## 処理フロー

### 処理シーケンス

```
1. ReactorNetty4Plugin.getHttpTransports()でトランスポート登録
   └─ "reactor-netty4"キーでReactorNetty4HttpServerTransportを登録
   └─ "reactor-netty4-secure"キーでセキュアバージョンを登録
2. ReactorNetty4HttpServerTransport.doStart()
   └─ Reactor Netty HttpServerの設定
   └─ ストリーミングハンドラの設定
   └─ サーババインド
3. リクエスト受信時
   └─ ReactorNetty4HttpRequestの生成
   └─ Dispatcherへの振り分け
   └─ レスポンス生成（通常/ストリーミング）
```

### フローチャート

```mermaid
flowchart TD
    A[ReactorNetty4Plugin] --> B{http.type設定}
    B -->|reactor-netty4| C[ReactorNetty4HttpServerTransport]
    B -->|reactor-netty4-secure| D[セキュアHTTPトランスポート]
    C --> E[doStart]
    D --> E
    E --> F[HttpServer設定]
    F --> G[サーババインド]
    G --> H[リクエスト待受]
    H --> I{ストリーミング?}
    I -->|Yes| J[StreamingRequestConsumer]
    I -->|No| K[NonStreamingRequestConsumer]
    J --> L[StreamingResponseProducer]
    K --> M[通常レスポンス]
```

## ビジネスルール

### 業務ルール

| ルールNo | ルール名 | 内容 | 適用条件 |
|---------|---------|------|---------|
| BR-94-01 | トランスポート名 | "reactor-netty4"で識別される | http.type設定時 |
| BR-94-02 | セキュアトランスポート名 | "reactor-netty4-secure"で識別される | セキュアHTTP使用時 |
| BR-94-03 | イベントループ共有 | SharedGroupFactoryを通じてイベントループグループを共有 | 常時 |
| BR-94-04 | ストリーミング対応 | ストリーミングリクエスト/レスポンスの両方に対応 | 対応するAPIエンドポイント使用時 |

### 計算ロジック

特になし。

## データベース操作仕様

### 操作別データベース影響一覧

| 操作 | 対象テーブル | 操作種別 | 概要 |
|-----|-------------|---------|------|
| - | - | - | データベース操作なし（HTTPトランスポートレイヤーのみ） |

### テーブル別操作詳細

該当なし。

## エラー処理

### エラーケース一覧

| エラーコード | エラー種別 | 発生条件 | 対処方法 |
|------------|----------|---------|---------|
| BindHttpException | バインドエラー | HTTPポートが既に使用中 | 別のポートを指定 |
| IOException | I/Oエラー | リクエスト/レスポンスの読み書きエラー | ネットワーク接続を確認 |

### リトライ仕様

HTTPクライアント側でリトライポリシーを設定する。サーバ側ではリトライ処理は行わない。

## トランザクション仕様

HTTPリクエストは個別に処理され、トランザクション管理は上位レイヤーが担当する。

## パフォーマンス要件

- Reactor Nettyのリアクティブモデルにより少数スレッドで大量の並行処理
- HTTP/2 H2Cサポートによるマルチプレクシング
- ストリーミングによるメモリ効率の向上

## セキュリティ考慮事項

- SecureHttpTransportSettingsProviderによるTLS設定をサポート
- "reactor-netty4-secure"トランスポートでTLS暗号化通信を提供

## 備考

- 本プラグインは実験的機能であり、pluginsディレクトリに配置される
- http.typeに"reactor-netty4"を指定することで有効化される
- デフォルトのHTTPトランスポートはNetty4HttpServerTransport

---

## コードリーディングガイド

本機能を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: データ構造を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | SharedGroupFactory.java | `plugins/transport-reactor-netty4/src/main/java/org/opensearch/transport/reactor/SharedGroupFactory.java` | イベントループグループの共有管理 |

**読解のコツ**: Reactor Nettyの非同期モデルではイベントループグループの管理が重要。SharedGroupFactoryがリソース共有の要。

#### Step 2: エントリーポイントを理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | ReactorNetty4Plugin.java | `plugins/transport-reactor-netty4/src/main/java/org/opensearch/transport/reactor/ReactorNetty4Plugin.java` | プラグインメインクラス |

**主要処理フロー**:
1. **37行目**: ReactorNetty4Plugin - NetworkPluginを実装
2. **41行目**: REACTOR_NETTY_HTTP_TRANSPORT_NAME = "reactor-netty4"
3. **46行目**: REACTOR_NETTY_SECURE_HTTP_TRANSPORT_NAME = "reactor-netty4-secure"
4. **59-65行目**: getSettings() - H2C/H3関連の設定を公開
5. **83-100行目**: getHttpTransports() - HTTPトランスポートの登録

#### Step 3: HTTPサーバ実装を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | ReactorNetty4HttpServerTransport.java | `plugins/transport-reactor-netty4/src/main/java/org/opensearch/http/reactor/netty4/ReactorNetty4HttpServerTransport.java` | HTTPサーバの実装本体 |
| 3-2 | ReactorNetty4HttpRequest.java | `plugins/transport-reactor-netty4/src/main/java/org/opensearch/http/reactor/netty4/ReactorNetty4HttpRequest.java` | HTTPリクエストのラッパー |
| 3-3 | ReactorNetty4HttpResponse.java | `plugins/transport-reactor-netty4/src/main/java/org/opensearch/http/reactor/netty4/ReactorNetty4HttpResponse.java` | HTTPレスポンスのラッパー |

#### Step 4: ストリーミング処理を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 4-1 | ReactorNetty4StreamingResponseProducer.java | `plugins/transport-reactor-netty4/src/main/java/org/opensearch/http/reactor/netty4/ReactorNetty4StreamingResponseProducer.java` | ストリーミングレスポンスの生成 |
| 4-2 | ReactorNetty4StreamingRequestConsumer.java | `plugins/transport-reactor-netty4/src/main/java/org/opensearch/http/reactor/netty4/ReactorNetty4StreamingRequestConsumer.java` | ストリーミングリクエストの消費 |
| 4-3 | StreamingHttpContentSender.java | `plugins/transport-reactor-netty4/src/main/java/org/opensearch/http/reactor/netty4/StreamingHttpContentSender.java` | ストリーミングコンテンツの送信 |

### プログラム呼び出し階層図

```
ReactorNetty4Plugin
    |
    +-- getHttpTransports()
    |    +-- ReactorNetty4HttpServerTransport
    |    +-- セキュアHTTPトランスポート（SecureHttpTransportSettingsProvider使用時）
    |
    +-- ReactorNetty4HttpServerTransport.doStart()
         |
         +-- HttpServer設定
         +-- ルート設定（ストリーミング/非ストリーミング）
         |    +-- ReactorNetty4StreamingRequestConsumer
         |    +-- ReactorNetty4NonStreamingRequestConsumer
         |
         +-- ReactorNetty4StreamingResponseProducer
         +-- ReactorNetty4NonStreamingHttpChannel
```

### データフロー図

```
[入力]                          [処理]                              [出力]

HTTPリクエスト ──────> ReactorNetty4HttpServerTransport ──────> HTTPレスポンス
                       ReactorNetty4HttpRequest                 (通常/ストリーミング)
                            |
                       Dispatcher
                            |
                       OpenSearch REST処理
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| ReactorNetty4Plugin.java | `plugins/transport-reactor-netty4/src/main/java/org/opensearch/transport/reactor/ReactorNetty4Plugin.java` | ソース | プラグインメインクラス |
| ReactorNetty4HttpServerTransport.java | `plugins/transport-reactor-netty4/src/main/java/org/opensearch/http/reactor/netty4/ReactorNetty4HttpServerTransport.java` | ソース | HTTPサーバ実装 |
| ReactorNetty4Transport.java | `plugins/transport-reactor-netty4/src/main/java/org/opensearch/transport/reactor/netty4/ReactorNetty4Transport.java` | ソース | ノード間トランスポート実装 |
| SharedGroupFactory.java | `plugins/transport-reactor-netty4/src/main/java/org/opensearch/transport/reactor/SharedGroupFactory.java` | ソース | イベントループ共有管理 |
| ReactorNetty4StreamingResponseProducer.java | `plugins/transport-reactor-netty4/src/main/java/org/opensearch/http/reactor/netty4/ReactorNetty4StreamingResponseProducer.java` | ソース | ストリーミングレスポンス |
| ReactorNetty4StreamingRequestConsumer.java | `plugins/transport-reactor-netty4/src/main/java/org/opensearch/http/reactor/netty4/ReactorNetty4StreamingRequestConsumer.java` | ソース | ストリーミングリクエスト消費 |
| ReactorNetty4HttpRequest.java | `plugins/transport-reactor-netty4/src/main/java/org/opensearch/http/reactor/netty4/ReactorNetty4HttpRequest.java` | ソース | HTTPリクエストラッパー |
| ReactorNetty4HttpResponse.java | `plugins/transport-reactor-netty4/src/main/java/org/opensearch/http/reactor/netty4/ReactorNetty4HttpResponse.java` | ソース | HTTPレスポンスラッパー |
| SslUtils.java | `plugins/transport-reactor-netty4/src/main/java/org/opensearch/http/reactor/netty4/ssl/SslUtils.java` | ソース | SSL/TLSユーティリティ |
