# 機能設計書 97-拡張機能フレームワーク

## 概要

本ドキュメントは、OpenSearchにおける外部拡張機能（Extensions）の管理基盤の設計を記述する。ExtensionsManagerは、OpenSearchの外部プロセスとして動作する拡張機能との通信・管理を担う。

### 本機能の処理概要

拡張機能フレームワークは、OpenSearchノードとは別プロセスで動作する外部拡張機能（Extensions）を登録・初期化し、トランスポートプロトコルを通じた通信を管理する。

**業務上の目的・背景**：従来のプラグインはOpenSearchプロセス内で動作するため、プラグインの不具合がノード全体に影響する可能性があった。拡張機能フレームワークは、拡張機能を別プロセスとして分離実行することで、安全性と独立したデプロイメントを実現する。これによりプラグインのホットデプロイや言語非依存の拡張開発が可能になる。

**機能の利用シーン**：外部プロセスとして実装された拡張機能をOpenSearchに登録し、REST ActionやTransport Actionの追加、カスタム設定の登録を行う場合に使用される。

**主要な処理内容**：
1. 拡張機能の初期化 - extensions.yml設定ファイルから拡張機能を読み込み、初期化リクエストを送信
2. REST Action登録 - 拡張機能が提供するREST Actionの登録処理
3. Transport Action登録 - 拡張機能が提供するTransport Actionの登録処理
4. カスタム設定登録 - 拡張機能固有の設定の登録処理
5. クラスタ状態・設定の共有 - 拡張機能へのクラスタ状態・環境設定の伝達

**関連システム・外部連携**：TransportServiceを通じて拡張機能プロセスと通信する。IdentityServiceと連携して認証トークンを管理する。

**権限による制御**：IdentityServiceを通じた拡張機能の認証。拡張機能毎のサービスアカウントによるアクセス制御。

## 関連画面

| 画面No | 画面名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| - | - | - | 拡張機能フレームワークに直接対応するREST API画面はない |

## 機能種別

フレームワーク基盤（拡張機能管理）

## 入力仕様

### 入力パラメータ

| パラメータ名 | 型 | 必須 | 説明 | バリデーション |
|-------------|-----|-----|------|---------------|
| extensions.yml | File | No | 拡張機能の定義ファイル | YAML形式 |
| Extension.uniqueId | String | Yes | 拡張機能の一意識別子 | 一意であること |
| Extension.hostAddress | String | Yes | 拡張機能プロセスのアドレス | 有効なIP/ホスト名 |
| Extension.port | Integer | Yes | 拡張機能プロセスのポート | 有効なポート番号 |
| Extension.version | String | Yes | 拡張機能のバージョン | - |

### 入力データソース

extensions.yml設定ファイル。拡張機能プロセスからのトランスポートリクエスト。

## 出力仕様

### 出力データ

| 項目名 | 型 | 説明 |
|--------|-----|------|
| InitializeExtensionResponse | Response | 拡張機能の初期化結果 |
| ClusterStateResponse | Response | クラスタ状態情報 |
| EnvironmentSettingsResponse | Response | 環境設定情報 |

### 出力先

拡張機能プロセスへのトランスポートレスポンス。ActionModule（REST Action登録）。

## 処理フロー

### 処理シーケンス

```
1. ExtensionsManager初期化
   └─ extensions.ymlの読み込み
   └─ 拡張機能の設定情報をマップに保存
2. initializeServicesAndRestHandler()
   └─ RestActionsRequestHandler初期化
   └─ CustomSettingsRequestHandler初期化
   └─ ExtensionTransportActionsHandler初期化
   └─ リクエストハンドラの登録
3. 各拡張機能の初期化
   └─ TransportServiceを通じてINIT_REQUESTを送信
   └─ InitializeExtensionResponseを受信
4. 拡張機能からの登録リクエスト処理
   └─ RegisterRestActionsRequest - REST Actionの登録
   └─ RegisterTransportActionsRequest - Transport Actionの登録
   └─ RegisterCustomSettingsRequest - カスタム設定の登録
5. 拡張機能へのクラスタ情報提供
   └─ クラスタ状態の共有
   └─ クラスタ設定の共有
   └─ 環境設定の共有
```

### フローチャート

```mermaid
flowchart TD
    A[ExtensionsManager初期化] --> B[extensions.yml読み込み]
    B --> C[initializeServicesAndRestHandler]
    C --> D[リクエストハンドラ登録]
    D --> E[拡張機能へINIT_REQUEST送信]
    E --> F{初期化成功?}
    F -->|Yes| G[拡張機能登録完了]
    F -->|No| H[エラーログ出力]
    G --> I[REST/TransportAction登録待受]
    I --> J[カスタム設定登録待受]
```

## ビジネスルール

### 業務ルール

| ルールNo | ルール名 | 内容 | 適用条件 |
|---------|---------|------|---------|
| BR-97-01 | 別プロセス実行 | 拡張機能はOpenSearchとは別プロセスで動作 | 常時 |
| BR-97-02 | トランスポート通信 | 拡張機能との通信はTransportServiceを使用 | 常時 |
| BR-97-03 | 初期化タイムアウト | 拡張機能の初期化リクエストは10秒でタイムアウト | 初期化時 |
| BR-97-04 | 拡張機能識別 | uniqueIdで一意に識別 | 常時 |

### 計算ロジック

特になし。

## データベース操作仕様

### 操作別データベース影響一覧

| 操作 | 対象テーブル | 操作種別 | 概要 |
|-----|-------------|---------|------|
| - | - | - | データベース操作なし |

### テーブル別操作詳細

該当なし。

## エラー処理

### エラーケース一覧

| エラーコード | エラー種別 | 発生条件 | 対処方法 |
|------------|----------|---------|---------|
| ConnectTransportException | 接続エラー | 拡張機能プロセスに接続できない | 拡張機能プロセスの起動状態を確認 |
| IOException | I/Oエラー | extensions.ymlの読み込み失敗 | ファイルの存在と形式を確認 |
| TimeoutException | タイムアウト | 初期化リクエストが10秒以内に完了しない | 拡張機能の応答性を確認 |

### リトライ仕様

初期化リクエストのリトライは明示的に実装されていない。接続失敗時はエラーログが出力される。

## トランザクション仕様

該当なし。拡張機能との通信はリクエスト/レスポンス単位で処理される。

## パフォーマンス要件

- 拡張機能との通信はTransportServiceを通じたプロセス間通信のため、プラグインと比較してレイテンシが増加する
- CompletableFutureを使用した非同期処理

## セキュリティ考慮事項

- IdentityServiceを通じた拡張機能の認証
- AuthTokenによるリクエスト認可
- 拡張機能のプロセス分離によるセキュリティ境界の確保

## 備考

- EXTENSION_REQUEST_WAIT_TIMEOUTは10秒
- NoopExtensionsManagerが拡張機能が無効な場合のスタブとして提供される
- 本機能は内部API(@opensearch.internal)としてマーク済み

---

## コードリーディングガイド

本機能を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: データ構造を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | DiscoveryExtensionNode.java | `server/src/main/java/org/opensearch/extensions/DiscoveryExtensionNode.java` | 拡張機能ノードの情報 |
| 1-2 | ExtensionsSettings.java | `server/src/main/java/org/opensearch/extensions/ExtensionsSettings.java` | 拡張機能の設定データ構造 |
| 1-3 | ExtensionDependency.java | `server/src/main/java/org/opensearch/extensions/ExtensionDependency.java` | 拡張機能の依存関係 |

**読解のコツ**: ExtensionsSettings.Extensionクラスが各拡張機能の設定情報（ID、アドレス、ポート等）を保持する。

#### Step 2: エントリーポイントを理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | ExtensionsManager.java | `server/src/main/java/org/opensearch/extensions/ExtensionsManager.java` | メインクラス |

**主要処理フロー**:
1. **66行目**: ExtensionsManagerクラス定義
2. **67-81行目**: 各種REQUEST_*定数 - 通信プロトコルのアクション名定義
3. **113-129行目**: コンストラクタ - 初期化処理
4. **142-176行目**: initializeServicesAndRestHandler() - サービス初期化
5. **184-186行目**: lookupInitializedExtensionById() - 初期化済み拡張機能の検索

#### Step 3: リクエストハンドラを理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | RestActionsRequestHandler.java | `server/src/main/java/org/opensearch/extensions/rest/RestActionsRequestHandler.java` | REST Action登録処理 |
| 3-2 | ExtensionTransportActionsHandler.java | `server/src/main/java/org/opensearch/extensions/action/ExtensionTransportActionsHandler.java` | Transport Action処理 |
| 3-3 | CustomSettingsRequestHandler.java | `server/src/main/java/org/opensearch/extensions/settings/CustomSettingsRequestHandler.java` | カスタム設定処理 |

### プログラム呼び出し階層図

```
ExtensionsManager
    |
    +-- コンストラクタ(additionalSettings, identityService)
    |
    +-- initializeServicesAndRestHandler(actionModule, settingsModule, ...)
    |    +-- RestActionsRequestHandler(restController, extensionIdMap, ...)
    |    +-- CustomSettingsRequestHandler(settingsModule)
    |    +-- AddSettingsUpdateConsumerRequestHandler(clusterService, ...)
    |    +-- ExtensionTransportActionsHandler(extensionIdMap, ...)
    |    +-- registerRequestHandler(dynamicActionRegistry)
    |
    +-- 拡張機能初期化
    |    +-- transportService.sendRequest(extensionNode, REQUEST_EXTENSION_ACTION_NAME, ...)
    |    +-- InitializeExtensionResponse処理
    |
    +-- handleTransportRequest(extensionActionRequest)
         +-- ExtensionTransportActionsHandler.sendTransportRequestToExtension()
```

### データフロー図

```
[入力]                           [処理]                           [出力]

extensions.yml ──────> ExtensionsManager ──────> REST/Transport Action登録
拡張機能プロセス        TransportService              |
                       拡張機能初期化            ActionModule
                       Action登録処理            (RESTコントローラ)
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| ExtensionsManager.java | `server/src/main/java/org/opensearch/extensions/ExtensionsManager.java` | ソース | 拡張機能管理メインクラス |
| NoopExtensionsManager.java | `server/src/main/java/org/opensearch/extensions/NoopExtensionsManager.java` | ソース | 無効時のスタブ実装 |
| ExtensionsSettings.java | `server/src/main/java/org/opensearch/extensions/ExtensionsSettings.java` | ソース | 拡張機能設定 |
| DiscoveryExtensionNode.java | `server/src/main/java/org/opensearch/extensions/DiscoveryExtensionNode.java` | ソース | 拡張機能ノード情報 |
| RestActionsRequestHandler.java | `server/src/main/java/org/opensearch/extensions/rest/RestActionsRequestHandler.java` | ソース | REST Action登録ハンドラ |
| ExtensionTransportActionsHandler.java | `server/src/main/java/org/opensearch/extensions/action/ExtensionTransportActionsHandler.java` | ソース | Transport Actionハンドラ |
| CustomSettingsRequestHandler.java | `server/src/main/java/org/opensearch/extensions/settings/CustomSettingsRequestHandler.java` | ソース | カスタム設定ハンドラ |
| ExtensionDependency.java | `server/src/main/java/org/opensearch/extensions/ExtensionDependency.java` | ソース | 拡張機能依存関係 |
| ExtensionRequest.java | `server/src/main/java/org/opensearch/extensions/ExtensionRequest.java` | ソース | 拡張機能リクエスト |
