# 機能設計書 99-GCEディスカバリ

## 概要

本ドキュメントは、Google Compute Engine（GCE）環境でのノード自動検出プラグイン（GCE Discovery Plugin）の設計を記述する。GCEディスカバリプラグインは、GCE APIを使用してクラスタメンバーのシードホストを自動検出する。

### 本機能の処理概要

GCEディスカバリプラグインは、Google Compute Engine APIを呼び出してGCEインスタンスの情報を取得し、クラスタのシードホストとして使用可能なノードのアドレスリストを生成する。

**業務上の目的・背景**：GCE環境ではインスタンスのIPアドレスが動的に変わるため、静的な設定によるノードディスカバリは困難である。GCEディスカバリプラグインにより、GCE APIを使った動的なノード検出が可能となり、Managed Instance Groupと連携した弾力的なクラスタ運用を実現する。

**機能の利用シーン**：Google Cloud Platform（GCP）のCompute Engine上でOpenSearchクラスタを運用する場合に使用される。特にManaged Instance Groupによるインスタンスの動的な増減が発生する環境で有用。

**主要な処理内容**：
1. GCEインスタンスサービスの初期化 - GCPクレデンシャルを使用したGCEクライアントの生成
2. インスタンス情報の取得 - GCE Compute APIによるインスタンスリストの取得
3. タグフィルタリング - GCEタグによるインスタンスのフィルタリング
4. ステータスフィルタリング - TERMINATEDステータスのインスタンスを除外
5. ホストアドレス解決 - プライベートIP/パブリックIPからホストアドレスを決定
6. シードホストリスト提供 - SeedHostsProviderインターフェースを通じてホストリストを返却

**関連システム・外部連携**：Google Compute Engine API。Google API Client Libraryを使用。

**権限による制御**：GCEインスタンスのlistまたはget権限がサービスアカウントに必要（compute.instances.list）。

## 関連画面

| 画面No | 画面名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| - | - | - | GCEディスカバリに直接対応する画面はない |

## 機能種別

データ連携（GCEノード検出）

## 入力仕様

### 入力パラメータ

| パラメータ名 | 型 | 必須 | 説明 | バリデーション |
|-------------|-----|-----|------|---------------|
| discovery.gce.tags | List<String> | No | フィルタ対象のGCEタグ | - |
| discovery.seed_providers | String | No | "gce"を指定して有効化 | - |
| cloud.gce.project_id | String | Yes | GCPプロジェクトID | - |
| cloud.gce.zone | String | Yes | GCEゾーン | - |

### 入力データソース

opensearch.yml設定ファイル。GCE Compute APIのレスポンス。GCPサービスアカウントクレデンシャル。

## 出力仕様

### 出力データ

| 項目名 | 型 | 説明 |
|--------|-----|------|
| List<TransportAddress> | List | 検出されたシードホストのトランスポートアドレスリスト |

### 出力先

ディスカバリモジュール（SeedHostsProvider経由）。

## 処理フロー

### 処理シーケンス

```
1. GceDiscoveryPlugin初期化
   └─ GceInstancesServiceImplの生成
2. getSeedHostProviders()で"gce"プロバイダを登録
   └─ GceSeedHostsProviderのインスタンスを返却
3. GceSeedHostsProvider.getSeedAddresses()呼び出し
   └─ GceInstancesService.instances()の呼び出し
   └─ TERMINATEDインスタンスの除外
   └─ タグフィルタリング
   └─ ネットワークインターフェースからIPアドレス取得
4. TransportAddressリストの生成
```

### フローチャート

```mermaid
flowchart TD
    A[getSeedAddresses呼び出し] --> B[GCE API呼び出し]
    B --> C{成功?}
    C -->|Yes| D[インスタンスリスト走査]
    C -->|No| E[エラー処理/空リスト]
    D --> F{TERMINATED?}
    F -->|Yes| G[スキップ]
    F -->|No| H{タグフィルタ一致?}
    H -->|Yes| I[IPアドレス抽出]
    H -->|No| G
    I --> J[TransportAddress生成]
    J --> K[リスト返却]
```

## ビジネスルール

### 業務ルール

| ルールNo | ルール名 | 内容 | 適用条件 |
|---------|---------|------|---------|
| BR-99-01 | TERMINATEDスキップ | TERMINATEDステータスのインスタンスは対象外 | 常時 |
| BR-99-02 | タグフィルタ | discovery.gce.tags設定時、一致するタグを持つインスタンスのみ対象 | タグ設定時 |
| BR-99-03 | GCEメタデータ | GCEメタデータサービスからプロジェクトID・ゾーンを取得可能 | GCE上で実行時 |
| BR-99-04 | ネットワーク名解決 | GceNameResolverで_gce_プレフィックスのネットワーク名解決が可能 | 常時 |

### 計算ロジック

特になし。

## データベース操作仕様

### 操作別データベース影響一覧

| 操作 | 対象テーブル | 操作種別 | 概要 |
|-----|-------------|---------|------|
| - | - | - | データベース操作なし |

### テーブル別操作詳細

該当なし。

## エラー処理

### エラーケース一覧

| エラーコード | エラー種別 | 発生条件 | 対処方法 |
|------------|----------|---------|---------|
| IOException | APIエラー | GCE API呼び出し失敗 | GCPクレデンシャルと権限を確認 |
| GoogleJsonResponseException | 認証エラー | 認証失敗 | サービスアカウントのクレデンシャルを確認 |

### リトライ仕様

RetryHttpInitializerWrapperによるHTTPリクエストのリトライが実装されている。

## トランザクション仕様

該当なし。

## パフォーマンス要件

- GCE APIの呼び出し頻度に注意（APIレート制限）
- ディスカバリの定期実行間隔を適切に設定

## セキュリティ考慮事項

- GCPサービスアカウントのクレデンシャルが必要
- compute.instances.list権限のみ必要（最小権限原則）
- ALLOW_REROUTE_GCE_SETTINGSはテスト用でデフォルト無効

## 備考

- pluginsディレクトリに配置される
- GceDiscoveryPluginはCloseableを実装しリソース解放を保証
- GceMetadataServiceでGCEメタデータを取得可能
- GceModuleでGuice DIの設定を管理

---

## コードリーディングガイド

本機能を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: データ構造を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | GceInstancesService.java | `plugins/discovery-gce/src/main/java/org/opensearch/cloud/gce/GceInstancesService.java` | GCEインスタンスサービスのインターフェース |
| 1-2 | GceMetadataService.java | `plugins/discovery-gce/src/main/java/org/opensearch/cloud/gce/GceMetadataService.java` | GCEメタデータサービス |

**読解のコツ**: GceInstancesService.instances()メソッドがGCE APIを呼び出し、Instance（Google API Clientライブラリのモデル）のリストを返す。

#### Step 2: エントリーポイントを理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | GceDiscoveryPlugin.java | `plugins/discovery-gce/src/main/java/org/opensearch/plugin/discovery/gce/GceDiscoveryPlugin.java` | プラグインのエントリーポイント |

**主要処理フロー**:
1. **65行目**: GceDiscoveryPlugin定義 - DiscoveryPlugin, Closeableを実装
2. **72行目**: GCE = "gce" 定数
3. **76行目**: GceInstancesServiceのSetOnce保持
4. **68-70行目**: ALLOW_REROUTE_GCE_SETTINGS - テスト用フラグ

#### Step 3: シードホスト検出処理を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | GceSeedHostsProvider.java | `plugins/discovery-gce/src/main/java/org/opensearch/discovery/gce/GceSeedHostsProvider.java` | シードホスト検出の実装 |

**主要処理フロー**:
- **63行目**: SeedHostsProviderを実装
- **70-75行目**: TAGS_SETTING - タグフィルタ設定
- **77-79行目**: Status.TERMINATED - TERMINATEDステータス定数

### プログラム呼び出し階層図

```
GceDiscoveryPlugin
    |
    +-- getSeedHostProviders()
         +-- GceSeedHostsProvider(settings, gceInstancesService, transportService, networkService)
              |
              +-- getSeedAddresses()
                   +-- gceInstancesService.instances()
                   +-- ステータスフィルタ（TERMINATED除外）
                   +-- タグフィルタ
                   +-- NetworkInterface.getAccessConfigs()
                   +-- TransportAddressリスト生成
```

### データフロー図

```
[入力]                          [処理]                           [出力]

GCE API ──────> GceSeedHostsProvider ──────> List<TransportAddress>
  (instances())   ステータスフィルタ                    |
  レスポンス      タグフィルタ              ディスカバリモジュール
                  アドレス抽出              (クラスタ参加処理)
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| GceDiscoveryPlugin.java | `plugins/discovery-gce/src/main/java/org/opensearch/plugin/discovery/gce/GceDiscoveryPlugin.java` | ソース | プラグインメインクラス |
| GceSeedHostsProvider.java | `plugins/discovery-gce/src/main/java/org/opensearch/discovery/gce/GceSeedHostsProvider.java` | ソース | シードホスト検出 |
| GceInstancesService.java | `plugins/discovery-gce/src/main/java/org/opensearch/cloud/gce/GceInstancesService.java` | ソース | GCEインスタンスサービスIF |
| GceInstancesServiceImpl.java | `plugins/discovery-gce/src/main/java/org/opensearch/cloud/gce/GceInstancesServiceImpl.java` | ソース | GCEインスタンスサービス実装 |
| GceMetadataService.java | `plugins/discovery-gce/src/main/java/org/opensearch/cloud/gce/GceMetadataService.java` | ソース | メタデータサービス |
| GceNameResolver.java | `plugins/discovery-gce/src/main/java/org/opensearch/cloud/gce/network/GceNameResolver.java` | ソース | ネットワーク名解決 |
| GceModule.java | `plugins/discovery-gce/src/main/java/org/opensearch/cloud/gce/GceModule.java` | ソース | Guiceモジュール設定 |
| RetryHttpInitializerWrapper.java | `plugins/discovery-gce/src/main/java/org/opensearch/discovery/gce/RetryHttpInitializerWrapper.java` | ソース | HTTPリトライラッパー |
