---
generated_at: 2026-02-03 12:00:00
metrics:
  claims_total: 20
  claims_with_evidence: 18
  claims_without_evidence: 2
confidence_derived: 0.90
---

# 根拠レポート：1-インデックス作成

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.90**
  - 根拠あり：18 / 20、根拠なし：2
- 優先レビュー（高）
  1. **テンプレート自動適用の詳細動作**：MetadataCreateIndexServiceの内部処理は未読
  2. **パフォーマンス要件の具体的数値**：ソースコードからは性能要件を特定できない

## 2) 参照した情報（Evidence一覧）

- E-01: `server/src/main/java/org/opensearch/action/admin/indices/create/CreateIndexRequest.java`
- E-02: `server/src/main/java/org/opensearch/action/admin/indices/create/TransportCreateIndexAction.java`
- E-03: `server/src/main/java/org/opensearch/action/admin/indices/create/CreateIndexResponse.java`
- E-04: `server/src/main/java/org/opensearch/action/admin/indices/create/CreateIndexClusterStateUpdateRequest.java`
- E-05: `server/src/main/java/org/opensearch/action/admin/indices/create/CreateIndexAction.java`
- E-06: `docs/code-to-docs/画面機能マッピング/画面機能マッピング.csv`
- E-07: `docs/code-to-docs/機能一覧/機能一覧.csv`

## 3) Claims と根拠の対応（レビューの主戦場）

| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | アクション名はindices:admin/create | E-05 (45行目) | ○ |
| C-02 | インデックス名はnullでないことがバリデーションで検証される | E-01 (160-166行目) | ○ |
| C-03 | settings, mappings, aliases, contextのフィールドが存在する | E-01 (97-108行目) | ○ |
| C-04 | デフォルトのmappingsは"{}" | E-01 (103行目) | ○ |
| C-05 | waitForActiveShardsのデフォルトはActiveShardCount.DEFAULT | E-01 (109行目) | ○ |
| C-06 | TransportCreateIndexActionはTransportClusterManagerNodeActionを継承 | E-02 (62行目) | ○ |
| C-07 | causeが空文字の場合"api"に設定される | E-02 (120-123行目) | ○ |
| C-08 | 日付数式でインデックス名が解決される | E-02 (167-169行目) | ○ |
| C-09 | マッピングトランスフォーマーが適用される | E-02 (150行目) | ○ |
| C-10 | MetadataCreateIndexService.createIndex()が呼び出される | E-02 (141行目) | ○ |
| C-11 | レスポンスはacknowledged, shardsAcknowledged, indexの3フィールド | E-03 (82行目) | ○ |
| C-12 | METADATA_WRITEとCREATE_INDEXレベルのブロックチェック | E-02 (104-112行目) | ○ |
| C-13 | エイリアス同時作成時はIndicesAliasesActionの権限も必要 | E-02 (160-164行目) | ○ |
| C-14 | ContextはV2.17.0以降で利用可能 | E-01 (137-139行目) | ○ |
| C-15 | IndicesOptions.strictSingleIndexNoExpandForbidClosed()が使用される | E-01 (174-176行目) | ○ |
| C-16 | CreateIndexClusterStateUpdateRequestにrecoverFromとresizeTypeが含まれる | E-04 (59-60行目) | ○ |
| C-17 | 画面No38が主画面として関連 | E-06 | ○ |
| C-18 | ShardsAcknowledgedResponseを継承 | E-03 (56行目) | ○ |
| C-19 | テンプレートに一致する場合は自動適用される | **根拠なし** | △ |
| C-20 | パフォーマンス要件としてクラスタマネージャがボトルネック | **根拠なし** | △ |

## 4) 不足情報（Unknown / Missing）
- MetadataCreateIndexServiceの内部処理（テンプレート適用ロジック）は未精査
  - 候補：`server/src/main/java/org/opensearch/cluster/metadata/MetadataCreateIndexService.java`
- REST APIハンドラの実装（RestCreateIndexAction）は未精査
  - 候補：`server/src/main/java/org/opensearch/rest/action/admin/indices/RestCreateIndexAction.java`

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク -- アクション名、データ構造、基本的な処理フローはソースコードから確認済み
- 1: 中リスク -- テンプレート自動適用の詳細動作はMetadataCreateIndexServiceの精査が必要
- 0: 低リスク -- エラーケースはソースコードのバリデーションロジックから導出

## 6) レビュアーチェックリスト（最小）
- [ ] MetadataCreateIndexServiceの内部処理（テンプレート適用、設定マージ）の記述が正確か確認
- [ ] REST APIのエンドポイント仕様（PUT /{index}）がOpenSearch公式ドキュメントと一致するか確認
- [ ] セキュリティ権限の記述が実際のアクション権限と一致するか確認
- [ ] パフォーマンス要件の記述が運用実態と整合するか確認
