---
generated_at: 2026-02-03 12:00:00
metrics:
  claims_total: 18
  claims_with_evidence: 16
  claims_without_evidence: 2
confidence_derived: 0.89
---

# 根拠レポート：10-ドキュメントインデックス（登録）

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.89**
  - 根拠あり：16 / 18、根拠なし：2
- 優先レビュー（高）
  1. **TransportBulkAction内部のパイプライン解決・シャード書き込みロジック**：TransportBulkActionの精査が必要
  2. **インデックス自動作成のロジック**：TransportBulkActionの精査が必要

## 2) 参照した情報（Evidence一覧）

- E-01: `server/src/main/java/org/opensearch/action/index/IndexRequest.java`
- E-02: `server/src/main/java/org/opensearch/action/index/TransportIndexAction.java`
- E-03: `server/src/main/java/org/opensearch/action/index/IndexAction.java`
- E-04: `server/src/main/java/org/opensearch/action/index/IndexResponse.java`
- E-05: `server/src/main/java/org/opensearch/action/bulk/TransportSingleItemBulkWriteAction.java`
- E-06: `docs/code-to-docs/画面機能マッピング/画面機能マッピング.csv`

## 3) Claims と根拠の対応（レビューの主戦場）

| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | アクション名はindices:data/write/index | E-03 (45行目) | ○ |
| C-02 | source必須バリデーション | E-01 (197-198行目) | ○ |
| C-03 | contentType必須バリデーション | E-01 (200-201行目) | ○ |
| C-04 | opTypeはINDEXまたはCREATEのみ | E-01 (203行目, 503-504行目) | ○ |
| C-05 | CREATE時versionType=INTERNALのみ | E-01 (206-212行目) | ○ |
| C-06 | CREATE時ifSeqNo/ifPrimaryTerm指定不可 | E-01 (222-228行目) | ○ |
| C-07 | CREATE時バージョン自動解決（MATCH_ANY -> MATCH_DELETED） | E-01 (561-562行目) | ○ |
| C-08 | ID未指定時のバージョニング制約 | E-01 (231-236行目) | ○ |
| C-09 | pipeline空文字列不可 | E-01 (242-244行目) | ○ |
| C-10 | finalPipeline空文字列不可 | E-01 (246-248行目) | ○ |
| C-11 | TransportIndexActionがTransportSingleItemBulkWriteActionを継承 | E-02 (57行目) | ○ |
| C-12 | doExecuteでtoSingleItemBulkRequestを呼びBulkActionに委譲 | E-05 (80-81行目) | ○ |
| C-13 | wrapBulkResponseでBulkResponseから単一アイテム抽出 | E-05 (89-102行目) | ○ |
| C-14 | ルーティング必須チェック（RoutingMissingException） | E-01 (631-633行目) | ○ |
| C-15 | ID自動生成（RequestUtils.generateID） | E-01 (641-647行目) | ○ |
| C-16 | 画面No3, 4, 10が関連 | E-06 | ○ |
| C-17 | TransportBulkAction内部でパイプライン解決とシャード書き込みが行われる | **根拠なし** | △ |
| C-18 | autoCreate=trueでインデックスが自動作成される | **根拠なし** | △ |

## 4) 不足情報（Unknown / Missing）
- TransportBulkActionの内部ロジック（パイプライン解決、インデックス自動作成、シャード書き込み、レプリケーション）
  - 候補：`server/src/main/java/org/opensearch/action/bulk/TransportBulkAction.java`
- TransportShardBulkActionのシャードレベル書き込みロジック
  - 候補：`server/src/main/java/org/opensearch/action/bulk/TransportShardBulkAction.java`

## 5) リスクフラグ（レビュー観点）
- 1: 中リスク -- TransportBulkAction以降の処理フロー（パイプライン解決、シャード書き込み、レプリケーション）は本スコープ外のため未精査

## 6) レビュアーチェックリスト（最小）
- [ ] TransportBulkActionのパイプライン解決ロジックを確認
- [ ] TransportBulkActionのインデックス自動作成ロジックを確認
- [ ] TransportShardBulkActionのシャードレベル書き込みロジックを確認
- [ ] IndexRequest.process()のID生成タイミングがBulkAction内で正しく呼ばれるか確認
