---
generated_at: 2026-02-03 10:00:00
metrics:
  claims_total: 20
  claims_with_evidence: 18
  claims_without_evidence: 2
confidence_derived: 0.90
---

# 根拠レポート：101-ワークロードグループ管理

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.90**
  - 根拠あり：18 / 20、根拠なし：2
- 優先レビュー（高）
  1. **権限制御の詳細**：セキュリティプラグイン連携の詳細が不明
  2. **パフォーマンス要件の数値根拠**：具体的なベンチマーク値が未確認

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。

- E-01: `server/src/main/java/org/opensearch/wlm/WorkloadGroupService.java`
- E-02: `server/src/main/java/org/opensearch/wlm/ResourceType.java`
- E-03: `server/src/main/java/org/opensearch/wlm/MutableWorkloadGroupFragment.java`
- E-04: `server/src/main/java/org/opensearch/wlm/WorkloadGroupTask.java`
- E-05: `server/src/main/java/org/opensearch/wlm/WorkloadManagementSettings.java`
- E-06: `server/src/main/java/org/opensearch/wlm/WlmMode.java`
- E-07: `server/src/main/java/org/opensearch/wlm/cancellation/WorkloadGroupTaskCancellationService.java`
- E-08: `server/src/main/java/org/opensearch/wlm/stats/WorkloadGroupStats.java`
- E-09: `server/src/main/java/org/opensearch/wlm/stats/WorkloadGroupState.java`
- E-10: `docs/code-to-docs/画面機能マッピング/画面機能マッピング.csv`

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | CPU/MEMORYの2リソースタイプをサポート | E-02 (28-29行目) | ○ |
| C-02 | 3つのレジリエンシーモード（SOFT/ENFORCED/MONITOR） | E-03 (193-196行目) | ○ |
| C-03 | リソース制限値は0.0-1.0の範囲 | E-03 (159行目) | ○ |
| C-04 | 定期実行間隔のデフォルトは1000ms | E-05 (26行目) | ○ |
| C-05 | WLMモードはenabled/monitor_only/disabledの3種類 | E-06 (18-20行目) | ○ |
| C-06 | DISABLEDモード時は処理スキップ | E-01 (126-128行目) | ○ |
| C-07 | ENFORCEDモードのグループはduress関係なくキャンセル | E-07 (87行目) | ○ |
| C-08 | SOFTモードはduress時のみキャンセル | E-07 (130行目) | ○ |
| C-09 | 正規化された拒否閾値 = limit * node_level_rejection_threshold | E-01 (315-321行目) | ○ |
| C-10 | 拒否時はOpenSearchRejectedExecutionExceptionを送出 | E-01 (308-310行目) | ○ |
| C-11 | ThreadContextヘッダでworkloadGroupIdを伝搬 | E-04 (32行目, 84-91行目) | ○ |
| C-12 | デフォルトのworkloadGroupIdはDEFAULT_WORKLOAD_GROUP | E-04 (33行目) | ○ |
| C-13 | duress判定はduressStreak回連続で閾値超過 | E-05 (43-49行目), E-01 (83-91行目) | ○ |
| C-14 | 統計データにcompletions/rejections/cancellations/failuresを含む | E-08 (94-101行目) | ○ |
| C-15 | クラスタ状態変更でグループの追加・削除を検知 | E-01 (158-188行目) | ○ |
| C-16 | MaximumResourceTaskSelectionStrategyで最大消費タスクを選択 | E-07 (39-40行目) | ○ |
| C-17 | monitor_onlyモードではログのみ出力 | E-07 (218-233行目) | ○ |
| C-18 | タスク完了時にtotalCompletionsをインクリメント | E-01 (348-363行目) | ○ |
| C-19 | 権限制御はクラスタ管理者権限が必要 | **根拠なし** | △ |
| C-20 | パフォーマンス要件の数値根拠 | **根拠なし** | △ |

## 4) 不足情報（Unknown / Missing）
- C-19: 権限制御の詳細はセキュリティプラグイン側の実装に依存するため、wlmパッケージ内では確認できない
  - 候補：SecurityPlugin / REST handler権限設定 / Action権限マッピング
- C-20: パフォーマンス要件の具体的な数値はコードからは確認できない
  - 候補：ベンチマーク結果 / SLA定義文書 / パフォーマンステスト結果

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - 基本的なデータ構造と処理フローはソースコードから直接確認可能
- 1: 中リスク - @ExperimentalApi注釈があり、APIの安定性が保証されていない点に注意
- 0: 低リスク - 統計データ構造はソースコードのJSON構造コメントと整合

## 6) レビュアーチェックリスト（最小）
- [ ] ResiliencyModeの3モード（SOFT/ENFORCED/MONITOR）の動作差異が正確か確認
- [ ] 正規化された閾値計算ロジックが正確か確認
- [ ] 権限制御に関する記載が環境に合致するか確認
- [ ] 画面機能マッピングとの整合性を確認
