---
generated_at: 2026-02-03 10:05:00
metrics:
  claims_total: 15
  claims_with_evidence: 13
  claims_without_evidence: 2
confidence_derived: 0.87
---

# 根拠レポート：102-ワークロード管理プラグイン

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.87**
  - 根拠あり：13 / 15、根拠なし：2
- 優先レビュー（高）
  1. **MAX_QUERY_GROUP_COUNTの具体的な値**：WorkloadGroupPersistenceService内で確認が必要
  2. **REST APIエンドポイントのパス定義**：RestHandlerの実装詳細が未確認

## 2) 参照した情報（Evidence一覧）

- E-01: `plugins/workload-management/src/main/java/org/opensearch/plugin/wlm/WorkloadManagementPlugin.java`
- E-02: `plugins/workload-management/src/main/java/org/opensearch/plugin/wlm/WorkloadManagementPluginModule.java`
- E-03: `docs/code-to-docs/画面機能マッピング/画面機能マッピング.csv`

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | 4つのCRUDアクション（Create/Get/Delete/Update）を提供 | E-01 (189-196行目) | ○ |
| C-02 | 4つのRESTハンドラを登録 | E-01 (204-218行目) | ○ |
| C-03 | システムインデックス名は.wlm_rules | E-01 (98行目) | ○ |
| C-04 | ActionPlugin/SystemIndexPlugin/DiscoveryPlugin/ExtensiblePlugin/RuleFrameworkExtensionを実装 | E-01 (87-93行目) | ○ |
| C-05 | AutoTaggingActionFilterをActionFilterとして登録 | E-01 (184-186行目) | ○ |
| C-06 | GuiceモジュールでWorkloadGroupPersistenceServiceをシングルトンバインド | E-02 (29行目) | ○ |
| C-07 | RefreshBasedSyncMechanismによるルール同期 | E-01 (158-165行目) | ○ |
| C-08 | MAX_RULES_PER_PAGEは50 | E-01 (102行目) | ○ |
| C-09 | AttributeExtractorExtensionによる拡張ポイント | E-01 (259-263行目) | ○ |
| C-10 | createComponents()でサービス初期化 | E-01 (121-175行目) | ○ |
| C-11 | PRINCIPAL_ATTRIBUTE_NAMEは"principal" | E-01 (106行目) | ○ |
| C-12 | getSettings()で3つの設定を公開 | E-01 (222-228行目) | ○ |
| C-13 | WorkloadGroupRuleRoutingServiceでruleRoutingServiceを実装 | E-01 (156行目) | ○ |
| C-14 | MAX_QUERY_GROUP_COUNTの具体値 | **根拠なし** | △ |
| C-15 | REST APIエンドポイントの正確なパス | **根拠なし** | △ |

## 4) 不足情報（Unknown / Missing）
- C-14: WorkloadGroupPersistenceService内の設定値を直接確認していないため、具体的な最大グループ数が不明
  - 候補：WorkloadGroupPersistenceService.java / テスト設定
- C-15: RestHandlerの実装内でのパス定義を直接確認していない
  - 候補：RestCreateWorkloadGroupAction.java / RestGetWorkloadGroupAction.java

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - プラグインのメインクラス構造はソースコードから直接確認済み
- 1: 中リスク - ルール同期メカニズムの詳細実装は未確認

## 6) レビュアーチェックリスト（最小）
- [ ] REST APIエンドポイントのパスが正確か確認
- [ ] グループ数上限の設定値が正確か確認
- [ ] 自動タグ付けフィルタの動作条件を確認
