---
generated_at: 2026-02-03 10:00:00
metrics:
  claims_total: 18
  claims_with_evidence: 16
  claims_without_evidence: 2
confidence_derived: 0.89
---

# 根拠レポート：11-ドキュメント取得

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.89**
  - 根拠あり：16 / 18、根拠なし：2
- 優先レビュー（高）
  1. **パフォーマンス要件の具体値**：1ms未満の目標値はコードからは確認不可
  2. **トランスログからのリアルタイム取得**：ShardGetServiceの内部実装は未確認

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。

- E-01: `server/src/main/java/org/opensearch/action/get/GetRequest.java` - リクエストフィールド定義・バリデーション
- E-02: `server/src/main/java/org/opensearch/action/get/GetResponse.java` - レスポンス構造・GetResultラッパー
- E-03: `server/src/main/java/org/opensearch/action/get/TransportGetAction.java` - Get操作の実処理
- E-04: `server/src/main/java/org/opensearch/action/get/GetAction.java` - アクション名定義
- E-05: `server/src/main/java/org/opensearch/action/get/MultiGetRequest.java` - Multi Getリクエスト構造
- E-06: `server/src/main/java/org/opensearch/action/get/TransportMultiGetAction.java` - Multi Get処理
- E-07: `server/src/main/java/org/opensearch/action/get/TransportShardMultiGetAction.java` - シャード単位Multi Get
- E-08: `docs/code-to-docs/画面機能マッピング/画面機能マッピング.csv` - 画面機能マッピング

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | アクション名は `indices:data/read/get` | E-04 (45行目) | ○ |
| C-02 | GetRequestはindex, id, routing, preference等のフィールドを持つ | E-01 (73-86行目) | ○ |
| C-03 | バリデーションでindex非null, id非空を検証 | E-01 (126-138行目) | ○ |
| C-04 | デフォルトでrealtime=true | E-01 (83行目) | ○ |
| C-05 | セグメントレプリケーション有効時にプライマリへ強制ルーティング | E-03 (96-98行目, 105-111行目) | ○ |
| C-06 | ルーティング必須インデックスでrouting未指定時にRoutingMissingException | E-03 (124-126行目) | ○ |
| C-07 | realtime=falseの場合はawaitShardSearchActiveで待機 | E-03 (133-143行目) | ○ |
| C-08 | refresh=trueかつrealtime=falseの場合にリフレッシュ実行 | E-03 (151-153行目) | ○ |
| C-09 | シャード上の取得はindexShard.getService().get()で実行 | E-03 (155-163行目) | ○ |
| C-10 | システムインデックスはSYSTEM_READスレッドプールで実行 | E-03 (175行目) | ○ |
| C-11 | 検索スロットル有効インデックスはSEARCH_THROTTLEDスレッドプール | E-03 (177行目) | ○ |
| C-12 | GetResponseはGetResultをラップしている | E-02 (68行目, 75-77行目) | ○ |
| C-13 | レスポンスにはisExists, getIndex, getId, getVersion, getSeqNo, getPrimaryTerm含む | E-02 (82-119行目) | ○ |
| C-14 | 画面No.5,6,7,8,11が関連画面 | E-08 | ○ |
| C-15 | Multi GetはCompositeIndicesRequestを実装 | E-05 (76-80行目) | ○ |
| C-16 | @PublicApi(since = "1.0.0")が付与されている | E-01 (70行目), E-02 (65行目) | ○ |
| C-17 | 単一ドキュメント取得は通常1ms未満のレイテンシ | **根拠なし** | △ |
| C-18 | リアルタイム取得時はトランスログから最新の未コミットデータも取得可能 | **根拠なし** | △ |

## 4) 不足情報（Unknown / Missing）
- C-17: パフォーマンス目標値はソースコードから直接確認できない。OpenSearchの一般的なGet APIの性能特性に基づく推定値。
  - 候補：ベンチマークテスト結果 / 公式ドキュメント / パフォーマンス要件定義書
- C-18: ShardGetServiceの内部実装でトランスログからの読み取りが行われる想定だが、当該ファイルの詳細確認が未実施。
  - 候補：`server/src/main/java/org/opensearch/index/get/ShardGetService.java` / Lucene Engineの実装

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - 入出力仕様はソースコードから正確に抽出
- 0: 低リスク - アクション名・バリデーションロジックはコードで確認済み
- 1: 中リスク - パフォーマンス要件は推定値のため要確認

## 6) レビュアーチェックリスト（最小）
- [ ] ShardGetServiceの内部実装を確認し、トランスログからのリアルタイム取得の記述が正確か検証
- [ ] パフォーマンス要件（1ms未満）が実際のSLA/要件に合致するか確認
- [ ] Multi Get APIのシャードグループ化ロジックの正確性を確認
