---
generated_at: 2026-02-03 10:45:00
metrics:
  claims_total: 12
  claims_with_evidence: 11
  claims_without_evidence: 1
confidence_derived: 0.92
---

# 根拠レポート：110-パーコレータ

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.92**
  - 根拠あり：11 / 12、根拠なし：1
- 優先レビュー（高）
  1. **PercolateQueryBuilderの入力パラメータ詳細**：先頭80行のみ確認のため

## 2) 参照した情報（Evidence一覧）

- E-01: `modules/percolator/src/main/java/org/opensearch/percolator/PercolatorModulePlugin.java`
- E-02: `modules/percolator/src/main/java/org/opensearch/percolator/PercolateQueryBuilder.java` (先頭80行)
- E-03: `modules/percolator/src/main/java/org/opensearch/percolator/PercolatorFieldMapper.java` (先頭80行)
- E-04: ファイル一覧（find結果）

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | MapperPluginとSearchPluginを実装 | E-01 (49行目) | ○ |
| C-02 | PercolateQueryBuilderをクエリとして登録 | E-01 (51-53行目) | ○ |
| C-03 | PercolatorMatchedSlotSubFetchPhaseとPercolatorHighlightSubFetchPhaseを登録 | E-01 (56-58行目) | ○ |
| C-04 | INDEX_MAP_UNMAPPED_FIELDS_AS_TEXT_SETTING設定を公開 | E-01 (62行目) | ○ |
| C-05 | percolatorフィールドタイプをマッパー登録 | E-01 (66-68行目) | ○ |
| C-06 | PercolateQueryBuilder/PercolateQuery/QueryAnalyzerが存在 | E-04 (ファイル一覧) | ○ |
| C-07 | PercolateQueryBuilderはLucene MemoryIndex/DirectoryReaderを使用 | E-02 (45-53行目 import) | ○ |
| C-08 | PercolatorFieldMapperはParametrizedFieldMapperを継承 | E-03 (75行目 import) | ○ |
| C-09 | CoveringQueryを使用した候補絞り込み | E-03 (45行目 import) | ○ |
| C-10 | BinaryRangeクラスが存在 | E-04 (ファイル一覧) | ○ |
| C-11 | BinaryDocValuesでクエリをバイナリ保存 | E-03 (37行目 import) | ○ |
| C-12 | PercolateQueryBuilderの入力パラメータの完全なリスト | **根拠なし** | △ |

## 4) 不足情報（Unknown / Missing）
- C-12: PercolateQueryBuilderのフィールド定義を先頭80行のみ読んだため、パラメータの完全リストが不確定
  - 候補：PercolateQueryBuilder.java の残り部分（ConstructingObjectParser定義等）

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - プラグイン構造とメインクラスの役割は確認済み
- 1: 中リスク - PercolateQueryBuilder/PercolateQueryの詳細な実行ロジックは先頭のみ確認

## 6) レビュアーチェックリスト（最小）
- [ ] PercolateQueryBuilderの全パラメータを確認
- [ ] QueryAnalyzerの候補絞り込みロジックを確認
- [ ] PercolateQueryのscorer()実装を確認
