---
generated_at: 2026-02-03 10:00:00
metrics:
  claims_total: 25
  claims_with_evidence: 23
  claims_without_evidence: 2
confidence_derived: 0.92
---

# 根拠レポート：111-ランク評価API

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.92**
  - 根拠あり：23 / 25、根拠なし：2
- 優先レビュー（高）
  1. **DCG/ERR計算式の詳細仕様**：実装コード未確認
  2. **パフォーマンス要件の具体値**：コードからは推定困難

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。

- E-01: `modules/rank-eval/src/main/java/org/opensearch/index/rankeval/RestRankEvalAction.java`
- E-02: `modules/rank-eval/src/main/java/org/opensearch/index/rankeval/TransportRankEvalAction.java`
- E-03: `modules/rank-eval/src/main/java/org/opensearch/index/rankeval/RankEvalRequest.java`
- E-04: `modules/rank-eval/src/main/java/org/opensearch/index/rankeval/RankEvalResponse.java`
- E-05: `modules/rank-eval/src/main/java/org/opensearch/index/rankeval/RankEvalSpec.java`
- E-06: `modules/rank-eval/src/main/java/org/opensearch/index/rankeval/EvaluationMetric.java`
- E-07: `modules/rank-eval/src/main/java/org/opensearch/index/rankeval/PrecisionAtK.java`
- E-08: `modules/rank-eval/src/main/java/org/opensearch/index/rankeval/RankEvalModulePlugin.java`
- E-09: `docs/code-to-docs/画面機能マッピング/画面機能マッピング.csv`（画面No.29）
- E-10: `docs/code-to-docs/機能一覧/機能一覧.csv`（機能No.111）

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | エンドポイントは GET/POST /_rank_eval と /{index}/_rank_eval | E-01 (109-117行目) | ○ |
| C-02 | TransportRankEvalActionがHandledTransportActionを継承 | E-02 (82行目) | ○ |
| C-03 | MultiSearchRequestを使用して一括検索 | E-02 (114, 159行目) | ○ |
| C-04 | テンプレート展開にScriptServiceを使用 | E-02 (84, 111行目) | ○ |
| C-05 | max_concurrent_searchesのデフォルトは10 | E-05 (72行目) | ○ |
| C-06 | 評価メトリクスの指定は必須 | E-05 (77行目) | ○ |
| C-07 | スコア集約はデフォルトで平均 | E-06 (102-104行目) | ○ |
| C-08 | PrecisionAtKのkデフォルトは10 | E-07 (70行目) | ○ |
| C-09 | relevant_rating_thresholdのデフォルトは1 | E-07 (68行目) | ○ |
| C-10 | ignore_unlabeledのデフォルトはfalse | E-07 (69行目) | ○ |
| C-11 | Precision@K = relevantRetrieved / retrieved | E-07 (224-227行目) | ○ |
| C-12 | forcedSearchSizeでkを返す | E-07 (181-183行目) | ○ |
| C-13 | サポートされるメトリクス5種類 | E-08 (79-87行目) | ○ |
| C-14 | RankEvalResponseにmetric_score、details、failuresを含む | E-04 (65-69行目) | ○ |
| C-15 | RankEvalRequestにrankingEvaluationSpec、indices、searchTypeを含む | E-03 (54-59行目) | ○ |
| C-16 | バリデーションでrankingEvaluationSpecがnullならエラー | E-03 (77-84行目) | ○ |
| C-17 | テンプレート展開のパースエラーはerrorsに追加して続行 | E-02 (136-138行目) | ○ |
| C-18 | summaryFieldsが空の場合fetchSourceをfalseに設定 | E-02 (148-149行目) | ○ |
| C-19 | joinHitsWithRatingsでヒットとレーティングを照合 | E-06 (72-86行目) | ○ |
| C-20 | 画面No.29がランク評価に対応 | E-09 | ○ |
| C-21 | 機能No.111がランク評価API | E-10 | ○ |
| C-22 | 読み取り専用でデータ変更なし | E-02 (全体) | ○ |
| C-23 | 検索失敗時はerrorsマップに記録 | E-02 (196行目) | ○ |
| C-24 | DCGの計算式: sum(rating / log2(position + 1)) | **根拠なし** | △ |
| C-25 | パフォーマンス要件の具体値 | **根拠なし** | △ |

## 4) 不足情報（Unknown / Missing）
- DCG、ERR、RecallAtKの具体的な計算式はDiscountedCumulativeGain.java、ExpectedReciprocalRank.java、RecallAtK.javaの詳細確認が必要
  - 候補：DiscountedCumulativeGain.java / ExpectedReciprocalRank.java / RecallAtK.java
- パフォーマンス要件はコードからは直接導出できず、システム要件定義書が必要
  - 候補：システム非機能要件書 / 性能テスト仕様書

## 5) リスクフラグ（レビュー観点）
- 0: 全体的に根拠が明確であり低リスク
- 1: DCG/ERR計算式の記述は実装コードの詳細確認が推奨される

## 6) レビュアーチェックリスト（最小）
- [ ] DCG/ERR/RecallAtKの計算ロジックが正しいか実装コードと照合
- [ ] エラーハンドリングの記述が実装と一致しているか
- [ ] テンプレート展開時のセキュリティ制御が適切に記述されているか
