---
generated_at: 2026-02-03 10:05:00
metrics:
  claims_total: 12
  claims_with_evidence: 10
  claims_without_evidence: 2
confidence_derived: 0.83
---

# 根拠レポート：112-Geoモジュール

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.83**
  - 根拠あり：10 / 12、根拠なし：2
- 優先レビュー（高）
  1. **集計の詳細パラメータ仕様**：AggregationBuilderの詳細確認必要
  2. **GeoShapeFieldMapperの入力パラメータ詳細**：マッパー定義の網羅性確認

## 2) 参照した情報（Evidence一覧）

- E-01: `modules/geo/src/main/java/org/opensearch/geo/GeoModulePlugin.java`
- E-02: `docs/code-to-docs/機能一覧/機能一覧.csv`（機能No.112）

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | GeoModulePluginがMapperPluginとSearchPluginを実装 | E-01 (54行目) | ○ |
| C-02 | GeoShapeFieldMapperをgetMappers()で登録 | E-01 (57-59行目) | ○ |
| C-03 | GeoBounds、GeoHashGrid、GeoTileGridの3集計を登録 | E-01 (66-84行目) | ○ |
| C-04 | GeoTileGridをComposite集計のソースとして登録 | E-01 (93-104行目) | ○ |
| C-05 | GeoShapeフィールドに対してもGeoBounds集計が可能 | E-01 (registerAggregators) | ○ |
| C-06 | 機能No.112がGeoモジュール | E-02 | ○ |
| C-07 | 画面機能マッピングに直接対応する画面なし | E-02（マッピング確認） | ○ |
| C-08 | GeoBoundsはtop_left/bottom_right座標を返す | E-01 (間接) | ○ |
| C-09 | GeoHashGridはGeoHash文字列でバケット化 | E-01 (間接) | ○ |
| C-10 | GeoTileGridはz/x/y座標でバケット化 | E-01 (間接) | ○ |
| C-11 | 集計の詳細パラメータ（precision、bounds等） | **根拠なし** | △ |
| C-12 | パフォーマンス要件の記述 | **根拠なし** | △ |

## 4) 不足情報（Unknown / Missing）
- 各AggregationBuilderの詳細パラメータ仕様はBuilder実装の詳細確認が必要
  - 候補：GeoBoundsAggregationBuilder.java / GeoHashGridAggregationBuilder.java / GeoTileGridAggregationBuilder.java

## 5) リスクフラグ（レビュー観点）
- 0: プラグイン登録構造は明確
- 1: 集計パラメータの詳細仕様は追加確認が推奨

## 6) レビュアーチェックリスト（最小）
- [ ] 各集計のパラメータ仕様がAggregationBuilder実装と一致するか
- [ ] GeoShapeFieldMapperの入力パラメータが網羅されているか
